<?php

namespace App\Http\Controllers;

use App\Models\Otps;
use App\Services\SettingService;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Validator;
use App\Traits\HandlesValidation;
use libphonenumber\PhoneNumberUtil;
use libphonenumber\NumberParseException;
class AuthController extends Controller
{
    use HandlesValidation;
    // public function send_otp(Request $request)
    // {
    //     $rules = [
    //         'mobile' => 'required|numeric',
    //     ];
    //     if ($response = $this->HandlesValidation($request, $rules)) {
    //         return $response;
    //     }
    //     $otp = random_int(100000, 999999);
    //     $data = [
    //         'mobile' => $request['mobile'],
    //         'otp' => $otp,
    //         'varified' => 0
    //     ];
    //     $code = $request['code'] ?? 91;
    //     $res = send_sms($request['mobile'], "please don't share with anyone $otp");
    //     $isSuccess = isset($res['http_code']) && in_array((int) $res['http_code'], [200, 201]);
    //     if ($isSuccess) {
    //         if (!isExist(['mobile' => $request['mobile']], OTPs::class)) {
    //             Otps::create($data);
    //         }
    //         $otp_details = Otps::where('mobile', $request['mobile']);
    //         $otp_details->update($data);
    //         return [
    //             "error" => false,
    //             "message" => "OTP send successfully.",
    //             "data" => $data
    //         ];
    //     }
    //     return [
    //         "error" => true,
    //         "message" => "Something went wrong."
    //     ];
    // }

  public function send_otp(Request $request)
{
    // Check if captcha was already validated in check_mobile_number
    if (!session('register_captcha_validated')) {
        return response()->json([
            'error' => true,
            'message' => 'Please validate captcha first'
        ], 422);
    }

    // Clear the session flag after checking
    session()->forget('register_captcha_validated');

    $rules = [
        'mobile' => 'required|string',

    ];

    if ($response = $this->HandlesValidation($request, $rules)) {
        return $response;
    }

    $code = $request['code'] ?? 91;

    $phoneUtil = PhoneNumberUtil::getInstance();

    $fullNumber = '+' . $code . $request->mobile;

    try {
        $phoneNumber = $phoneUtil->parse($fullNumber, null);

        if (!$phoneUtil->isValidNumber($phoneNumber)) {
            return response()->json([
                'error' => true,
                'message' => 'Invalid mobile number for selected country'
            ], 422);
        }
    } catch (NumberParseException $e) {
        return response()->json([
            'error' => true,
            'message' => 'Invalid mobile number format'
        ], 422);
    }
    $otp = random_int(100000, 999999);

    $data = [
        'mobile'       => $request->mobile,
        'otp'          => $otp,
    ];

    $message = " OTP: $otp";


    $res = send_sms($fullNumber, $message);

    if (!isset($res['http_code']) || !in_array((int)$res['http_code'], [200, 201])) {
        return response()->json([
            'error' => true,
            'message' => 'Failed to send OTP'
        ], 400);
    }

    Otps::updateOrCreate(
        [
            'mobile'       => $request->mobile,

        ],
        $data
    );

    return response()->json([
        'error' => false,
        'message' => 'OTP sent successfully',
        // "data" => $data

    ]);
}


    public function verify_otp(Request $request)
    {

        $rules = [
            'mobile' => 'required|numeric',
            'verification_code' => 'required'
        ];
        if ($response = $this->HandlesValidation($request, $rules)) {
            return $response;
        }
        $otp_details = Otps::where('mobile', $request['mobile'])->first();
        if ($otp_details != null) {
            if ($otp_details['otp'] == $request['verification_code']) {
                $data = [
                    'varified' => 1
                ];
                $otp_details->update($data);
                return [
                    "error" => false,
                    "message" => "Verification Code Varified Successfully."
                ];
            }
            return [
                "error" => true,
                "message" => "Verification Failed, Code Incorrect!"
            ];
        }
        return [
            "error" => true,
            "message" => "Something Went Wrong Please Try Again."
        ];
    }

 public function resend_otp(Request $request)
    {
        // Validate the input

        $rules = [
            'mobile' => 'required|numeric',

        ];
        if ($response = $this->HandlesValidation($request, $rules, [], null, true)) {
            return $response;
        }



        $mobile = $request->input('mobile');
        $auth_settings = json_decode(app(SettingService::class)->getSettings('system_settings', true), true);

        if ($auth_settings['authentication_method'] == "sms") {
            $otps = Otps::where('mobile', $mobile)->first();

            if (!$otps) {
                return response()->json([
                    'error' => true,
                    'message' => 'No OTP found for this mobile number.',
                    'language_message_key' => 'data_not_found',
                    'data' => [],
                ]);
            }

            $otp = random_int(100000, 999999);
            $data = set_user_otp($mobile, $otp);

            // Optionally, you can send the OTP here using a hypothetical function send_otp
            set_user_otp($mobile, $otp);

            return response()->json([
                'error' => false,
                'message' => 'Resend OTP successfully.',
                'language_message_key' => 'ready_to_send_otp',
                // 'data' => $data,
            ]);
        }

        return response()->json([
            'error' => true,
            'message' => 'Invalid authentication method',
            'language_message_key' => 'invalid_authentication_method',
            'data' => [],
        ]);
    }

}
