<?php

namespace App\Http\Controllers;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Http\Request;

class CategoryProductController extends Controller
{
    public function byCategorySlug(Request $request, string $slug)
    {
        $storeId = session('store_id');

        $category = Category::query()
            ->when($storeId, fn($q) => $q->where('store_id', $storeId))
            ->where('slug', $slug)
            ->first();

        if (!$category) {
            return response()->view('partials.room-products', ['products' => collect()]);
        }

        $products = Product::query()
            ->where('category_id', $category->id)
            ->where('status', 1)
            ->latest('id')
            ->take(8)
            ->get();

        return view('partials.room-products', compact('products'));
    }

    function add_to_cart(Request $request, $check_status = true)
    {

        // dd('here');
        $store_id = session('store_id');
        $product_reference_id = isset($request->product_reference_id) ? $request->product_reference_id : '';
        $user_id = Auth::user() != '' ? Auth::user()->id : 0;
        if ($user_id) {
        } else {
            $response = [
                'error' => true,
                'message' => 'Please Login first.',
                'code' => 102,
            ];
            return response()->json($response);
        }

        $product_variant_id = $request->input('product_variant_id');

        $qty = $request->input('qty');

        $is_saved_for_later = $request->input('is_saved_for_later');
        $product_type = $request->input('product_type');


        $cart_data = [
            'product_variant_id' => $product_variant_id,
            'qty' => $qty,
            'is_saved_for_later' => $is_saved_for_later,
        ];

        if ($request->input('product_type') != 'combo') {
            $rules = [
                'product_variant_id' => 'required|exists:product_variants,id',
                'qty' => 'required|numeric|min:1',
            ];
        } else {
            $rules = [
                'product_variant_id' => 'required|exists:combo_products,id',
                'qty' => 'required|numeric|min:1',
            ];
        }
        if ($response = $this->HandlesValidation(new \Illuminate\Http\Request($cart_data), $rules)) {
            return $response;
        } else {

            $data = [
                'product_variant_id'
                => $product_variant_id,
                'qty' => $qty,
                'user_id' => $user_id,
                'store_id' => $store_id,
                'is_saved_for_later' => $is_saved_for_later,
                'product_type' => $product_type,
                'product_reference_id' => $product_reference_id,
            ];

            $settings = app(SettingService::class)->getSettings('system_settings', true);


            if ($request->input('product_type') != 'combo') {
                if (!isExist(['id' => $product_variant_id], Product_variants::class)) {
                    $response = [
                        'error' => true,
                        'message' => 'Product Varient not available.',
                        'data' => [],
                    ];
                    return response()->json($response);
                }
            } else {
                if (!isExist(['id' => $product_variant_id], ComboProduct::class)) {
                    $response = [
                        'error' => true,
                        'message' => 'Product Varient not available.',
                        'data' => [],
                    ];
                    return response()->json($response);
                }
            }
            $settings = json_decode($settings, true);
            $store_details = fetchDetails(Store::class, ['id' => $store_id], '*');
            $is_single_seller_order_system = !$store_details->isEmpty() ? $store_details[0]->is_single_seller_order_system : "";
            //    dd($is_single_seller_order_system);
            if ($settings['single_seller_order_system'] == 1 || $is_single_seller_order_system == 1) {

                if (!app(CartService::class)->isSingleSeller($product_variant_id, $user_id, $product_type, $store_id)) {
                    $response = [
                        'error' => true,
                        'message' => 'Only single seller items are allow in cart.You can remove previous item(s) and add this item.',
                        'data' => [],
                    ];
                    return response()->json($response);
                }
            }

            //check for digital or phisical product in cart
            if (!app(CartService::class)->isSingleProductType($product_variant_id, $user_id, $product_type, $store_id)) {
                $response = [
                    'error' => true,
                    'message' => 'you can only add either digital product or physical product to cart',
                    'data' => [],
                ];
                return response()->json($response);
            }

            $check_status = ($qty == 0 || $is_saved_for_later == 1) ? false : true;

            $cart_count = app(CartService::class)->getCartCount($user_id, $store_id);


            $is_variant_available_in_cart = app(CartService::class)->isVariantAvailableInCart($product_variant_id, $user_id);

            if (!$is_variant_available_in_cart) {
                if ($cart_count >= $settings['maximum_item_allowed_in_cart']) {
                    $response = [
                        'error' => true,
                        'message' => 'Maximum ' . $settings['maximum_item_allowed_in_cart'] . ' Item(s) Can Be Added Only!',
                        'data' => [],
                    ];
                    return response()->json($response);
                }
            }

            $result = app(CartService::class)->addToCart($data, $check_status);

            if (isset($result['error']) && $result['error'] == true) {
                $response = [
                    'error' => true,
                    'message' => $result['message'],
                ];
            } else {
                $cart_count = app(CartService::class)->getCartCount($user_id, $store_id);
                $response = [
                    'error' => false,
                    'message' => 'Product Added to cart successfully',
                    'cart_count' => $cart_count
                ];
            }
            return response()->json($response);
        }
    }
}


