<?php

namespace App\Http\Controllers;

use App\Http\Controllers\TransactionController;
use App\Libraries\Stripe;
use App\Libraries\Phonepe;
use App\Models\Order;
use App\Models\OrderItems;
use App\Models\Transaction;
use App\Services\CartService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
//use App\Http\Controllers\TransactionController;
use App\Libraries\Razorpay;
use App\Libraries\Hdfc;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use DB;
class PaymentsController extends Controller
{

    public $phonepe;
    public $stripe;
    public $razorpay;
    public $hdfc;

    public function __construct()
    {
        $this->phonepe = new Phonepe();
        $this->stripe = new Stripe();
        $this->razorpay = new Razorpay();
        $this->hdfc = new Hdfc();
    }

    public function phonepe(Request $request)
    {
        $user_id = $request['user_id'];
        $final_total = $request['final_total'];
        $mobile = $request['mobile'];
        $transaction_id = time() . "" . rand("100", "999");
        $data = array(
            'merchantTransactionId' => $transaction_id,
            'merchantUserId' => $user_id,
            'amount' => $final_total * 100,
            'redirectUrl' => customUrl(url('payments/response')),
            'redirectMode' => 'POST',
            'callbackUrl' => url("webhook/phonepe_webhook"),
            'mobileNumber' => $mobile,
        );
        $res = $this->phonepe->pay_v2($data);
        if ($res) {
            $response = [
                'error' => false,
                'message' => $res['message'] ?? "Success",
                'transaction_id' => $transaction_id ?? "",
                'payment_url' => $res['redirectUrl'] ?? "",
                'data' => $res,
            ];
            return json_encode($response);
        }
    }

    public function stripe(Request $request)
    {
        // dd($request['user-email']);
        if (isset($request['type']) && $request['type'] == "wallet") {
            $data = [
                'amount' => $request['amount'] ?? "",
                'product_name' => $request['product_name'] ?? "",
                'type' => "wallet",
                'email' => $request['user-email'] ?? "test@gmail.com",
            ];
        } else {
            $data = [
                'amount' => $request['amount'] ?? "",
                'product_name' => $request['product_name'] ?? "",
                'selected_address_id' => $request['selected_address_id'] ?? "",
                'address-mobile' => $request['address-mobile'] ?? "",
                'delivery_date' => $request['delivery_date'] ?? "",
                'delivery_time' => $request['delivery_time'] ?? "",
                'order_note' => $request['order_note'] ?? "",
                'payment_method' => $request['payment_method'] ?? "",
                'product_type' => $request['product_type'] ?? "",
                'promo_set' => $request['promo_set'] ?? "",
                'discount' => $request['discount'] ?? "",
                'is_wallet_used' => $request['is_wallet_used'] ?? "",
                'is_delivery_charge_returnable' => $request['is_delivery_charge_returnable'] ?? "",
                'wallet_balance_used' => $request['wallet_balance_used'] ?? "",
                'delivery_charge' => $request['delivery_charge'] ?? "",
                'currency_code' => $request['currency_code'] ?? "",
                'promo_code' => $request['promo_code'] ?? "",
                'email' => $request['user-email'] ?? "test@gmail.com",
                'type' => "order",
            ];
        }
        $data['user_id'] = Auth::user()->id ?? 0;
        $checkout_session = $this->stripe->createPaymentIntent($data);
        return $checkout_session;
    }

    public function stripe_response(Request $request)
    {
        if (null !== $request->query("session_id")) {
            $session_id = $request->query("session_id");
            $res = $this->stripe->stripe_response($session_id);
            $res = json_decode($res, true);
            if ($res['status'] == "complete") {
                $newRequest = new Request();
                $res['data']['metadata']['stripe_payment_id'] = $res['data']['payment_intent'];
                $res['data']['metadata']['payment_method'] = 'stripe';
                $newRequest->replace([
                    'res' => $res['data']['metadata']
                ]);
                $transactionController = app(TransactionController::class);
                if (isset($res['data']['metadata']['type']) && $res['data']['metadata']['type'] == "wallet") {
                    //                    $walletController = app(WalletController::class);
                    //                    $result = $walletController->refill($newRequest, $transactionController);
                    //                    $result = json_decode($result->getContent(), true);
                    //                    if ($result['error'] == false) {
                    return redirect(url('payments?response=wallet_success'));
                    //                    }
                    //                    return redirect(url('payments?response=wallet_failed'));
                }
                $cartController = app(CartController::class);
                $result = $cartController->place_order($newRequest, $transactionController);
                $result = json_decode($result->getContent(), true);
                if ($result['error'] == false) {
                    return redirect(url('payments?response=order_success'));
                }
                return redirect(url('payments?response=order_failed'));
            }
            return redirect(url('payments?response=order_failed'));
        }
        $response = [
            'error' => true,
            'message' => "request not allowed"
        ];
        return json_encode($response);
    }
 public function razorpay(Request $request)
    {

        $amount = intval($request['amount'] * 100);
        $order_id = $request['order_id'];

        $res = $this->razorpay->create_order($amount,$order_id);
        return $res;
    }

    public function hdfc(Request $request)
    {
        // Minimal backend initiator to generate fields/signature for HDFC SmartGateway
        // Expects: amount, order context (optional), user context (optional)
        $store_id = session('store_id') ?? '';
        $user_id = Auth::user()->id ?? "";
        if ($user_id == "") {
            $response = [
                'error' => true,
                'message' => 'Please Login first.',
                'code' => 102,
            ];
            return response()->json($response);
        }

        if ($request['product_type'] != 'digital_product') {
            $user_cart_data = app(CartService::class)->getCartTotal($user_id, false, 0, "", $store_id);
        } else {
            $user_cart_data = app(CartService::class)->getCartTotal($user_id, false, 0, $request['selected_address_id']??"", $store_id);
        }
        $temp_order_id = Str::uuid();


        $context = [
            'order_id' => $temp_order_id,
            'amount' => is_null($request['amount'])?1:$request['amount'],
            'currency' => 'INR',
            'return_url' => url('payments/response'),
            'callback_url' => url('webhook/hdfc_webhook'),
            'customer' => [
                'name' => $request->input('username', ''),
                'email' => $request->input('user-email', ''),
                'mobile' => $request->input('address-mobile', ''),
            ],
        ];

        $customerEmail = $request->input('user-email', '');
        $customerMobile = $request->input('address-mobile', '');

        $payload = $this->hdfc->createSession(
            $temp_order_id,
            is_null($request['amount']) ? 1 : $request['amount'],
            'test-customer', // You might want to use a real customer ID if available
            $customerEmail,
            $customerMobile
        );

        if ($payload['error'] ?? false) {
            return response()->json($payload, 422);
        }

        return response()->json([
            'error' => false,
            'message' => 'HDFC payment initialized',
            'order_id' => env('HDFCORDERPRE','').$temp_order_id,
            'payment_link'=>$payload['payment_link']??'',
            'fields' => $payload['fields'] ?? [],
            'action' => $payload['action'] ?? '',
        ]);
    }

    public function verifyHDFC(Request $request){
//        dd($request->order_id,null !== $request->query("order_id"),$request->query("order_id"));
//        dd($request->all(),null !== $request->order_id);
        if (null !== $request->order_id) {
            $session_id = $request->order_id;

            $res = $this->hdfc->getOrderStatus($session_id);
        //    dd($res,$request->all());
            if($res['error']==false){
                if ($res['status'] == "CHARGED" ) {
                    $transaction = fetchDetails(Transaction::class, ['txn_id' => $session_id]);
                    if (empty($transaction)) {
                        return redirect(url('payments?response=order_failed'));
                    }
                    Auth::loginUsingId($transaction[0]->user_id);
                    $transaction = $transaction[0];

                    DB::beginTransaction();

                    try {
                        // Update transaction status
                        Transaction::where('txn_id', $session_id)->update([
                            'status'  => 'success',
                            'message' => 'Payment received successfully'
                        ]);

                        // Update order items status
                        if (!empty($transaction->order_id)) {

                            updateDetails(
                                ['active_status' => 'received'],
                                ['order_id' => $transaction->order_id],
                                OrderItems::class
                            );

                            $order_status = json_encode([
                                ['received', now()->format('d-m-Y h:i:sa')]
                            ]);

                            updateDetails(
                                ['status' => $order_status],
                                ['order_id' => $transaction->order_id],
                                OrderItems::class
                            );
                        }

                        DB::commit();

                        return redirect(url('payments?response=order_success'));

                    } catch (\Exception $e) {
                        DB::rollBack();

                        \Log::error('Order update failed', [
                            'txn_id' => $session_id,
                            'error'  => $e->getMessage()
                        ]);

                        return redirect(url('payments?response=order_failed'));
                    }
                    // $transaction = fetchDetails(Transaction::class, ['txn_id' => $session_id]);
                    $newRequest = new Request();
                    $res['data']['metadata']['hdfc_payment_id'] = $res['txnId'];
                    $res['data']['metadata']['payment_method'] = 'hdfc';
                    $newRequest->replace([
                        'res' => $res['data']['metadata']
                    ]);
                    // dd($transaction,$res['data']['metadata']);
                    $transactionController = app(TransactionController::class);
                    if (isset($res['data']['metadata']['type']) && $res['data']['metadata']['type'] == "wallet") {
                        //                    $walletController = app(WalletController::class);
                        //                    $result = $walletController->refill($newRequest, $transactionController);
                        //                    $result = json_decode($result->getContent(), true);
                        //                    if ($result['error'] == false) {
                        
                        return redirect(url('payments?response=wallet_success'));
                        //                    }
                        //                    return redirect(url('payments?response=wallet_failed'));
                    }
                    // dd('asx');
                    $cartController = app(CartController::class);
                    $result = $cartController->place_order($newRequest, $transactionController);
                    $result = json_decode($result->getContent(), true);
                    dd($result);
                    if ($result['error'] == false) {
                        return redirect(url('payments?response=order_success'));
                    }
                    return redirect(url('payments?response=order_failed'));
                }
            }

            return redirect(url('payments?response=order_failed'));
        }
        return redirect(url('payments?response=order_failed'));
    }
}


