<?php

namespace App\Http\Controllers;

use App\Libraries\Shiprocket;
use App\Models\Favorite;
use App\Models\PickupLocation;
use App\Models\Product;
use App\Models\Product_variants;
use App\Models\ProductFaq;
use App\Models\Zipcode;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Traits\HandlesValidation;
use App\Services\ProductService;
use App\Services\DeliveryService;
class ProductController extends Controller
{
    use HandlesValidation;
    public function AddProductFaqs(Request $request)
    {
        $request->validate([
            'user_id' => 'required|integer|exists:users,id',
            'product_id' => 'required|integer|exists:products,id',
            'question' => 'required',
        ]);

        $faq = new ProductFaq();
        $faq->user_id = $request->user_id;
        $faq->product_id = $request->product_id;
        $faq->question = $request->question;

        $faq->save();

        return response()->json(['message' => 'Product faq add successfully']);
    }

    // public function add_to_favorites(Request $request)
    // {
    //     $request->validate([
    //         'user_id' => 'required|integer|exists:users,id',
    //         'product_id' => 'required|integer|exists:products,id',
    //         'product_type' => 'required',
    //     ]);

    //     $user_id = Auth::user() != '' ? Auth::user()->id : 0;

    //     $product_id = $request->input('product_id');
    //     $product_type = $request->input('product_type');
    //     if (isExist(['user_id' => $user_id, 'product_id' => $product_id, 'product_type' => $product_type], Favorite::class)) {
    //         $response = [
    //             'error' => true,
    //             'message' => 'Already added to favorite !',
    //             'data' => [],
    //         ];
    //         return response()->json($response);
    //     }
    //     $data = [
    //         'user_id' => $user_id,
    //         'product_id' => $product_id,
    //         'product_type' => $product_type,
    //     ];
    //     $fav_res = Favorite::create($data);
    //     $store_id = session('store_id');
    //     $favorite_count = getFavorites(user_id: $user_id, store_id: $store_id);
    //     if ($fav_res) {
    //         $response = [
    //             'error' => false,
    //             'message' => 'Added to favorite !',
    //             'wishlist_count' => $favorite_count['favorites_count'],
    //             'data' => [],
    //         ];
    //     } else {
    //         $response = [
    //             'error' => true,
    //             'message' => 'Not Added to favorite !',
    //             'data' => [],
    //         ];
    //     }
    //     return response()->json($response);
    // }

    public function add_to_favorites(Request $request)
{
    if (!auth()->check()) {
        return response()->json([
            'error' => true,
            'message' => 'Please Login First',
        ]);
    }

    $request->validate([
        'product_id' => 'required|integer',
        'product_type' => 'required|in:regular,combo',
    ]);

    $user_id = Auth::id();
    $product_id = $request->product_id;
    $product_type = strtolower($request->product_type);

    if ($product_type === 'regular' &&
        !\App\Models\Product::where('id', $product_id)->exists()) {
        return response()->json(['error' => true, 'message' => 'Invalid product']);
    }

    if ($product_type === 'combo' &&
        !\App\Models\ComboProduct::where('id', $product_id)->exists()) {
        return response()->json(['error' => true, 'message' => 'Invalid combo product']);
    }

    if (Favorite::where('user_id', $user_id)
        ->where('product_id', $product_id)
        ->where('product_type', $product_type)
        ->exists()
    ) {
        return response()->json(['error' => true, 'message' => 'Already added']);
    }

    Favorite::create([
        'user_id' => $user_id,
        'product_id' => $product_id,
        'product_type' => $product_type,
    ]);

    $favorite_count = getFavorites($user_id);

    return response()->json([
        'error' => false,
        'message' => 'Added to favorite!',
        'wishlist_count' => $favorite_count['favorites_count'],
    ]);
}

    // public function remove_from_favorite(Request $request)
    // {
    //     $request->validate([
    //         'user_id' => 'required|integer|exists:users,id',
    //         'productId' => 'required|integer',
    //         'productType' => 'required',
    //     ]);
    //     $product_id = $request->input('productId');
    //     if ($product_id == '') {
    //         $response = [
    //             'error' => true,
    //             'message' => 'Please pass product id',
    //             'code' => 102,
    //         ];
    //         return response()->json($response);
    //     } else {
    //         // uncomment after dynamic login

    //         if (auth()->check()) {
    //             $user_id = Auth::user() != '' ? Auth::user()->id : 0;
    //         } else {
    //             $response = [
    //                 'error' => true,
    //                 'message' => 'Please Login first.',
    //                 'code' => 102,
    //             ];
    //             return response()->json($response);
    //         }


    //         $productType = $request->input('productType');
    //         if (!isExist(['user_id' => $user_id, 'product_id' => $product_id, 'product_type' => $productType], Favorite::class)) {
    //             $response = [
    //                 'error' => true,
    //                 'message' => 'Item not added as favorite !',
    //                 'data' => [],
    //             ];
    //             return response()->json($response);
    //         }
    //         $data = [
    //             'user_id' => $user_id,
    //             'product_id' => $product_id,
    //             'product_type' => $productType,
    //         ];
    //         deleteDetails($data, Favorite::class);
    //         $favorite_count = getFavorites($user_id);
    //         $response = [
    //             'error' => false,
    //             'message' => 'Removed from favorite',
    //             'wishlist_count' => $favorite_count['favorites_count'],
    //             'data' => [],
    //         ];
    //         return response()->json($response);
    //     }
    // }
public function remove_from_favorite(Request $request)
{
    $request->validate([
        'productId' => 'required|integer',
        'productType' => 'required|string',
    ]);

    if (!auth()->check()) {
        return response()->json([
            'error' => true,
            'message' => 'Please Login first.',
        ]);
    }

    $user_id = Auth::id();
    $product_id = $request->productId;
    $productType = strtolower(trim($request->productType));

    $favorite = Favorite::where('user_id', $user_id)
        ->where('product_id', $product_id)
        ->where('product_type', $productType)
        ->first();

    if (!$favorite) {
        return response()->json([
            'error' => true,
            'message' => 'Item not found in wishlist!',
        ]);
    }

    $favorite->delete();

    $favorite_count = getFavorites($user_id);

    return response()->json([
        'error' => false,
        'message' => 'Removed from favorite',
        'wishlist_count' => $favorite_count['favorites_count'],
    ]);
}


    public function check_zipcode(request $request)
    {
        $rules = [
            'product_id' => 'required|numeric|exists:products,id',
            'zipcode' => 'required',
        ];
        if ($response = $this->HandlesValidation($request, $rules)) {
            return $response;
        } else {
            $zipcode = request('zipcode');
            $is_pincode = isexist(['zipcode' => $zipcode], Zipcode::class);
            $product_id = request('product_id');
            if ($is_pincode) {
                $zipcode_id = fetchDetails(Zipcode::class, ['zipcode' => $zipcode], 'id');
                $zipcode_id = !$zipcode_id->isEmpty() ? $zipcode_id[0]->id : '';
                $is_available = app(DeliveryService::class)->isProductDelivarable('zipcode', $zipcode_id, $product_id);
                if ($is_available) {
                    session(['valid_zipcode' => $zipcode]);
                    return response()->json([
                        'error' => false,
                        'message' => 'Product is deliverable on "' . $zipcode . '"',
                    ]);
                } else {
                    return response()->json([
                        'error' => true,
                        'message' => 'Product is not deliverable on "' . $zipcode . '"',
                    ]);
                }
            } else {

                $product_data = fetchDetails(Product::class, ['id' => $product_id], 'pickup_location');
                $product_variant_data = fetchDetails(Product_variants::class, ['product_id' => $product_id], 'weight');
                $pickup_pincode = fetchDetails(PickupLocation::class, ['pickup_location' => $product_data[0]->pickup_location], 'pincode');

                if (!empty($zipcode)) {
                    $availability_deliverability = [
                        'pickup_postcode' => $pickup_pincode ?? "",
                        'delivery_postcode' => $zipcode,
                        'cod' => 0,
                        'weight' => $product_variant_data,
                    ];
                    $shiprocket = new Shiprocket();

                    $check_deliverability = $shiprocket->check_serviceability($availability_deliverability);

                    if (isset($check_deliverability['status_code']) && $check_deliverability['status_code'] == 422) {
                        return response()->json([
                            'error' => true,
                            'message' => 'Invalid Delivery Pincode "' . $zipcode . '"',
                        ]);
                    } else {
                        if (isset($check_deliverability['status']) && $check_deliverability['status'] == 200 && !empty($check_deliverability['data']['available_courier_companies'])) {
                            $estimate_date = $check_deliverability['data']['available_courier_companies'][0]['etd'];
                            session(['valid_zipcode' => $zipcode]);
                            return response()->json([
                                'error' => false,
                                'message' => 'Product is deliverable by ' . $estimate_date . '',
                            ]);
                        } else {
                            return response()->json([
                                'error' => true,
                                'message' => 'Product is not deliverable on "' . $zipcode . '"',
                            ]);
                        }
                    }
                } else {
                    return response()->json([
                        'error' => true,
                        'message' => 'Cannot deliver to "' . $zipcode . '"',
                    ]);
                }
            }
        }
    }
    public function get_compare_data(Request $request)
    {
        $product_ids = $request->compare_data;

        if (empty($product_ids) || !isset($product_ids[0])) {
            return response()->json([
                'error' => true,
                'message' => 'Product IDs are required in compare_data',
                'data' => [],
            ]);
        } else {
            $product_details = [];

            foreach ($product_ids as $product_id) {
                $products = app(ProductService::class)->fetchProduct("", "", $product_id);
                $product_details[] = $products['product'];
            }
            return $product_details;
        }
    }
}
