<?php

namespace App\Livewire\Blogs;

use App\Models\Blog;
use Livewire\Component;
use App\Services\TranslationService;
class Details extends Component
{

    public $slug = "";

    public function mount($slug)
    {
        $this->slug = $slug;
    }

    public function render()
    {
        $store_id = session("store_id");
        $blog = fetchDetails(Blog::class, ['store_id' => $store_id, 'status' => 1, 'slug' => $this->slug], '*');
        if (count($blog) == 0) {
            abort(404);
            return;
        }
        $language_code = app(TranslationService::class)->getLanguageCode();
        $bread_crumb = [
            'page_main_bread_crumb' => '<a wire:navigate href="' . customUrl('blogs') . '">' . labels('front_messages.blogs', 'Blogs') . '</a>',
            'right_breadcrumb' => array(
                app(TranslationService::class)->getDynamicTranslation(Blog::class, 'title', $blog[0]->id, $language_code)
            )
        ];
        return view('livewire.' . config('constants.theme') . '.blogs.details', [
            'blog' => $blog,
            'bread_crumb' => $bread_crumb,
        ])->title(app(TranslationService::class)->getDynamicTranslation(Blog::class, 'title', $blog[0]->id, $language_code) . ' Blogs |');
    }
}
