<?php

namespace App\Livewire\Cart;

use App\Models\Cart;
use App\Models\Product;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use App\Services\ProductService;
use App\Services\CartService;
use App\Services\TranslationService;
class Listing extends Component
{
    protected $listeners = ['refreshComponent'];
    public $user_id = "";
    public function __construct()
    {
        $this->user_id = Auth::user() != '' ? Auth::user()->id : NUll;
    }
    public $store_id = "";
    public $product_type = "";
    public $cart_count = "";

    public function render()
    {
        $store_id = session('store_id');
        $this->store_id = $store_id;
        $cart_data = $this->get_user_cart($this->user_id, $store_id);
        // dd($cart_data['cart_items']);
        $this->cart_count = (count($cart_data) >= 1) ? count($cart_data['cart_items']) : "";
        $cart_product_types = [];
        $product_ids = [];
        $related_product = [];
        if (count($cart_data) >= 1) {
            foreach ($cart_data['cart_items'] as $cart_item) {
                array_push($cart_product_types, $cart_item['cart_product_type']);
                array_push($product_ids, $cart_item['product_id']);
            }
            $related_product = $this->related_product($product_ids, $cart_product_types, $this->user_id, $store_id);
        }
        $save_for_later = $this->get_user_cart($this->user_id, $store_id, 1);
        if (count($save_for_later) >= 1) {
            $save_for_later['cart_count'] = count($save_for_later['cart_items']);
            $save_for_later['heading'] = [
                'title' => 'Save For Later',
                'short_description' => $save_for_later['cart_count'] . ' Items in Save for Later',
            ];
        }

        $related_product_heading = [
            'title' => labels('front_messages.related_products', 'Related Products'),
            'short_description' => labels('front_messages.products_you_may_like', 'Products You May Like'),
        ];
        $language_code = app(TranslationService::class)->getLanguageCode();
        $bread_crumb = [
            'page_main_bread_crumb' => labels('front_messages.cart', 'Cart'),

        ];
        return view('livewire.' . config('constants.theme') . '.cart.view-cart', [
            'cart_data' => $cart_data,
            'related_product_heading' => $related_product_heading,
            'save_for_later' => $save_for_later,
            'related_product' => $related_product,
            'bread_crumb' => $bread_crumb,
            'language_code' => $language_code,
        ])->title('Product Cart |');
    }

    // public function move_to_cart($id)
    // {
    //     updateDetails(['is_saved_for_later' => 0], ['product_variant_id' => $id], 'cart');
    // }


    public function move_to_cart($id)
    {
        $store_id = session('store_id');
        $user_id = $this->user_id;

        // Find cart item saved for later
        $cart_item = Cart::where('product_variant_id', $id)
            ->where('user_id', $user_id)
            ->where('store_id', $store_id)
            ->where('is_saved_for_later', 1)
            ->first();

        if (!$cart_item) {
            $this->dispatch('cart-updated', message: 'Cart item not found.');
            return;
        }

        // Get moving product type via relationship
        $moving_product_type = $cart_item->productVariant->product->type ?? null;

        // Get existing cart items' types
        $cart_items_types = Cart::with(['productVariant.product'])
            ->where('user_id', $user_id)
            ->where('store_id', $store_id)
            ->where('is_saved_for_later', 0)
            ->get()
            ->pluck('productVariant.product.type')
            ->filter()
            ->toArray();

        $cart_items_types[] = $moving_product_type;

        if (count(array_unique($cart_items_types)) > 1) {
            $this->dispatch('cart-updated', message: 'You can only add either digital or physical product.');
            return;
        }

        // Update is_saved_for_later flag
        $cart_item->is_saved_for_later = 0;
        $cart_item->save();
    }


    public function save_for_later($id)
    {
        updateDetails(['is_saved_for_later' => 1], ['product_variant_id' => $id], Cart::class);
    }

    public function get_user_cart($user_id, $store_id, $save_later = 0)
    {
        $cart_data = app(CartService::class)->getCartTotal($user_id, false, $save_later, "", $store_id);
        return $cart_data;
    }

    public function related_product($product_ids, $cart_product_type, $user_id, $store_id)
    {
        $categories_id = [];

        foreach ($product_ids as $i => $product_id) {
            if ($cart_product_type[$i] == 'regular') {
                $category_id = fetchDetails(Product::class, ['id' => $product_id], 'category_id');
                $categories_id[$i] = $category_id[0]->category_id ?? '';
            }
        }
        $relative_product = [];
        if (count($categories_id) >= 1) {
            $relative_products_id = Product::select('id')
                ->where('category_id', $store_id)
                ->where('store_id', $categories_id)
                ->whereNotIn('id', $product_ids)
                ->get();
            $relative_id = [];
            foreach ($relative_products_id as $i => $relative_product_id) {
                $relative_id[$i] = $relative_product_id->id;
            }
            $relative_product = app(ProductService::class)->fetchProduct($user_id, "", $relative_id, '', '20', '0', '', '', '', '', '', '', $store_id);
        }
        return $relative_product;
    }

    public function refreshComponent()
    {
        $this->dispatch('$refresh');
    }

    public function remove_from_cart($id)
    {
        $cart_item = fetchDetails(Cart::class, ['product_variant_id' => $id], 'product_type');
        $data = [
            'variant_id' => $id,
            'store_id' => $this->store_id,
            'user_id' => $this->user_id,
            'cart_count' => $this->cart_count,
        ];
        if ($cart_item != []) {
            $data['product_type'] = $cart_item[0]->product_type;
        }
        $this->dispatch('remove_from_cart', data: $data);
    }
    
    public function remove_from_save_later($id)
    {
        $cart_item = fetchDetails(Cart::class, ['product_variant_id' => $id], 'product_type');
        $data = [
            'variant_id' => $id,
            'store_id' => $this->store_id,
            'user_id' => $this->user_id,
            'cart_count' => $this->cart_count,
            'is_saved_for_later' => 1,
        ];
        if ($cart_item != []) {
            $data['product_type'] = $cart_item[0]->product_type;
        }
        $this->dispatch('remove_from_save_later', data: $data);
    }
}
