<?php

namespace App\Services;

use App\Models\Cart;
use App\Models\Address;
use App\Models\City;
use App\Models\Zipcode;
use App\Models\ComboProduct;
use App\Models\Product_variants;
use Illuminate\Support\Str;
use App\Services\DeliveryService;
use App\Services\MediaService;
use App\Services\CurrencyService;
use App\Services\SettingService;
use App\Models\AffiliateTracking;
use Illuminate\Support\Facades\Cache;
class CartService
{
    public function addToCart($data, $check_status = true, $fromApp = false)
    {
        $data = array_map('htmlspecialchars', $data);
        $product_type = $data['product_type'] != null ? explode(',', Str::lower($data['product_type'])) : [];
        $product_variant_ids = explode(',', $data['product_variant_id']);
        $store_id = explode(',', $data['store_id']);
        $qtys = explode(',', $data['qty']);
        // dd($data);

        //  store reference in cache

        if (isset($data['product_reference_id']) && !empty($data['product_reference_id'])) {
            $existingAffiliateReference = json_decode(Cache::get('affiliate_reference'), true) ?? [];

            if (!is_array($existingAffiliateReference)) {
                $existingAffiliateReference = [];
            }

            foreach ($product_variant_ids as $index => $product_variant_id) {
                $existingAffiliateReference[$product_variant_id] = $data['product_reference_id'];
            }

            Cache::put('affiliate_reference', json_encode($existingAffiliateReference), now()->addDays(30));
        }
        //  store reference in cache end

        if ($check_status == true) {

            $check_current_stock_status = validateStock($product_variant_ids, $qtys, $product_type);
            if (!empty($check_current_stock_status) && $check_current_stock_status['error'] == true) {
                return $check_current_stock_status;
            }
        }

        foreach ($product_variant_ids as $index => $product_variant_id) {
            $cart_data = [
                'user_id' => $data['user_id'],
                'product_variant_id' => $product_variant_id,
                'qty' => $qtys[$index],
                'is_saved_for_later' => (isset($data['is_saved_for_later']) && !empty($data['is_saved_for_later']) && $data['is_saved_for_later'] == '1') ? $data['is_saved_for_later'] : '0',
                'store_id' => (isset($store_id) && !empty($store_id)) ? $store_id[$index] : '',
                'product_type' => (isset($product_type) && !empty($product_type)) ? $product_type[$index] : '',
            ];
            if ($qtys[$index] == 0) {

                $this->removeFromCart($cart_data);
            } else {
                $existing_cart_item = Cart::where(['user_id' => $data['user_id'], 'product_variant_id' => $product_variant_id])->first();


                if (!empty($existing_cart_item) && $existing_cart_item != null) {

                    $existing_cart_item->update($cart_data);

                    if ($fromApp == true) {

                        return true;
                    } else {
                        return true;
                    }
                } else {
                    Cart::create($cart_data);
                    if ($fromApp == true) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public function removeFromCart($data)
    {
        $is_saved_for_later = isset($data['is_saved_for_later']) ? $data['is_saved_for_later'] : 0;
        if (isset($data['user_id']) && !empty($data['user_id'])) {
            $query = Cart::where('user_id', $data['user_id']);

            if (isset($data['product_variant_id'])) {
                $product_variant_ids = explode(',', $data['product_variant_id']);
                $query->whereIn('product_variant_id', $product_variant_ids);
            }
            if (isset($data['product_type'])) {
                $product_types = explode(',', $data['product_type']);
                $query->whereIn('product_type', $product_types);
            }
            $query->where('store_id', $data['store_id']);
            $query->where('is_saved_for_later', $is_saved_for_later);

            return $query->delete();
        } else {
            return false;
        }
    }
public function getUserCart($user_id, $address_id = '', $store_id = '', $is_saved_for_later = 0, $affiliate_reference = '')
{
    return $this->getCartTotal(
        $user_id,
        false,
        $is_saved_for_later,
        $address_id,
        $store_id,
        $affiliate_reference
    );
}

    public function getCartTotal($user_id, $product_variant_id = false, $is_saved_for_later = 0, $address_id = '', $store_id = '', $affiliate_reference = '')
    {
        $query = [];
        // get product details from products table
        $productQuery = Cart::with([
            'productVariant.product' => function ($query) {
                $query->with('sellerData', 'category');
            }
        ])
            ->where('user_id', $user_id)
            ->where('qty', '>=', 0)
            ->where('is_saved_for_later', intval($is_saved_for_later))
            ->where('store_id', $store_id)
            ->where('product_type', 'regular')
            ->whereHas('productVariant.product', function ($query) {
                $query->where('status', 1)->whereHas('sellerData', function ($q) {
                    $q->where('status', 1);
                });
            })
            ->whereHas('productVariant', function ($query) {
                $query->where('status', 1);
            })
            ->when($product_variant_id, function ($query) use ($product_variant_id) {
                $query->where('product_variant_id', $product_variant_id);
            })
            ->orderBy('id', 'desc')
            ->get();

        // get product details from combo_products table

        $comboProductQuery = Cart::with('comboProduct.sellerData')
            ->where('user_id', $user_id)
            ->where('qty', '>=', 0)
            ->where('is_saved_for_later', intval($is_saved_for_later))
            ->where('store_id', $store_id)
            ->where('product_type', 'combo')
            ->whereHas('comboProduct', function ($query) {
                $query->where('status', 1)->whereHas('sellerData', function ($q) {
                    $q->where('status', 1);
                });
            })
            ->when($product_variant_id, function ($query) use ($product_variant_id) {
                $query->where('product_variant_id', $product_variant_id);
            })
            ->orderBy('id', 'desc')
            ->get();
        $query = $productQuery->merge($comboProductQuery);
        $total = [];
        $total = [];
        $sub_totals = []; // Accumulator for Display Subtotal (Base Price)
        $msrp_totals = []; // Accumulator for MSRP (for discount calc)
        $item_total = []; // Legacy naming: usually MSRP? Or Line Total? We will map explicitly logic.
        $variant_id = [];
        $quantity = [];
        $percentage = [];
        $amount = [];
        $cod_allowed = 1;
        $download_allowed = [];
        $totalItems = 0;
        $product_qty = '';
        $product_ids = [];
        $cart_product_type = [];
        $tax_details = [];


        // get affiliate reference from cache
        // dd($affiliate_reference);
      if (isset($affiliate_reference) && !empty($affiliate_reference)) {
        if (is_array($affiliate_reference)) {
            $affiliateReference = $affiliate_reference; // Already array
        } else {
            $affiliateReference = json_decode($affiliate_reference, true) ?? [];
        }
     }

        // $affiliate_data = [];


        // if (!empty($affiliateReference) && is_array($affiliateReference)) {
        //     $variantIds = array_keys($affiliateReference);
        //     // dd($variantIds);
        //     // Step 1: Get variants using Eloquent
        //     $variants = Product_variants::whereIn('id', $variantIds)->get(['id', 'product_id']);

        //     // Step 2: Build product_id => token mapping
        //     foreach ($variants as $variant) {
        //         $variantId = $variant->id;
        //         $productId = $variant->product_id;

        //         if (isset($affiliateReference[$variantId])) {
        //             $affiliate_data[$productId] = $affiliateReference[$variantId];
        //         }
        //     }

        //     // Step 3: Query AffiliateTracking model using OR conditions
        //     $affiliateQuery = AffiliateTracking::where(function ($q) use ($affiliate_data) {
        //         foreach ($affiliate_data as $productId => $token) {
        //             $q->orWhere(function ($subQ) use ($productId, $token) {
        //                 $subQ->where('product_id', $productId)
        //                     ->where('token', $token);
        //             });
        //         }
        //     });

        //     $affiliate_commission_data = $affiliateQuery->get();
        // }
        // dd($affiliate_commission_data);

        $affiliate_data = [];

        // Prepare regular product affiliate data
        if (!empty($affiliateReference) && is_array($affiliateReference)) {
            $variantIds = array_keys($affiliateReference);
            // dd($variantIds);
            // Fetch variants only for regular products
            $variants = Product_variants::whereIn('id', $variantIds)->get(['id', 'product_id']);

            foreach ($variants as $variant) {
                $variantId = $variant->id;
                $productId = $variant->product_id;

                if (isset($affiliateReference[$variantId])) {
                    $affiliate_data[$productId] = $affiliateReference[$variantId];
                }
            }

            // Handle combo products
            foreach ($comboProductQuery as $comboCartItem) {
                $product = $comboCartItem->comboProduct; // Should already be eager loaded

                if ($product && isset($affiliateReference[$comboCartItem->product_variant_id])) {
                    $affiliate_data[$product->id] = $affiliateReference[$comboCartItem->product_variant_id];
                }
            }
            // dd($affiliate_data);
            // Query affiliate tracking records
            $affiliateQuery = AffiliateTracking::where(function ($q) use ($affiliate_data) {
                foreach ($affiliate_data as $productId => $token) {
                    $q->orWhere(function ($subQ) use ($productId, $token) {
                        $subQ->where('product_id', $productId)
                            ->where('token', $token);
                    });
                }
            });

            $affiliate_commission_data = $affiliateQuery->get();
        }
        // dd($affiliate_commission_data);
        if (!$query->isEmpty()) {

            foreach ($query as $result) {
                $totalItems += $result->qty;
            }

            foreach ($query as $i => $item) {
                $type = $item->product_type;
                if ($type == 'combo') {
                    $product = $item->comboProduct;
                } else {
                    $product = $item->product;
                    $category_ids[$i] = $product->category_id;
                }

                $product_ids[$i] = $item->product?->id;
                $cart_product_type[$i] = $type;
                $tax_percentage = $product->getTaxPercentages();
                $tax_titles = $product->getTaxTitles();
                $total_tax_percent = array_sum(array_map('floatval', $tax_percentage));
                $is_inclusive = isset($product->is_prices_inclusive_tax) && $product->is_prices_inclusive_tax == 1;

                // Set tax info on item
                $item->item_tax_percentage = implode(',', $tax_percentage);
                $item->tax_title = implode(',', $tax_titles);

                if ($type == 'combo') {
                    $item_price = $product->price ?? 0;
                    $item_special_price = $product->special_price ?? 0;
                } else {
                    $item_price = $item->productVariant['price'] ?? 0;
                    $item_special_price = $item->productVariant['special_price'] ?? 0;
                }

                $effective_price = ($item_special_price > 0 && $item_special_price < $item_price)
                    ? $item_special_price
                    : $item_price;

                // --- 2. Calculate Subtotal, Tax, and Total per Unit ---
                // Rule 1: Inclusive Tax
                if ($is_inclusive) {
                    $unit_subtotal = $effective_price; // Subtotal = Given Price
                    
                    // Tax extracted from price: (Price * Rate) / (100 + Rate)
                    $unit_tax_amount = ($total_tax_percent > 0) 
                        ? ($effective_price * $total_tax_percent) / (100 + $total_tax_percent) 
                        : 0;
                        
                    $unit_total = $unit_subtotal; // Total = Subtotal (No extra tax)
                    $tax_label = 'Inclusive';
                } 
                // Rule 2: Exclusive Tax
                else {
                    $unit_subtotal = $effective_price; // Subtotal = Base Price
                    
                    // Tax added to price: Price * (Rate / 100)
                    $unit_tax_amount = ($effective_price * $total_tax_percent) / 100;
                    
                    $unit_total = $unit_subtotal + $unit_tax_amount; // Total = Subtotal + Tax
                    $tax_label = 'Exclusive';
                }

                $item->tax_label = $tax_label;

                // --- 3. Currency Conversion & Line Accumulation ---
                $currencyService = app(CurrencyService::class);
                
                $line_subtotal = $unit_subtotal * $item->qty; // Sale Base
                $line_tax_amount = $unit_tax_amount * $item->qty;
                $line_total = $unit_total * $item->qty; // Sale Final

                // Calculate MSRP (Regular Price) Line Total for Discount Logic
                // If Exclusive: MSRP = Price + TaxOnPrice. 
                // If Inclusive: MSRP = Price.
                if ($is_inclusive) {
                    $unit_msrp = $item_price;
                } else {
                    $tax_on_msrp = ($item_price * $total_tax_percent) / 100;
                    $unit_msrp = $item_price + $tax_on_msrp; 
                }
                $line_msrp_total = $unit_msrp * $item->qty;

                // Populate global arrays (converted to currency)
                // $total -> Final Line Total (Sale + Tax/Included) -> Used for Payment
                $total[$i] = $currencyService->currentCurrencyPrice($line_total); 
                
                // $sub_totals -> Display Subtotal (Sale Base) -> Used for "Subtotal" row
                $sub_totals[$i] = $currencyService->currentCurrencyPrice($line_subtotal);

                // $msrp_totals -> MSRP Total -> Used for Discount (MSRP - Sale)
                $msrp_totals[$i] = $currencyService->currentCurrencyPrice($line_msrp_total);
                
                // Keep legacy array structure if needed, but we will use specific sums below
                $item_total[$i] = $msrp_totals[$i]; 
                $amount[$i] = $currencyService->currentCurrencyPrice($line_tax_amount);
                
                // Helper for legacy 'price_tax_amount' needed for variant update below
                if (!$is_inclusive) {
                     $price_tax_amount = $item_price * ($total_tax_percent / 100);
                     $special_price_tax_amount = $item_special_price * ($total_tax_percent / 100);
                } else {
                     $price_tax_amount = 0;
                     $special_price_tax_amount = 0;
                }

                 // --- 4. Tax Details Breakdown ---
                if (!empty($tax_percentage)) {
                    foreach ($tax_percentage as $idx => $percent) {
                        $tax_title = $tax_titles[$idx] ?? 'Tax';
                        
                        // Calculate specific share of the total tax amount
                        if ($total_tax_percent > 0) {
                            $share_amount = ($unit_tax_amount * $percent) / $total_tax_percent;
                        } else {
                            $share_amount = 0;
                        }
                        
                        $share_total = $share_amount * $item->qty;
                        $converted_share = $currencyService->currentCurrencyPrice($share_total);

                        if (!isset($tax_details[$tax_title])) {
                            $tax_details[$tax_title] = [
                                'title' => $tax_title,
                                'percentage' => $percent,
                                'amount' => 0,
                                'tax_label' => $tax_label,
                            ];
                        }
                        $tax_details[$tax_title]['amount'] += $converted_share;
                    }
                }

                if ($product['cod_allowed'] == 0) {
                    $cod_allowed = 0;
                }
                $variant_id[$i] = $item->product_variant_id;
                $quantity[$i] = intval($item->qty);


                // affilicate code
                $item->total_subtotal_amount = array_sum($total);

                // if (isset($affiliate_commission_data) && !empty($affiliate_commission_data)) {
                //     foreach ($affiliate_commission_data as $affiliate_commission_data_item) {
                //         $affiliate_commission_amount = ($item->total_subtotal_amount * $affiliate_commission_data_item['category_commission']) / 100;
                //         dd($item->comboProduct);
                //         if ($item->product?->id == $affiliate_commission_data_item['product_id']) {
                //             $item->affiliate_id = $affiliate_commission_data_item['affiliate_id'];
                //             $item->affiliate_token = $affiliate_commission_data_item['token'];
                //             $item->category_commission = $affiliate_commission_data_item['category_commission'];
                //             $item->affiliate_commission_amount = $affiliate_commission_amount;
                //         }
                //     }
                // } else {
                //     $item->affiliate_token = '';
                //     $item->affiliate_id = '';
                //     $item->category_commission = '';
                //     $item->affiliate_commission_amount = '';
                // }


                if (isset($affiliate_commission_data) && !empty($affiliate_commission_data)) {
                    foreach ($affiliate_commission_data as $affiliate_commission_data_item) {
                        $affiliate_commission_amount = ($item->total_subtotal_amount * $affiliate_commission_data_item['category_commission']) / 100;

                        // Check based on product_type
                        if (
                            ($item->product_type == 'regular' && $item->product?->id == $affiliate_commission_data_item['product_id']) ||
                            ($item->product_type == 'combo' && $item->comboProduct?->id == $affiliate_commission_data_item['product_id'])
                        ) {
                            $item->affiliate_id = $affiliate_commission_data_item['affiliate_id'];
                            $item->affiliate_token = $affiliate_commission_data_item['token'];
                            $item->category_commission = $affiliate_commission_data_item['category_commission'];
                            $item->affiliate_commission_amount = $affiliate_commission_amount;
                            break;
                        }
                    }
                } else {
                    $item->affiliate_token = '';
                    $item->affiliate_id = '';
                    $item->category_commission = '';
                    $item->affiliate_commission_amount = '';
                }

                // affilicate code end

                // --- 6. Update Item Object for Response ---
                
                if ($type !== 'combo') {
                    $item->productVariant['special_price'] = $item_special_price;
                    $item->productVariant['price'] = $item_price;
                    $item->productVariant['id'] = $item->product_variant_id;
                    $item->id = $item->product_variant_id;
                }
                
                $percentage[$i] = $total_tax_percent;
                
                // Add new fields requested
                $item->subtotal = $currencyService->currentCurrencyPrice($line_subtotal);
                $item->tax_amount = $currencyService->currentCurrencyPrice($line_tax_amount);
                $item->total_price = $currencyService->currentCurrencyPrice($line_total);
                // dd($item->product_type);
                if ($item->product_type != 'combo') {
                    $item->product_variants = app(ProductService::class)->getVariantsValuesById($item->id);
                } else {
                    $item->type = 'combo';
                }
                array_push($download_allowed, $item->download_allowed);

                $item->cart_product_type = $item->product_type;
                $item->cart_count = $query->count();

                $item->total_items = $totalItems;
                $product_qty .= $item->qty . ',';

                $query[$i] = (object) $item;

                $item->image = app(MediaService::class)->getMediaImageUrl($item->image);
                // dd($item->productVariant);
                $items[] = $item;
                // dd($items);
            }



            $total_sum = array_sum($total); // Final Total
            $sub_total_sum = array_sum($sub_totals); // Display Subtotal (Base)
            $msrp_sum = array_sum($msrp_totals); // MSRP Total (for discount)

            $settings = app(DeliveryService::class)->getDeliveryChargeSetting($store_id);

            $shipping_settings = app(SettingService::class)->getSettings('shipping_method', true);
            $shipping_settings = json_decode($shipping_settings, true);

            $delivery_charge = '';
            // dd($address_id);
            if (!empty($address_id)) {
                $address = fetchDetails(Address::class, ['id' => $address_id], ['area_id', 'area', 'pincode', 'city']);
                $pincode = !$address->isEmpty() ? $address[0]->pincode : 0;
                $zipcode_id = fetchDetails(Zipcode::class, ['zipcode' => $address[0]->pincode], 'id');
                $city_id = fetchDetails(City::class, ['name' => $address[0]->city], 'id');

                if (isset($settings[0]->product_deliverability_type) && !empty($settings[0]->product_deliverability_type)) {
                    if ($settings[0]->product_deliverability_type == 'city_wise_deliverability') {
                        $tmpRow['is_deliverable'] = !$city_id->isEmpty() && $city_id[0]->id > 0 ?
                            app(DeliveryService::class)->isProductDelivarable('city', $city_id[0]->id, $query[0]->product_id, $query[0]->cart_product_type)
                            : false;
                    } else {
                        $tmpRow['is_deliverable'] = !$zipcode_id->isEmpty() && $zipcode_id[0]->id > 0 ?
                            app(DeliveryService::class)->isProductDelivarable('zipcode', $zipcode_id[0]->id, $query[0]->product_id, $query[0]->cart_product_type)
                            : false;
                    }
                }
                // dd('here');
                $tmpRow['delivery_by'] = $tmpRow['is_deliverable'] ? "local" : ((isset($shipping_settings['shiprocket_shipping_method']) && $shipping_settings['shiprocket_shipping_method'] == 1) ? 'standard_shipping' : '');
                if (isset($tmpRow['delivery_by']) && $tmpRow['delivery_by'] === 'standard_shipping') {

                    $parcels = app(ShiprocketService::class)->makeShippingParcels($query);
                    $parcels_details = app(ShiprocketService::class)->checkParcelsDeliverability($parcels, $pincode);
                    $delivery_charge = $parcels_details['delivery_charge_without_cod'];
                } else {
                    // dd($query[0]->product_id);
                    // dd($is_saved_for_later);
                    $product_availability = app(DeliveryService::class)->checkCartProductsDeliverable($user_id, '', '', $store_id, '', '', $is_saved_for_later);
                    // dd($product_availability);
                    $cart = [];
                    for ($i = 0; $i < count($query); $i++) {
                        $cart[$i] = (array) $query[$i];
                        $cart[$i]['product_qty'] = $product_availability[$i]['product_qty'] ?? 1;
                        $cart[$i]['minimum_free_delivery_order_qty'] = $product_availability[$i]['minimum_free_delivery_order_qty'] ?? 0;
                        $cart[$i]['product_delivery_charge'] = $product_availability[$i]['product_delivery_charge'] ?? 0;
                        $cart[$i]['delivery_by'] = $product_availability[$i]['delivery_by'] ?? 'local';
                        $cart[$i]['currency_product_delivery_charge_data'] = app(CurrencyService::class)->getPriceCurrency($cart[$i]['product_delivery_charge']);
                        if (isset($cart[$i]['delivery_by']) && $cart[$i]['delivery_by'] == "standard_shipping") {
                            $standard_shipping_cart[] = $cart[$i];
                        } else {
                            $local_shipping_cart[] = $cart[$i];
                        }
                    }

                    // dd('here');

                    $delivery_charge = app(DeliveryService::class)->getDeliveryCharge($address_id, $total_sum, $local_shipping_cart, $store_id);

                    // dd($delivery_charge);
                    if (isset($settings[0]->delivery_charge_type) && !empty($settings[0]->delivery_charge_type) && $settings[0]->delivery_charge_type == 'product_wise_delivery_charge') {

                        $deliveryCharge = 0;
                        foreach ($delivery_charge as $row) {
                            $deliveryCharge += isset($row['delivery_charge']) && !empty($row['delivery_charge']) ? $row['delivery_charge'] : 0;
                        }
                        $delivery_charge = $deliveryCharge;
                    }
                    // dd($delivery_charge);
                }
            }

            // dd($items);
            // Sums calculated above
            
            $delivery_charge = isset($query[0]->type) && $query[0]->type == 'digital_product' ? 0 : $delivery_charge;
            $discount = $msrp_sum - $total_sum;
            
            $tax_amount = array_sum($amount);
            $overall_amt = (float) $total_sum + (float) $delivery_charge;
            $query[0]->is_cod_allowed = $cod_allowed;
            
            $query['sub_total'] = strval($sub_total_sum); // This now strictly follows "Base Price" rule
            $query['item_total'] = strval($msrp_sum); // Used for saving/reference?
            $query['discount'] = strval($discount);
            $query['discount'] = strval($discount);
            $query['currency_sub_total_data'] = app(CurrencyService::class)->getPriceCurrency($query['sub_total']);
            $query['product_quantity'] = $product_qty;
            $query['quantity'] = strval(array_sum($quantity));
            $query['tax_percentage'] = strval(array_sum(array_map('floatval', is_string($percentage) ? explode(',', $percentage) : $percentage)));
            $query['tax_amount'] = strval(array_sum($amount));
            $query['currency_tax_amount_data'] = app(CurrencyService::class)->getPriceCurrency($query['tax_amount']);
            $query['total_arr'] = $total_sum;
            $query['currency_total_arr_data'] = app(CurrencyService::class)->getPriceCurrency($query['total_arr']);
            $query['variant_id'] = $variant_id;
            $query['delivery_charge'] = $delivery_charge;
            $query['currency_delivery_charge_data'] = app(CurrencyService::class)->getPriceCurrency($query['delivery_charge']);
            $query['overall_amount'] = strval($overall_amt);
            $query['currency_overall_amount_data'] = app(CurrencyService::class)->getPriceCurrency($query['overall_amount']);
            $query['amount_inclusive_tax'] = strval($overall_amt);
            $query['currency_amount_inclusive_tax_data'] = app(CurrencyService::class)->getPriceCurrency($query['amount_inclusive_tax']);
            $query['tax_details'] = $tax_details;
            $query['download_allowed'] = $download_allowed;
            $query['cart_items'] = $items;
        }
        return $query;
    }

    public function isSingleSeller($product_variant_id, $user_id, $product_type = "", $store_id = '')
    {
        if (empty($product_variant_id) || empty($user_id)) {
            return false;
        }

        $variantIds = is_string($product_variant_id) && strpos($product_variant_id, ',') !== false
            ? explode(',', $product_variant_id)
            : (array) $product_variant_id;

        $carts = Cart::with([
            'productVariant.product.sellerData',
            'comboProduct'
        ])
            ->where('user_id', $user_id)
            ->where('is_saved_for_later', 0)
            ->where('store_id', $store_id)
            ->get();

        $sellerIds = [];

        foreach ($carts as $cart) {
            if ($cart->productVariant && $cart->productVariant->product && $cart->productVariant->product->sellerData) {
                $sellerIds[] = $cart->productVariant->product->sellerData->id;
            }

            if ($cart->comboProduct) {
                $sellerIds[] = $cart->comboProduct->seller_id;
            }
        }

        $uniqueSellerIds = array_values(array_unique(array_filter($sellerIds)));

        if (empty($uniqueSellerIds)) {
            return true;
        }

        $newSellerId = null;

        if ($product_type == 'regular') {
            $variant = Product_variants::with('product.sellerData')
                ->whereIn('id', $variantIds)
                ->first();

            $newSellerId = $variant?->product?->sellerData?->id;
        } else {
            $comboProduct = ComboProduct::whereIn('id', $variantIds)->first();
            $newSellerId = $comboProduct?->seller_id;
        }

        if (!empty($newSellerId)) {
            return in_array($newSellerId, $uniqueSellerIds);
        }

        return false;
    }
    public function isSingleProductType($product_variant_id, $user_id, $product_type, $store_id = '')
    {
        if (empty($product_variant_id) || empty($user_id)) {
            return false;
        }

        $variantIds = is_string($product_variant_id) && strpos($product_variant_id, ',') !== false
            ? explode(',', $product_variant_id)
            : (array) $product_variant_id;

        $productTypes = [];

        // 1️⃣ Get types from incoming product(s)
        if ($product_type == 'regular') {
            $productVariants = Product_variants::with('product')
                ->whereIn('id', $variantIds)
                ->get();

            foreach ($productVariants as $variant) {
                if ($variant->product) {
                    $productTypes[] = $variant->product->type;
                }
            }
        } else {
            $comboProducts = ComboProduct::whereIn('id', $variantIds)->get();
            foreach ($comboProducts as $combo) {
                $productTypes[] = $combo->product_type;
            }
        }

        // Flatten + clean types
        $productTypes = array_unique(array_filter($productTypes));

        $hasDigitalProduct = in_array('digital_product', $productTypes);
        $hasSimpleOrPhysical = array_intersect(['simple_product', 'variable_product', 'physical_product'], $productTypes);

        if ($hasDigitalProduct && !empty($hasSimpleOrPhysical)) {
            return false;
        }

        // 2️⃣ Get existing cart product types
        $carts = Cart::with(['productVariant.product', 'comboProduct'])
            ->where('user_id', $user_id)
            ->where('store_id', $store_id)
            ->where('is_saved_for_later', 0)
            ->get();

        $existingTypes = [];

        foreach ($carts as $cart) {
            if ($cart->productVariant && $cart->productVariant->product) {
                $existingTypes[] = $cart->productVariant->product->type;
            }
            if ($cart->comboProduct) {
                $existingTypes[] = $cart->comboProduct->product_type;
            }
        }

        $existingTypes = array_values(array_unique(array_filter($existingTypes)));

        // If no products in cart, allow
        if (empty($existingTypes)) {
            return true;
        }

        // 3️⃣ Get the new product type for comparison (assume first only)
        $newProductType = $productTypes[0] ?? null;

        if (!$newProductType) {
            return false;
        }

        // 4️⃣ Validate product type consistency
        if (in_array($newProductType, $existingTypes)) {
            return true;
        }

        if (
            !in_array('digital_product', $existingTypes) &&
            in_array($newProductType, ['simple_product', 'variable_product', 'physical_product'])
        ) {
            return true;
        }

        return false;
    }

    public function getCartCount($user_id, $store_id = '')
    {
        if (!empty($user_id)) {
            $count = Cart::where('user_id', $user_id)
                ->where('qty', '!=', 0)
                ->where('store_id', $store_id)
                ->where('is_saved_for_later', 0)
                ->distinct()
                ->count();
        } else {
            $count = 0;
        }
        return $count;
    }
    public function isVariantAvailableInCart($product_variant_id, $user_id)
    {
        // Use Eloquent to check if the variant is available in the cart\
        $cartItem = Cart::where('product_variant_id', $product_variant_id)
            ->where('user_id', $user_id)
            ->where('qty', '>', 0)
            ->where('is_saved_for_later', 0)
            ->select('id')
            ->first();


        return !is_null($cartItem);
    }
}
