<?php

namespace App\Services;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Config;
use SplFileInfo;
use Illuminate\Support\Str;
use Spatie\MediaLibrary\MediaCollections\Filesystem as MediaFilesystem;
use Illuminate\Contracts\Filesystem\Factory as FilesystemFactory;
use Debugbar;

class MediaService
{
    public function findMediaType($extenstion)
    {
        $mediaTypes = config('eshop_pro.type');

        foreach ($mediaTypes as $mainType => $mediaType) {
            if (in_array(strtolower($extenstion), $mediaType['types'])) {

                return [$mainType, $mediaType['icon']];
            }
        }
        return false;
    }
    public function getImageUrl($path, $image_type = '', $image_size = '', $file_type = 'image', $const = 'MEDIA_PATH')
    {
        // If the path is already a full URL (S3 or external), just return it
        if (filter_var($path, FILTER_VALIDATE_URL)) {
            return $path;
        }

        $pathParts = explode('/', $path);
        $subdirectory = implode("/", array_slice($pathParts, 0, -1));
        $image_name = end($pathParts);
        $file_main_dir = str_replace('\\', '/', public_path(config('constants.' . $const) . $subdirectory));
        // dd($file_main_dir);

        if ($file_type == 'image') {
            $types = ['thumb', 'cropped'];
            $sizes = ['md', 'sm'];

            if (in_array(strtolower($image_type), $types) && in_array(strtolower($image_size), $sizes)) {
                $filepath = $file_main_dir . '/' . $image_type . '-' . $image_size . '/' . $image_name;

                if (File::exists($filepath)) {
                    return $this->customAsset(config('constants.' . $const) . '/' . $path);
                } elseif (File::exists($file_main_dir . '/' . $image_name)) {
                    return $this->customAsset(config('constants.' . $const) . '/' . $path);
                } else {
                    return asset(Config::get('constants.NO_IMAGE'));
                }
            } else {
                // dd($file_main_dir . '/' . $image_name,File::exists($file_main_dir . '/' . $image_name));
                if (File::exists($file_main_dir . '/' . $image_name)) {
                    return $this->customAsset(config('constants.' . $const) . '/' . $path);
                } else {
                    // If CDN is configured, we can still try to return the path on the CDN
                    if (config('constants.CDN_URL')) {
                        return $this->customAsset(config('constants.' . $const) . '/' . $path);
                    }
                    return asset(Config::get('constants.NO_IMAGE'));
                }
            }
        } else {
            $file = new SplFileInfo($file_main_dir . '/' . $image_name);
            $ext = $file->getExtension();
            $media_data = $this->findMediaType($ext);

            if (is_array($media_data) && isset($media_data[1])) {
                $imagePlaceholder = $media_data[1];
            } else {
                return asset(Config::get('constants.NO_IMAGE'));
            }

            $filepath = str_replace('\\', '/', public_path($imagePlaceholder));
            if (File::exists($filepath)) {
                return $this->customAsset($imagePlaceholder);
            } else {
                return asset(Config::get('constants.NO_IMAGE'));
            }
        }
    }

    public function removeMediaFile($path, $disk)
    {


        // Instantiate the Spatie Media Library Filesystem
        $mediaFileSystem = app(MediaFilesystem::class);

        // Instantiate the FilesystemFactory
        $filesystem = app(FilesystemFactory::class);

        // Instantiate the CustomFileRemover with the dependencies
        $fileRemover = new CustomFileRemover($mediaFileSystem, $filesystem);

        if ($disk == 's3') {
            // Get the last two segments of the path
            $path = implode('/', array_slice(explode('/', $path), -2));
        }


        $fileRemover->removeFile($path, $disk);
    }

    public function dynamic_image($image, $width, $quality = 90)
    {
        return $this->normalizeImageUrl($image);
        return route('front_end.dynamic_image', [
            'url' => $this->normalizeImageUrl($image),
            'width' => $width,
            'quality' => $quality,
        ]);
    }

    private function normalizeImageUrl($image, $const = 'MEDIA_PATH')
    {
        // If empty, fallback to NO_IMAGE
        if (empty($image)) {
            return asset(config('constants.NO_IMAGE'));
        }

        // If already full URL, just return it
        if (Str::startsWith($image, ['http://', 'https://'])) {
            return $image;
        }

        // Otherwise assume it’s a relative path inside your MEDIA_PATH
        return $this->customAsset(config('constants.' . $const) . $image);
    }
    private function buildPublicFilePath($image, $const = 'MEDIA_PATH')
    {
        $basePath = rtrim(config('constants.' . $const), '/');
        $normalized = ltrim($image, '/');
        return public_path($basePath . '/' . $normalized);
    }
    private function buildPublicFilePathAdmin($image, $const = 'MEDIA_PATH')
    {
        $basePath = rtrim(config('constants.' . $const), '/');
        $normalized = ltrim($image, '/');
        return public_path($basePath . '/' . $normalized);
    }

    public function getMediaImageUrl($image, $const = 'MEDIA_PATH')
    {
        if (empty($image)) {
            return asset(config('constants.NO_IMAGE'));
        }

        // Already full URL
        if (Str::startsWith($image, ['http://', 'https://'])) {
            return $image;
        }

        // Build proper path
        $filePath = $this->buildPublicFilePath($image, $const);
        $filePathAdmin = $this->buildPublicFilePathAdmin($image, $const);
        // dd($filePathAdmin);
        if (File::exists($filePath)) {
            // Corrected asset path generation
            $basePath = rtrim(config('constants.' . $const), '/');
            $normalized = ltrim($image, '/');
            return $this->customAsset($basePath . '/' . $normalized);
        }

        // Add fallback if CDN is configured
        if (config('constants.CDN_URL')) {
            $basePath = rtrim(config('constants.' . $const), '/');
            $normalized = ltrim($image, '/');
            return $this->customAsset($basePath . '/' . $normalized);
        }

        return asset(config('constants.NO_IMAGE'));
    }

    private function customAsset($path)
    {

        $cdnDomain = config('constants.CDN_URL', config('app.url'));
        // dd("sd",config('constants.CDN_URL', config('app.url')),rtrim($cdnDomain, '/') . '/' . ltrim($path, '/'));
//        Debugbar::info("sd",config('constants.CDN_URL', config('app.url')),rtrim($cdnDomain, '/') . '/' . ltrim($path, '/'));
        return rtrim($cdnDomain, '/') . '/' . ltrim($path, '/');
    }

    private function customPublicPath($path = '', $const = 'MEDIA_PATH')
    {
        $basePublicPath = config('constants.PUBLIC_PATH', public_path());
        return rtrim($basePublicPath, '/') . '/' . ltrim(config('constants.' . $const) . '/' . $path, '/');
    }



}
