<?php

return [
    'type' => [
        'image' => [
            'types' => ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'eps', 'webp', 'svg'],
            'icon' => ''
        ],
        'video' => [
            'types' => ['mp4','mp3', '3gp', 'avchd', 'avi', 'flv', 'mkv', 'mov', 'webm', 'wmv', 'mpg', 'mpeg', 'ogg'],
            'icon' => 'assets/admin/images/video-file.png'
        ],
        'document' => [
            'types' => ['doc', 'docx', 'txt', 'pdf', 'ppt', 'pptx','csv'],
            'icon' => 'assets/admin/images/doc-file.png'
        ],
        'spreadsheet' => [
            'types' => ['xls', 'xlsx'],
            'icon' => 'assets/admin/images/xls-file.png'
        ],
        'archive' => [
            'types' => ['zip', '7z', 'bz2', 'gz', 'gzip', 'rar', 'tar'],
            'icon' => 'assets/admin/images/archive-file.png'
        ]
    ],

    'identity_column' =>  "mobile",

    'supported_locales' => [
        "af" => "ZAR",
        "am" => "ETB",
        'ar_DZ' => "DZD",
        "ar_EG" => "EGP",
        "az" => "AZN",
        "be" => "BYN",
        "bg" => "BGN",
        "bn" => "BDT",
        "br" => "EUR",
        "bs" => "BAM",
        "ca" => "EUR",
        "chr" => "USD",
        "cs" => "CZK",
        "cy" => "GBP",
        "da" => "DKK",
        "de" => "EUR",
        "de_AT" => "EUR",
        "de_CH" => "CHF",
        "el" => "EUR",
        "en" => "USD",
        "en_AU" => "AUD",
        "en_CA" => "CAD",
        "en_GB" => "GBP",
        "en_IE" => "EUR",
        "en_IN" => "INR",
        "en_MY" => "MYR",
        "en_SG" => "SGD",
        "en_US" => "USD",
        "en_ZA" => "ZAR",
        "es" => "EUR",
        "es_419" => "MXN",
        "es_ES" => "EUR",
        "es_MX" => "MXN",
        "es_US" => "USD",
        "et" => "EUR",
        "eu" => "EUR",
        "fi" => "EUR",
        "fil" => "PHP",
        "fr" => "EUR",
        "fr_CA" => "CAD",
        "fr_CH" => "CHF",
        "ga" => "EUR",
        "gl" => "EUR",
        "gsw" => "CHF",
        "gu" => "INR",
        "haw" => "USD",
        "he" => "ILS",
        "hi" => "INR",
        "hr" => "HRK",
        "hu" => "HUF",
        "hy" => "AMD",
        "id" => "IDR",
        "in" => "IDR",
        "is" => "ISK",
        "it" => "EUR",
        "it_CH" => "CHF",
        "iw" => "ILS",
        "ja" => "JPY",
        "ka" => "GEL",
        "kk" => "KZT",
        "km" => "KHR",
        "kn" => "INR",
        "ko" => "KRW",
        "ky" => "KGS",
        "ln" => "CDF",
        "lo" => "LAK",
        "lt" => "EUR",
        "lv" => "EUR",
        "mk" => "MKD",
        "ml" => "INR",
        "mn" => "MNT",
        "mr" => "INR",
        "ms" => "MYR",
        "mt" => "EUR",
        "nb" => "NOK",
        "ne" => "NPR",
        "nl" => "EUR",
        "no" => "NOK",
        "no_NO" => "NOK",
        "or" => "INR",
        "pa" => "INR",
        "pl" => "PLN",
        "pt" => "BRL",
        "pt_BR" => "BRL",
        "pt_PT" => "EUR",
        "ro" => "RON",
        "ru" => "RUB",
        "si" => "LKR",
        "sk" => "EUR",
        "sl" => "EUR",
        "sq" => "ALL",
        "sr" => "RSD",
        "sr_Latn" => "RSD",
        "sv" => "SEK",
        "sw" => "TZS",
        "ta" => "INR",
        "te" => "INR",
        "th" => "THB",
        "tl" => "PHP",
        "tr" => "TRY",
        "uk" => "UAH",
        "ur" => "PKR",
        "uz" => "UZS",
        "vi" => "VND",
        "zh" => "CNY",
        "zh_CN" => "CNY",
        "zh_HK" => "HKD",
        "zh_TW" => "TWD",
        "zu" => "ZAR"
    ],
    'supported_locales_list' => [
        "AED" => "United Arab Emirates Dirham",
        "AFN" => "Afghanistan Afghani",
        "ALL" => "Albania Lek",
        "AMD" => "Armenia Dram",
        "ANG" => "Netherlands Antilles Guilder",
        "AOA" => "Angola Kwanza",
        "ARS" => "Argentina Peso",
        "AUD" => "Australia Dollar",
        "AWG" => "Aruba Guilder",
        "AZN" => "Azerbaijan Manat",
        "BAM" => "Bosnia and Herzegovina Convertible Mark",
        "BBD" => "Barbados Dollar",
        "BDT" => "Bangladesh Taka",
        "BGN" => "Bulgaria Lev",
        "BHD" => "Bahrain Dinar",
        "BIF" => "Burundi Franc",
        "BMD" => "Bermuda Dollar",
        "BND" => "Brunei Darussalam Dollar",
        "BOB" => "Bolivia Bolíviano",
        "BRL" => "Brazil Real",
        "BSD" => "Bahamas Dollar",
        "BTN" => "Bhutan Ngultrum",
        "BWP" => "Botswana Pula",
        "BYN" => "Belarus Ruble",
        "BZD" => "Belize Dollar",
        "CAD" => "Canada Dollar",
        "CDF" => "Congo/Kinshasa Franc",
        "CHF" => "Switzerland Franc",
        "CLP" => "Chile Peso",
        "CNY" => "China Yuan Renminbi",
        "COP" => "Colombia Peso",
        "CRC" => "Costa Rica Colon",
        "CUC" => "Cuba Convertible Peso",
        "CUP" => "Cuba Peso",
        "CVE" => "Cape Verde Escudo",
        "CZK" => "Czech Republic Koruna",
        "DJF" => "Djibouti Franc",
        "DKK" => "Denmark Krone",
        "DOP" => "Dominican Republic Peso",
        "DZD" => "Algeria Dinar",
        "EGP" => "Egypt Pound",
        "ERN" => "Eritrea Nakfa",
        "ETB" => "Ethiopia Birr",
        "EUR" => "Euro Member Countries",
        "FJD" => "Fiji Dollar",
        "FKP" => "Falkland Islands (Malvinas) Pound",
        "GBP" => "United Kingdom Pound",
        "GEL" => "Georgia Lari",
        "GGP" => "Guernsey Pound",
        "GHS" => "Ghana Cedi",
        "GIP" => "Gibraltar Pound",
        "GMD" => "Gambia Dalasi",
        "GNF" => "Guinea Franc",
        "GTQ" => "Guatemala Quetzal",
        "GYD" => "Guyana Dollar",
        "HKD" => "Hong Kong Dollar",
        "HNL" => "Honduras Lempira",
        "HRK" => "Croatia Kuna",
        "HTG" => "Haiti Gourde",
        "HUF" => "Hungary Forint",
        "IDR" => "Indonesia Rupiah",
        "ILS" => "Israel Shekel",
        "IMP" => "Isle of Man Pound",
        "INR" => "India Rupee",
        "IQD" => "Iraq Dinar",
        "IRR" => "Iran Rial",
        "ISK" => "Iceland Krona",
        "JEP" => "Jersey Pound",
        "JMD" => "Jamaica Dollar",
        "JOD" => "Jordan Dinar",
        "JPY" => "Japan Yen",
        "KES" => "Kenya Shilling",
        "KGS" => "Kyrgyzstan Som",
        "KHR" => "Cambodia Riel",
        "KMF" => "Comorian Franc",
        "KPW" => "Korea (North) Won",
        "KRW" => "Korea (South) Won",
        "KWD" => "Kuwait Dinar",
        "KYD" => "Cayman Islands Dollar",
        "KZT" => "Kazakhstan Tenge",
        "LAK" => "Laos Kip",
        "LBP" => "Lebanon Pound",
        "LKR" => "Sri Lanka Rupee",
        "LRD" => "Liberia Dollar",
        "LSL" => "Lesotho Loti",
        "LYD" => "Libya Dinar",
        "MAD" => "Morocco Dirham",
        "MDL" => "Moldova Leu",
        "MGA" => "Madagascar Ariary",
        "MKD" => "Macedonia Denar",
        "MMK" => "Myanmar (Burma) Kyat",
        "MNT" => "Mongolia Tughrik",
        "MOP" => "Macau Pataca",
        "MRU" => "Mauritania Ouguiya",
        "MUR" => "Mauritius Rupee",
        "MVR" => "Maldives (Maldive Islands) Rufiyaa",
        "MWK" => "Malawi Kwacha",
        "MXN" => "Mexico Peso",
        "MYR" => "Malaysia Ringgit",
        "MZN" => "Mozambique Metical",
        "NAD" => "Namibia Dollar",
        "NGN" => "Nigeria Naira",
        "NIO" => "Nicaragua Cordoba",
        "NOK" => "Norway Krone",
        "NPR" => "Nepal Rupee",
        "NZD" => "New Zealand Dollar",
        "OMR" => "Oman Rial",
        "PAB" => "Panama Balboa",
        "PEN" => "Peru Sol",
        "PGK" => "Papua New Guinea Kina",
        "PHP" => "Philippines Peso",
        "PKR" => "Pakistan Rupee",
        "PLN" => "Poland Zloty",
        "PYG" => "Paraguay Guarani",
        "QAR" => "Qatar Riyal",
        "RON" => "Romania Leu",
        "RSD" => "Serbia Dinar",
        "RUB" => "Russia Ruble",
        "RWF" => "Rwanda Franc",
        "SAR" => "Saudi Arabia Riyal",
        "SBD" => "Solomon Islands Dollar",
        "SCR" => "Seychelles Rupee",
        "SDG" => "Sudan Pound",
        "SEK" => "Sweden Krona",
        "SGD" => "Singapore Dollar",
        "SHP" => "Saint Helena Pound",
        "SLL" => "Sierra Leone Leone",
        "SOS" => "Somalia Shilling",
        "SPL*" => "Seborga Luigino",
        "SRD" => "Suriname Dollar",
        "STN" => "São Tomé and Príncipe Dobra",
        "SVC" => "El Salvador Colon",
        "SYP" => "Syria Pound",
        "SZL" => "eSwatini Lilangeni",
        "THB" => "Thailand Baht",
        "TJS" => "Tajikistan Somoni",
        "TMT" => "Turkmenistan Manat",
        "TND" => "Tunisia Dinar",
        "TOP" => "Tonga Pa'anga",
        "TRY" => "Turkey Lira",
        "TTD" => "Trinidad and Tobago Dollar",
        "TVD" => "Tuvalu Dollar",
        "TWD" => "Taiwan New Dollar",
        "TZS" => "Tanzania Shilling",
        "UAH" => "Ukraine Hryvnia",
        "UGX" => "Uganda Shilling",
        "USD" => "United States Dollar",
        "UYU" => "Uruguay Peso",
        "UZS" => "Uzbekistan Som",
        "VEF" => "Venezuela Bolívar",
        "VND" => "Viet Nam Dong",
        "VUV" => "Vanuatu Vatu",
        "WST" => "Samoa Tala",
        "XAF" => "Communauté Financière Africaine (BEAC) CFA Franc BEAC",
        "XCD" => "East Caribbean Dollar",
        "XDR" => "International Monetary Fund (IMF) Special Drawing Rights",
        "XOF" => "Communauté Financière Africaine (BCEAO) Franc",
        "XPF" => "Comptoirs Français du Pacifique (CFP) Franc",
        "YER" => "Yemen Rial",
        "ZAR" => "South Africa Rand",
        "ZMW" => "Zambia Kwacha",
        "ZWD" => "Zimbabwe Dollar"
    ],
    'shiprocket_status_codes'=>[
        ["code" => 3, "description" => "pickup generated"],
        ["code" => 62, "description" => "ready to pack"],
        ["code" => 42, "description" => "picked up"],
        ["code" => 6, "description" => "shipped"],
        ["code" => 17, "description" => "out for delivery"],
        ["code" => 7, "description" => "delivered"],
        ["code" => 8, "description" => "cancelled"],
        ["code" => 16, "description" => "cancellation requested"],
        ["code" => 23, "description" => "partial delivered"],
    ],
];
