import { OverridableComponent } from '@mui/types';
import { CircularProgressTypeMap } from './CircularProgressProps';
/**
 * ## ARIA
 *
 * If the progress bar is describing the loading progress of a particular region of a page,
 * you should use `aria-describedby` to point to the progress bar, and set the `aria-busy`
 * attribute to `true` on that region until it has finished loading.
 *
 * Demos:
 *
 * - [Circular Progress](https://mui.com/joy-ui/react-circular-progress/)
 *
 * API:
 *
 * - [CircularProgress API](https://mui.com/joy-ui/api/circular-progress/)
 */
declare const CircularProgress: OverridableComponent<CircularProgressTypeMap>;
export default CircularProgress;
