import { ColorPaletteProp, ColorSystem } from '../styles/types';
import { DefaultColorScheme, ExtendedColorScheme } from '../styles/types/colorScheme';
interface ThemeFragment {
    cssVarPrefix?: string;
    colorSchemes: {
        [k: string]: ColorSystem | undefined;
    };
    getCssVar: (...args: any[]) => string;
    palette: Record<string, any>;
    getColorSchemeSelector: (colorScheme: DefaultColorScheme | ExtendedColorScheme) => string;
}
export declare const INVERTED_COLORS_ATTR = "data-skip-inverted-colors";
export declare const INVERTED_COLORS_SELECTOR = "& :not([data-skip-inverted-colors], [data-skip-inverted-colors] *)";
export declare const skipInvertedColors: (theme: ThemeFragment) => {
    [x: string]: string | {
        [x: string]: string;
    };
    '--variant-plainColor': string;
    '--variant-plainHoverColor': string;
    '--variant-plainHoverBg': string;
    '--variant-plainActiveBg': string;
    '--variant-plainDisabledColor': string;
    '--variant-outlinedColor': string;
    '--variant-outlinedBorder': string;
    '--variant-outlinedHoverColor': string;
    '--variant-outlinedHoverBorder': string;
    '--variant-outlinedHoverBg': string;
    '--variant-outlinedActiveBg': string;
    '--variant-outlinedDisabledColor': string;
    '--variant-outlinedDisabledBorder': string;
    '--variant-softColor': string;
    '--variant-softHoverColor': string;
    '--variant-softBg': string;
    '--variant-softHoverBg': string;
    '--variant-softActiveBg': string;
    '--variant-softActiveColor': string;
    '--variant-softDisabledColor': string;
    '--variant-softDisabledBg': string;
    '--variant-solidColor': string;
    '--variant-solidBg': string;
    '--variant-solidHoverBg': string;
    '--variant-solidActiveBg': string;
    '--variant-solidDisabledColor': string;
    '--variant-solidDisabledBg': string;
    '--Badge-ringColor': string;
    colorScheme: string;
};
/**
 *
 * @param color a supported theme color palette
 * @returns (theme: ThemeFragment) => Record<DefaultColorPalette, CSSObject>
 */
export declare const applySolidInversion: (color: ColorPaletteProp) => (themeProp: ThemeFragment | {
    theme?: ThemeFragment;
}) => {
    "& :not([data-skip-inverted-colors], [data-skip-inverted-colors] *)": {
        [x: string]: string | {
            [x: string]: string;
            colorScheme: string;
            '--variant-plainColor': string;
            '--variant-plainHoverColor': string;
            '--variant-plainHoverBg': string;
            '--variant-plainActiveBg': string;
            '--variant-plainDisabledColor': string;
            '--variant-outlinedColor': string;
            '--variant-outlinedBorder': string;
            '--variant-outlinedHoverColor': string;
            '--variant-outlinedHoverBorder': string;
            '--variant-outlinedHoverBg': string;
            '--variant-outlinedActiveBg': string;
            '--variant-outlinedDisabledColor': string;
            '--variant-outlinedDisabledBorder': string;
            '--variant-softColor': string;
            '--variant-softHoverColor': string;
            '--variant-softBg': string;
            '--variant-softHoverBg': string;
            '--variant-softActiveBg': string;
            '--variant-softActiveColor': string;
            '--variant-softDisabledColor': string;
            '--variant-softDisabledBg': string;
            '--variant-solidColor': string;
            '--variant-solidBg': string;
            '--variant-solidHoverBg': string;
            '--variant-solidActiveBg': string;
            '--variant-solidDisabledColor': string;
            '--variant-solidDisabledBg': string;
        };
        '--Badge-ringColor': string;
        '--Icon-color': string;
    };
    "&, & [data-skip-inverted-colors]": {
        [x: string]: string | {
            [x: string]: string;
        };
        '--variant-plainColor': string;
        '--variant-plainHoverColor': string;
        '--variant-plainHoverBg': string;
        '--variant-plainActiveBg': string;
        '--variant-plainDisabledColor': string;
        '--variant-outlinedColor': string;
        '--variant-outlinedBorder': string;
        '--variant-outlinedHoverColor': string;
        '--variant-outlinedHoverBorder': string;
        '--variant-outlinedHoverBg': string;
        '--variant-outlinedActiveBg': string;
        '--variant-outlinedDisabledColor': string;
        '--variant-outlinedDisabledBorder': string;
        '--variant-softColor': string;
        '--variant-softHoverColor': string;
        '--variant-softBg': string;
        '--variant-softHoverBg': string;
        '--variant-softActiveBg': string;
        '--variant-softActiveColor': string;
        '--variant-softDisabledColor': string;
        '--variant-softDisabledBg': string;
        '--variant-solidColor': string;
        '--variant-solidBg': string;
        '--variant-solidHoverBg': string;
        '--variant-solidActiveBg': string;
        '--variant-solidDisabledColor': string;
        '--variant-solidDisabledBg': string;
        '--Badge-ringColor': string;
        colorScheme: string;
    };
};
/**
 *
 * @param color a supported theme color palette
 * @returns (theme: ThemeFragment) => Record<DefaultColorPalette, CSSObject>
 */
export declare const applySoftInversion: (color: ColorPaletteProp) => (themeProp: ThemeFragment & {
    theme?: ThemeFragment;
}) => {
    "& :not([data-skip-inverted-colors], [data-skip-inverted-colors] *)": {
        [x: string]: string | {
            [x: string]: string;
            '--variant-plainColor': string;
            '--variant-plainHoverColor': string;
            '--variant-plainHoverBg': string;
            '--variant-plainActiveBg': string;
            '--variant-plainDisabledColor': string;
            '--variant-outlinedColor': string;
            '--variant-outlinedHoverColor': string;
            '--variant-outlinedBg': string;
            '--variant-outlinedBorder': string;
            '--variant-outlinedHoverBorder': string;
            '--variant-outlinedHoverBg': string;
            '--variant-outlinedActiveBg': string;
            '--variant-outlinedDisabledColor': string;
            '--variant-outlinedDisabledBorder': string;
            '--variant-softColor': string;
            '--variant-softBg': string;
            '--variant-softHoverColor': string;
            '--variant-softHoverBg': string;
            '--variant-softActiveBg': string;
            '--variant-softDisabledColor': string;
            '--variant-softDisabledBg': string;
            '--variant-solidColor': string;
            '--variant-solidBg': string;
            '--variant-solidHoverColor': string;
            '--variant-solidHoverBg': string;
            '--variant-solidActiveBg': string;
            '--variant-solidDisabledColor': string;
            '--variant-solidDisabledBg': string;
        } | {
            [x: string]: string;
            '--variant-plainColor': string;
            '--variant-plainHoverColor': string;
            '--variant-plainHoverBg': string;
            '--variant-plainActiveBg': string;
            '--variant-plainDisabledColor': string;
            '--variant-outlinedColor': string;
            '--variant-outlinedBorder': string;
            '--variant-outlinedHoverColor': string;
            '--variant-outlinedHoverBorder': string;
            '--variant-outlinedHoverBg': string;
            '--variant-outlinedActiveBg': string;
            '--variant-outlinedDisabledColor': string;
            '--variant-outlinedDisabledBorder': string;
            '--variant-softColor': string;
            '--variant-softBg': string;
            '--variant-softHoverColor': string;
            '--variant-softHoverBg': string;
            '--variant-softActiveBg': string;
            '--variant-softDisabledColor': string;
            '--variant-softDisabledBg': string;
            '--variant-solidColor': string;
            '--variant-solidBg': string;
            '--variant-solidHoverColor': string;
            '--variant-solidHoverBg': string;
            '--variant-solidActiveBg': string;
            '--variant-solidDisabledColor': string;
            '--variant-solidDisabledBg': string;
            '--variant-outlinedBg'?: undefined;
        };
        '--Badge-ringColor': string;
        '--Icon-color': string;
    };
    "&, & [data-skip-inverted-colors]": {
        [x: string]: string | {
            [x: string]: string;
        };
        '--variant-plainColor': string;
        '--variant-plainHoverColor': string;
        '--variant-plainHoverBg': string;
        '--variant-plainActiveBg': string;
        '--variant-plainDisabledColor': string;
        '--variant-outlinedColor': string;
        '--variant-outlinedBorder': string;
        '--variant-outlinedHoverColor': string;
        '--variant-outlinedHoverBorder': string;
        '--variant-outlinedHoverBg': string;
        '--variant-outlinedActiveBg': string;
        '--variant-outlinedDisabledColor': string;
        '--variant-outlinedDisabledBorder': string;
        '--variant-softColor': string;
        '--variant-softHoverColor': string;
        '--variant-softBg': string;
        '--variant-softHoverBg': string;
        '--variant-softActiveBg': string;
        '--variant-softActiveColor': string;
        '--variant-softDisabledColor': string;
        '--variant-softDisabledBg': string;
        '--variant-solidColor': string;
        '--variant-solidBg': string;
        '--variant-solidHoverBg': string;
        '--variant-solidActiveBg': string;
        '--variant-solidDisabledColor': string;
        '--variant-solidDisabledBg': string;
        '--Badge-ringColor': string;
        colorScheme: string;
    };
};
export {};
