import { OverridableStringUnion } from '@mui/types';
/**
 * default Joy color-schemes
 */
export type DefaultColorScheme = 'light' | 'dark';
/**
 * The application can add more color-scheme by extending this interface via module augmentation
 *
 * Ex.
 * declare module @mui/joy/styles {
 *   interface ColorSchemeOverrides {
 *     foo: true;
 *   }
 * }
 *
 * // SupportedColorScheme = 'light' | 'dark' | 'foo';
 */
export interface ColorSchemeOverrides {
}
export type ExtendedColorScheme = OverridableStringUnion<never, ColorSchemeOverrides>;
/**
 * All color-schemes that the application has
 */
export type SupportedColorScheme = DefaultColorScheme | ExtendedColorScheme;
