import { CSSObject } from '@mui/system';
import { DefaultColorPalette, PaletteVariant } from './types/colorSystem';
import { VariantKey } from './types/variants';
export declare const isVariantPalette: (colorPalette: string | number | Record<string, any>) => boolean | "" | 0;
/**
 *
 * @param name variant name
 * @example 'plain'
 *
 * @param palette object that contains palette tokens
 * @example { primary: { plainColor: '', plainHoverColor: '', ...tokens }, ...other palette }
 *
 * @param getCssVar a function that receive variant token and return a CSS variable
 *
 * result will be the stylesheet based on the palette tokens
 * @example {
 *   color: '--token',
 *   backgroundColor: '--token',
 *   '--variant-borderWidth': '0px',
 * }
 * @example {
 *   cursor: 'pointer',
 *   color: '--token',
 *   backgroundColor: '--token',
 *   '--variant-borderWidth': '1px',
 * }
 * @example {
 *   pointerEvents: 'none',
 *   cursor: 'default',
 *   color: '--token',
 *   backgroundColor: '--token',
 *   '--variant-borderWidth': '0px',
 * }
 */
export declare const createVariantStyle: (name: string, palette: Partial<PaletteVariant> | undefined, getCssVar?: (variantVar: keyof PaletteVariant) => string) => CSSObject;
interface ThemeFragment {
    cssVarPrefix?: string;
    getCssVar: (...args: any[]) => string;
    palette: Record<string, any>;
}
export declare const createVariant: (variant: VariantKey, theme?: ThemeFragment) => Record<"context" | DefaultColorPalette, CSSObject>;
export {};
