import * as _nextui_org_system from '@nextui-org/system';
import { PropGetter, HTMLNextUIProps } from '@nextui-org/system';
import * as react from 'react';
import { ReactNode } from 'react';
import { ButtonProps } from '@nextui-org/button';
import { AlertVariantProps, SlotsToClasses, AlertSlots } from '@nextui-org/theme';
import { ReactRef } from '@nextui-org/react-utils';

interface Props extends HTMLNextUIProps<"div"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLDivElement | null>;
    /**
     * title of the alert message
     */
    title?: string;
    /**
     * description of the alert message
     */
    description?: ReactNode;
    /**
     * Icon to be displayed in the alert - overrides the default icon
     */
    icon?: ReactNode;
    /**
     * Content to be displayed in the end side of the alert
     */
    endContent?: ReactNode;
    /**
     * Content to be displayed in the start side of the alert
     */
    startContent?: ReactNode;
    /**
     * Whether the alert is visible.
     * @default false
     */
    isVisible?: boolean;
    /**
     * Whether the alert should be visible by default.
     * @default false
     */
    isDefaultVisible?: boolean;
    /**
     * The event handler for the alert visibility state.
     * @param isVisible boolean
     * @returns void
     */
    onVisibleChange?: (isVisible: boolean) => void;
    /**
     *  whether the alert can be closed by user
     */
    isClosable?: boolean;
    /**
     * Props for the close button
     */
    closeButtonProps?: Omit<ButtonProps, "children">;
    /**
     * function which is called when close button is clicked
     */
    onClose?: () => void;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Alert classNames={{
     *    base:"base-classes",
     *    mainWrapper: "mainWrapper-classes"
     *    description: "description-classes"
     *    title: "title-classes"
     *    closeButton: "closeButton-classes"
     *    closeIcon: "closeIcon-classes"
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<AlertSlots>;
}
type UseAlertProps = Props & AlertVariantProps;
declare function useAlert(originalProps: UseAlertProps): {
    title: string | undefined;
    icon: ReactNode;
    children: ReactNode;
    description: ReactNode;
    isClosable: boolean | undefined;
    domRef: react.RefObject<HTMLDivElement>;
    endContent: ReactNode;
    startContent: ReactNode;
    getBaseProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getMainWrapperProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getDescriptionProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getTitleProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    color: any;
    getCloseButtonProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    handleClose: () => void;
    isVisible: boolean;
    onClose: (() => void) | undefined;
    getAlertIconProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getIconWrapperProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
};

export { UseAlertProps, useAlert };
