"use client";
"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/autocomplete.tsx
var autocomplete_exports = {};
__export(autocomplete_exports, {
  default: () => autocomplete_default
});
module.exports = __toCommonJS(autocomplete_exports);
var import_system2 = require("@nextui-org/system");
var import_popover = require("@nextui-org/popover");
var import_scroll_shadow = require("@nextui-org/scroll-shadow");
var import_shared_icons = require("@nextui-org/shared-icons");
var import_listbox = require("@nextui-org/listbox");
var import_button = require("@nextui-org/button");
var import_input = require("@nextui-org/input");
var import_framer_motion = require("framer-motion");

// src/use-autocomplete.ts
var import_system = require("@nextui-org/system");
var import_use_safe_layout_effect = require("@nextui-org/use-safe-layout-effect");
var import_theme = require("@nextui-org/theme");
var import_i18n = require("@react-aria/i18n");
var import_combobox = require("@react-stately/combobox");
var import_react_utils = require("@nextui-org/react-utils");
var import_react = require("react");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_utils = require("@react-aria/utils");
var import_combobox2 = require("@react-aria/combobox");
var import_form = require("@nextui-org/form");
var import_aria_utils = require("@nextui-org/aria-utils");
function useAutocomplete(originalProps) {
  var _a, _b, _c, _d, _e;
  const globalContext = (0, import_system.useProviderContext)();
  const { validationBehavior: formValidationBehavior } = (0, import_form.useSlottedContext)(import_form.FormContext) || {};
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.autocomplete.variantKeys);
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const isClearable = originalProps.disableClearable !== void 0 ? !originalProps.disableClearable : originalProps.isReadOnly ? false : originalProps.isClearable;
  const {
    ref,
    as,
    label,
    isLoading,
    menuTrigger = "focus",
    filterOptions = {
      sensitivity: "base"
    },
    children,
    selectorIcon,
    clearIcon,
    scrollRef: scrollRefProp,
    defaultFilter,
    endContent,
    allowsEmptyCollection = true,
    shouldCloseOnBlur = true,
    popoverProps = {},
    inputProps: userInputProps = {},
    scrollShadowProps = {},
    listboxProps = {},
    selectorButtonProps = {},
    clearButtonProps = {},
    showScrollIndicators = true,
    allowsCustomValue = false,
    isVirtualized,
    maxListboxHeight = 256,
    itemHeight = 32,
    validationBehavior = (_c = formValidationBehavior != null ? formValidationBehavior : globalContext == null ? void 0 : globalContext.validationBehavior) != null ? _c : "native",
    className,
    classNames,
    errorMessage,
    onOpenChange,
    onClose,
    isReadOnly = false,
    ...otherProps
  } = props;
  const { contains } = (0, import_i18n.useFilter)(filterOptions);
  let state = (0, import_combobox.useComboBoxState)({
    ...originalProps,
    children,
    menuTrigger,
    validationBehavior,
    shouldCloseOnBlur,
    allowsEmptyCollection,
    defaultFilter: defaultFilter && typeof defaultFilter === "function" ? defaultFilter : contains,
    onOpenChange: (open, menuTrigger2) => {
      onOpenChange == null ? void 0 : onOpenChange(open, menuTrigger2);
      if (!open) {
        onClose == null ? void 0 : onClose();
      }
    }
  });
  state = {
    ...state,
    ...isReadOnly && {
      disabledKeys: /* @__PURE__ */ new Set([...state.collection.getKeys()])
    }
  };
  const buttonRef = (0, import_react.useRef)(null);
  const inputWrapperRef = (0, import_react.useRef)(null);
  const listBoxRef = (0, import_react.useRef)(null);
  const popoverRef = (0, import_react.useRef)(null);
  const inputRef = (0, import_react_utils.useDOMRef)(ref);
  const scrollShadowRef = (0, import_react_utils.useDOMRef)(scrollRefProp);
  const {
    buttonProps,
    inputProps,
    listBoxProps,
    isInvalid: isAriaInvalid,
    validationDetails,
    validationErrors
  } = (0, import_combobox2.useComboBox)(
    {
      validationBehavior,
      ...originalProps,
      inputRef,
      buttonRef,
      listBoxRef,
      popoverRef
    },
    state
  );
  const isInvalid = originalProps.isInvalid || isAriaInvalid;
  const slotsProps = {
    inputProps: (0, import_utils.mergeProps)(
      {
        label,
        ref: inputRef,
        wrapperRef: inputWrapperRef,
        onClick: () => {
          if (!state.isOpen && !!state.selectedItem) {
            state.open();
          }
        },
        isClearable: false,
        disableAnimation
      },
      userInputProps
    ),
    popoverProps: (0, import_utils.mergeProps)(
      {
        offset: 5,
        placement: "bottom",
        triggerScaleOnOpen: false,
        disableAnimation
      },
      popoverProps
    ),
    scrollShadowProps: (0, import_utils.mergeProps)(
      {
        ref: scrollShadowRef,
        isEnabled: (_d = showScrollIndicators && state.collection.size > 5) != null ? _d : true,
        hideScrollBar: true,
        offset: 15
      },
      scrollShadowProps
    ),
    listboxProps: (0, import_utils.mergeProps)(
      {
        hideEmptyContent: allowsCustomValue,
        emptyContent: "No results found.",
        disableAnimation
      },
      listboxProps
    ),
    selectorButtonProps: (0, import_utils.mergeProps)(
      {
        isLoading,
        size: "sm",
        variant: "light",
        radius: "full",
        color: isInvalid ? "danger" : originalProps == null ? void 0 : originalProps.color,
        isIconOnly: true,
        disableAnimation
      },
      selectorButtonProps
    ),
    clearButtonProps: (0, import_utils.mergeProps)(
      {
        size: "sm",
        variant: "light",
        radius: "full",
        color: isInvalid ? "danger" : originalProps == null ? void 0 : originalProps.color,
        isIconOnly: true,
        disableAnimation
      },
      clearButtonProps
    )
  };
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const isOpen = ((_e = slotsProps.listboxProps) == null ? void 0 : _e.hideEmptyContent) ? state.isOpen && !!state.collection.size : state.isOpen;
  (0, import_use_safe_layout_effect.useSafeLayoutEffect)(() => {
    if (!inputRef.current)
      return;
    const key = inputRef.current.value;
    const item = state.collection.getItem(key);
    if (item && state.inputValue !== item.textValue) {
      state.setSelectedKey(key);
      state.setInputValue(item.textValue);
    }
  }, [inputRef.current]);
  (0, import_react.useEffect)(() => {
    let key = state.collection.getFirstKey();
    while (key && state.disabledKeys.has(key)) {
      key = state.collection.getKeyAfter(key);
    }
    state.selectionManager.setFocusedKey(key);
  }, [state.collection, state.disabledKeys]);
  (0, import_react.useEffect)(() => {
    if (isOpen) {
      if (popoverRef.current && inputWrapperRef.current) {
        let rect = inputWrapperRef.current.getBoundingClientRect();
        let popover = popoverRef.current;
        popover.style.width = rect.width + "px";
      }
    }
  }, [isOpen]);
  if (inputProps.onKeyDown) {
    const originalOnKeyDown = inputProps.onKeyDown;
    inputProps.onKeyDown = (e) => {
      if ("continuePropagation" in e) {
        e.stopPropagation = () => {
        };
      }
      return originalOnKeyDown(e);
    };
  }
  const Component = as || "div";
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.autocomplete)({
      ...variantProps,
      isClearable,
      disableAnimation,
      className
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), isClearable, disableAnimation, className]
  );
  const getBaseProps = () => ({
    "data-invalid": (0, import_shared_utils.dataAttr)(isInvalid),
    "data-open": (0, import_shared_utils.dataAttr)(state.isOpen),
    className: slots.base({ class: baseStyles })
  });
  const getSelectorButtonProps = () => {
    var _a2;
    return {
      ref: buttonRef,
      ...(0, import_utils.mergeProps)(buttonProps, slotsProps.selectorButtonProps),
      "data-open": (0, import_shared_utils.dataAttr)(state.isOpen),
      className: slots.selectorButton({
        class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.selectorButton, (_a2 = slotsProps.selectorButtonProps) == null ? void 0 : _a2.className)
      })
    };
  };
  const getClearButtonProps = () => {
    var _a2, _b2;
    return {
      ...(0, import_utils.mergeProps)(buttonProps, slotsProps.clearButtonProps),
      onPressStart: () => {
        var _a3;
        (_a3 = inputRef.current) == null ? void 0 : _a3.focus();
      },
      onPress: (e) => {
        var _a3, _b3;
        (_b3 = (_a3 = slotsProps.clearButtonProps) == null ? void 0 : _a3.onPress) == null ? void 0 : _b3.call(_a3, e);
        if (state.selectedItem) {
          state.setSelectedKey(null);
        }
        state.setInputValue("");
        state.open();
      },
      "data-visible": !!state.selectedItem || ((_a2 = state.inputValue) == null ? void 0 : _a2.length) > 0,
      className: slots.clearButton({
        class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.clearButton, (_b2 = slotsProps.clearButtonProps) == null ? void 0 : _b2.className)
      })
    };
  };
  const hasUncommittedValidation = validationBehavior === "native" && state.displayValidation.isInvalid === false && state.realtimeValidation.isInvalid === true;
  const getInputProps = () => ({
    ...otherProps,
    ...inputProps,
    ...slotsProps.inputProps,
    isInvalid: hasUncommittedValidation ? void 0 : isInvalid,
    validationBehavior,
    errorMessage: typeof errorMessage === "function" ? errorMessage({ isInvalid, validationErrors, validationDetails }) : errorMessage || (validationErrors == null ? void 0 : validationErrors.join(" ")),
    onClick: (0, import_utils.chain)(slotsProps.inputProps.onClick, otherProps.onClick)
  });
  const getListBoxProps = () => {
    const shouldVirtualize = isVirtualized != null ? isVirtualized : state.collection.size > 50;
    return {
      state,
      ref: listBoxRef,
      isVirtualized: shouldVirtualize,
      virtualization: shouldVirtualize ? {
        maxListboxHeight,
        itemHeight
      } : void 0,
      scrollShadowProps: slotsProps.scrollShadowProps,
      ...(0, import_utils.mergeProps)(slotsProps.listboxProps, listBoxProps, {
        shouldHighlightOnFocus: true
      })
    };
  };
  const getPopoverProps = (props2 = {}) => {
    var _a2, _b2, _c2;
    const popoverProps2 = (0, import_utils.mergeProps)(slotsProps.popoverProps, props2);
    return {
      state,
      ref: popoverRef,
      triggerRef: inputWrapperRef,
      scrollRef: listBoxRef,
      triggerType: "listbox",
      ...popoverProps2,
      classNames: {
        ...(_a2 = slotsProps.popoverProps) == null ? void 0 : _a2.classNames,
        content: slots.popoverContent({
          class: (0, import_shared_utils.clsx)(
            classNames == null ? void 0 : classNames.popoverContent,
            (_c2 = (_b2 = slotsProps.popoverProps) == null ? void 0 : _b2.classNames) == null ? void 0 : _c2["content"],
            props2.className
          )
        })
      },
      shouldCloseOnInteractOutside: (popoverProps2 == null ? void 0 : popoverProps2.shouldCloseOnInteractOutside) ? popoverProps2.shouldCloseOnInteractOutside : (element) => (0, import_aria_utils.ariaShouldCloseOnInteractOutside)(element, inputWrapperRef, state),
      disableDialogFocus: true
    };
  };
  const getEmptyPopoverProps = () => {
    return {
      ref: popoverRef,
      className: "hidden"
    };
  };
  const getListBoxWrapperProps = (props2 = {}) => {
    var _a2, _b2;
    return {
      ...(0, import_utils.mergeProps)(slotsProps.scrollShadowProps, props2),
      className: slots.listboxWrapper({
        class: (0, import_shared_utils.clsx)(
          classNames == null ? void 0 : classNames.listboxWrapper,
          (_a2 = slotsProps.scrollShadowProps) == null ? void 0 : _a2.className,
          props2 == null ? void 0 : props2.className
        )
      }),
      style: {
        maxHeight: (_b2 = originalProps.maxListboxHeight) != null ? _b2 : 256
      }
    };
  };
  const getEndContentWrapperProps = (props2 = {}) => ({
    className: slots.endContentWrapper({
      class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.endContentWrapper, props2 == null ? void 0 : props2.className)
    }),
    onPointerDown: (0, import_utils.chain)(props2.onPointerDown, (e) => {
      var _a2;
      if (e.button === 0 && e.currentTarget === e.target) {
        (_a2 = inputRef.current) == null ? void 0 : _a2.focus();
      }
    }),
    onMouseDown: (0, import_utils.chain)(props2.onMouseDown, (e) => {
      if (e.button === 0 && e.currentTarget === e.target) {
        e.preventDefault();
      }
    })
  });
  return {
    Component,
    inputRef,
    label,
    state,
    slots,
    classNames,
    isLoading,
    clearIcon,
    isOpen,
    endContent,
    isClearable,
    disableAnimation,
    allowsCustomValue,
    selectorIcon,
    getBaseProps,
    getInputProps,
    getListBoxProps,
    getPopoverProps,
    getEmptyPopoverProps,
    getClearButtonProps,
    getSelectorButtonProps,
    getListBoxWrapperProps,
    getEndContentWrapperProps
  };
}

// src/autocomplete.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Autocomplete = (0, import_system2.forwardRef)(function Autocomplete2(props, ref) {
  var _a;
  const {
    Component,
    isOpen,
    disableAnimation,
    selectorIcon = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_shared_icons.ChevronDownIcon, {}),
    clearIcon = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_shared_icons.CloseIcon, {}),
    endContent,
    getBaseProps,
    getSelectorButtonProps,
    getInputProps,
    getListBoxProps,
    getPopoverProps,
    getEmptyPopoverProps,
    getClearButtonProps,
    getListBoxWrapperProps,
    getEndContentWrapperProps
  } = useAutocomplete({ ...props, ref });
  const listboxProps = getListBoxProps();
  const popoverContent = isOpen ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_popover.FreeSoloPopover, { ...getPopoverProps(), children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_scroll_shadow.ScrollShadow, { ...getListBoxWrapperProps(), children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_listbox.Listbox, { ...listboxProps }) }) }) : ((_a = listboxProps.state) == null ? void 0 : _a.collection.size) === 0 ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ...getEmptyPopoverProps() }) : null;
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(Component, { ...getBaseProps(), children: [
    /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      import_input.Input,
      {
        ...getInputProps(),
        endContent: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { ...getEndContentWrapperProps(), children: [
          endContent || /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_button.Button, { ...getClearButtonProps(), children: clearIcon }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_button.Button, { ...getSelectorButtonProps(), children: selectorIcon })
        ] })
      }
    ),
    disableAnimation ? popoverContent : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.AnimatePresence, { children: popoverContent })
  ] });
});
var autocomplete_default = Autocomplete;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
