"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Calendar: () => calendar_default,
  CalendarProvider: () => CalendarProvider,
  RangeCalendar: () => range_calendar_default,
  useCalendar: () => useCalendar,
  useCalendarContext: () => useCalendarContext,
  useRangeCalendar: () => useRangeCalendar
});
module.exports = __toCommonJS(src_exports);

// src/calendar.tsx
var import_system2 = require("@nextui-org/system");

// src/use-calendar.ts
var import_react2 = require("react");
var import_react_utils2 = require("@nextui-org/react-utils");
var import_calendar = require("@react-aria/calendar");
var import_calendar2 = require("@react-stately/calendar");
var import_date2 = require("@internationalized/date");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_utils3 = require("@react-aria/utils");

// src/use-calendar-base.ts
var import_date = require("@internationalized/date");
var import_system = require("@nextui-org/system");
var import_react = require("react");
var import_theme = require("@nextui-org/theme");
var import_utils = require("@react-stately/utils");
var import_react_utils = require("@nextui-org/react-utils");
var import_i18n = require("@react-aria/i18n");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_utils2 = require("@react-aria/utils");
function useCalendarBase(originalProps) {
  var _a, _b, _c, _d, _e, _f, _g;
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.calendar.variantKeys);
  const globalContext = (0, import_system.useProviderContext)();
  const { locale } = (0, import_i18n.useLocale)();
  const calendarProp = (0, import_date.createCalendar)(new import_date.DateFormatter(locale).resolvedOptions().calendar);
  const gregorianYearOffset = (0, import_shared_utils.getGregorianYearOffset)(calendarProp.identifier);
  const {
    ref,
    as,
    children,
    className,
    topContent,
    bottomContent,
    showHelper = true,
    calendarWidth = 256,
    visibleMonths: visibleMonthsProp = 1,
    weekdayStyle = "narrow",
    navButtonProps = {},
    isHeaderExpanded: isHeaderExpandedProp,
    isHeaderDefaultExpanded,
    onHeaderExpandedChange = () => {
    },
    createCalendar: createCalendarProp = (_a = globalContext == null ? void 0 : globalContext.createCalendar) != null ? _a : null,
    minValue = (_c = (_b = globalContext == null ? void 0 : globalContext.defaultDates) == null ? void 0 : _b.minDate) != null ? _c : new import_date.CalendarDate(calendarProp, 1900 + gregorianYearOffset, 1, 1),
    maxValue = (_e = (_d = globalContext == null ? void 0 : globalContext.defaultDates) == null ? void 0 : _d.maxDate) != null ? _e : new import_date.CalendarDate(calendarProp, 2099 + gregorianYearOffset, 12, 31),
    prevButtonProps: prevButtonPropsProp,
    nextButtonProps: nextButtonPropsProp,
    errorMessage,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "div";
  const visibleMonths = (0, import_shared_utils.clamp)(visibleMonthsProp, 1, 3);
  const showMonthAndYearPickers = originalProps.showMonthAndYearPickers && visibleMonths === 1;
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const handleHeaderExpandedChange = (0, import_react.useCallback)(
    (isExpanded) => {
      onHeaderExpandedChange(isExpanded || false);
    },
    [onHeaderExpandedChange]
  );
  const [isHeaderExpanded, setIsHeaderExpanded] = (0, import_utils.useControlledState)(
    isHeaderExpandedProp,
    isHeaderDefaultExpanded != null ? isHeaderDefaultExpanded : false,
    handleHeaderExpandedChange
  );
  const visibleDuration = (0, import_react.useMemo)(() => ({ months: visibleMonths }), [visibleMonths]);
  const hasMultipleMonths = visibleMonths > 1;
  const shouldFilterDOMProps = typeof Component === "string";
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.calendar)({
      ...variantProps,
      showMonthAndYearPickers,
      isRange: !!originalProps.isRange,
      isHeaderWrapperExpanded: isHeaderExpanded,
      className
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), showMonthAndYearPickers, isHeaderExpanded, className]
  );
  const disableAnimation = (_g = (_f = originalProps.disableAnimation) != null ? _f : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _g : false;
  const commonButtonProps = {
    size: "sm",
    variant: "light",
    radius: "full",
    isIconOnly: true,
    disableAnimation,
    ...navButtonProps
  };
  const baseProps = {
    "data-slot": "base",
    "data-has-multiple-months": (0, import_shared_utils.dataAttr)(hasMultipleMonths),
    style: {
      "--visible-months": typeof visibleMonths === "number" ? `${visibleMonths}` : visibleMonths,
      "--calendar-width": typeof calendarWidth === "number" ? `${calendarWidth}px` : calendarWidth
    }
  };
  const getPrevButtonProps = (props2 = {}) => {
    return {
      "data-slot": "prev-button",
      tabIndex: isHeaderExpanded ? -1 : 0,
      className: slots.prevButton({ class: classNames == null ? void 0 : classNames.prevButton }),
      ...(0, import_utils2.mergeProps)(commonButtonProps, prevButtonPropsProp, props2)
    };
  };
  const getNextButtonProps = (props2 = {}) => {
    return {
      "data-slot": "next-button",
      tabIndex: isHeaderExpanded ? -1 : 0,
      className: slots.nextButton({ class: classNames == null ? void 0 : classNames.nextButton }),
      ...(0, import_utils2.mergeProps)(commonButtonProps, nextButtonPropsProp, props2)
    };
  };
  const getErrorMessageProps = (props2 = {}) => {
    return {
      "data-slot": "error-message",
      className: slots.errorMessage({ class: classNames == null ? void 0 : classNames.errorMessage }),
      ...props2
    };
  };
  return {
    Component,
    children,
    domRef,
    slots,
    locale,
    minValue,
    maxValue,
    baseProps,
    showHelper,
    weekdayStyle,
    visibleMonths,
    visibleDuration,
    shouldFilterDOMProps,
    isHeaderExpanded,
    showMonthAndYearPickers,
    disableAnimation,
    createCalendar: createCalendarProp,
    getPrevButtonProps,
    getNextButtonProps,
    getErrorMessageProps,
    setIsHeaderExpanded,
    topContent,
    bottomContent,
    errorMessage,
    classNames,
    otherProps
  };
}

// src/use-calendar.ts
function useCalendar({
  buttonPickerProps: buttonPickerPropsProp,
  className,
  ...originalProps
}) {
  const {
    Component,
    slots,
    children,
    domRef,
    locale,
    minValue,
    maxValue,
    showHelper,
    weekdayStyle,
    visibleDuration,
    baseProps,
    disableAnimation,
    shouldFilterDOMProps,
    isHeaderExpanded,
    visibleMonths,
    createCalendar: createCalendarProp,
    showMonthAndYearPickers,
    getPrevButtonProps,
    getNextButtonProps,
    getErrorMessageProps,
    setIsHeaderExpanded,
    topContent,
    bottomContent,
    errorMessage,
    classNames,
    otherProps
  } = useCalendarBase(originalProps);
  const headerRef = (0, import_react2.useRef)(null);
  const state = (0, import_calendar2.useCalendarState)({
    ...originalProps,
    locale,
    minValue,
    maxValue,
    visibleDuration,
    createCalendar: !createCalendarProp || typeof createCalendarProp !== "function" ? import_date2.createCalendar : createCalendarProp
  });
  const { title, calendarProps, prevButtonProps, nextButtonProps, errorMessageProps } = (0, import_calendar.useCalendar)(originalProps, state);
  const baseStyles = (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.base, className);
  const buttonPickerProps = {
    ...(0, import_utils3.mergeProps)(buttonPickerPropsProp, { isDisabled: originalProps.isDisabled }),
    onPress: (0, import_utils3.chain)(buttonPickerPropsProp == null ? void 0 : buttonPickerPropsProp.onPress, () => setIsHeaderExpanded(!isHeaderExpanded))
  };
  const getBaseCalendarProps = (props = {}) => {
    return {
      ...baseProps,
      Component,
      showHelper,
      topContent,
      bottomContent,
      buttonPickerProps,
      calendarRef: domRef,
      calendarProps,
      prevButtonProps: getPrevButtonProps(prevButtonProps),
      nextButtonProps: getNextButtonProps(nextButtonProps),
      errorMessageProps: getErrorMessageProps(errorMessageProps),
      className: slots.base({ class: baseStyles }),
      errorMessage,
      ...(0, import_react_utils2.filterDOMProps)(otherProps, {
        enabled: shouldFilterDOMProps
      }),
      ...props
    };
  };
  const context = (0, import_react2.useMemo)(
    () => ({
      state,
      slots,
      headerRef,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      classNames,
      showMonthAndYearPickers,
      disableAnimation
    }),
    [
      state,
      slots,
      classNames,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      disableAnimation,
      showMonthAndYearPickers
    ]
  );
  return {
    Component,
    children,
    domRef,
    context,
    state,
    slots,
    title,
    classNames,
    getBaseCalendarProps
  };
}

// src/calendar-context.ts
var import_react_utils3 = require("@nextui-org/react-utils");
var [CalendarProvider, useCalendarContext] = (0, import_react_utils3.createContext)({
  name: "CalendarContext",
  strict: true,
  errorMessage: "useContext: `context` is undefined. Seems you forgot to wrap component within the CalendarProvider"
});

// src/calendar-base.tsx
var import_react8 = require("react");
var import_visually_hidden = require("@react-aria/visually-hidden");
var import_button2 = require("@nextui-org/button");
var import_utils7 = require("@react-aria/utils");
var import_framer_motion3 = require("framer-motion");
var import_framer_utils = require("@nextui-org/framer-utils");

// src/chevron-left.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var ChevronLeftIcon = (props) => /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
  "svg",
  {
    "aria-hidden": "true",
    fill: "none",
    focusable: "false",
    height: "1em",
    role: "presentation",
    viewBox: "0 0 16 16",
    width: "1em",
    ...props,
    children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "path",
      {
        d: "M10 3.33334L6 8.00001L10 12.6667",
        stroke: "currentColor",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: "1.5"
      }
    )
  }
);

// src/chevron-right.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var ChevronRightIcon = (props) => /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
  "svg",
  {
    "aria-hidden": "true",
    fill: "none",
    focusable: "false",
    height: "1em",
    role: "presentation",
    viewBox: "0 0 16 16",
    width: "1em",
    ...props,
    children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      "path",
      {
        d: "M6 3.33334L10 8.00001L6 12.6667",
        stroke: "currentColor",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: "1.5"
      }
    )
  }
);

// src/calendar-month.tsx
var import_date4 = require("@internationalized/date");
var import_i18n3 = require("@react-aria/i18n");
var import_calendar4 = require("@react-aria/calendar");
var import_framer_motion = require("framer-motion");
var import_shared_utils4 = require("@nextui-org/shared-utils");

// src/calendar-cell.tsx
var import_date3 = require("@internationalized/date");
var import_calendar3 = require("@react-aria/calendar");
var import_utils4 = require("@react-aria/utils");
var import_i18n2 = require("@react-aria/i18n");
var import_focus = require("@react-aria/focus");
var import_interactions = require("@react-aria/interactions");
var import_react3 = require("react");
var import_shared_utils3 = require("@nextui-org/shared-utils");
var import_jsx_runtime3 = require("react/jsx-runtime");
function CalendarCell(originalProps) {
  const { state, slots, isPickerVisible, currentMonth, classNames, ...props } = originalProps;
  const ref = (0, import_react3.useRef)(null);
  const {
    cellProps,
    buttonProps,
    isPressed,
    isSelected,
    isDisabled,
    isFocused,
    isInvalid,
    formattedDate
  } = (0, import_calendar3.useCalendarCell)(
    {
      ...props,
      isDisabled: !(0, import_date3.isSameMonth)(props.date, currentMonth) || isPickerVisible
    },
    state,
    ref
  );
  const isUnavailable = state.isCellUnavailable(props.date);
  const isLastSelectedBeforeDisabled = !isDisabled && !isInvalid && state.isCellUnavailable(props.date.add({ days: 1 }));
  const isFirstSelectedAfterDisabled = !isDisabled && !isInvalid && state.isCellUnavailable(props.date.subtract({ days: 1 }));
  const highlightedRange = "highlightedRange" in state && state.highlightedRange;
  const isSelectionStart = isSelected && highlightedRange ? (0, import_date3.isSameDay)(props.date, highlightedRange.start) : false;
  const isSelectionEnd = isSelected && highlightedRange ? (0, import_date3.isSameDay)(props.date, highlightedRange.end) : false;
  const { locale } = (0, import_i18n2.useLocale)();
  const dayOfWeek = (0, import_date3.getDayOfWeek)(props.date, locale);
  const isRangeStart = isSelected && (isFirstSelectedAfterDisabled || dayOfWeek === 0 || props.date.day === 1);
  const isRangeEnd = isSelected && (isLastSelectedBeforeDisabled || dayOfWeek === 6 || props.date.day === currentMonth.calendar.getDaysInMonth(currentMonth));
  const { focusProps, isFocusVisible } = (0, import_focus.useFocusRing)();
  const { hoverProps, isHovered } = (0, import_interactions.useHover)({
    isDisabled: isDisabled || isUnavailable || state.isReadOnly
  });
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("td", { className: slots == null ? void 0 : slots.cell({ class: classNames == null ? void 0 : classNames.cell }), "data-slot": "cell", ...cellProps, children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    "span",
    {
      ...(0, import_utils4.mergeProps)(buttonProps, hoverProps, focusProps),
      ref,
      className: slots == null ? void 0 : slots.cellButton({ class: classNames == null ? void 0 : classNames.cellButton }),
      "data-disabled": (0, import_shared_utils3.dataAttr)(isDisabled && !isInvalid),
      "data-focus-visible": (0, import_shared_utils3.dataAttr)(isFocused && isFocusVisible),
      "data-hover": (0, import_shared_utils3.dataAttr)(isHovered),
      "data-invalid": (0, import_shared_utils3.dataAttr)(isInvalid),
      "data-outside-month": (0, import_shared_utils3.dataAttr)(!(0, import_date3.isSameMonth)(props.date, currentMonth)),
      "data-pressed": (0, import_shared_utils3.dataAttr)(isPressed && !state.isReadOnly),
      "data-range-end": (0, import_shared_utils3.dataAttr)(isRangeEnd),
      "data-range-selection": (0, import_shared_utils3.dataAttr)(isSelected && "highlightedRange" in state),
      "data-range-start": (0, import_shared_utils3.dataAttr)(isRangeStart),
      "data-readonly": (0, import_shared_utils3.dataAttr)(state.isReadOnly),
      "data-selected": (0, import_shared_utils3.dataAttr)(isSelected),
      "data-selection-end": (0, import_shared_utils3.dataAttr)(isSelectionEnd),
      "data-selection-start": (0, import_shared_utils3.dataAttr)(isSelectionStart),
      "data-today": (0, import_shared_utils3.dataAttr)((0, import_date3.isToday)(props.date, state.timeZone)),
      "data-unavailable": (0, import_shared_utils3.dataAttr)(isUnavailable),
      children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("span", { children: formattedDate })
    }
  ) });
}

// src/calendar-transitions.ts
var transition = {
  type: "spring",
  bounce: 0,
  duration: 0.3
};
var slideVariants = {
  enter: (direction) => ({
    x: `${direction * 100}%`
  }),
  center: {
    x: "0%"
  },
  exit: (direction) => ({
    x: `${direction * -100}%`
  })
};

// src/calendar-month.tsx
var import_jsx_runtime4 = require("react/jsx-runtime");
function CalendarMonth(props) {
  const { startDate, direction, currentMonth } = props;
  const { locale } = (0, import_i18n3.useLocale)();
  const weeksInMonth = (0, import_date4.getWeeksInMonth)(startDate, locale);
  const { state, slots, weekdayStyle, isHeaderExpanded, disableAnimation, classNames } = useCalendarContext();
  const { gridProps, headerProps, weekDays } = (0, import_calendar4.useCalendarGrid)(
    {
      ...props,
      weekdayStyle,
      endDate: (0, import_date4.endOfMonth)(startDate)
    },
    state
  );
  const bodyContent = [...new Array(weeksInMonth).keys()].map((weekIndex) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
    "tr",
    {
      className: slots == null ? void 0 : slots.gridBodyRow({ class: classNames == null ? void 0 : classNames.gridBodyRow }),
      "data-slot": "grid-body-row",
      inert: (0, import_shared_utils4.getInertValue)(!!isHeaderExpanded),
      children: state.getDatesInWeek(weekIndex, startDate).map(
        (date, i) => date ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
          CalendarCell,
          {
            classNames,
            currentMonth: startDate,
            date,
            isPickerVisible: isHeaderExpanded,
            slots,
            state
          },
          i
        ) : /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("td", {}, i)
      )
    },
    weekIndex
  ));
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(
    "table",
    {
      ...gridProps,
      "aria-hidden": (0, import_shared_utils4.dataAttr)(isHeaderExpanded),
      className: slots == null ? void 0 : slots.grid({ class: classNames == null ? void 0 : classNames.grid }),
      "data-slot": "grid",
      tabIndex: -1,
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
          "thead",
          {
            ...headerProps,
            className: slots == null ? void 0 : slots.gridHeader({ class: classNames == null ? void 0 : classNames.gridHeader }),
            "data-slot": "grid-header",
            children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
              "tr",
              {
                className: slots == null ? void 0 : slots.gridHeaderRow({ class: classNames == null ? void 0 : classNames.gridHeaderRow }),
                "data-slot": "grid-header-row",
                children: weekDays.map((day, index) => /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
                  "th",
                  {
                    className: slots == null ? void 0 : slots.gridHeaderCell({ class: classNames == null ? void 0 : classNames.gridHeaderCell }),
                    "data-slot": "grid-header-cell",
                    children: /* @__PURE__ */ (0, import_jsx_runtime4.jsx)("span", { children: day })
                  },
                  index
                ))
              }
            )
          }
        ),
        disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
          "tbody",
          {
            className: slots == null ? void 0 : slots.gridBody({ class: classNames == null ? void 0 : classNames.gridBody }),
            "data-slot": "grid-body",
            tabIndex: isHeaderExpanded ? -1 : 0,
            children: bodyContent
          },
          currentMonth
        ) : /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
          import_framer_motion.m.tbody,
          {
            animate: "center",
            className: slots == null ? void 0 : slots.gridBody({ class: classNames == null ? void 0 : classNames.gridBody }),
            custom: direction,
            "data-slot": "grid-body",
            exit: "exit",
            initial: "enter",
            variants: slideVariants,
            children: bodyContent
          },
          currentMonth
        )
      ]
    }
  );
}

// src/calendar-header.tsx
var import_i18n4 = require("@react-aria/i18n");
var import_framer_motion2 = require("framer-motion");
var import_button = require("@nextui-org/button");
var import_react4 = require("react");

// src/chevron-down.tsx
var import_jsx_runtime5 = require("react/jsx-runtime");
var ChevronDownIcon = (props) => /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
  "svg",
  {
    "aria-hidden": "true",
    fill: "none",
    focusable: "false",
    height: "1em",
    role: "presentation",
    viewBox: "0 0 24 24",
    width: "1em",
    ...props,
    children: /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
      "path",
      {
        d: "M19 9L12 15L5 9",
        stroke: "currentColor",
        strokeLinecap: "round",
        strokeLinejoin: "round",
        strokeWidth: "1.5"
      }
    )
  }
);

// src/calendar-header.tsx
var import_jsx_runtime6 = require("react/jsx-runtime");
function CalendarHeader(props) {
  const { direction, date, currentMonth, buttonPickerProps } = props;
  const {
    state,
    slots,
    headerRef,
    showMonthAndYearPickers,
    isHeaderExpanded,
    setIsHeaderExpanded,
    disableAnimation,
    classNames
  } = useCalendarContext();
  const monthAndYearDateFormatter = (0, import_i18n4.useDateFormatter)({
    month: "long",
    era: currentMonth.calendar.identifier === "gregory" && currentMonth.era === "BC" ? "short" : void 0,
    calendar: currentMonth.calendar.identifier,
    timeZone: state.timeZone,
    year: "numeric"
  });
  const monthDateContent = monthAndYearDateFormatter.format(date.toDate(state.timeZone));
  const headerTitle = /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(import_jsx_runtime6.Fragment, { children: disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
    "span",
    {
      "aria-hidden": true,
      className: slots == null ? void 0 : slots.title({ class: classNames == null ? void 0 : classNames.title }),
      "data-slot": "title",
      children: monthDateContent
    },
    currentMonth.month
  ) : /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
    import_framer_motion2.m.span,
    {
      animate: "center",
      "aria-hidden": true,
      className: slots == null ? void 0 : slots.title({ class: classNames == null ? void 0 : classNames.title }),
      custom: direction,
      "data-slot": "title",
      exit: "exit",
      initial: "enter",
      variants: isHeaderExpanded ? {} : slideVariants,
      children: monthDateContent
    },
    currentMonth.month
  ) });
  const headerProps = {
    ref: headerRef,
    className: slots == null ? void 0 : slots.header({ class: classNames == null ? void 0 : classNames.header }),
    "data-slot": "header"
  };
  const handleKeyDown = (0, import_react4.useCallback)(
    (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        setIsHeaderExpanded == null ? void 0 : setIsHeaderExpanded(false);
      }
    },
    [setIsHeaderExpanded]
  );
  return showMonthAndYearPickers ? /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(
    import_button.Button,
    {
      ...headerProps,
      "aria-label": "switch to year and month view",
      disableAnimation,
      endContent: /* @__PURE__ */ (0, import_jsx_runtime6.jsx)(ChevronDownIcon, { className: "chevron-icon" }),
      onKeyDown: handleKeyDown,
      ...buttonPickerProps,
      children: headerTitle
    }
  ) : /* @__PURE__ */ (0, import_jsx_runtime6.jsx)("header", { ...headerProps, children: headerTitle });
}

// src/calendar-picker.tsx
var import_react7 = require("react");
var import_shared_utils7 = require("@nextui-org/shared-utils");

// src/calendar-picker-item.tsx
var import_use_aria_button = require("@nextui-org/use-aria-button");
var import_interactions2 = require("@react-aria/interactions");
var import_focus2 = require("@react-aria/focus");
var import_react5 = require("react");
var import_react_utils4 = require("@nextui-org/react-utils");
var import_shared_utils5 = require("@nextui-org/shared-utils");
var import_utils5 = require("@react-aria/utils");
var import_jsx_runtime7 = require("react/jsx-runtime");
var CalendarPickerItem = (0, import_react5.forwardRef)(({ children, autoFocus, isDisabled, onKeyDown, ...otherProps }, ref) => {
  const domRef = (0, import_react_utils4.useDOMRef)(ref);
  const { buttonProps: ariaButtonProps, isPressed } = (0, import_use_aria_button.useAriaButton)(
    {
      elementType: "button",
      isDisabled,
      onKeyDown,
      ...otherProps
    },
    domRef
  );
  const { isFocusVisible, isFocused, focusProps } = (0, import_focus2.useFocusRing)({
    autoFocus
  });
  const { isHovered, hoverProps } = (0, import_interactions2.useHover)({ isDisabled });
  return /* @__PURE__ */ (0, import_jsx_runtime7.jsx)(
    "button",
    {
      ref: domRef,
      "data-disabled": (0, import_shared_utils5.dataAttr)(isDisabled),
      "data-focus": (0, import_shared_utils5.dataAttr)(isFocused),
      "data-focus-visible": (0, import_shared_utils5.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils5.dataAttr)(isHovered),
      "data-pressed": (0, import_shared_utils5.dataAttr)(isPressed),
      "data-slot": "picker-item",
      ...(0, import_utils5.mergeProps)(
        focusProps,
        hoverProps,
        ariaButtonProps,
        (0, import_react_utils4.filterDOMProps)(otherProps, { enabled: true })
      ),
      children
    }
  );
});
CalendarPickerItem.displayName = "CalendarPickerItem";

// src/use-calendar-picker.ts
var import_i18n5 = require("@react-aria/i18n");
var import_react6 = require("react");
var import_shared_utils6 = require("@nextui-org/shared-utils");
var import_react_utils5 = require("@nextui-org/react-utils");
var import_scroll_into_view_if_needed = __toESM(require("scroll-into-view-if-needed"));

// src/utils.ts
var import_date5 = require("@internationalized/date");
function getYearRange(start, end) {
  const years = [];
  if (!start || !end) {
    return years;
  }
  let current = (0, import_date5.startOfYear)(start);
  while (current.compare(end) <= 0) {
    years.push(current);
    current = (0, import_date5.startOfYear)(current.add({ years: 1 }));
  }
  return years;
}
function addMonths(date, months) {
  return date.add({ months });
}
function getMonthsInYear(year) {
  const firstMonth = (0, import_date5.startOfYear)(year);
  const months = [firstMonth];
  while (months.length < 12) {
    const prevMonth = months[months.length - 1];
    months.push(addMonths(prevMonth, 1));
  }
  return months;
}

// src/use-calendar-picker.ts
var SCROLL_DEBOUNCE_TIME = 200;
function useCalendarPicker(props) {
  var _a;
  const { date, currentMonth } = props;
  const { slots, state, headerRef, isHeaderExpanded, setIsHeaderExpanded, classNames } = useCalendarContext();
  const highlightRef = (0, import_react6.useRef)(null);
  const yearsListRef = (0, import_react6.useRef)(null);
  const monthsListRef = (0, import_react6.useRef)(null);
  const monthsItemsRef = (0, import_react6.useRef)();
  const yearsItemsRef = (0, import_react6.useRef)();
  const monthDateFormatter = (0, import_i18n5.useDateFormatter)({
    month: "long",
    era: currentMonth.calendar.identifier === "gregory" && currentMonth.era === "BC" ? "short" : void 0,
    calendar: currentMonth.calendar.identifier,
    timeZone: state.timeZone
  });
  const yearDateFormatter = (0, import_i18n5.useDateFormatter)({
    year: "numeric",
    timeZone: state.timeZone
  });
  const years = (_a = getYearRange(state.minValue, state.maxValue)) == null ? void 0 : _a.map((y) => ({
    value: y.year,
    label: yearDateFormatter.format(y.toDate(state.timeZone))
  }));
  const months = getMonthsInYear(date).map((m3) => ({
    value: m3.month,
    label: monthDateFormatter.format(m3.toDate(state.timeZone))
  }));
  function getItemsRefMap(itemsRef) {
    if (!itemsRef.current) {
      itemsRef.current = /* @__PURE__ */ new Map();
    }
    return itemsRef.current;
  }
  function getItemRef(node, value, list) {
    const map = getItemsRefMap(list === "months" ? monthsItemsRef : yearsItemsRef);
    if (node) {
      map.set(value, node);
    } else {
      map.delete(value);
    }
  }
  const handleListScroll = (0, import_react6.useCallback)(
    (e, highlightEl, list) => {
      if (!(e.target instanceof HTMLElement))
        return;
      const map = getItemsRefMap(list === "months" ? monthsItemsRef : yearsItemsRef);
      const items = Array.from(map.values());
      const item = items.find((itemEl) => {
        const rect1 = itemEl.getBoundingClientRect();
        const rect2 = highlightEl == null ? void 0 : highlightEl.getBoundingClientRect();
        if (!rect2) {
          return false;
        }
        return (0, import_react_utils5.areRectsIntersecting)(rect1, rect2);
      });
      const itemValue = Number(item == null ? void 0 : item.getAttribute("data-value"));
      if (!itemValue)
        return;
      let date2 = state.focusedDate.set(list === "months" ? { month: itemValue } : { year: itemValue });
      state.setFocusedDate(date2);
    },
    [state, isHeaderExpanded]
  );
  (0, import_react6.useEffect)(() => {
    if (!isHeaderExpanded)
      return;
    scrollTo(date.month, "months", false);
    scrollTo(date.year, "years", false);
  }, [isHeaderExpanded]);
  (0, import_react6.useEffect)(() => {
    const monthsList = monthsListRef.current;
    const yearsList = yearsListRef.current;
    const highlightEl = highlightRef.current;
    if (!highlightEl)
      return;
    const debouncedHandleMonthsScroll = (0, import_shared_utils6.debounce)(
      (e) => handleListScroll(e, highlightEl, "months"),
      SCROLL_DEBOUNCE_TIME
    );
    const debouncedHandleYearsScroll = (0, import_shared_utils6.debounce)(
      (e) => handleListScroll(e, highlightEl, "years"),
      SCROLL_DEBOUNCE_TIME
    );
    monthsList == null ? void 0 : monthsList.addEventListener("scroll", debouncedHandleMonthsScroll);
    yearsList == null ? void 0 : yearsList.addEventListener("scroll", debouncedHandleYearsScroll);
    return () => {
      if (debouncedHandleMonthsScroll) {
        monthsList == null ? void 0 : monthsList.removeEventListener("scroll", debouncedHandleMonthsScroll);
      }
      if (debouncedHandleYearsScroll) {
        yearsList == null ? void 0 : yearsList.removeEventListener("scroll", debouncedHandleYearsScroll);
      }
    };
  }, [handleListScroll]);
  function scrollTo(value, list, smooth = true) {
    const mapListRef = list === "months" ? monthsItemsRef : yearsItemsRef;
    const listRef = list === "months" ? monthsListRef : yearsListRef;
    const map = getItemsRefMap(mapListRef);
    const node = map.get(value);
    if (!node)
      return;
    (0, import_scroll_into_view_if_needed.default)(node, {
      scrollMode: "always",
      behavior: smooth ? "smooth" : "auto",
      boundary: listRef.current
    });
  }
  const onPickerItemPressed = (0, import_react6.useCallback)(
    (e, list) => {
      const target = e.target;
      const value = Number(target.getAttribute("data-value"));
      if (!value)
        return;
      scrollTo(value, list);
    },
    [state]
  );
  const onPickerItemKeyDown = (0, import_react6.useCallback)(
    (e, value, list) => {
      var _a2;
      const map = getItemsRefMap(list === "months" ? monthsItemsRef : yearsItemsRef);
      const node = map.get(value);
      if (!node)
        return;
      let nextValue = value;
      switch (e.key) {
        case "ArrowDown":
          nextValue = value + 1;
          break;
        case "ArrowUp":
          nextValue = value - 1;
          break;
        case "Home":
          nextValue = 0;
          break;
        case "End":
          nextValue = months.length - 1;
          break;
        case "PageUp":
          nextValue = value - 3;
          break;
        case "PageDown":
          nextValue = value + 3;
          break;
        case "Escape":
        case "Enter":
        case " ":
          setIsHeaderExpanded == null ? void 0 : setIsHeaderExpanded(false);
          (_a2 = headerRef == null ? void 0 : headerRef.current) == null ? void 0 : _a2.focus();
          return;
      }
      const nextItem = map.get(nextValue);
      nextItem == null ? void 0 : nextItem.focus();
    },
    [state]
  );
  return {
    state,
    slots,
    classNames,
    years,
    months,
    highlightRef,
    monthsListRef,
    yearsListRef,
    getItemRef,
    isHeaderExpanded,
    onPickerItemPressed,
    onPickerItemKeyDown
  };
}

// src/calendar-picker.tsx
var import_jsx_runtime8 = require("react/jsx-runtime");
var EMPTY_ITEMS_OFFSET = 3;
function CalendarPicker(props) {
  const {
    state,
    slots,
    months,
    years,
    highlightRef,
    monthsListRef,
    yearsListRef,
    classNames,
    getItemRef,
    isHeaderExpanded,
    onPickerItemPressed,
    onPickerItemKeyDown
  } = useCalendarPicker(props);
  const EmptyItem = (0, import_react7.useCallback)(
    (props2) => /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
      "div",
      {
        "aria-hidden": "true",
        className: slots == null ? void 0 : slots.pickerItem({ class: classNames == null ? void 0 : classNames.pickerItem }),
        "data-slot": "picker-item-empty",
        tabIndex: -1,
        ...props2,
        children: "\xA0"
      }
    ),
    [slots, classNames == null ? void 0 : classNames.pickerItem]
  );
  const PickerItemWrapper = (0, import_react7.useCallback)(
    ({ children }) => /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(import_jsx_runtime8.Fragment, { children: [
      Array.from({ length: EMPTY_ITEMS_OFFSET }, (_, i) => /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(EmptyItem, {}, i)),
      children,
      Array.from({ length: EMPTY_ITEMS_OFFSET }, (_, i) => /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(EmptyItem, {}, i))
    ] }),
    [EmptyItem]
  );
  return /* @__PURE__ */ (0, import_jsx_runtime8.jsxs)(
    "div",
    {
      className: slots == null ? void 0 : slots.pickerWrapper({
        class: classNames == null ? void 0 : classNames.pickerWrapper
      }),
      "data-slot": "picker-wrapper",
      inert: (0, import_shared_utils7.getInertValue)(!isHeaderExpanded),
      children: [
        /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
          "div",
          {
            ref: highlightRef,
            className: slots == null ? void 0 : slots.pickerHighlight({ class: classNames == null ? void 0 : classNames.pickerHighlight }),
            "data-slot": "picker-highlight"
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
          "div",
          {
            ref: monthsListRef,
            className: slots == null ? void 0 : slots.pickerMonthList({ class: classNames == null ? void 0 : classNames.pickerMonthList }),
            "data-slot": "picker-month-list",
            children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(PickerItemWrapper, { children: months.map((month) => {
              var _a;
              return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
                CalendarPickerItem,
                {
                  ref: (node) => getItemRef(node, month.value, "months"),
                  className: slots == null ? void 0 : slots.pickerItem({ class: classNames == null ? void 0 : classNames.pickerItem }),
                  "data-value": month.value,
                  tabIndex: !isHeaderExpanded || ((_a = state.focusedDate) == null ? void 0 : _a.month) !== month.value ? -1 : 0,
                  onKeyDown: (e) => onPickerItemKeyDown(e, month.value, "months"),
                  onPress: (e) => onPickerItemPressed(e, "months"),
                  children: month.label
                },
                `picker-month-${month.value}`
              );
            }) })
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
          "div",
          {
            ref: yearsListRef,
            className: slots == null ? void 0 : slots.pickerYearList({ class: classNames == null ? void 0 : classNames.pickerYearList }),
            "data-slot": "picker-year-list",
            children: /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(PickerItemWrapper, { children: years.map((year) => {
              var _a;
              return /* @__PURE__ */ (0, import_jsx_runtime8.jsx)(
                CalendarPickerItem,
                {
                  ref: (node) => getItemRef(node, year.value, "years"),
                  className: slots == null ? void 0 : slots.pickerItem({ class: classNames == null ? void 0 : classNames.pickerItem }),
                  "data-value": year.value,
                  tabIndex: !isHeaderExpanded || ((_a = state.focusedDate) == null ? void 0 : _a.year) !== year.value ? -1 : 0,
                  onKeyDown: (e) => onPickerItemKeyDown(e, year.value, "years"),
                  onPress: (e) => onPickerItemPressed(e, "years"),
                  children: year.label
                },
                `picker-year-${year.value}`
              );
            }) })
          }
        )
      ]
    }
  );
}

// src/calendar-base.tsx
var import_jsx_runtime9 = require("react/jsx-runtime");
var import_react9 = require("react");
var domAnimation = () => import("@nextui-org/dom-animation").then((res) => res.default);
function CalendarBase(props) {
  const {
    Component = "div",
    showHelper,
    topContent,
    bottomContent,
    calendarProps,
    nextButtonProps,
    prevButtonProps,
    buttonPickerProps,
    errorMessageProps,
    calendarRef: ref,
    errorMessage,
    ...otherProps
  } = props;
  const { state, slots, visibleMonths, showMonthAndYearPickers, disableAnimation, classNames } = useCalendarContext();
  const [direction, setDirection] = (0, import_react8.useState)(0);
  const currentMonth = state.visibleRange.start;
  const headers = [];
  const calendars = [];
  for (let i = 0; i < visibleMonths; i++) {
    let d = currentMonth.add({ months: i });
    headers.push(
      /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_react8.Fragment, { children: [
        i === 0 && /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          import_button2.Button,
          {
            ...prevButtonProps,
            onPress: (0, import_utils7.chain)(prevButtonProps.onPress, () => setDirection(-1)),
            children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(ChevronLeftIcon, {})
          }
        ),
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          CalendarHeader,
          {
            buttonPickerProps,
            currentMonth,
            date: d,
            direction
          }
        ),
        i === visibleMonths - 1 && /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          import_button2.Button,
          {
            ...nextButtonProps,
            onPress: (0, import_utils7.chain)(nextButtonProps.onPress, () => setDirection(1)),
            children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(ChevronRightIcon, {})
          }
        )
      ] }, `calendar-header-${i}`)
    );
    const calendarMonthContent = /* @__PURE__ */ (0, import_react9.createElement)(
      CalendarMonth,
      {
        ...props,
        key: `calendar-month-${i}`,
        currentMonth: currentMonth.month,
        direction,
        startDate: d
      }
    );
    calendars.push(
      showMonthAndYearPickers ? /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_react8.Fragment, { children: [
        calendarMonthContent,
        /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(CalendarPicker, { currentMonth, date: d })
      ] }, `calendar-month-with-pickers-${i}`) : calendarMonthContent
    );
  }
  const calendarContent = /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(import_jsx_runtime9.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
      "div",
      {
        className: slots == null ? void 0 : slots.headerWrapper({ class: classNames == null ? void 0 : classNames.headerWrapper }),
        "data-slot": "header-wrapper",
        children: headers
      },
      "header-wrapper"
    ),
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
      "div",
      {
        className: slots == null ? void 0 : slots.gridWrapper({ class: classNames == null ? void 0 : classNames.gridWrapper }),
        "data-slot": "grid-wrapper",
        children: calendars
      },
      "grid-wrapper"
    )
  ] });
  return /* @__PURE__ */ (0, import_jsx_runtime9.jsxs)(Component, { ...(0, import_utils7.mergeProps)(calendarProps, otherProps), ref, children: [
    topContent,
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_visually_hidden.VisuallyHidden, { children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("h2", { children: calendarProps["aria-label"] }) }),
    disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime9.jsx)("div", { className: slots == null ? void 0 : slots.content({ class: classNames == null ? void 0 : classNames.content }), "data-slot": "content", children: calendarContent }) : /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
      import_framer_utils.ResizablePanel,
      {
        className: slots == null ? void 0 : slots.content({ class: classNames == null ? void 0 : classNames.content }),
        "data-slot": "content",
        children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_framer_motion3.AnimatePresence, { custom: direction, initial: false, mode: "popLayout", children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_framer_motion3.MotionConfig, { transition, children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_framer_motion3.LazyMotion, { features: domAnimation, children: calendarContent }) }) })
      }
    ),
    /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(import_visually_hidden.VisuallyHidden, { children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
      "button",
      {
        "aria-label": nextButtonProps["aria-label"],
        disabled: nextButtonProps.isDisabled,
        tabIndex: -1,
        onClick: () => state.focusNextPage()
      }
    ) }),
    state.isValueInvalid && showHelper && /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
      "div",
      {
        className: slots == null ? void 0 : slots.helperWrapper({ class: classNames == null ? void 0 : classNames.helperWrapper }),
        "data-slot": "helper-wrapper",
        children: /* @__PURE__ */ (0, import_jsx_runtime9.jsx)(
          "span",
          {
            ...errorMessageProps,
            className: slots == null ? void 0 : slots.errorMessage({ class: classNames == null ? void 0 : classNames.errorMessage }),
            "data-slot": "error-message",
            children: errorMessage || "Selected date unavailable."
          }
        )
      }
    ),
    bottomContent
  ] });
}

// src/calendar.tsx
var import_jsx_runtime10 = require("react/jsx-runtime");
var Calendar2 = (0, import_system2.forwardRef)(function Calendar3(props, ref) {
  const { context, getBaseCalendarProps } = useCalendar({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(CalendarProvider, { value: context, children: /* @__PURE__ */ (0, import_jsx_runtime10.jsx)(CalendarBase, { ...getBaseCalendarProps() }) });
});
var calendar_default = Calendar2;

// src/range-calendar.tsx
var import_system3 = require("@nextui-org/system");

// src/use-range-calendar.ts
var import_react10 = require("react");
var import_react_utils6 = require("@nextui-org/react-utils");
var import_calendar5 = require("@react-aria/calendar");
var import_calendar6 = require("@react-stately/calendar");
var import_date6 = require("@internationalized/date");
var import_shared_utils8 = require("@nextui-org/shared-utils");
var import_utils8 = require("@react-aria/utils");
function useRangeCalendar({
  buttonPickerProps: buttonPickerPropsProp,
  className,
  ...originalProps
}) {
  const {
    Component,
    slots,
    children,
    domRef,
    locale,
    showHelper,
    minValue,
    maxValue,
    weekdayStyle,
    visibleDuration,
    shouldFilterDOMProps,
    isHeaderExpanded,
    visibleMonths,
    disableAnimation,
    createCalendar: createCalendarProp,
    showMonthAndYearPickers,
    baseProps,
    getPrevButtonProps,
    getNextButtonProps,
    getErrorMessageProps,
    setIsHeaderExpanded,
    topContent,
    bottomContent,
    errorMessage,
    classNames,
    otherProps
  } = useCalendarBase({ ...originalProps, isRange: true });
  const headerRef = (0, import_react10.useRef)(null);
  const state = (0, import_calendar6.useRangeCalendarState)({
    ...originalProps,
    locale,
    minValue,
    maxValue,
    visibleDuration,
    createCalendar: !createCalendarProp || typeof createCalendarProp !== "function" ? import_date6.createCalendar : createCalendarProp
  });
  const { title, calendarProps, prevButtonProps, nextButtonProps, errorMessageProps } = (0, import_calendar5.useRangeCalendar)(originalProps, state, domRef);
  const baseStyles = (0, import_shared_utils8.clsx)(classNames == null ? void 0 : classNames.base, className);
  const buttonPickerProps = {
    ...buttonPickerPropsProp,
    onPress: (0, import_utils8.chain)(buttonPickerPropsProp == null ? void 0 : buttonPickerPropsProp.onPress, () => setIsHeaderExpanded(!isHeaderExpanded))
  };
  const getBaseCalendarProps = (props = {}) => {
    return {
      ...baseProps,
      Component,
      showHelper,
      topContent,
      bottomContent,
      buttonPickerProps,
      calendarRef: domRef,
      calendarProps,
      prevButtonProps: getPrevButtonProps(prevButtonProps),
      nextButtonProps: getNextButtonProps(nextButtonProps),
      errorMessageProps: getErrorMessageProps(errorMessageProps),
      className: slots.base({ class: baseStyles }),
      errorMessage,
      ...(0, import_react_utils6.filterDOMProps)(otherProps, {
        enabled: shouldFilterDOMProps
      }),
      ...props
    };
  };
  const context = (0, import_react10.useMemo)(
    () => ({
      state,
      slots,
      headerRef,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      showMonthAndYearPickers,
      classNames,
      disableAnimation
    }),
    [
      state,
      slots,
      classNames,
      weekdayStyle,
      isHeaderExpanded,
      setIsHeaderExpanded,
      visibleMonths,
      disableAnimation,
      showMonthAndYearPickers
    ]
  );
  return {
    Component,
    children,
    domRef,
    context,
    state,
    slots,
    title,
    classNames,
    getBaseCalendarProps
  };
}

// src/range-calendar.tsx
var import_jsx_runtime11 = require("react/jsx-runtime");
var RangeCalendar = (0, import_system3.forwardRef)(function RangeCalendar2(props, ref) {
  const { context, getBaseCalendarProps } = useRangeCalendar({ ...props, ref });
  return /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(CalendarProvider, { value: context, children: /* @__PURE__ */ (0, import_jsx_runtime11.jsx)(CalendarBase, { ...getBaseCalendarProps() }) });
});
var range_calendar_default = RangeCalendar;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Calendar,
  CalendarProvider,
  RangeCalendar,
  useCalendar,
  useCalendarContext,
  useRangeCalendar
});
