import * as _nextui_org_theme from '@nextui-org/theme';
import * as tailwind_variants from 'tailwind-variants';
import * as react from 'react';
import * as _nextui_org_system from '@nextui-org/system';
import { DateValue, AriaCalendarProps } from '@react-types/calendar';
import { CalendarState } from '@react-stately/calendar';
import { UseCalendarBaseProps, ContextType } from './use-calendar-base.js';
import { CalendarBaseProps } from './calendar-base.js';
import '@react-types/shared';
import '@internationalized/date';
import '@react-aria/calendar';
import '@react-types/button';
import '@nextui-org/button';
import '@nextui-org/react-utils';
import 'react/jsx-runtime';

type UseCalendarProps<T extends DateValue> = UseCalendarBaseProps & AriaCalendarProps<T>;
declare function useCalendar<T extends DateValue>({ buttonPickerProps: buttonPickerPropsProp, className, ...originalProps }: UseCalendarProps<T>): {
    Component: _nextui_org_system.As<any>;
    children: react.ReactNode;
    domRef: react.RefObject<HTMLDivElement>;
    context: ContextType<CalendarState>;
    state: CalendarState;
    slots: {
        base: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
    } & {
        base: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        prevButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        nextButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        headerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        header: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        title: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        content: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        grid: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeader: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridHeaderCell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBody: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        gridBodyRow: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cell: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        cellButton: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerMonthList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerYearList: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerHighlight: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        pickerItem: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        helperWrapper: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
        errorMessage: (slotProps?: ({
            color?: "foreground" | "primary" | "secondary" | "success" | "warning" | "danger" | undefined;
            isRange?: boolean | undefined;
            hideDisabledDates?: boolean | undefined;
            isHeaderWrapperExpanded?: boolean | undefined;
            showMonthAndYearPickers?: boolean | undefined;
            showShadow?: boolean | undefined;
            disableAnimation?: boolean | undefined;
        } & tailwind_variants.ClassProp<ClassValue>) | undefined) => string;
    } & {};
    title: string;
    classNames: _nextui_org_theme.SlotsToClasses<"base" | "header" | "title" | "content" | "errorMessage" | "gridWrapper" | "grid" | "gridHeader" | "gridHeaderRow" | "gridHeaderCell" | "gridBody" | "gridBodyRow" | "cell" | "pickerWrapper" | "pickerMonthList" | "pickerYearList" | "pickerHighlight" | "helperWrapper" | "prevButton" | "nextButton" | "headerWrapper" | "cellButton" | "pickerItem"> | undefined;
    getBaseCalendarProps: (props?: {}) => CalendarBaseProps;
};
type UseCalendarReturn = ReturnType<typeof useCalendar>;

export { UseCalendarProps, UseCalendarReturn, useCalendar };
