import * as react from 'react';
import { DateValue } from '@internationalized/date';
import { DateInputProps } from '@nextui-org/date-input';
import { DatePickerState } from '@react-stately/datepicker';
import { ButtonProps } from '@nextui-org/button';
import { CalendarProps } from '@nextui-org/calendar';
import { PopoverProps } from '@nextui-org/popover';
import { UseDatePickerBaseProps } from './use-date-picker-base.js';
import { DOMAttributes } from '@nextui-org/system';
import { SlotsToClasses, DatePickerSlots } from '@nextui-org/theme';
import { AriaDatePickerProps } from '@react-aria/datepicker';
import '@react-types/datepicker';
import '@react-types/shared';

interface Props<T extends DateValue> extends UseDatePickerBaseProps<T> {
}
interface Props<T extends DateValue> extends Omit<UseDatePickerBaseProps<T>, keyof AriaDatePickerProps<T>> {
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <DatePicker classNames={{
     *    base:"base-classes",
     *    label: "label-classes",
     *    calendar:"calendar-classes",
     *    selectorButton:"selector-button-classes",
     *    selectorIcon:"selector-icon-classes",
     *    popoverContent:"popover-content-classes",
     *    calendarContent : "calendar-content-classes",
     *    inputWrapper: "input-wrapper-classes",
     *    input: "input-classes",
     *    segment: "segment-classes",
     *    helperWrapper: "helper-wrapper-classes",
     *    description: "description-classes",
     *    errorMessage: "error-message-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<DatePickerSlots> & DateInputProps<T>["classNames"];
}
type UseDatePickerProps<T extends DateValue> = Props<T> & AriaDatePickerProps<T> & {
    /**
     * Classname or List of classes to change the classNames of the date input element.
     */
    dateInputClassNames?: DateInputProps<T>["classNames"];
};
declare function useDatePicker<T extends DateValue>({ className, classNames, ...originalProps }: UseDatePickerProps<T>): {
    state: DatePickerState;
    startContent: react.ReactNode;
    endContent: react.ReactNode;
    selectorIcon: react.ReactNode;
    showTimeField: boolean;
    isCalendarHeaderExpanded: boolean | undefined;
    disableAnimation: boolean;
    CalendarTopContent: react.ReactNode;
    CalendarBottomContent: react.ReactNode;
    getDateInputProps: () => DateInputProps<DateValue>;
    getPopoverProps: (props?: DOMAttributes) => PopoverProps;
    getSelectorButtonProps: () => ButtonProps;
    getCalendarProps: () => CalendarProps<DateValue>;
    getTimeInputProps: () => {};
    getSelectorIconProps: () => {
        className: string;
        "data-slot": string;
    };
};
type UseDatePickerReturn = ReturnType<typeof useDatePicker>;

export { UseDatePickerProps, UseDatePickerReturn, useDatePicker };
