import { PopoverProps } from '@nextui-org/popover';
import { MenuTriggerType } from '@react-types/menu';
import { Ref } from 'react';
import { PropGetter, HTMLNextUIProps } from '@nextui-org/system';
import { ReactRef } from '@nextui-org/react-utils';
import { MenuProps } from '@nextui-org/menu';

interface Props extends HTMLNextUIProps<"div"> {
    /**
     * Type of overlay that is opened by the trigger.
     */
    type?: "menu" | "listbox";
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    /**
     * How the menu is triggered.
     * @default 'press'
     */
    trigger?: MenuTriggerType;
    /**
     * Whether menu trigger is disabled.
     * @default false
     */
    isDisabled?: boolean;
    /**
     * Whether the Menu closes when a selection is made.
     * @default true
     */
    closeOnSelect?: boolean;
}
type UseDropdownProps = Props & Omit<PopoverProps, "children" | "color" | "variant">;
declare function useDropdown(props: UseDropdownProps): UseDropdownReturn;
type UseDropdownReturn = {
    Component: string | React.ElementType;
    menuRef: React.RefObject<HTMLUListElement>;
    menuProps: any;
    classNames: string;
    closeOnSelect: boolean;
    onClose: () => void;
    autoFocus: any;
    disableAnimation: boolean;
    getPopoverProps: PropGetter;
    getMenuProps: <T extends object>(props?: Partial<MenuProps<T>>, ref?: Ref<any>) => MenuProps;
    getMenuTriggerProps: (props?: any) => any;
};

export { UseDropdownProps, UseDropdownReturn, useDropdown };
