import * as react from 'react';
import { MouseEventHandler } from 'react';
import * as _nextui_org_system from '@nextui-org/system';
import { PropGetter, HTMLNextUIProps } from '@nextui-org/system';
import { AriaLinkProps } from '@react-types/link';
import { LinkVariantProps } from '@nextui-org/theme';
import { ReactRef } from '@nextui-org/react-utils';

interface Props extends HTMLNextUIProps<"a">, LinkVariantProps {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLAnchorElement | null>;
    /**
     * Whether the link is external.
     * @default false
     */
    isExternal?: boolean;
    /**
     * Whether to show the icon when the link is external.
     * @default false
     */
    showAnchorIcon?: boolean;
    /**
     * The icon to display right after the link.
     * @default <LinkIcon />
     */
    anchorIcon?: React.ReactNode;
    /**
     * The native link click event handler.
     * use `onPress` instead.
     * @deprecated
     */
    onClick?: MouseEventHandler<HTMLAnchorElement>;
}
type UseLinkProps = Props & AriaLinkProps;
declare function useLink(originalProps: UseLinkProps): {
    Component: _nextui_org_system.As<any>;
    children: react.ReactNode;
    anchorIcon: react.ReactNode;
    showAnchorIcon: boolean;
    getLinkProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
};
type UseLinkReturn = ReturnType<typeof useLink>;

export { UseLinkProps, UseLinkReturn, useLink };
