import { SlotsToClasses, MenuSectionSlots } from '@nextui-org/theme';
import { SectionProps } from '@nextui-org/aria-utils';
import { DividerProps } from '@nextui-org/divider';
import { MenuItemProps } from '../menu-item.js';
import 'react/jsx-runtime';
import '../use-menu-item.js';
import './menu-item-base.js';
import '@react-aria/menu';
import '@react-types/shared';
import 'react';
import 'tailwind-variants';
import '@nextui-org/system';
import '@react-stately/tree';

interface MenuSectionBaseProps<T extends object = {}> extends SectionProps<"ul", T> {
    /**
     * The menu section classNames.
     */
    classNames?: SlotsToClasses<MenuSectionSlots>;
    /**
     * The menu items classNames.
     */
    itemClasses?: MenuItemProps["classNames"];
    /**
     * Shows a divider between sections
     * @default false
     */
    showDivider?: boolean;
    /**
     * Whether to hide the check icon when the items are selected.
     * @default false
     */
    hideSelectedIcon?: boolean;
    /**
     * The divider props
     */
    dividerProps?: DividerProps;
}
declare const MenuSectionBase: <T extends object>(props: MenuSectionBaseProps<T>) => JSX.Element;

export { MenuSectionBaseProps, MenuSectionBase as default };
