"use client";
import {
  MenuSelectedIcon
} from "./chunk-7C7K3AST.mjs";
import {
  useMenuItem
} from "./chunk-ZS6DUJJC.mjs";

// src/menu-item.tsx
import { useMemo } from "react";
import { jsx, jsxs } from "react/jsx-runtime";
var MenuItem = (props) => {
  const {
    Component,
    slots,
    classNames,
    rendered,
    shortcut,
    description,
    isSelectable,
    isSelected,
    isDisabled,
    selectedIcon,
    startContent,
    endContent,
    disableAnimation,
    hideSelectedIcon,
    getItemProps,
    getLabelProps,
    getDescriptionProps,
    getKeyboardShortcutProps,
    getSelectedIconProps
  } = useMenuItem(props);
  const selectedContent = useMemo(() => {
    const defaultIcon = /* @__PURE__ */ jsx(MenuSelectedIcon, { disableAnimation, isSelected });
    if (typeof selectedIcon === "function") {
      return selectedIcon({ icon: defaultIcon, isSelected, isDisabled });
    }
    if (selectedIcon)
      return selectedIcon;
    return defaultIcon;
  }, [selectedIcon, isSelected, isDisabled, disableAnimation]);
  return /* @__PURE__ */ jsxs(Component, { ...getItemProps(), children: [
    startContent,
    description ? /* @__PURE__ */ jsxs("div", { className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }), children: [
      /* @__PURE__ */ jsx("span", { ...getLabelProps(), children: rendered }),
      /* @__PURE__ */ jsx("span", { ...getDescriptionProps(), children: description })
    ] }) : /* @__PURE__ */ jsx("span", { ...getLabelProps(), children: rendered }),
    shortcut && /* @__PURE__ */ jsx("kbd", { ...getKeyboardShortcutProps(), children: shortcut }),
    isSelectable && !hideSelectedIcon && /* @__PURE__ */ jsx("span", { ...getSelectedIconProps(), children: selectedContent }),
    endContent
  ] });
};
MenuItem.displayName = "NextUI.MenuItem";
var menu_item_default = MenuItem;

export {
  menu_item_default
};
