"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Modal: () => modal_default,
  ModalBody: () => modal_body_default,
  ModalContent: () => modal_content_default,
  ModalFooter: () => modal_footer_default,
  ModalHeader: () => modal_header_default,
  ModalProvider: () => ModalProvider,
  useDisclosure: () => import_use_disclosure.useDisclosure,
  useDraggable: () => import_use_draggable.useDraggable,
  useModal: () => useModal,
  useModalContext: () => useModalContext
});
module.exports = __toCommonJS(src_exports);

// src/modal.tsx
var import_framer_motion = require("framer-motion");
var import_overlays2 = require("@react-aria/overlays");
var import_system2 = require("@nextui-org/system");

// src/use-modal.ts
var import_use_aria_modal_overlay = require("@nextui-org/use-aria-modal-overlay");
var import_react = require("react");
var import_theme = require("@nextui-org/theme");
var import_system = require("@nextui-org/system");
var import_use_aria_button = require("@nextui-org/use-aria-button");
var import_focus = require("@react-aria/focus");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_react_utils = require("@nextui-org/react-utils");
var import_overlays = require("@react-stately/overlays");
var import_utils = require("@react-aria/utils");
function useModal(originalProps) {
  var _a, _b, _c;
  const globalContext = (0, import_system.useProviderContext)();
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.modal.variantKeys);
  const {
    ref,
    as,
    className,
    classNames,
    isOpen,
    defaultOpen,
    onOpenChange,
    motionProps,
    closeButton,
    isDismissable = true,
    hideCloseButton = false,
    shouldBlockScroll = true,
    portalContainer,
    isKeyboardDismissDisabled = false,
    onClose,
    ...otherProps
  } = props;
  const Component = as || "section";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const closeButtonRef = (0, import_react.useRef)(null);
  const [headerMounted, setHeaderMounted] = (0, import_react.useState)(false);
  const [bodyMounted, setBodyMounted] = (0, import_react.useState)(false);
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const dialogId = (0, import_react.useId)();
  const headerId = (0, import_react.useId)();
  const bodyId = (0, import_react.useId)();
  const state = (0, import_overlays.useOverlayTriggerState)({
    isOpen,
    defaultOpen,
    onOpenChange: (isOpen2) => {
      onOpenChange == null ? void 0 : onOpenChange(isOpen2);
      if (!isOpen2) {
        onClose == null ? void 0 : onClose();
      }
    }
  });
  const { modalProps, underlayProps } = (0, import_use_aria_modal_overlay.useAriaModalOverlay)(
    {
      isDismissable,
      shouldBlockScroll,
      isKeyboardDismissDisabled
    },
    state,
    domRef
  );
  const { buttonProps: closeButtonProps } = (0, import_use_aria_button.useAriaButton)({ onPress: state.close }, closeButtonRef);
  const { isFocusVisible: isCloseButtonFocusVisible, focusProps: closeButtonFocusProps } = (0, import_focus.useFocusRing)();
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.modal)({
      ...variantProps,
      disableAnimation
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), disableAnimation]
  );
  const getDialogProps = (props2 = {}, ref2 = null) => {
    var _a2;
    return {
      ref: (0, import_utils.mergeRefs)(ref2, domRef),
      ...(0, import_utils.mergeProps)(modalProps, otherProps, props2),
      className: slots.base({ class: (0, import_shared_utils.clsx)(baseStyles, props2.className) }),
      id: dialogId,
      "data-open": (0, import_shared_utils.dataAttr)(state.isOpen),
      "data-dismissable": (0, import_shared_utils.dataAttr)(isDismissable),
      "aria-modal": (0, import_shared_utils.dataAttr)(true),
      "data-placement": (_a2 = originalProps == null ? void 0 : originalProps.placement) != null ? _a2 : "right",
      "aria-labelledby": headerMounted ? headerId : void 0,
      "aria-describedby": bodyMounted ? bodyId : void 0
    };
  };
  const getBackdropProps = (0, import_react.useCallback)(
    (props2 = {}) => ({
      className: slots.backdrop({ class: classNames == null ? void 0 : classNames.backdrop }),
      onClick: () => state.close(),
      ...underlayProps,
      ...props2
    }),
    [slots, classNames, underlayProps]
  );
  const getCloseButtonProps = () => {
    return {
      role: "button",
      tabIndex: 0,
      "aria-label": "Close",
      "data-focus-visible": (0, import_shared_utils.dataAttr)(isCloseButtonFocusVisible),
      className: slots.closeButton({ class: classNames == null ? void 0 : classNames.closeButton }),
      ...(0, import_utils.mergeProps)(closeButtonProps, closeButtonFocusProps)
    };
  };
  return {
    Component,
    slots,
    domRef,
    headerId,
    bodyId,
    motionProps,
    classNames,
    isDismissable,
    closeButton,
    hideCloseButton,
    portalContainer,
    shouldBlockScroll,
    backdrop: (_c = originalProps.backdrop) != null ? _c : "opaque",
    isOpen: state.isOpen,
    onClose: state.close,
    disableAnimation,
    setBodyMounted,
    setHeaderMounted,
    getDialogProps,
    getBackdropProps,
    getCloseButtonProps
  };
}

// src/modal-context.ts
var import_react_utils2 = require("@nextui-org/react-utils");
var [ModalProvider, useModalContext] = (0, import_react_utils2.createContext)({
  name: "ModalContext",
  errorMessage: "useModalContext: `context` is undefined. Seems you forgot to wrap all popover components within `<Modal />`"
});

// src/modal.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Modal = (0, import_system2.forwardRef)((props, ref) => {
  const { children, ...otherProps } = props;
  const context = useModal({ ...otherProps, ref });
  const overlay = /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays2.Overlay, { portalContainer: context.portalContainer, children });
  return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(ModalProvider, { value: context, children: context.disableAnimation && context.isOpen ? overlay : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.AnimatePresence, { children: context.isOpen ? overlay : null }) });
});
Modal.displayName = "NextUI.Modal";
var modal_default = Modal;

// src/modal-content.tsx
var import_react2 = require("react");
var import_overlays3 = require("@react-aria/overlays");
var import_framer_utils2 = require("@nextui-org/framer-utils");
var import_shared_icons = require("@nextui-org/shared-icons");
var import_framer_motion2 = require("framer-motion");
var import_dialog = require("@react-aria/dialog");
var import_utils2 = require("@react-aria/utils");

// src/modal-transition.ts
var import_framer_utils = require("@nextui-org/framer-utils");
var scaleInOut = {
  enter: {
    scale: "var(--scale-enter)",
    y: "var(--slide-enter)",
    opacity: 1,
    willChange: "auto",
    transition: {
      scale: {
        duration: 0.4,
        ease: import_framer_utils.TRANSITION_EASINGS.ease
      },
      opacity: {
        duration: 0.4,
        ease: import_framer_utils.TRANSITION_EASINGS.ease
      },
      y: {
        type: "spring",
        bounce: 0,
        duration: 0.6
      }
    }
  },
  exit: {
    scale: "var(--scale-exit)",
    y: "var(--slide-exit)",
    opacity: 0,
    willChange: "transform",
    transition: {
      duration: 0.3,
      ease: import_framer_utils.TRANSITION_EASINGS.ease
    }
  }
};

// src/modal-content.tsx
var import_jsx_runtime2 = require("react/jsx-runtime");
var domAnimation = () => import("@nextui-org/dom-animation").then((res) => res.default);
var ModalContent = (props) => {
  const { as, children, role = "dialog", ...otherProps } = props;
  const {
    Component: DialogComponent,
    domRef,
    slots,
    classNames,
    motionProps,
    backdrop,
    closeButton,
    hideCloseButton,
    disableAnimation,
    getDialogProps,
    getBackdropProps,
    getCloseButtonProps,
    onClose
  } = useModalContext();
  const Component = as || DialogComponent || "div";
  const viewport = (0, import_utils2.useViewportSize)();
  const { dialogProps } = (0, import_dialog.useDialog)(
    {
      role
    },
    domRef
  );
  const closeButtonContent = (0, import_react2.isValidElement)(closeButton) ? (0, import_react2.cloneElement)(closeButton, getCloseButtonProps()) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("button", { ...getCloseButtonProps(), children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_shared_icons.CloseIcon, {}) });
  const onKeyDown = (0, import_react2.useCallback)((e) => {
    if (e.key === "Tab" && e.nativeEvent.isComposing) {
      e.stopPropagation();
      e.preventDefault();
    }
  }, []);
  const contentProps = getDialogProps((0, import_utils2.mergeProps)(dialogProps, otherProps));
  const content = /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)(Component, { ...contentProps, onKeyDown: (0, import_utils2.chain)(contentProps.onKeyDown, onKeyDown), children: [
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_overlays3.DismissButton, { onDismiss: onClose }),
    !hideCloseButton && closeButtonContent,
    typeof children === "function" ? children(onClose) : children,
    /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_overlays3.DismissButton, { onDismiss: onClose })
  ] });
  const backdropContent = (0, import_react2.useMemo)(() => {
    if (backdrop === "transparent") {
      return null;
    }
    if (disableAnimation) {
      return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)("div", { ...getBackdropProps() });
    }
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_framer_motion2.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
      import_framer_motion2.m.div,
      {
        animate: "enter",
        exit: "exit",
        initial: "exit",
        variants: import_framer_utils2.TRANSITION_VARIANTS.fade,
        ...getBackdropProps()
      }
    ) });
  }, [backdrop, disableAnimation, getBackdropProps]);
  const viewportStyle = {
    "--visual-viewport-height": viewport.height + "px"
  };
  const contents = disableAnimation ? /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    "div",
    {
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      "data-slot": "wrapper",
      style: viewportStyle,
      children: content
    }
  ) : /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(import_framer_motion2.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    import_framer_motion2.m.div,
    {
      animate: "enter",
      className: slots.wrapper({ class: classNames == null ? void 0 : classNames.wrapper }),
      "data-slot": "wrapper",
      exit: "exit",
      initial: "exit",
      variants: scaleInOut,
      ...motionProps,
      style: viewportStyle,
      children: content
    }
  ) });
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsxs)("div", { tabIndex: -1, children: [
    backdropContent,
    contents
  ] });
};
ModalContent.displayName = "NextUI.ModalContent";
var modal_content_default = ModalContent;

// src/modal-header.tsx
var import_react3 = require("react");
var import_system3 = require("@nextui-org/system");
var import_react_utils3 = require("@nextui-org/react-utils");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_jsx_runtime3 = require("react/jsx-runtime");
var ModalHeader = (0, import_system3.forwardRef)((props, ref) => {
  const { as, children, className, ...otherProps } = props;
  const { slots, classNames, headerId, setHeaderMounted } = useModalContext();
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const Component = as || "header";
  (0, import_react3.useEffect)(() => {
    setHeaderMounted(true);
    return () => setHeaderMounted(false);
  }, [setHeaderMounted]);
  return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
    Component,
    {
      ref: domRef,
      className: slots.header({ class: (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.header, className) }),
      id: headerId,
      ...otherProps,
      children
    }
  );
});
ModalHeader.displayName = "NextUI.ModalHeader";
var modal_header_default = ModalHeader;

// src/modal-body.tsx
var import_react4 = require("react");
var import_system4 = require("@nextui-org/system");
var import_react_utils4 = require("@nextui-org/react-utils");
var import_shared_utils3 = require("@nextui-org/shared-utils");
var import_jsx_runtime4 = require("react/jsx-runtime");
var ModalBody = (0, import_system4.forwardRef)((props, ref) => {
  const { as, children, className, ...otherProps } = props;
  const { slots, classNames, bodyId, setBodyMounted } = useModalContext();
  const domRef = (0, import_react_utils4.useDOMRef)(ref);
  const Component = as || "div";
  (0, import_react4.useEffect)(() => {
    setBodyMounted(true);
    return () => setBodyMounted(false);
  }, [setBodyMounted]);
  return /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
    Component,
    {
      ref: domRef,
      className: slots.body({ class: (0, import_shared_utils3.clsx)(classNames == null ? void 0 : classNames.body, className) }),
      id: bodyId,
      ...otherProps,
      children
    }
  );
});
ModalBody.displayName = "NextUI.ModalBody";
var modal_body_default = ModalBody;

// src/modal-footer.tsx
var import_system5 = require("@nextui-org/system");
var import_react_utils5 = require("@nextui-org/react-utils");
var import_shared_utils4 = require("@nextui-org/shared-utils");
var import_jsx_runtime5 = require("react/jsx-runtime");
var ModalFooter = (0, import_system5.forwardRef)((props, ref) => {
  const { as, children, className, ...otherProps } = props;
  const { slots, classNames } = useModalContext();
  const domRef = (0, import_react_utils5.useDOMRef)(ref);
  const Component = as || "footer";
  return /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(
    Component,
    {
      ref: domRef,
      className: slots.footer({ class: (0, import_shared_utils4.clsx)(classNames == null ? void 0 : classNames.footer, className) }),
      ...otherProps,
      children
    }
  );
});
ModalFooter.displayName = "NextUI.ModalFooter";
var modal_footer_default = ModalFooter;

// src/index.ts
var import_use_disclosure = require("@nextui-org/use-disclosure");
var import_use_draggable = require("@nextui-org/use-draggable");
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Modal,
  ModalBody,
  ModalContent,
  ModalFooter,
  ModalHeader,
  ModalProvider,
  useDisclosure,
  useDraggable,
  useModal,
  useModalContext
});
