"use client";
import {
  navbar_menu_default
} from "./chunk-QKHJHOQ7.mjs";
import {
  hideOnScrollVariants
} from "./chunk-SBDILHQN.mjs";
import {
  useNavbar
} from "./chunk-HY4MGMIV.mjs";
import {
  NavbarProvider
} from "./chunk-CLWTNWD4.mjs";

// src/navbar.tsx
import { forwardRef } from "@nextui-org/system";
import { pickChildren } from "@nextui-org/react-utils";
import { LazyMotion, m } from "framer-motion";
import { mergeProps } from "@react-aria/utils";
import { Fragment, jsx, jsxs } from "react/jsx-runtime";
var domAnimation = () => import("@nextui-org/dom-animation").then((res) => res.default);
var Navbar = forwardRef((props, ref) => {
  const { children, ...otherProps } = props;
  const context = useNavbar({ ...otherProps, ref });
  const Component = context.Component;
  const [childrenWithoutMenu, menu] = pickChildren(children, navbar_menu_default);
  const content = /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx("header", { ...context.getWrapperProps(), children: childrenWithoutMenu }),
    menu
  ] });
  return /* @__PURE__ */ jsx(NavbarProvider, { value: context, children: context.shouldHideOnScroll ? /* @__PURE__ */ jsx(LazyMotion, { features: domAnimation, children: /* @__PURE__ */ jsx(
    m.nav,
    {
      animate: context.isHidden ? "hidden" : "visible",
      initial: false,
      variants: hideOnScrollVariants,
      ...mergeProps(context.getBaseProps(), context.motionProps),
      children: content
    }
  ) }) : /* @__PURE__ */ jsx(Component, { ...context.getBaseProps(), children: content }) });
});
Navbar.displayName = "NextUI.Navbar";
var navbar_default = Navbar;

export {
  navbar_default
};
