"use client";

// src/use-navbar.ts
import {
  mapPropsVariants,
  useProviderContext
} from "@nextui-org/system";
import { navbar } from "@nextui-org/theme";
import { useDOMRef } from "@nextui-org/react-utils";
import { clsx, dataAttr, objectToDeps } from "@nextui-org/shared-utils";
import { useCallback, useEffect, useMemo, useRef, useState } from "react";
import { mergeProps, useResizeObserver } from "@react-aria/utils";
import { useScrollPosition } from "@nextui-org/use-scroll-position";
import { useControlledState } from "@react-stately/utils";
import { usePreventScroll } from "@react-aria/overlays";
function useNavbar(originalProps) {
  var _a, _b;
  const globalContext = useProviderContext();
  const [props, variantProps] = mapPropsVariants(originalProps, navbar.variantKeys);
  const {
    ref,
    as,
    parentRef,
    height = "4rem",
    shouldHideOnScroll = false,
    disableScrollHandler = false,
    shouldBlockScroll = true,
    onScrollPositionChange,
    isMenuOpen: isMenuOpenProp,
    isMenuDefaultOpen,
    onMenuOpenChange = () => {
    },
    motionProps,
    className,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "nav";
  const disableAnimation = (_b = (_a = originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const domRef = useDOMRef(ref);
  const prevWidth = useRef(0);
  const navHeight = useRef(0);
  const [isHidden, setIsHidden] = useState(false);
  const handleMenuOpenChange = useCallback(
    (isOpen) => {
      onMenuOpenChange(isOpen || false);
    },
    [onMenuOpenChange]
  );
  const [isMenuOpen, setIsMenuOpen] = useControlledState(
    isMenuOpenProp,
    isMenuDefaultOpen != null ? isMenuDefaultOpen : false,
    handleMenuOpenChange
  );
  const updateWidth = () => {
    if (domRef.current) {
      const width = domRef.current.offsetWidth;
      if (width !== prevWidth.current) {
        prevWidth.current = width;
      }
    }
  };
  usePreventScroll({
    isDisabled: !(shouldBlockScroll && isMenuOpen)
  });
  useResizeObserver({
    ref: domRef,
    onResize: () => {
      var _a2;
      const currentWidth = (_a2 = domRef.current) == null ? void 0 : _a2.offsetWidth;
      const scrollWidth = window.innerWidth - document.documentElement.clientWidth;
      if (currentWidth && currentWidth + scrollWidth == prevWidth.current) {
        return;
      }
      if (currentWidth !== prevWidth.current) {
        updateWidth();
        setIsMenuOpen(false);
      }
    }
  });
  useEffect(() => {
    var _a2;
    updateWidth();
    navHeight.current = ((_a2 = domRef.current) == null ? void 0 : _a2.offsetHeight) || 0;
  }, []);
  const slots = useMemo(
    () => navbar({
      ...variantProps,
      disableAnimation,
      hideOnScroll: shouldHideOnScroll
    }),
    [objectToDeps(variantProps), disableAnimation, shouldHideOnScroll]
  );
  const baseStyles = clsx(classNames == null ? void 0 : classNames.base, className);
  useScrollPosition({
    elementRef: parentRef,
    isEnabled: shouldHideOnScroll || !disableScrollHandler,
    callback: ({ prevPos, currPos }) => {
      onScrollPositionChange == null ? void 0 : onScrollPositionChange(currPos.y);
      if (shouldHideOnScroll) {
        setIsHidden((prev) => {
          const next = currPos.y > prevPos.y && currPos.y > navHeight.current;
          return next !== prev ? next : prev;
        });
      }
    }
  });
  const getBaseProps = (props2 = {}) => ({
    ...mergeProps(otherProps, props2),
    "data-hidden": dataAttr(isHidden),
    "data-menu-open": dataAttr(isMenuOpen),
    ref: domRef,
    className: slots.base({ class: clsx(baseStyles, props2 == null ? void 0 : props2.className) }),
    style: {
      "--navbar-height": typeof height === "number" ? `${height}px` : height,
      ...otherProps == null ? void 0 : otherProps.style,
      ...props2 == null ? void 0 : props2.style
    }
  });
  const getWrapperProps = (props2 = {}) => ({
    ...props2,
    "data-menu-open": dataAttr(isMenuOpen),
    className: slots.wrapper({ class: clsx(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) })
  });
  return {
    Component,
    slots,
    domRef,
    height,
    isHidden,
    disableAnimation,
    shouldHideOnScroll,
    isMenuOpen,
    classNames,
    setIsMenuOpen,
    motionProps,
    getBaseProps,
    getWrapperProps
  };
}

export {
  useNavbar
};
