import * as react_jsx_runtime from 'react/jsx-runtime';
import { FocusableElement } from '@react-types/shared';
import React__default, { ReactNode, RefObject } from 'react';
import { MultiSelectState, MultiSelectProps } from '@nextui-org/use-aria-multiselect';

interface AriaHiddenSelectProps {
    /**
     * Describes the type of autocomplete functionality the input should provide if any. See [MDN](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#htmlattrdefautocomplete).
     */
    autoComplete?: string;
    /** The text label for the select. */
    label?: ReactNode;
    /** HTML form input name. */
    name?: string;
    /** Sets the disabled state of the select and input. */
    isDisabled?: boolean;
    /** Whether the select is required. */
    isRequired?: boolean;
}
type NativeHTMLSelectProps = Omit<React__default.SelectHTMLAttributes<HTMLSelectElement>, keyof AriaHiddenSelectProps>;
type CombinedAriaSelectProps = NativeHTMLSelectProps & AriaHiddenSelectProps;
interface HiddenSelectProps<T> extends CombinedAriaSelectProps {
    /** State for the select. */
    state: MultiSelectState<T>;
    /** The selection mode for the select. */
    selectionMode: MultiSelectProps<T>["selectionMode"];
    /** A ref to the trigger element. */
    triggerRef: RefObject<FocusableElement>;
    /** A ref to the hidden `<select>` element. */
    selectRef?: RefObject<HTMLSelectElement>;
}
interface AriaHiddenSelectOptions<T> extends CombinedAriaSelectProps {
    /** A ref to the hidden `<select>` element. */
    selectRef?: RefObject<HTMLSelectElement>;
    /** The selection mode for the select. */
    selectionMode: MultiSelectProps<T>["selectionMode"];
}
/**
 * Provides the behavior and accessibility implementation for a hidden `<select>` element, which
 * can be used in combination with `useSelect` to support browser form autofill, mobile form
 * navigation, and native HTML form submission.
 */
declare function useHiddenSelect<T>(props: AriaHiddenSelectOptions<T>, state: MultiSelectState<T>, triggerRef: RefObject<FocusableElement>): {
    containerProps: {
        "aria-hidden": boolean;
        "data-a11y-ignore": string;
        id?: string | undefined;
        role?: React__default.AriaRole | undefined;
        tabIndex?: number | undefined;
        style?: React__default.CSSProperties | undefined;
        className?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "none" | "list" | "inline" | "both" | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-controls'?: string | undefined;
        'aria-current'?: boolean | "true" | "false" | "page" | "step" | "location" | "date" | "time" | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-dropeffect'?: "none" | "link" | "copy" | "execute" | "move" | "popup" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-haspopup'?: boolean | "dialog" | "grid" | "listbox" | "menu" | "tree" | "true" | "false" | undefined;
        'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-label'?: string | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "assertive" | "polite" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-roledescription'?: string | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        children?: React__default.ReactNode;
        dangerouslySetInnerHTML?: {
            __html: string | TrustedHTML;
        } | undefined;
        onCopy?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onCopyCapture?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onCut?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onCutCapture?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onPaste?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onPasteCapture?: React__default.ClipboardEventHandler<FocusableElement> | undefined;
        onCompositionEnd?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onCompositionEndCapture?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onCompositionStart?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onCompositionStartCapture?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onCompositionUpdate?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onCompositionUpdateCapture?: React__default.CompositionEventHandler<FocusableElement> | undefined;
        onFocus?: React__default.FocusEventHandler<FocusableElement> | undefined;
        onFocusCapture?: React__default.FocusEventHandler<FocusableElement> | undefined;
        onBlur?: React__default.FocusEventHandler<FocusableElement> | undefined;
        onBlurCapture?: React__default.FocusEventHandler<FocusableElement> | undefined;
        onChange?: React__default.FormEventHandler<FocusableElement> | undefined;
        onChangeCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onBeforeInput?: React__default.FormEventHandler<FocusableElement> | undefined;
        onBeforeInputCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onInput?: React__default.FormEventHandler<FocusableElement> | undefined;
        onInputCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onReset?: React__default.FormEventHandler<FocusableElement> | undefined;
        onResetCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onSubmit?: React__default.FormEventHandler<FocusableElement> | undefined;
        onSubmitCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onInvalid?: React__default.FormEventHandler<FocusableElement> | undefined;
        onInvalidCapture?: React__default.FormEventHandler<FocusableElement> | undefined;
        onLoad?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onError?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onErrorCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onKeyDown?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onKeyDownCapture?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onKeyPress?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onKeyPressCapture?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onKeyUp?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onKeyUpCapture?: React__default.KeyboardEventHandler<FocusableElement> | undefined;
        onAbort?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onAbortCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onCanPlay?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onCanPlayCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onCanPlayThrough?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onCanPlayThroughCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onDurationChange?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onDurationChangeCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEmptied?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEmptiedCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEncrypted?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEncryptedCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEnded?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onEndedCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadedData?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadedDataCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadedMetadata?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadedMetadataCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadStart?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onLoadStartCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPause?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPauseCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPlay?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPlayCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPlaying?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onPlayingCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onProgress?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onProgressCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onRateChange?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onRateChangeCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onResize?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onResizeCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSeeked?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSeekedCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSeeking?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSeekingCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onStalled?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onStalledCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSuspend?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSuspendCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onTimeUpdate?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onTimeUpdateCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onVolumeChange?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onVolumeChangeCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onWaiting?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onWaitingCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onAuxClick?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onAuxClickCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onClick?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onClickCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onContextMenu?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onContextMenuCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onDoubleClick?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onDoubleClickCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onDrag?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragEnd?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragEndCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragEnter?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragEnterCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragExit?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragExitCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragLeave?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragLeaveCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragOver?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragOverCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragStart?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDragStartCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDrop?: React__default.DragEventHandler<FocusableElement> | undefined;
        onDropCapture?: React__default.DragEventHandler<FocusableElement> | undefined;
        onMouseDown?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseDownCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseEnter?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseLeave?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseMove?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseMoveCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseOut?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseOutCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseOver?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseOverCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseUp?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onMouseUpCapture?: React__default.MouseEventHandler<FocusableElement> | undefined;
        onSelect?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onSelectCapture?: React__default.ReactEventHandler<FocusableElement> | undefined;
        onTouchCancel?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchCancelCapture?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchEnd?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchEndCapture?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchMove?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchMoveCapture?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchStart?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onTouchStartCapture?: React__default.TouchEventHandler<FocusableElement> | undefined;
        onPointerDown?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerDownCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerMove?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerMoveCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerUp?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerUpCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerCancel?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerCancelCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerEnter?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerEnterCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerLeave?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerLeaveCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerOver?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerOverCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerOut?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onPointerOutCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onGotPointerCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onGotPointerCaptureCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onLostPointerCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onLostPointerCaptureCapture?: React__default.PointerEventHandler<FocusableElement> | undefined;
        onScroll?: React__default.UIEventHandler<FocusableElement> | undefined;
        onScrollCapture?: React__default.UIEventHandler<FocusableElement> | undefined;
        onWheel?: React__default.WheelEventHandler<FocusableElement> | undefined;
        onWheelCapture?: React__default.WheelEventHandler<FocusableElement> | undefined;
        onAnimationStart?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onAnimationStartCapture?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onAnimationEnd?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onAnimationEndCapture?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onAnimationIteration?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onAnimationIterationCapture?: React__default.AnimationEventHandler<FocusableElement> | undefined;
        onTransitionEnd?: React__default.TransitionEventHandler<FocusableElement> | undefined;
        onTransitionEndCapture?: React__default.TransitionEventHandler<FocusableElement> | undefined;
    };
    inputProps: {
        style: {
            display: string;
        };
    };
    selectProps: {
        autoComplete: string | undefined;
        disabled: boolean | undefined;
        "aria-invalid": true | undefined;
        "aria-required": true | undefined;
        required: boolean | undefined;
        name: string | undefined;
        tabIndex: number;
        value: React__default.Key | string[];
        multiple: boolean;
        onChange: (e: React__default.ChangeEvent<HTMLSelectElement>) => void;
    };
};
/**
 * Renders a hidden native `<select>` element, which can be used to support browser
 * form autofill, mobile form navigation, and native form submission.
 */
declare function HiddenSelect<T>(props: HiddenSelectProps<T>): react_jsx_runtime.JSX.Element | null;

export { AriaHiddenSelectOptions, AriaHiddenSelectProps, HiddenSelect, HiddenSelectProps, useHiddenSelect };
