import * as _react_types_table from '@react-types/table';
import { TableCollection } from '@react-types/table';
import * as _nextui_org_system from '@nextui-org/system';
import { PropGetter, HTMLNextUIProps } from '@nextui-org/system';
import * as react from 'react';
import { ReactNode, Key } from 'react';
import { TableVariantProps, TableReturnType, SlotsToClasses, TableSlots } from '@nextui-org/theme';
import { Layout } from '@react-stately/virtualizer';
import { SelectionBehavior, Node, DisabledBehavior } from '@react-types/shared';
import { TableStateProps, TableState } from '@react-stately/table';
import { AriaTableProps } from '@react-aria/table';
import { ReactRef } from '@nextui-org/react-utils';
import { CheckboxProps } from '@nextui-org/checkbox';

type TableContentPlacement = "inside" | "outside";
interface Props<T> extends HTMLNextUIProps<"table"> {
    /**
     * Ref to the DOM node.
     */
    ref?: ReactRef<HTMLElement | null>;
    children?: ReactNode;
    layoutNode?: Layout<Node<T>>;
    /**
     * A custom wrapper component for the table.
     * @default "div"
     */
    BaseComponent?: React.ComponentType<any>;
    /**
     * Ref to the container element.
     */
    baseRef?: ReactRef<HTMLElement | null>;
    /**
     * Where to place the `topContent` component.
     * @default "inside"
     */
    topContentPlacement?: TableContentPlacement;
    /**
     * Provides content to include a component in the top of the table.
     */
    topContent?: ReactNode;
    /**
     * Where to place the `bottomContent` component.
     * @default "inside"
     */
    bottomContentPlacement?: TableContentPlacement;
    /**
     * Provides content to include a component in the bottom of the table.
     */
    bottomContent?: ReactNode;
    /**
     * Whether the table base container should not be rendered.
     * @default false
     */
    removeWrapper?: boolean;
    /**
     * How multiple selection should behave in the collection.
     * The selection behavior for the table. If selectionMode is `"none"`, this will be `null`.
     * otherwise, this will be `toggle` or `replace`.
     * @default "toggle"
     */
    selectionBehavior?: SelectionBehavior | null;
    /**
     * Whether `disabledKeys` applies to all interactions, or only selection.
     * @default "selection"
     */
    disabledBehavior?: DisabledBehavior;
    /**
     * Whether to disable the table and checkbox animations.
     * @default false
     */
    disableAnimation?: boolean;
    /**
     * Whether to disable the keyboard navigation functionality.
     * @default false
     */
    isKeyboardNavigationDisabled?: boolean;
    /**
     * Props to be passed to the checkboxes.
     */
    checkboxesProps?: CheckboxProps;
    /** Handler that is called when a user performs an action on the row. */
    onRowAction?: (key: Key) => void;
    /** Handler that is called when a user performs an action on the cell. */
    onCellAction?: (key: Key) => void;
    /**
     * Classname or List of classes to change the classNames of the element.
     * if `className` is passed, it will be added to the base slot.
     *
     * @example
     * ```ts
     * <Table classNames={{
     *    base:"base-classes", // table wrapper
     *    table: "table-classes",
     *    thead: "thead-classes",
     *    tbody: "tbody-classes",
     *    tr: "tr-classes",
     *    th: "th-classes",
     *    td: "td-classes",
     *    tfoot: "tfoot-classes",
     *    sortIcon: "sort-icon-classes",
     *    emptyWrapper: "empty-wrapper-classes",
     * }} />
     * ```
     */
    classNames?: SlotsToClasses<TableSlots>;
}
type UseTableProps<T = object> = Props<T> & TableStateProps<T> & Omit<AriaTableProps, "layout"> & TableVariantProps;
type ValuesType<T = object> = {
    state: TableState<T>;
    slots: TableReturnType;
    collection: TableCollection<T>;
    color: TableVariantProps["color"];
    isSelectable: boolean;
    selectionMode: UseTableProps<T>["selectionMode"];
    selectionBehavior: SelectionBehavior | null;
    checkboxesProps?: CheckboxProps;
    disabledBehavior: UseTableProps<T>["disabledBehavior"];
    disableAnimation?: UseTableProps<T>["disableAnimation"];
    isHeaderSticky?: UseTableProps<T>["isHeaderSticky"];
    showSelectionCheckboxes: UseTableProps<T>["showSelectionCheckboxes"];
    classNames?: SlotsToClasses<TableSlots>;
    onRowAction?: UseTableProps<T>["onRowAction"];
    onCellAction?: UseTableProps<T>["onCellAction"];
};
declare function useTable<T extends object>(originalProps: UseTableProps<T>): {
    BaseComponent: string | react.ComponentType<any>;
    Component: _nextui_org_system.As<any>;
    children: ((string | number | boolean | react.ReactElement<any, string | react.JSXElementConstructor<any>> | react.ReactFragment | react.ReactPortal | null) & [react.ReactElement<_react_types_table.TableHeaderProps<T>, string | react.JSXElementConstructor<any>>, react.ReactElement<_react_types_table.TableBodyProps<T>, string | react.JSXElementConstructor<any>>]) | undefined;
    state: TableState<T>;
    collection: TableCollection<T>;
    values: ValuesType<T>;
    topContent: ReactNode;
    bottomContent: ReactNode;
    removeWrapper: boolean;
    topContentPlacement: TableContentPlacement;
    bottomContentPlacement: TableContentPlacement;
    getBaseProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getWrapperProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
    getTableProps: PropGetter<Record<string, unknown>, _nextui_org_system.DOMAttributes<_nextui_org_system.DOMElement>>;
};
type UseTableReturn = ReturnType<typeof useTable>;

export { UseTableProps, UseTableReturn, ValuesType, useTable };
