"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  Tab: () => tab_item_base_default,
  Tabs: () => tabs_default,
  useTabs: () => useTabs
});
module.exports = __toCommonJS(src_exports);

// src/tabs.tsx
var import_react2 = require("react");
var import_framer_motion2 = require("framer-motion");
var import_system4 = require("@nextui-org/system");

// src/use-tabs.ts
var import_system = require("@nextui-org/system");
var import_theme = require("@nextui-org/theme");
var import_react_utils = require("@nextui-org/react-utils");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_react_utils2 = require("@nextui-org/react-utils");
var import_react = require("react");
var import_tabs = require("@react-stately/tabs");
var import_tabs2 = require("@react-aria/tabs");
var import_utils = require("@react-aria/utils");
function useTabs(originalProps) {
  var _a, _b, _c;
  const globalContext = (0, import_system.useProviderContext)();
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.tabs.variantKeys);
  const {
    ref,
    as,
    className,
    classNames,
    children,
    disableCursorAnimation,
    motionProps,
    isVertical = false,
    shouldSelectOnPressUp = true,
    destroyInactiveTabPanel = true,
    ...otherProps
  } = props;
  const Component = as || "div";
  const shouldFilterDOMProps = typeof Component === "string";
  const domRef = (0, import_react_utils.useDOMRef)(ref);
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const state = (0, import_tabs.useTabListState)({
    children,
    ...otherProps
  });
  const { tabListProps } = (0, import_tabs2.useTabList)(otherProps, state, domRef);
  const slots = (0, import_react.useMemo)(
    () => (0, import_theme.tabs)({
      ...variantProps,
      className,
      disableAnimation,
      ...isVertical ? { placement: "start" } : {}
    }),
    [(0, import_shared_utils.objectToDeps)(variantProps), className, disableAnimation, isVertical]
  );
  const baseStyles = (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.base, className);
  const values = (0, import_react.useMemo)(
    () => ({
      state,
      slots,
      classNames,
      motionProps,
      disableAnimation,
      listRef: domRef,
      shouldSelectOnPressUp,
      disableCursorAnimation,
      isDisabled: originalProps == null ? void 0 : originalProps.isDisabled
    }),
    [
      state,
      slots,
      domRef,
      motionProps,
      disableAnimation,
      disableCursorAnimation,
      shouldSelectOnPressUp,
      originalProps == null ? void 0 : originalProps.isDisabled,
      classNames
    ]
  );
  const getBaseProps = (0, import_react.useCallback)(
    (props2) => ({
      "data-slot": "base",
      className: slots.base({ class: (0, import_shared_utils.clsx)(baseStyles, props2 == null ? void 0 : props2.className) }),
      ...(0, import_utils.mergeProps)(
        (0, import_react_utils2.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps
        }),
        props2
      )
    }),
    [baseStyles, otherProps, slots]
  );
  const placement = (_c = variantProps.placement) != null ? _c : isVertical ? "start" : "top";
  const getWrapperProps = (0, import_react.useCallback)(
    (props2) => ({
      "data-slot": "tabWrapper",
      className: slots.wrapper({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.wrapper, props2 == null ? void 0 : props2.className) }),
      "data-placement": placement,
      "data-vertical": isVertical || placement === "start" || placement === "end" ? "vertical" : "horizontal"
    }),
    [classNames, slots, placement, isVertical]
  );
  const getTabListProps = (0, import_react.useCallback)(
    (props2) => ({
      ref: domRef,
      "data-slot": "tabList",
      className: slots.tabList({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.tabList, props2 == null ? void 0 : props2.className) }),
      ...(0, import_utils.mergeProps)(tabListProps, props2)
    }),
    [domRef, tabListProps, classNames, slots]
  );
  return {
    Component,
    domRef,
    state,
    values,
    destroyInactiveTabPanel,
    getBaseProps,
    getTabListProps,
    getWrapperProps
  };
}

// src/tab.tsx
var import_system2 = require("@nextui-org/system");
var import_react_utils3 = require("@nextui-org/react-utils");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_utils2 = require("@react-aria/utils");
var import_scroll_into_view_if_needed = __toESM(require("scroll-into-view-if-needed"));
var import_focus = require("@react-aria/focus");
var import_tabs3 = require("@react-aria/tabs");
var import_interactions = require("@react-aria/interactions");
var import_framer_motion = require("framer-motion");
var import_use_is_mounted = require("@nextui-org/use-is-mounted");
var import_jsx_runtime = require("react/jsx-runtime");
var Tab = (0, import_system2.forwardRef)((props, ref) => {
  var _a;
  const {
    className,
    as,
    item,
    state,
    classNames,
    isDisabled: isDisabledProp,
    listRef,
    slots,
    motionProps,
    disableAnimation,
    disableCursorAnimation,
    shouldSelectOnPressUp,
    onClick,
    tabRef,
    ...otherProps
  } = props;
  const { key } = item;
  const domRef = (0, import_react_utils3.useDOMRef)(ref);
  const Component = as || (props.href ? "a" : "button");
  const shouldFilterDOMProps = typeof Component === "string";
  const {
    tabProps,
    isSelected,
    isDisabled: isDisabledItem,
    isPressed
  } = (0, import_tabs3.useTab)({ key, isDisabled: isDisabledProp, shouldSelectOnPressUp }, state, domRef);
  if (props.children == null) {
    delete tabProps["aria-controls"];
  }
  const isDisabled = isDisabledProp || isDisabledItem;
  const { focusProps, isFocused, isFocusVisible } = (0, import_focus.useFocusRing)();
  const { hoverProps, isHovered } = (0, import_interactions.useHover)({
    isDisabled
  });
  const tabStyles = (0, import_shared_utils2.clsx)(classNames == null ? void 0 : classNames.tab, className);
  const [, isMounted] = (0, import_use_is_mounted.useIsMounted)({
    rerender: true
  });
  const handleClick = () => {
    (0, import_utils2.chain)(onClick, tabProps.onClick);
    if (!(domRef == null ? void 0 : domRef.current) || !(listRef == null ? void 0 : listRef.current))
      return;
    (0, import_scroll_into_view_if_needed.default)(domRef.current, {
      scrollMode: "if-needed",
      behavior: "smooth",
      block: "end",
      inline: "end",
      boundary: listRef == null ? void 0 : listRef.current
    });
  };
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
    Component,
    {
      ref: (0, import_react_utils3.mergeRefs)(domRef, tabRef),
      "data-disabled": (0, import_shared_utils2.dataAttr)(isDisabledItem),
      "data-focus": (0, import_shared_utils2.dataAttr)(isFocused),
      "data-focus-visible": (0, import_shared_utils2.dataAttr)(isFocusVisible),
      "data-hover": (0, import_shared_utils2.dataAttr)(isHovered),
      "data-hover-unselected": (0, import_shared_utils2.dataAttr)((isHovered || isPressed) && !isSelected),
      "data-pressed": (0, import_shared_utils2.dataAttr)(isPressed),
      "data-selected": (0, import_shared_utils2.dataAttr)(isSelected),
      "data-slot": "tab",
      ...(0, import_utils2.mergeProps)(
        tabProps,
        !isDisabled ? {
          ...focusProps,
          ...hoverProps
        } : {},
        (0, import_react_utils3.filterDOMProps)(otherProps, {
          enabled: shouldFilterDOMProps,
          omitPropNames: /* @__PURE__ */ new Set(["title"])
        }),
        { onClick: handleClick }
      ),
      className: (_a = slots.tab) == null ? void 0 : _a.call(slots, { class: tabStyles }),
      title: otherProps == null ? void 0 : otherProps.titleValue,
      type: Component === "button" ? "button" : void 0,
      children: [
        isSelected && !disableAnimation && !disableCursorAnimation && isMounted ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: import_framer_motion.domMax, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          import_framer_motion.m.span,
          {
            className: slots.cursor({ class: classNames == null ? void 0 : classNames.cursor }),
            "data-slot": "cursor",
            layoutDependency: false,
            layoutId: "cursor",
            transition: {
              type: "spring",
              bounce: 0.15,
              duration: 0.5
            },
            ...motionProps
          }
        ) }) : null,
        /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
          "div",
          {
            className: slots.tabContent({
              class: classNames == null ? void 0 : classNames.tabContent
            }),
            "data-slot": "tabContent",
            children: item.rendered
          }
        )
      ]
    }
  );
});
Tab.displayName = "NextUI.Tab";
var tab_default = Tab;

// src/tab-panel.tsx
var import_system3 = require("@nextui-org/system");
var import_react_utils4 = require("@nextui-org/react-utils");
var import_shared_utils3 = require("@nextui-org/shared-utils");
var import_utils3 = require("@react-aria/utils");
var import_tabs4 = require("@react-aria/tabs");
var import_focus2 = require("@react-aria/focus");
var import_jsx_runtime2 = require("react/jsx-runtime");
var TabPanel = (0, import_system3.forwardRef)((props, ref) => {
  var _a, _b;
  const { as, tabKey, destroyInactiveTabPanel, state, className, slots, classNames, ...otherProps } = props;
  const Component = as || "div";
  const domRef = (0, import_react_utils4.useDOMRef)(ref);
  const { tabPanelProps } = (0, import_tabs4.useTabPanel)({ ...props, id: String(tabKey) }, state, domRef);
  const { focusProps, isFocused, isFocusVisible } = (0, import_focus2.useFocusRing)();
  const selectedItem = state.selectedItem;
  const content = state.collection.getItem(tabKey).props.children;
  const tabPanelStyles = (0, import_shared_utils3.clsx)(classNames == null ? void 0 : classNames.panel, className, (_a = selectedItem == null ? void 0 : selectedItem.props) == null ? void 0 : _a.className);
  const isSelected = tabKey === (selectedItem == null ? void 0 : selectedItem.key);
  if (!content || !isSelected && destroyInactiveTabPanel) {
    return null;
  }
  return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(
    Component,
    {
      ref: domRef,
      "data-focus": isFocused,
      "data-focus-visible": isFocusVisible,
      "data-inert": !isSelected ? "true" : void 0,
      inert: (0, import_shared_utils3.getInertValue)(!isSelected),
      ...isSelected && (0, import_utils3.mergeProps)(tabPanelProps, focusProps, otherProps),
      className: (_b = slots.panel) == null ? void 0 : _b.call(slots, { class: tabPanelStyles }),
      "data-slot": "panel",
      children: content
    }
  );
});
TabPanel.displayName = "NextUI.TabPanel";
var tab_panel_default = TabPanel;

// src/tabs.tsx
var import_jsx_runtime3 = require("react/jsx-runtime");
var Tabs = (0, import_system4.forwardRef)(function Tabs2(props, ref) {
  const {
    Component,
    values,
    state,
    destroyInactiveTabPanel,
    getBaseProps,
    getTabListProps,
    getWrapperProps
  } = useTabs({
    ...props,
    ref
  });
  const layoutId = (0, import_react2.useId)();
  const layoutGroupEnabled = !props.disableAnimation && !props.disableCursorAnimation;
  const tabsProps = {
    state,
    listRef: values.listRef,
    slots: values.slots,
    classNames: values.classNames,
    isDisabled: values.isDisabled,
    motionProps: values.motionProps,
    disableAnimation: values.disableAnimation,
    shouldSelectOnPressUp: values.shouldSelectOnPressUp,
    disableCursorAnimation: values.disableCursorAnimation
  };
  const tabs2 = [...state.collection].map((item) => /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(tab_default, { item, ...tabsProps, ...item.props }, item.key));
  const renderTabs = /* @__PURE__ */ (0, import_jsx_runtime3.jsxs)(import_jsx_runtime3.Fragment, { children: [
    /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { ...getBaseProps(), children: /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(Component, { ...getTabListProps(), children: layoutGroupEnabled ? /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(import_framer_motion2.LayoutGroup, { id: layoutId, children: tabs2 }) : tabs2 }) }),
    [...state.collection].map((item) => {
      return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
        tab_panel_default,
        {
          classNames: values.classNames,
          destroyInactiveTabPanel,
          slots: values.slots,
          state: values.state,
          tabKey: item.key
        },
        item.key
      );
    })
  ] });
  if ("placement" in props || "isVertical" in props) {
    return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)("div", { ...getWrapperProps(), children: renderTabs });
  }
  return renderTabs;
});
var tabs_default = Tabs;

// src/base/tab-item-base.ts
var import_aria_utils = require("@nextui-org/aria-utils");
var TabItemBase = import_aria_utils.BaseItem;
var tab_item_base_default = TabItemBase;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Tab,
  Tabs,
  useTabs
});
