"use client";
"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/tooltip.tsx
var tooltip_exports = {};
__export(tooltip_exports, {
  default: () => tooltip_default
});
module.exports = __toCommonJS(tooltip_exports);
var import_system2 = require("@nextui-org/system");
var import_overlays2 = require("@react-aria/overlays");
var import_framer_motion = require("framer-motion");
var import_framer_utils = require("@nextui-org/framer-utils");
var import_shared_utils2 = require("@nextui-org/shared-utils");
var import_react3 = require("react");
var import_aria_utils2 = require("@nextui-org/aria-utils");
var import_utils2 = require("@react-aria/utils");

// src/use-tooltip.ts
var import_react = require("react");
var import_tooltip = require("@react-stately/tooltip");
var import_utils = require("@react-aria/utils");
var import_tooltip2 = require("@react-aria/tooltip");
var import_overlays = require("@react-aria/overlays");
var import_system = require("@nextui-org/system");
var import_theme = require("@nextui-org/theme");
var import_shared_utils = require("@nextui-org/shared-utils");
var import_react_utils = require("@nextui-org/react-utils");
var import_react_utils2 = require("@nextui-org/react-utils");
var import_react2 = require("react");
var import_aria_utils = require("@nextui-org/aria-utils");
var import_use_safe_layout_effect = require("@nextui-org/use-safe-layout-effect");
function useTooltip(originalProps) {
  var _a, _b;
  const globalContext = (0, import_system.useProviderContext)();
  const [props, variantProps] = (0, import_system.mapPropsVariants)(originalProps, import_theme.popover.variantKeys);
  const {
    ref,
    as,
    isOpen: isOpenProp,
    content,
    children,
    defaultOpen,
    onOpenChange,
    isDisabled,
    trigger: triggerAction,
    shouldFlip = true,
    containerPadding = 12,
    placement: placementProp = "top",
    delay = 0,
    closeDelay = 500,
    showArrow = false,
    offset = 7,
    crossOffset = 0,
    isDismissable,
    shouldCloseOnBlur = true,
    portalContainer,
    isKeyboardDismissDisabled = false,
    updatePositionDeps = [],
    shouldCloseOnInteractOutside,
    className,
    onClose,
    motionProps,
    classNames,
    ...otherProps
  } = props;
  const Component = as || "div";
  const disableAnimation = (_b = (_a = originalProps == null ? void 0 : originalProps.disableAnimation) != null ? _a : globalContext == null ? void 0 : globalContext.disableAnimation) != null ? _b : false;
  const state = (0, import_tooltip.useTooltipTriggerState)({
    delay,
    closeDelay,
    isDisabled,
    defaultOpen,
    isOpen: isOpenProp,
    onOpenChange: (isOpen2) => {
      onOpenChange == null ? void 0 : onOpenChange(isOpen2);
      if (!isOpen2) {
        onClose == null ? void 0 : onClose();
      }
    }
  });
  const triggerRef = (0, import_react2.useRef)(null);
  const overlayRef = (0, import_react2.useRef)(null);
  const tooltipId = (0, import_react.useId)();
  const isOpen = state.isOpen && !isDisabled;
  (0, import_react.useImperativeHandle)(
    ref,
    () => (0, import_react_utils2.createDOMRef)(overlayRef)
  );
  const { triggerProps, tooltipProps: triggerTooltipProps } = (0, import_tooltip2.useTooltipTrigger)(
    {
      isDisabled,
      trigger: triggerAction
    },
    state,
    triggerRef
  );
  const { tooltipProps } = (0, import_tooltip2.useTooltip)(
    {
      isOpen,
      ...(0, import_utils.mergeProps)(props, triggerTooltipProps)
    },
    state
  );
  const {
    overlayProps: positionProps,
    placement,
    updatePosition
  } = (0, import_overlays.useOverlayPosition)({
    isOpen,
    targetRef: triggerRef,
    placement: (0, import_aria_utils.toReactAriaPlacement)(placementProp),
    overlayRef,
    offset: showArrow ? offset + 3 : offset,
    crossOffset,
    shouldFlip,
    containerPadding
  });
  (0, import_use_safe_layout_effect.useSafeLayoutEffect)(() => {
    if (!updatePositionDeps.length)
      return;
    updatePosition();
  }, updatePositionDeps);
  const { overlayProps } = (0, import_overlays.useOverlay)(
    {
      isOpen,
      onClose: state.close,
      isDismissable,
      shouldCloseOnBlur,
      isKeyboardDismissDisabled,
      shouldCloseOnInteractOutside
    },
    overlayRef
  );
  const slots = (0, import_react2.useMemo)(
    () => {
      var _a2, _b2, _c;
      return (0, import_theme.popover)({
        ...variantProps,
        disableAnimation,
        radius: (_a2 = originalProps == null ? void 0 : originalProps.radius) != null ? _a2 : "md",
        size: (_b2 = originalProps == null ? void 0 : originalProps.size) != null ? _b2 : "md",
        shadow: (_c = originalProps == null ? void 0 : originalProps.shadow) != null ? _c : "sm"
      });
    },
    [
      (0, import_shared_utils.objectToDeps)(variantProps),
      disableAnimation,
      originalProps == null ? void 0 : originalProps.radius,
      originalProps == null ? void 0 : originalProps.size,
      originalProps == null ? void 0 : originalProps.shadow
    ]
  );
  const getTriggerProps = (0, import_react2.useCallback)(
    (props2 = {}, _ref = null) => ({
      ...(0, import_utils.mergeProps)(triggerProps, props2),
      ref: (0, import_react_utils.mergeRefs)(_ref, triggerRef),
      "aria-describedby": isOpen ? tooltipId : void 0
    }),
    [triggerProps, isOpen, tooltipId, state]
  );
  const getTooltipProps = (0, import_react2.useCallback)(
    () => ({
      ref: overlayRef,
      "data-slot": "base",
      "data-open": (0, import_shared_utils.dataAttr)(isOpen),
      "data-arrow": (0, import_shared_utils.dataAttr)(showArrow),
      "data-disabled": (0, import_shared_utils.dataAttr)(isDisabled),
      "data-placement": (0, import_aria_utils.getArrowPlacement)(placement || "top", placementProp),
      ...(0, import_utils.mergeProps)(tooltipProps, overlayProps, otherProps),
      style: (0, import_utils.mergeProps)(positionProps.style, otherProps.style, props.style),
      className: slots.base({ class: classNames == null ? void 0 : classNames.base }),
      id: tooltipId
    }),
    [
      slots,
      isOpen,
      showArrow,
      isDisabled,
      placement,
      placementProp,
      tooltipProps,
      overlayProps,
      otherProps,
      positionProps,
      props,
      tooltipId
    ]
  );
  const getTooltipContentProps = (0, import_react2.useCallback)(
    () => ({
      "data-slot": "content",
      "data-open": (0, import_shared_utils.dataAttr)(isOpen),
      "data-arrow": (0, import_shared_utils.dataAttr)(showArrow),
      "data-disabled": (0, import_shared_utils.dataAttr)(isDisabled),
      "data-placement": (0, import_aria_utils.getArrowPlacement)(placement || "top", placementProp),
      className: slots.content({ class: (0, import_shared_utils.clsx)(classNames == null ? void 0 : classNames.content, className) })
    }),
    [slots, isOpen, showArrow, isDisabled, placement, placementProp, classNames]
  );
  return {
    Component,
    content,
    children,
    isOpen,
    triggerRef,
    showArrow,
    portalContainer,
    placement: placementProp,
    disableAnimation,
    isDisabled,
    motionProps,
    getTooltipContentProps,
    getTriggerProps,
    getTooltipProps
  };
}

// src/tooltip.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var domAnimation = () => import("@nextui-org/dom-animation").then((res) => res.default);
var Tooltip = (0, import_system2.forwardRef)((props, ref) => {
  const {
    Component,
    children,
    content,
    isOpen,
    portalContainer,
    placement,
    disableAnimation,
    motionProps,
    getTriggerProps,
    getTooltipProps,
    getTooltipContentProps
  } = useTooltip({
    ...props,
    ref
  });
  let trigger;
  try {
    const childrenNum = import_react3.Children.count(children);
    if (childrenNum !== 1)
      throw new Error();
    if (!(0, import_react3.isValidElement)(children)) {
      trigger = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("p", { ...getTriggerProps(), children });
    } else {
      const child = children;
      trigger = (0, import_react3.cloneElement)(child, getTriggerProps(child.props, child.ref));
    }
  } catch (error) {
    trigger = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", {});
    (0, import_shared_utils2.warn)("Tooltip must have only one child node. Please, check your code.");
  }
  const { ref: tooltipRef, id, style, ...otherTooltipProps } = getTooltipProps();
  const animatedContent = /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ref: tooltipRef, id, style, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.LazyMotion, { features: domAnimation, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
    import_framer_motion.m.div,
    {
      animate: "enter",
      exit: "exit",
      initial: "exit",
      variants: import_framer_utils.TRANSITION_VARIANTS.scaleSpring,
      ...(0, import_utils2.mergeProps)(motionProps, otherTooltipProps),
      style: {
        ...(0, import_aria_utils2.getTransformOrigins)(placement)
      },
      children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Component, { ...getTooltipContentProps(), children: content })
    }
  ) }) });
  return /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(import_jsx_runtime.Fragment, { children: [
    trigger,
    disableAnimation && isOpen ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays2.OverlayContainer, { portalContainer, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { ref: tooltipRef, id, style, ...otherTooltipProps, children: /* @__PURE__ */ (0, import_jsx_runtime.jsx)(Component, { ...getTooltipContentProps(), children: content }) }) }) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_framer_motion.AnimatePresence, { children: isOpen ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_overlays2.OverlayContainer, { portalContainer, children: animatedContent }) : null })
  ] });
});
Tooltip.displayName = "NextUI.Tooltip";
var tooltip_default = Tooltip;
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {});
