import { AriaLinkProps } from '@react-types/link';
import { DOMAttributes, FocusableElement } from '@react-types/shared';
import { RefObject } from 'react';

interface AriaLinkOptions extends AriaLinkProps {
    /** Indicates the element that represents the current item within a container or set of related elements. */
    "aria-current"?: DOMAttributes["aria-current"];
    /** Whether the link is disabled. */
    isDisabled?: boolean;
    /** The role of the element */
    role?: string;
    /**
     * The HTML element used to render the link, e.g. 'a', or 'span'.
     * @default 'a'
     */
    elementType?: string;
}
interface LinkAria {
    /** Props for the link element. */
    linkProps: DOMAttributes;
    /** Whether the link is currently pressed. */
    isPressed: boolean;
}
/**
 * Provides the behavior and accessibility implementation for a link component.
 * A link allows a user to navigate to another page or resource within a web page
 * or application.
 */
declare function useAriaLink(props: AriaLinkOptions, ref: RefObject<FocusableElement>): LinkAria;

export { AriaLinkOptions, LinkAria, useAriaLink };
