import { AriaModalOverlayProps, ModalOverlayAria } from '@react-aria/overlays';
import { OverlayTriggerState } from '@react-stately/overlays';
import { RefObject } from 'react';

interface UseAriaModalOverlayProps extends AriaModalOverlayProps {
}
/**
 * Provides the behavior and accessibility implementation for a modal component.
 * A modal is an overlay element which blocks interaction with elements outside it.
 *
 * This is a modified version from https://vscode.dev/github/adobe/react-spectrum/blob/main/packages/%40react-aria/overlays/src/useModalOverlay.ts#L46
 *
 * This implementation disables the prevent scroll when `shouldBlockScroll` prop is false.
 */
declare function useAriaModalOverlay(props: (UseAriaModalOverlayProps & {
    shouldBlockScroll?: boolean | undefined;
}) | undefined, state: OverlayTriggerState, ref: RefObject<HTMLElement>): ModalOverlayAria;
type UseAriaModalOverlayReturn = ReturnType<typeof useAriaModalOverlay>;

export { UseAriaModalOverlayProps, UseAriaModalOverlayReturn, useAriaModalOverlay };
