import { MoveResult } from '@react-aria/interactions';

interface UseDraggableProps {
    /**
     * Ref to the moving target DOM node.
     */
    targetRef?: React.RefObject<HTMLElement>;
    /**
     * Whether to disable the target is draggable.
     * @default false
     */
    isDisabled?: boolean;
    /**
     * Whether the target can overflow the viewport.
     * @default false
     */
    canOverflow?: boolean;
}
/**
 * A hook to make a target draggable.
 * @param props UseDraggableProps
 * @returns MoveResult for the drag DOM node.
 */
declare function useDraggable(props: UseDraggableProps): MoveResult;

export { UseDraggableProps, useDraggable };
