var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var project_exports = {};
__export(project_exports, {
  $project: () => $project
});
module.exports = __toCommonJS(project_exports);
var import_core = require("../../core");
var import_util = require("../../util");
const $project = (collection, expr, options) => {
  if ((0, import_util.isEmpty)(expr)) return collection;
  validateExpression(expr, options);
  return collection.map(createHandler(expr, import_core.ComputeOptions.init(options)));
};
function createHandler(expr, options, isRoot = true) {
  const idKey = options.idKey;
  const expressionKeys = Object.keys(expr);
  const excludedKeys = new Array();
  const includedKeys = new Array();
  const handlers = {};
  for (const key of expressionKeys) {
    const subExpr = expr[key];
    if ((0, import_util.isNumber)(subExpr) || (0, import_util.isBoolean)(subExpr)) {
      if (subExpr) {
        includedKeys.push(key);
      } else {
        excludedKeys.push(key);
      }
    } else if ((0, import_util.isArray)(subExpr)) {
      handlers[key] = (o) => subExpr.map((v) => (0, import_core.computeValue)(o, v, null, options.update(o)) ?? null);
    } else if ((0, import_util.isObject)(subExpr)) {
      const subExprKeys = Object.keys(subExpr);
      const operator = subExprKeys.length == 1 ? subExprKeys[0] : "";
      const projectFn = (0, import_core.getOperator)(
        "projection",
        operator,
        options
      );
      if (projectFn) {
        const foundSlice = operator === "$slice";
        if (foundSlice && !(0, import_util.ensureArray)(subExpr[operator]).every(import_util.isNumber)) {
          handlers[key] = (o) => (0, import_core.computeValue)(o, subExpr, key, options.update(o));
        } else {
          handlers[key] = (o) => projectFn(o, subExpr[operator], key, options.update(o));
        }
      } else if ((0, import_util.isOperator)(operator)) {
        handlers[key] = (o) => (0, import_core.computeValue)(o, subExpr[operator], operator, options);
      } else {
        validateExpression(subExpr, options);
        handlers[key] = (o) => {
          if (!(0, import_util.has)(o, key)) return (0, import_core.computeValue)(o, subExpr, null, options);
          if (isRoot) options.update(o);
          const target = (0, import_util.resolve)(o, key);
          const fn = createHandler(subExpr, options, false);
          if ((0, import_util.isArray)(target)) return target.map(fn);
          if ((0, import_util.isObject)(target)) return fn(target);
          return fn(o);
        };
      }
    } else {
      handlers[key] = (0, import_util.isString)(subExpr) && subExpr[0] === "$" ? (o) => (0, import_core.computeValue)(o, subExpr, key, options) : (_) => subExpr;
    }
  }
  const handlerKeys = Object.keys(handlers);
  const idKeyExcluded = excludedKeys.includes(idKey);
  const idKeyOnlyExcluded = isRoot && idKeyExcluded && excludedKeys.length === 1 && !includedKeys.length && !handlerKeys.length;
  if (idKeyOnlyExcluded) {
    return (o) => {
      const newObj = { ...o };
      delete newObj[idKey];
      return newObj;
    };
  }
  const idKeyImplicit = isRoot && !idKeyExcluded && !includedKeys.includes(idKey);
  const opts = {
    preserveMissing: true
  };
  return (o) => {
    const newObj = {};
    if (excludedKeys.length && !includedKeys.length) {
      (0, import_util.merge)(newObj, o);
      for (const k of excludedKeys) {
        (0, import_util.removeValue)(newObj, k, { descendArray: true });
      }
    }
    for (const k of includedKeys) {
      const pathObj = (0, import_util.resolveGraph)(o, k, opts) ?? {};
      (0, import_util.merge)(newObj, pathObj);
    }
    if (includedKeys.length) (0, import_util.filterMissing)(newObj);
    for (const k of handlerKeys) {
      const value = handlers[k](o);
      if (value === void 0) {
        (0, import_util.removeValue)(newObj, k, { descendArray: true });
      } else {
        (0, import_util.setValue)(newObj, k, value);
      }
    }
    if (idKeyImplicit && (0, import_util.has)(o, idKey)) {
      newObj[idKey] = (0, import_util.resolve)(o, idKey);
    }
    return newObj;
  };
}
function validateExpression(expr, options) {
  let exclusions = false;
  let inclusions = false;
  for (const [k, v] of Object.entries(expr)) {
    (0, import_util.assert)(!k.startsWith("$"), "Field names may not start with '$'.");
    (0, import_util.assert)(
      !k.endsWith(".$"),
      "Positional projection operator '$' is not supported."
    );
    if (k === options?.idKey) continue;
    if (v === 0 || v === false) {
      exclusions = true;
    } else if (v === 1 || v === true) {
      inclusions = true;
    }
    (0, import_util.assert)(
      !(exclusions && inclusions),
      "Projection cannot have a mix of inclusion and exclusion."
    );
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  $project
});
