import "./init/basic";
import { Aggregator } from "./aggregator";
import { Query } from "./query";
import { createUpdater, update } from "./updater";
import { Aggregator as Aggregator2 } from "./aggregator";
import { Query as Query2 } from "./query";
import { createUpdater as createUpdater2, update as update2 } from "./updater";
function find(collection, criteria, projection, options) {
  return new Query(criteria, options).find(collection, projection);
}
function remove(collection, criteria, options) {
  return new Query(criteria, options).remove(collection);
}
function aggregate(collection, pipeline, options) {
  return new Aggregator(pipeline, options).run(collection);
}
var index_default = {
  Aggregator,
  Query,
  aggregate,
  createUpdater,
  find,
  remove,
  update
};
export {
  Aggregator2 as Aggregator,
  Query2 as Query,
  aggregate,
  createUpdater2 as createUpdater,
  index_default as default,
  find,
  remove,
  update2 as update
};
