import {
  ComputeOptions,
  computeValue
} from "../../core";
import { Lazy } from "../../lazy";
import { $sort } from "../pipeline/sort";
import { $push } from "./push";
const $bottomN = (collection, expr, options) => {
  const copts = ComputeOptions.init(options);
  const { n, sortBy } = computeValue(
    copts.local.groupId,
    expr,
    null,
    copts
  );
  const result = $sort(Lazy(collection), sortBy, options).value();
  const m = result.length;
  const p = n;
  return $push(m <= p ? result : result.slice(m - p), expr.output, copts);
};
export {
  $bottomN
};
