import { computeValue } from "../../../core";
import { assert, isDate, isNumber } from "../../../util";
const $subtract = (obj, expr, options) => {
  const [a, b] = computeValue(obj, expr, null, options);
  if (isNumber(a) && isNumber(b) || isDate(a) && isDate(b)) return +a - +b;
  if (isDate(a) && isNumber(b)) return new Date(+a - b);
  assert(false, "$subtract: must resolve to number/date.");
};
export {
  $subtract
};
