import { computeValue } from "../../../core";
import { assert, flatten, isArray, isNil } from "../../../util";
import { $first as __first } from "../../accumulator/first";
const $first = (obj, expr, options) => {
  if (isArray(obj)) return __first(obj, expr, options);
  const arr = computeValue(obj, expr, null, options);
  if (isNil(arr)) return null;
  assert(
    isArray(arr) && arr.length > 0,
    "$first must resolve to a non-empty array."
  );
  return flatten(arr)[0];
};
export {
  $first
};
