import { computeValue } from "../../../core";
import { isNil } from "../../../util";
const $mergeObjects = (obj, expr, options) => {
  const docs = computeValue(obj, expr, null, options) ?? [];
  const acc = {};
  for (const o of docs) {
    if (isNil(o)) continue;
    for (const k of Object.keys(o)) {
      if (o[k] !== void 0) acc[k] = o[k];
    }
  }
  return acc;
};
export {
  $mergeObjects
};
