import { computeValue } from "../../../core";
import { assert, isArray, isNil, ValueMap } from "../../../util";
const $setDifference = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  if (isNil(args)) return null;
  assert(isArray(args), "$setDifference must be an arrays.");
  if (args.some(isNil)) return null;
  assert(args.length == 2, `$setDifference takes exactly 2 arguments.`);
  assert(args.every(isArray), "$setDifference operands must be arrays.");
  const m = ValueMap.init(options.hashFunction);
  args[0].forEach((v) => m.set(v, true));
  args[1].forEach((v) => m.delete(v));
  return Array.from(m.keys());
};
export {
  $setDifference
};
