import { computeValue } from "../../../core";
import { assert, intersection, isArray, isNil } from "../../../util";
const $setIntersection = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  if (isNil(args)) return null;
  assert(
    isArray(args) && args.every(isArray),
    "$setIntersection operands must be arrays."
  );
  return intersection(args, options?.hashFunction);
};
export {
  $setIntersection
};
