import { computeValue } from "../../../core";
import { assert, isArray, ValueMap } from "../../../util";
const $setIsSubset = (obj, expr, options) => {
  const args = computeValue(obj, expr, null, options);
  assert(
    isArray(args) && args.every(isArray),
    "$setIsSubset operands must be arrays."
  );
  const first = args[0];
  const second = args[1];
  const map = ValueMap.init();
  const set = /* @__PURE__ */ new Set();
  first.every((v, i) => map.set(v, i));
  for (const v of second) {
    set.add(map.get(v) ?? -1);
    if (set.size > map.size) return true;
  }
  set.delete(-1);
  return set.size == map.size;
};
export {
  $setIsSubset
};
