import { computeValue } from "../../../core";
import { isDate, isNil } from "../../../util";
import { $dateToString } from "../date/dateToString";
const $toString = (obj, expr, options) => {
  const val = computeValue(obj, expr, null, options);
  if (isNil(val)) return null;
  if (isDate(val)) {
    return $dateToString(
      obj,
      {
        date: expr,
        format: "%Y-%m-%dT%H:%M:%S.%LZ"
      },
      options
    );
  }
  return val.toString();
};
export {
  $toString
};
