import { PipelineOperator } from "../../core";
/**
 * Takes the documents returned by the aggregation pipeline and writes them to a specified collection.
 *
 * Unlike in MongoDB, this operator can appear in any position in the pipeline and is
 * useful for collecting intermediate results of an aggregation operation.
 *
 * Note: Object are deep cloned for output regardless of the {@link ProcessingMode}.
 *
 * See {@link https://www.mongodb.com/docs/manual/reference/operator/aggregation/out/ usage}.
 *
 * @param collection
 * @param expr
 * @param options
 * @returns
 */
export declare const $out: PipelineOperator;
