"use strict";
Dropzone.autoDiscover = false;
$.ajaxSetup({
    headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
});
var is_logged = "";
var appUrl = document.getElementById("app_url").dataset.appUrl;
if (appUrl.charAt(appUrl.length - 1) !== "/") {
    appUrl += "/";
}
$(".loading-state").addClass("d-none");
document.addEventListener("livewire:initialized", () => {
    Livewire.on("validationErrorshow", (message) => {
        let messages = message[0].data;
        $.each(messages, function (key, value) {
            iziToast.error({
                message: value[0],
                position: "topRight",
            });
            return false;
        });
    });
});
// Livewire.on("validationErrorshow", (message) => {
//     let messages = message[0].data;
//     let firstError = Object.values(messages)[0][0]; // Get the first error message

//     iziToast.error({
//         message: firstError,
//         position: "topRight",
//     });
// });
document.addEventListener("livewire:initialized", () => {
    Livewire.on("validationSuccessShow", (message) => {
        let messages = message[0].data;
        $.each(messages, function (key, value) {
            iziToast.success({
                message: value[0],
                position: "topRight",
            });
            return false;
        });
    });
});
document.addEventListener("livewire:initialized", () => {
    Livewire.on("showError", (message) => {
        iziToast.error({
            title: "Error",
            message: message,
            position: "topRight",
        });
        $(".kv-ltr-theme-svg-star").rating();
    });
});
document.addEventListener("livewire:initialized", () => {
    Livewire.on("showSuccess", (message) => {
        iziToast.success({
            title: "Success",
            message: message,
            position: "topRight",
        });
        $(".kv-ltr-theme-svg-star").rating();
    });
});

// Livewire.on("showSuccess", (message) => {
//     iziToast.destroy();
//     iziToast.success({
//         title: "Success",
//         message: message,
//         position: "topRight",
//     });
//     $(".kv-ltr-theme-svg-star").rating();
// });

// ================================
// PER-VARIANT DEBOUNCE MAP
// ================================
const cartDebounceMap = {};

// delay = 5â€“8 ms (you can change)
function debounceCartUpdate(variant_id, callback, delay = 8) {
    if (cartDebounceMap[variant_id]) {
        clearTimeout(cartDebounceMap[variant_id]);
    }

    cartDebounceMap[variant_id] = setTimeout(() => {
        callback();
        delete cartDebounceMap[variant_id];
    }, delay);
}
function product_zoom() {
    $(".zoompro").elevateZoom({
        gallery: "gallery",
        cursor: "pointer",
        galleryActiveClass: "active",
        imageCrossfade: true,
        borderSize: 2,
        loadingIcon: "https://www.elevateweb.co.uk/spinner.gif",
    });
    $(".zoompro_style_2").elevateZoom({
        gallery: "gallery",
        cursor: "pointer",
        zoomType: "inner",
        galleryActiveClass: "active",
        imageCrossfade: true,
        borderSize: 2,
        loadingIcon: "https://www.elevateweb.co.uk/spinner.gif",
    });
}

function FirebaseAuth() {
    $.ajax({
        type: "get",
        url: appUrl + "settings/get-firebase-credentials",
        dataType: "json",
        success: function (response) {
            const firebaseConfig = {
                apiKey: response.apiKey,
                authDomain: response.authDomain,
                projectId: response.projectId,
                databaseURL: response.databaseURL,
                storageBucket: response.storageBucket,
                messagingSenderId: response.messagingSenderId,
                appId: response.appId,
                measurementId: response.measurementId,
            };
            if (firebase.apps.length == 0) {
                firebase.initializeApp(firebaseConfig);
            }
            let coderesult = "";
            $(document).off("click", "#recovery_send_otp, #send_otp").on("click", "#recovery_send_otp, #send_otp", function () {
                let container = $(this).closest(".send-otp-box"); if (container.length == 0) container = $(this).closest(".login-register"); let code = container.find("#recovery_number, #number").intlTelInput("getSelectedCountryData").dialCode;
                let number = container.find("#recovery_number, #number").val();
                let type = container.find("#recovery_type, #type").val();
                if (number == "") {
                    iziToast.error({
                        message: "Please Enter Mobile Number",
                        position: "topRight",
                    });
                    return;
                }
                $("#recovery_send_otp, #send_otp").attr("disabled", true).html("Please Wait...");
                const call_api = () => {
                    return new Promise((resolve, reject) => {
                        if (type == "password-recovery") {
                            $.ajax({
                                type: "POST",
                                url: appUrl + "password-recovery/check-number",
                                data: {
                                    mobile: number,
                                },
                                success: function (response) {
                                    if (response.error == true) {
                                        $("#recovery_send_otp, #send_otp")
                                            .attr("disabled", false)
                                            .html("Send OTP");
                                        iziToast.error({
                                            message: response.message,
                                            position: "topRight",
                                        });
                                        reject(0);
                                        return;
                                    }
                                    resolve();
                                },
                            });
                        } else {
                            $.ajax({
                                type: "POST",
                                url: appUrl + "register/check-number",
                                data: {
                                    mobile: number,
                                    captcha: $("#register_captcha_input").val()
                                },
                                success: function (response) {
                                    if (
                                        response.allow_modification_error !=
                                        undefined &&
                                        response.allow_modification_error ==
                                        true
                                    ) {
                                        $("#recovery_send_otp, #send_otp")
                                            .attr("disabled", false)
                                            .html("Send OTP");

                                        iziToast.error({
                                            message: response.message,
                                            position: "topRight",
                                        });
                                        return;
                                    }
                                    if (response.error == true) {
                                        console.log(response, 'response')
                                        $("#recovery_send_otp, #send_otp")
                                            .attr("disabled", false)
                                            .html("Send OTP");
                                        $.each(
                                            response.message,
                                            function (key, value) {
                                                iziToast.error({
                                                    message: value[0],
                                                    position: "topRight",
                                                });
                                            }
                                        );
                                        reject(0);
                                        return;
                                    }
                                    resolve();
                                },
                            });
                        }
                    });
                };
                call_api()
                    .then(() => {
                        let phoneNumber = "+" + code + number;
                        firebase
                            .auth()
                            .signInWithPhoneNumber(
                                phoneNumber,
                                window.recaptchaVerifier
                            )
                            .then(function (confirmationResult) {
                                window.confirmationResult = confirmationResult;
                                coderesult = confirmationResult;
                                $(".send-otp-box").addClass("d-none");
                                $(".verify-otp-box").removeClass("d-none");
                                iziToast.success({
                                    message: "OTP Sent Successfully",
                                    position: "topRight",
                                });
                            })
                            .catch(function (error) {
                                $("#recovery_send_otp, #send_otp")
                                    .attr("disabled", false)
                                    .html("Send OTP");
                                iziToast.error({
                                    message: error.message,
                                    position: "topRight",
                                });
                                return;
                            });
                    })
                    .catch((err) => { });
            });
            $(document).off("click", "#recovery_verify_otp, #verify_otp").on("click", "#recovery_verify_otp, #verify_otp", function () {
                let container = $(this).closest(".login-register"); let code = container.find("#verificationCode").val();
                if (code == "") {
                    iziToast.error({
                        message: "Please Enter Verification Code",
                        position: "topRight",
                    });
                    return;
                }
                $("#recovery_verify_otp, #verify_otp").attr("disabled", true).html("Please Wait...");
                coderesult
                    .confirm(code)
                    .then(function (result) {
                        let type = container.find("#recovery_type, #type").val();
                        $(".verify-otp-box").addClass("d-none");
                        if (type == "password-recovery") {
                            $(".reset-password-form").removeClass("d-none");
                        } else {
                            $(".register-form").removeClass("d-none");
                        }
                        iziToast.success({
                            message: "Mobile Number Verified",
                            position: "topRight",
                        });

                        if (type == "password-recovery") {
                            $(".reset-password-form").on(
                                "submit",
                                function (e) {
                                    e.preventDefault();
                                    let number = container.find("#recovery_number, #number").val();
                                    let password = $("#new_password").val();
                                    let password_confirmation = $(
                                        "#verify_password"
                                    ).val();
                                    if (password == "") {
                                        iziToast.error({
                                            message: "Please Enter Password",
                                            position: "topRight",
                                        });
                                        return;
                                    }
                                    if (password != password_confirmation) {
                                        iziToast.error({
                                            message:
                                                "Password and Conform Password Doesn't match kjhgj",
                                            position: "topRight",
                                        });
                                        return;
                                    }
                                    $("#changePassword")
                                        .attr("disabled", true)
                                        .val("Please Wait...");
                                    $.ajax({
                                        type: "POST",
                                        url:
                                            appUrl +
                                            "password-recovery/set-new-password",
                                        data: {
                                            mobile: number,
                                            new_password: password,
                                            verify_password:
                                                password_confirmation,
                                        },
                                        success: function (response) {
                                            if (response.error == true) {
                                                $("#changePassword")
                                                    .attr("disabled", false)
                                                    .val("Change Password");
                                                $.each(
                                                    response.message,
                                                    function (key, value) {
                                                        iziToast.error({
                                                            message: value[0],
                                                            position:
                                                                "topRight",
                                                        });
                                                        return false;
                                                    }
                                                );
                                                return false;
                                            }
                                            iziToast.success({
                                                message: response.message,
                                                position: "topRight",
                                            });
                                            Livewire.navigate("/login");
                                            return;
                                        },
                                    });
                                }
                            );
                        } else {
                            $(".register-form").on("submit", function (e) {
                                e.preventDefault();
                                let username = $("#username").val();
                                let country_code = $(".selected-dial-code").text();
                                let number = container.find("#recovery_number, #number").val();
                                let email = $("#email").val();
                                let password = $("#password").val();
                                let password_confirmation = $(
                                    "#password_confirmation"
                                ).val();

                                if (username == "") {
                                    iziToast.error({
                                        message: "Please Enter Username",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (email == "") {
                                    iziToast.error({
                                        message: "Please Enter Email",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (password == "") {
                                    iziToast.error({
                                        message: "Please Enter Password",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (password != password_confirmation) {
                                    iziToast.error({
                                        message:
                                            "Password and Conform Password Doesn't match",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                $("#register-form-submit")
                                    .attr("disabled", true)
                                    .val("Please Wait...");

                                $.ajax({
                                    type: "POST",
                                    url: appUrl + "register/submit",
                                    data: {
                                        username,
                                        mobile: number,
                                        email,
                                        country_code,
                                        password,
                                        password_confirmation,
                                    },
                                    success: function (response) {
                                        if (response.error == true) {
                                            $("#register-form-submit")
                                                .attr("disabled", false)
                                                .val("Register");
                                            $.each(
                                                response.message,
                                                function (key, value) {
                                                    iziToast.error({
                                                        message: value[0],
                                                        position: "topRight",
                                                    });
                                                    return false;
                                                }
                                            );
                                            return false;
                                        }
                                        iziToast.success({
                                            message: response.message,
                                            position: "topRight",
                                        });
                                        Livewire.navigate("/");
                                        return;
                                    },
                                });
                            });
                        }
                    })
                    .catch(function (error) {
                        $("#recovery_verify_otp, #verify_otp")
                            .attr("disabled", false)
                            .html("Verify Code");
                        iziToast.success({
                            message: error.message,
                            position: "topRight",
                        });
                    });
            });
            window.recaptchaVerifier = new firebase.auth.RecaptchaVerifier(
                "recaptcha-container"
            );
            recaptchaVerifier.render();
        },
    });
}
let resendTimer = null;
let timeLeft;

function startOtpTimer() {
    clearInterval(resendTimer);
    timeLeft = 30;

    $('#resend-otp-btn').prop('disabled', true);
    $('#otp-timer').removeClass('d-none');

    resendTimer = setInterval(function () {
        let minutes = Math.floor(timeLeft / 60);
        let seconds = timeLeft % 60;

        $('#timer-count').text(
            String(minutes).padStart(2, '0') + ':' + String(seconds).padStart(2, '0')
        );

        if (timeLeft <= 0) {
            clearInterval(resendTimer);
            $('#otp-timer').addClass('d-none');
            $('#resend-otp-btn').prop('disabled', false);
        }

        timeLeft--;
    }, 1000);
}


$(document).on('click', '#resend-otp-btn', function () {
    let mobile = $('#number').val();

    $.ajax({
        url: appUrl + 'resend_otp',
        type: 'POST',
        data: {
            mobile: mobile,
            _token: $('meta[name="csrf-token"]').attr('content')
        },
        success: function (res) {
            if (!res.error) {
                startOtpTimer(); // ðŸ” RESTART TIMER
                iziToast.success({
                    message: res.message,
                    position: 'topRight'
                });
            }
        }
    });
});
$(document).on("click", ".eye-icon", function () {
    let input = $(this).prev("input");

    if (input.attr("type") === "password") {
        input.attr("type", "text");
        $(this).attr("name", "eye-outline");
    } else {
        input.attr("type", "password");
        $(this).attr("name", "eye-off-outline");
    }
});


function CustomSmsAuth() {
    $(document).off("click", "#recovery_send_otp, #send_otp").on("click", "#recovery_send_otp, #send_otp", function () {
        let container = $(this).closest(".send-otp-box"); if (container.length == 0) container = $(this).closest(".login-register"); let countryData = container.find("#recovery_number, #number").intlTelInput("getSelectedCountryData");
        let code = countryData ? countryData.dialCode : "91";
        // let code = $("#recovery_number, #number").intlTelInput("getSelectedCountryData").dialCode || "+ 91";
        let number = container.find("#recovery_number, #number").val();
        let type = container.find("#recovery_type, #type").val();
        let captcha = container.find("#register_captcha_input").val();
        if (number == "") {
            iziToast.error({
                message: "Please Enter Mobile Number",
                position: "topRight",
            });
            return;
        }
        $("#recovery_send_otp, #send_otp").attr("disabled", true).html("Please Wait...");
        const call_api = () => {
            return new Promise((resolve, reject) => {
                if (type == "password-recovery") {
                    $.ajax({
                        type: "POST",
                        url: appUrl + "password-recovery/check-number",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            mobile: number,
                        },
                        success: function (response) {
                            if (response.error == true) {
                                $("#recovery_send_otp, #send_otp")
                                    .attr("disabled", false)
                                    .html("Send OTP");
                                iziToast.error({
                                    message: response.message,
                                    position: "topRight",
                                });
                                reject(0);
                                return;
                            }
                            resolve();
                        },
                    });
                } else {
                    $.ajax({
                        type: "POST",
                        url: appUrl + "register/check-number",
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        data: {
                            mobile: number,
                            captcha: captcha
                        },
                        success: function (response) {
                            if (response.error == true) {
                                console.log(response, 'response')

                                $("#recovery_send_otp, #send_otp")
                                    .attr("disabled", false)
                                    .html("Send OTP");
                                if (Array.isArray(response.message)) {
                                    $.each(
                                        response.message,
                                        // function (key, value) {
                                        // iziToast.error({
                                        //     message: value[0],
                                        //     position: "topRight",
                                        // });
                                        // }
                                    );
                                } else {

                                    Object.values(response.message).forEach(errArr => {
                                        iziToast.error({
                                            message: errArr[0],
                                            position: "topRight",
                                        })
                                    })

                                }
                                reject(0);
                                return;
                            }
                            resolve();
                        },
                    });
                }
            });
        };
        call_api()
            .then(() => {
                $.ajax({
                    type: "POST",
                    url: appUrl + "auth/send_otp",
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        code,
                        mobile: number,
                    },
                    dataType: "json",
                    success: function (response) {
                        $("#recovery_send_otp, #send_otp").attr("disabled", false).html("Send OTP");

                        if (response.error === false) {
                            $(".send-otp-box").addClass("d-none");
                            $(".verify-otp-box").removeClass("d-none");

                            startOtpTimer();

                            iziToast.success({
                                message: response.message,
                                position: "topRight",
                            });
                            return;
                        }

                        iziToast.error({
                            message: response.message || "Invalid mobile number",
                            position: "topRight",
                        });
                    },
                    error: function (xhr) {
                        $("#recovery_send_otp, #send_otp").attr("disabled", false).html("Send OTP");

                        let msg = "Invalid mobile number for selected country";

                        if (xhr.responseJSON?.message) {
                            msg = xhr.responseJSON.message;
                        }

                        iziToast.error({
                            message: msg,
                            position: "topRight",
                        });
                    }
                });

            })
            .catch((err) => { });
        $(document).off("click", "#recovery_verify_otp, #verify_otp").on("click", "#recovery_verify_otp, #verify_otp", function () {
            let container = $(this).closest(".login-register"); let code = container.find("#verificationCode").val(); let number = container.find("#recovery_number, #number").val();
            if (code == "") {
                iziToast.error({
                    message: "Please Enter Verification Code",
                    position: "topRight",
                });
                return;
            }
            $("#recovery_verify_otp, #verify_otp").attr("disabled", true).html("Please Wait...");
            $.ajax({
                type: "post",
                url: appUrl + "auth/verify_otp",
                data: {
                    mobile: number,
                    verification_code: code,
                },
                dataType: "json",
                success: function (response) {
                    if (response.error == false) {
                        let type = container.find("#recovery_type, #type").val();
                        console.log(type, 'type')
                        $(".verify-otp-box").addClass("d-none");
                        if (type == "password-recovery") {
                            $(".reset-password-form").removeClass("d-none");
                        } else {
                            $(".register-form").removeClass("d-none");
                        }
                        iziToast.success({
                            message: "Mobile Number Verified",
                            position: "topRight",
                        });
                        if (type == "password-recovery") {
                            $(".reset-password-form").on(
                                "submit",
                                function (e) {
                                    e.preventDefault();
                                    let container = $(this).closest(".send-otp-box"); if (container.length == 0) container = $(this).closest(".login-register");
                                    let number = container.find("#recovery_number, #number").val();
                                    let password = $("#recovery_new_password").val();
                                    let password_confirmation = $("#recovery_verify_password").val();
                                    console.log(password, password_confirmation, "hihi");

                                    if (password == "") {
                                        iziToast.error({
                                            message: "Please Enter Password",
                                            position: "topRight",
                                        });
                                        return;
                                    }
                                    if (password != password_confirmation) {
                                        iziToast.error({
                                            message:
                                                "Password and Conform Password Doesn't match.",
                                            position: "topRight",
                                        }
                                        );
                                        return;
                                    }
                                    $("#changePassword")
                                        .attr("disabled", true)
                                        .val("Please Wait...");
                                    $.ajax({
                                        type: "POST",
                                        url:
                                            appUrl +
                                            "password-recovery/set-new-password",
                                        data: {
                                            mobile: number,
                                            new_password: password,
                                            verify_password: password_confirmation,
                                        },
                                        success: function (response) {
                                            if (response.error == true) {
                                                $("#changePassword")
                                                    .attr("disabled", false)
                                                    .val("Change Password");
                                                $.each(
                                                    response.message,
                                                    function (key, value) {
                                                        iziToast.error({
                                                            message: value[0],
                                                            position:
                                                                "topRight",
                                                        });
                                                        return false;
                                                    }
                                                );
                                                return false;
                                            }
                                            iziToast.success({
                                                message: response.message,
                                                position: "topRight",
                                            });
                                            Livewire.navigate("/");
                                            return;
                                        },
                                    });
                                }
                            );
                            return;
                        } else {
                            $(".register-form").on("submit", function (e) {
                                e.preventDefault();
                                let username = $("#username").val();
                                let country_code = $('.selected-dial-code').text();
                                let container = $(this).closest(".send-otp-box"); if (container.length == 0) container = $(this).closest(".login-register"); let number = container.find("#recovery_number, #number").val();
                                let email = $("#email").val();
                                let password = $("#new_password").val();
                                let password_confirmation = $(
                                    "#verify_password"
                                ).val();
                                console.log(password, password_confirmation, "register");
                                if (username == "") {
                                    iziToast.error({
                                        message: "Please Enter Username",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (email == "") {
                                    iziToast.error({
                                        message: "Please Enter Email",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (password == "") {
                                    iziToast.error({
                                        message: "Please Enter Password",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                if (password != password_confirmation) {
                                    iziToast.error({
                                        message:
                                            "Password and Conform Password Doesn't match",
                                        position: "topRight",
                                    });
                                    return;
                                }
                                $("#register-form-submit")
                                    .attr("disabled", true)
                                    .val("Please Wait...");
                                $.ajax({
                                    type: "POST",
                                    url: appUrl + "register/submit",
                                    data: {
                                        username,
                                        mobile: number,
                                        email,
                                        password,
                                        country_code,
                                        password_confirmation,
                                    },
                                    success: function (response) {
                                        if (response.error == true) {
                                            $("#register-form-submit")
                                                .attr("disabled", false)
                                                .val("Register");
                                            $.each(
                                                response.message,
                                                function (key, value) {
                                                    iziToast.error({
                                                        message: value[0],
                                                        position: "topRight",
                                                    });
                                                    return false;
                                                }
                                            );
                                            return false;
                                        }
                                        iziToast.success({
                                            message: response.message,
                                            position: "topRight",
                                        });
                                        Livewire.navigate("/");
                                        return;
                                    },
                                });
                            });
                            return;
                        }
                    }
                    $("#recovery_verify_otp, #verify_otp")
                        .attr("disabled", false)
                        .html("Verify Code");
                    iziToast.error({
                        message: response.message,
                        position: "topRight",
                    });
                    return;
                },
            });
        });
    });
}
/* Prevent background scrolling when modals are open */
$(document).ready(function () {
    var modals = ['#loginModal', '#registerModal'];

    modals.forEach(function (modalId) {
        $(modalId).on('show.bs.modal', function () {
            $('body').css('overflow', 'hidden');
        });

        $(modalId).on('hidden.bs.modal', function () {
            $('body').css('overflow', 'auto');
        });
    });
});
$(document).on("submit", ".register-form", function (e) {
    e.preventDefault(); // 🔥 stops page reload

    let username = $("#username").val().trim();
    let country_code = $('.selected-dial-code').text();
    let container = $(this).closest(".login-register");
    let number = container.find("#recovery_number, #number").val();
    let email = $("#email").val().trim();
    let password = $("#new_password").val();
    let password_confirmation = $("#verify_password").val();

    if (username === "") {
        iziToast.error({ message: "Please Enter Username", position: "topRight" });
        return;
    }

    if (email === "") {
        iziToast.error({ message: "Please Enter Email", position: "topRight" });
        return;
    }

    if (password === "") {
        iziToast.error({ message: "Please Enter Password", position: "topRight" });
        return;
    }

    if (password !== password_confirmation) {
        iziToast.error({
            message: "Password and Confirm Password doesn't match hfh",
            position: "topRight",
        });
        return;
    }
    console.log(password, password_confirmation, 'dsklfdsj')

    $("#register-form-submit")
        .prop("disabled", true)
        .text("Please Wait...");

    $.ajax({
        type: "POST",
        url: appUrl + "register/submit",
        data: {
            username,
            mobile: number,
            email,
            password,
            country_code,
            password_confirmation,
            _token: $('meta[name="csrf-token"]').attr("content"),
        },

        success: function (response) {
            $("#register-form-submit")
                .prop("disabled", false)
                .text("Register");

            if (response.error) {
                $.each(response.message, function (key, value) {
                    iziToast.error({
                        message: value[0],
                        position: "topRight",
                    });
                    return false;
                });
                return;
            }

            iziToast.success({
                message: response.message,
                position: "topRight",
            });

            Livewire.navigate("/");
        }
    });
});


document.addEventListener("DOMContentLoaded", function () {

    const sendOtpBtn = document.getElementById("send_otp");
    const verifyOtpBtn = document.getElementById("verify_otp");
    const mobileInput = document.getElementById("number");
    const verificationInput = document.getElementById("verificationCode");
    const sendOtpBox = document.querySelector(".send-otp-box");
    const verifyOtpBox = document.querySelector(".verify-otp-box");
    const registerForm = document.querySelector(".register-form");
    const csrfToken = document.querySelector('meta[name="csrf-token"]')?.content;

    let currentMobile = "";

    function toggleLoading(button, isLoading, defaultText) {
        if (!button) return;

        if (defaultText) button.dataset.defaultText = defaultText;

        button.disabled = isLoading;
        button.innerHTML = isLoading
            ? `<span class="spinner-border spinner-border-sm me-1"></span> Please wait...`
            : button.dataset.defaultText;
    }

    /* ================= SEND OTP ================= */
    // if (sendOtpBtn) {
    //     toggleLoading(sendOtpBtn, false, sendOtpBtn.textContent.trim());

    //     sendOtpBtn.addEventListener("click", function () {
    //         const mobile = mobileInput.value.trim();
    //         const errorBox = document.getElementById("mobile_error");
    //         errorBox.textContent = "";

    //         if (!mobile) {
    //             errorBox.textContent = "Please enter mobile number";
    //             return;
    //         }

    //         toggleLoading(sendOtpBtn, true);

    //         fetch("/register/check-number", {
    //             method: "POST",
    //             headers: {
    //                 "Content-Type": "application/x-www-form-urlencoded",
    //                 "X-CSRF-TOKEN": csrfToken,
    //                 "Accept": "application/json"
    //             },
    //             body: new URLSearchParams({ mobile })
    //         })
    //             .then(res => res.json())
    //             .then(check => {
    //                 if (check.error) {
    //                     if (typeof check.message === "string") {
    //                         errorBox.textContent = check.message;
    //                     } else if (check.message?.mobile?.length) {
    //                         errorBox.textContent = check.message.mobile[0];
    //                     }

    //                     toggleLoading(sendOtpBtn, false);
    //                     return;
    //                 }


    //                 return fetch("/auth/send_otp", {
    //                     method: "POST",
    //                     headers: {
    //                         "Content-Type": "application/x-www-form-urlencoded",
    //                         "X-CSRF-TOKEN": csrfToken,
    //                         "Accept": "application/json"
    //                     },
    //                     body: new URLSearchParams({
    //                         mobile,
    //                         code: 91,
    //                         send_otp: 1
    //                     })
    //                 });
    //             })
    //             .then(res => res?.json())
    //             .then(data => {
    //                 if (!data) return;

    //                 if (data.error) {
    //                     errorBox.textContent = data.message || "Failed to send OTP";
    //                     return;
    //                 }

    //                 currentMobile = mobile;
    //                 iziToast.success({
    //                     message: "OTP sent successfully!",
    //                     position: "topRight"
    //                 });

    //                 sendOtpBox.classList.add("d-none");
    //                 verifyOtpBox.classList.remove("d-none");
    //             })
    //             .finally(() => toggleLoading(sendOtpBtn, false));
    //     });
    // }
    // Registration - Send OTP validation

    if (sendOtpBtn && mobileInput) {
        sendOtpBtn.addEventListener("click", function () {
            const mobile = mobileInput.value.trim();
            const captchaInput = document.getElementById("register_captcha_input");
            const captcha = captchaInput ? captchaInput.value.trim() : "";

            // Debug logs - REMOVE THESE AFTER TESTING
            console.log("Mobile:", mobile);
            console.log("Captcha:", captcha);
            console.log("Captcha element:", captchaInput);

            const errorBox = document.getElementById("mobile_error");
            const captchaBox = document.getElementById("captcha_error");

            // Clear previous errors
            if (errorBox) errorBox.textContent = "";
            if (captchaBox) captchaBox.textContent = "";

            let hasError = false;

            // Validate mobile number
            if (!mobile) {
                if (errorBox) errorBox.textContent = "Please enter mobile number.";
                hasError = true;
            } else if (!/^[0-9]{10}$/.test(mobile)) {
                if (errorBox) errorBox.textContent = "Please enter a valid 10-digit mobile number.";
                hasError = true;
            }

            // Validate captcha
            if (!captcha) {
                if (captchaBox) captchaBox.textContent = "Captcha is required.";
                hasError = true;
            }

            // If there are validation errors, stop here
            if (hasError) {
                return;
            }

            // Show loading state
            const originalText = sendOtpBtn.innerHTML;
            sendOtpBtn.disabled = true;
            sendOtpBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Sending...';

            // Prepare form data
            const formData = new URLSearchParams();
            formData.append('mobile', mobile);
            formData.append('captcha', captcha);

            console.log("Sending data:", Object.fromEntries(formData)); // Debug log

            // First API call: Check number
            fetch("/register/check-number", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "X-CSRF-TOKEN": csrfToken,
                    "Accept": "application/json"
                },
                body: formData
            })
                .then(res => res.json())
                .then(check => {
                    console.log("Check number response:", check); // Debug log

                    if (check.error) {
                        // Handle mobile error
                        if (check.message?.mobile) {
                            if (errorBox) {
                                errorBox.textContent = Array.isArray(check.message.mobile)
                                    ? check.message.mobile[0]
                                    : check.message.mobile;
                            }
                        }
                        // Handle captcha error
                        if (check.message?.captcha) {
                            if (captchaBox) {
                                captchaBox.textContent = Array.isArray(check.message.captcha)
                                    ? check.message.captcha[0]
                                    : check.message.captcha;
                            }
                        }
                        // Handle general error message
                        if (typeof check.message === 'string') {
                            if (errorBox) errorBox.textContent = check.message;
                        }

                        // Reset button
                        sendOtpBtn.disabled = false;
                        sendOtpBtn.innerHTML = originalText;
                        return Promise.reject('Validation failed');
                    }

                    // Second API call: Send OTP
                    const otpFormData = new URLSearchParams();
                    otpFormData.append('mobile', mobile);
                    otpFormData.append('captcha', captcha);
                    otpFormData.append('code', '91');
                    otpFormData.append('send_otp', '1');

                    return fetch("/auth/send_otp", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/x-www-form-urlencoded",
                            "X-CSRF-TOKEN": csrfToken,
                            "Accept": "application/json"
                        },
                        body: otpFormData
                    });
                })
                .then(res => res?.json())
                .then(data => {
                    console.log("Send OTP response:", data); // Debug log

                    if (!data) return;

                    if (data.error) {
                        // Handle errors from send_otp
                        if (data.message?.mobile && errorBox) {
                            errorBox.textContent = Array.isArray(data.message.mobile)
                                ? data.message.mobile[0]
                                : data.message.mobile;
                        }
                        if (data.message?.captcha && captchaBox) {
                            captchaBox.textContent = Array.isArray(data.message.captcha)
                                ? data.message.captcha[0]
                                : data.message.captcha
                        }
                        if (typeof data.message === 'string' && errorBox) {
                            errorBox.textContent = data.message;
                        }
                        return;
                    }

                    // Success - OTP sent
                    if (typeof iziToast !== 'undefined') {
                        iziToast.success({
                            message: "OTP sent successfully!",
                            position: "topRight"
                        });
                    }

                    // Hide send OTP box, show verify OTP box
                    if (sendOtpBox) sendOtpBox.classList.add("d-none");
                    if (verifyOtpBox) verifyOtpBox.classList.remove("d-none");
                })
                .catch(error => {
                    console.error('Fetch error:', error); // Debug log
                    if (error !== 'Validation failed') {
                        if (errorBox) errorBox.textContent = "An error occurred. Please try again.";
                    }
                })
                .finally(() => {
                    // Reset button state
                    sendOtpBtn.disabled = false;
                    sendOtpBtn.innerHTML = originalText;
                });
        });

        // Clear mobile error on input
        mobileInput.addEventListener("input", function () {
            const errorBox = document.getElementById("mobile_error");
            if (this.value.trim() !== '' && errorBox) {
                errorBox.textContent = "";
            }
        });

        // // Clear captcha error on input
        // const captchaInput = document.getElementById("register_captcha_input");
        // if (captchaInput) {
        //     captchaInput.addEventListener("input", function () {
        //         const captchaBox = document.getElementById("captcha_error");
        //         if (this.value.trim() !== '' && captchaBox) {
        //             captchaBox.textContent = "";
        //         }
        //     });
        // }
        if (mobileInput) {
            mobileInput.addEventListener("input", function () {
                const errorBox = document.getElementById("mobile_error");
                if (errorBox) errorBox.textContent = "";
            });
        }

        const captchaInputEl = document.getElementById("register_captcha_input");
        if (captchaInputEl) {
            captchaInputEl.addEventListener("input", function () {
                const captchaBox = document.getElementById("captcha_error");
                if (captchaBox) captchaBox.textContent = "";
            });
        }

    }


    // Clear errors on input
    mobileInput.addEventListener("input", function () {
        if (this.value.trim() !== '') {
            document.getElementById("mobile_error").textContent = "";
        }
    });

    document.getElementById("register_captcha_input").addEventListener("input", function () {
        if (this.value.trim() !== '') {
            document.getElementById("captcha_error").textContent = "";
        }
    });

    // Clear errors on input
    mobileInput.addEventListener("input", function () {
        if (this.value.trim() !== '') {
            document.getElementById("mobile_error").textContent = "";
        }
    });

    document.getElementById("register_captcha_input").addEventListener("input", function () {
        if (this.value.trim() !== '') {
            document.getElementById("captcha_error").textContent = "";
        }
    });
    /* ================= VERIFY OTP ================= */
    if (verifyOtpBtn) {
        toggleLoading(verifyOtpBtn, false, verifyOtpBtn.textContent.trim());

        verifyOtpBtn.addEventListener("click", function () {
            const code = verificationInput.value.trim();
            const mobile = currentMobile || mobileInput.value.trim();

            if (!code) {
                iziToast.error({ message: "Enter verification code", position: "topRight" });
                return;
            }

            toggleLoading(verifyOtpBtn, true);

            fetch("/auth/verify_otp", {
                method: "POST",
                headers: {
                    "Content-Type": "application/x-www-form-urlencoded",
                    "X-CSRF-TOKEN": csrfToken,
                    "Accept": "application/json"
                },
                body: new URLSearchParams({
                    mobile,
                    verification_code: code
                })
            })
                .then(res => res.json())
                .then(data => {
                    if (!data.error) {
                        document.getElementById("verified_mobile").value = mobile;
                        verifyOtpBox.classList.add("d-none");
                        registerForm.classList.remove("d-none");
                        mobileInput.setAttribute("readonly", "readonly");

                        iziToast.success({
                            message: "Verification successful!",
                            position: "topRight"
                        });
                    } else {
                        iziToast.error({
                            message: data.message || "Verification failed",
                            position: "topRight"
                        });
                    }
                })
                .finally(() => toggleLoading(verifyOtpBtn, false));
        });
    }
});



function bootTab_init() {
    const tabLinks = document.querySelectorAll(".product-tabs .tablink");
    const tabContents = document.querySelectorAll(
        ".tab-container .tab-content"
    );
    tabLinks.forEach(function (tabLink) {
        tabLink.addEventListener("click", function (event) {
            event.preventDefault();
            tabLinks.forEach(function (link) {
                link.parentElement.classList.remove("active");
            });
            this.parentElement.classList.add("active");
            const targetTabId = this.getAttribute("rel");
            const targetTab = document.getElementById(targetTabId);

            tabContents.forEach(function (content) {
                content.style.display = "none";
            });
            if (targetTab !== null && targetTab !== undefined) {
                targetTab.style.display = "block";
            }
        });
    });
}
document.addEventListener('DOMContentLoaded', function () {
    const checkbox = document.getElementById('prTearm');
    const checkoutBtn = document.getElementById('checkoutBtn');
    const viewCartBtn = document.getElementById('viewCartBtn');

    function toggleButtons() {
        if (checkbox.checked) {
            checkoutBtn.classList.remove('disabled');
            viewCartBtn.classList.remove('disabled');
        } else {
            checkoutBtn.classList.add('disabled');
            viewCartBtn.classList.add('disabled');
        }
    }

    // ðŸ”¥ IMPORTANT: run on page load
    toggleButtons();

    // Run when checkbox changes
    checkbox.addEventListener('change', toggleButtons);

    // Extra safety: prevent click if disabled
    document.querySelectorAll('.cart-checkout').forEach(btn => {
        btn.addEventListener('click', function (e) {
            if (this.classList.contains('disabled')) {
                e.preventDefault();
                alert('Please accept Terms & Conditions');
            }
        });
    });
});
// function showPdpQtyUI(el) {
//     let card = $(el).closest('.button-action, .product-form-submit');

//     if (!card.length) return;

//     card.find('.addtocart-btn').addClass('d-none');
//     card.find('.cart-qtyDetail').removeClass('d-none');
// }
function showPdpQtyUI(el) {
    let card = $(el).closest('.button-action, .product-form-submit');
    if (!card.length) return;

    // â­ Get minimum order quantity from button
    let minQty = parseInt($(el).attr("data-min")) || 1;

    // Toggle UI
    card.find('.addtocart-btn').addClass('d-none');
    card.find('.cart-qtyDetail').removeClass('d-none');

    // â­ Set qty input to minimum order quantity
    let qtyInput = card.find('.qty');
    if (qtyInput.length) {
        qtyInput.val(minQty);
    }
}


// function resetToAddToCartUI(el) {
//     let card = $(el).closest('.button-action, .product-form-submit');

//     if (!card.length) return;

//     card.find('.cart-qtyDetail').addClass('d-none');
//     card.find('.addtocart-btn').removeClass('d-none');
// }
function resetToAddToCartUI(el) {
    let card = $(el).closest('.button-action, .product-form-submit');
    if (!card.length) return;

    // ðŸ”‘ get min qty from add button
    let minQty = parseInt(card.find('.addtocart-btn').data('min')) || 1;

    // ðŸ”‘ reset qty input
    card.find('.qty').val(minQty);

    // ðŸ”‘ toggle UI
    card.find('.cart-qtyDetail').addClass('d-none');
    card.find('.addtocart-btn').removeClass('d-none');
}


function resetToAddToCartUIByVariant(variant_id) {
    // Hide qty UI
    $(`input.qty[data-variant-id="${variant_id}"]`)
        .closest('.cart-qtyDetail')
        .addClass('d-none');

    // Show Add to Cart
    $(`.addtocart-btn[data-product-variant-id="${variant_id}"]`)
        .removeClass('d-none');
}


$(document).on("click", ".close-cart", function () {
    let offcanvasEl = document.querySelector(".offcanvas.show");
    if (offcanvasEl) {
        let instance = bootstrap.Offcanvas.getInstance(offcanvasEl);
        if (!instance) {
            instance = new bootstrap.Offcanvas(offcanvasEl);
        }
        instance.hide();
    }
});

// document.addEventListener("livewire:load", () => {

//     Livewire.hook("message.processed", () => {

//         const checkbox = document.getElementById("prTearm");
//         if (!checkbox) return;

//         const enabled = checkbox.checked;

//         document.querySelectorAll("#checkoutBtn, #viewCartBtn")
//             .forEach(btn => {
//                 btn.classList.toggle("disabled", !enabled);
//             });
//     });

// });

// $(document).on("change", "#prTearm", function () {
//     const enable = this.checked;
//     $("#checkoutBtn, #viewCartBtn")
//         .toggleClass("disabled", !enable);
// });

function display_cart(cart) {
    let display = "";
    let currency_symbol = $("#currency").val();
    let current_store_id = $("#current_store_id").val();

    if (cart !== null && cart.length > 0) {
        display += `<div class="block block-cart"><div class="minicart-content"><ul class="m-0 clearfix">`;

        let total = 0;
        let cart_count = 0;
        cart.forEach((e) => {
            if (e.store_id == current_store_id) {
                // Use line total (qty * price); fallback to variant_price if missing
                let lineTotal = parseFloat(e.final_price);
                if (isNaN(lineTotal)) {
                    lineTotal = (parseFloat(e.variant_price) || 0) * (parseInt(e.qty) || 1);
                }
                total += lineTotal;
                cart_count++;
                display +=
                    '<li class="item d-flex justify-content-center align-items-center">' +
                    '<a class="product-image rounded-3" wire:navigate href="' +
                    appUrl +
                    "products/" +
                    e.slug +
                    '"><img src="' +
                    e.image +
                    '" alt="' +
                    e.name +
                    '" title="' +
                    e.name +
                    '" width="50" height="50" ' +
                    'style="width:50px;height:50px;object-fit:cover;display:block;" />'
                    +
                    '</a><div class="product-details">' +
                    '<div class="product-title-container" x-data="{ expanded: false, isOverflown: false }" x-init="$nextTick(() => { isOverflown = $refs.title.scrollHeight > $refs.title.clientHeight })">' +
                    '<a x-ref="title" class="" wire:navigate href="' +
                    appUrl +
                    "products/" +
                    e.slug +
                    '" :style="expanded ? \'display: block; white-space: normal;\' : \'display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; text-overflow: ellipsis;\'">' +
                    e.name +
                    "</a>" +
                    '<span x-show="isOverflown" @click="expanded = !expanded" class="read-more-toggle text-primary pointer" style="cursor: pointer; font-size: 13px; font-weight: 500; display: inline-block; margin-top: 2px;">' +
                    '<span x-show="!expanded">... read more</span>' +
                    '<span x-show="expanded"> show less</span>' +
                    '</span>' +
                    '</div>' +
                    '<div class="variant-cart my-2">' +
                    (e.product_type === "regular"
                        ? e.brand_name
                        : e.product_type) +
                    "</div>" +
                    '<div class="priceRow"><div class="product-price">' +
                    currency_symbol +
                    '<span class="price price-' +
                    e.product_variant_id +
                    '">' +
                    e.final_price +
                    '</span></div></div></div><div class="qtyDetail text-end cart-qtyDetail">' +
                    '<div class="qtyField"><a class="qtyBtn minus" href="#;"><ion-icon name="remove-outline"></ion-icon></a>' +
                    '<input type="number" name="quantity" data-variant-id="' +
                    e.product_variant_id +
                    '" value="' +
                    e.qty +
                    '" max="' +
                    (e.max == 0 ? "Infinity" : e.max) +
                    '" min="' +
                    e.min +
                    '" step="' +
                    e.step +
                    '" data-variant-price="' +
                    e.variant_price +
                    '" class="qty">' +
                    '<a class="qtyBtn plus" href="#;"><ion-icon name="add-outline"></ion-icon></a></div>' +
                    '<a class="remove_from_cart remove pointer" data-variant-id="' +
                    e.product_variant_id +
                    '"><ion-icon class="icon" data-bs-toggle="tooltip" data-bs-placement="top" name="close-outline"></ion-icon></a></div> </li>';
            }
        });
        $(".cart-count").text(cart_count);
        $(".cart_count").text(cart_count);
        if (cart_count != 0) {
            display += `</ul></div>`;
            display += `<div class="minicart-bottom"><div class="subtotal clearfix my-3"><div class="totalInfo clearfix"><span>Total:</span><span class="item product-price sub-total">${currency_symbol}${total}</span></div></div><div class="agree-check customCheckbox"><input id="prTearm" name="tearm" type="checkbox" value="tearm" required /><label for="prTearm"> I agree with the </label><a wire:navigate href="${appUrl}term-and-conditions" class="ms-1 text-link">Terms &amp; conditions</a></div><div class="minicart-action d-flex mt-3"><button class="cart-checkout proceed-to-checkout btn btn-primary w-50 me-1 disabled">Check Out</button> <button class="cart-checkout cart-btn btn btn-secondary w-50 ms-1 disabled">View Cart</button></div></div></div>`;
        } else {
            display +=
                `<div id="display_cart"><div class="cartEmpty-content mt-4"><ion-icon name="cart-outline" class="icon text-muted fs-1"></ion-icon><p class="my-3">No Products in the Cart</p><a wire:navigate href="` +
                appUrl +
                "products" +
                `" class="btn btn-primary">Continue shopping</a></div></div>`;
        }
    } else {
        display +=
            `<div id="display_cart"><div class="cartEmpty-content mt-4"><ion-icon name="cart-outline" class="icon text-muted fs-1"></ion-icon><p class="my-3">No Products in the Cart</p><a wire:navigate href="` +
            appUrl +
            "products" +
            `" class="btn btn-primary">Continue shopping</a></div></div>`;
    }
    $("#display_cart").html(display);
}

function initListner(event, selector, callback) {
    $(selector).off(event);
    $(selector).on(event, callback);
}
// function add_cart() {
//     initListner("click", ".add_cart", function (e) {
//         console.log("here");
//         e.preventDefault();
//         let variant_id = $(this).attr("data-product-variant-id");
//         let t = $(this);

//         if (!variant_id) {
//             iziToast.error({
//                 message: "Please Select Variant",
//                 position: "topRight",
//             });
//             return;
//         }
//         let qty = $(this)
//             .closest("#stickycart-form, .product-action")
//             .find(".qty")
//             .val();
//         let product_type = $(this).attr("data-product-type");
//         if (product_type == undefined || product_type == null) {
//             product_type = "regular";
//         }
//         let variant_price = $(this).attr("data-variant-price");
//         let min = $(this).attr("data-min");
//         let name = $(this).attr("data-name");
//         let store_id = $(this).attr("data-store-id");
//         let slug = $(this).attr("data-slug");
//         let brand_name = $(this).attr("data-brand-name");
//         let max = $(this).attr("data-max");
//         let step = $(this).attr("data-step");
//         let image = $(this).attr("data-image");
//         let product_reference_id = $(this).attr("data-product-reference-id");
//         if (qty == null && qty == undefined) {
//             qty = 1;
//         }
//         if (is_logged == true) {
//             $.ajax({
//                 type: "POST",
//                 url: appUrl + "cart/add-to-cart",
//                 data: {
//                     product_variant_id: variant_id,
//                     qty: qty,
//                     is_saved_for_later: false,
//                     product_type: product_type,
//                     product_reference_id: product_reference_id,
//                 },
//                 dataType: "json",
//                 success: function (response) {
//                     Livewire.dispatch("refreshComponent");
//                     if (response.error != true) {
//                         iziToast.success({
//                             message: response.message,
//                             position: "topRight",
//                         });
//                         $(".cart-count").text(response.cart_count);

//                         t.find(".button-text").text("Go to Cart");
//                         t.addClass("go-cart-btn");
//                         $(".cart-count").text(response.cart_count);

//                         if (t.hasClass("buy_now")) {
//                             Livewire.navigate(appUrl + "cart");
//                         }
//                         return false;
//                     }
//                     iziToast.error({
//                         message: response.message,
//                         position: "topRight",
//                     });
//                 },
//             });
//             return;
//         }
//         let cart_items = {
//             product_variant_id: variant_id,
//             qty: qty,
//             product_type: product_type,
//             variant_price: variant_price,
//             final_price: qty * parseFloat(variant_price),
//             name: name,
//             slug: slug,
//             brand_name: brand_name,
//             min: min,
//             max: max,
//             step: step,
//             image: image,
//             store_id: store_id,
//         };

//         let cart = localStorage.getItem("cart");
//         cart = localStorage.getItem("cart") != null ? JSON.parse(cart) : null;

//         if (cart != null && cart != undefined) {
//             let existingItemIndex = cart.findIndex(
//                 (item) =>
//                     item.product_variant_id === cart_items.product_variant_id
//             );
//             if (existingItemIndex !== -1) {
//                 iziToast.error({
//                     message: "Item Already Added in Cart",
//                     position: "topRight",
//                 });
//                 return false;
//             } else {
//                 cart.push(cart_items);
//             }
//         } else {
//             cart = [cart_items];
//         }

//         localStorage.setItem("cart", JSON.stringify(cart));
//         console.log(localStorage.getItem("cart"));
//         display_cart(cart);
//         iziToast.success({
//             message: "Added to Cart Successfully",
//             position: "topRight",
//         });
//         return;
//     });
// }

$(document).on("click", ".add_cart", function (e) {
    e.preventDefault();

    let wrapper = $(this).closest(".button-action");

    // ðŸ”¥ AFTER ADD TO CART SUCCESS
    wrapper.find(".addtocart-btn").addClass("d-none");   // hide button
    wrapper.find(".cart-qtyDetail").removeClass("d-none"); // show qty
});




function add_cart() {
    initListner("click", ".add_cart", function (e) {
        console.log("is_logged", is_logged);

        e.preventDefault();

        let t = $(this);
        let variantId = t.data("product-variant-id");

        // ðŸ‘‰ YOUR EXISTING ADD TO CART LOGIC HERE
        // ajax / localStorage / validations
        // ----------------------------------
        //  $("#addcart-section-" + variantId).hide();    // hide Add to Cart
        //         $("#qty-section-" + variantId).removeClass("d-none").show();


        // â­ IF BUTTON IS "GO TO CART"
        if (t.hasClass("go-cart-btn")) {

            // â­ Guest user â†’ force login
            if (!is_logged) {
                iziToast.error({
                    message: "Please login to view your cart",
                    position: "topRight",
                });

                window.location.href = appUrl + "login";
                return;
            } else {

                // â­ Logged-in user â†’ go to cart directly
                window.location.href = appUrl + "cart";
                return;
            }

        }
        let variant_id = t.attr("data-product-variant-id");
        if (!variant_id) {
            // iziToast.error({
            //     message: "Please Select Variant",
            //     position: "topRight",
            // });
            return;
        }

        let minQty = parseInt(t.attr("data-min")) || 1;

        let qtyInput = t.closest("#stickycart-form, .product-action").find(".qty");
        let qty = qtyInput.length ? parseInt(qtyInput.val()) : minQty;
        let product_type = t.attr("data-product-type") || "regular";
        let variant_price = t.attr("data-variant-price");
        let min = t.attr("data-min");
        let name = t.attr("data-name");
        let store_id = t.attr("data-store-id");
        let slug = t.attr("data-slug");
        let brand_name = t.attr("data-brand-name");
        let max = t.attr("data-max");
        let step = t.attr("data-step");
        let image = t.attr("data-image");
        let product_reference_id = t.attr("data-product-reference-id");


        // ============================================================
        // â­ LOGGED-IN USERS (BACKEND CART)
        // ============================================================
        if (is_logged) {
            $.ajax({
                type: "POST",
                url: appUrl + "cart/add-to-cart",
                data: {
                    product_variant_id: variant_id,
                    qty: qty,
                    is_saved_for_later: false,
                    product_type: product_type,
                    product_reference_id: product_reference_id,
                },
                dataType: "json",
                success: function (response) {
                    Livewire.dispatch("refreshComponent");

                    if (response.error != true) {
                        iziToast.success({
                            message: response.message,
                            position: "topRight",
                        });
                        showPdpQtyUI(this);
                        console.log('response', response);
                        $(".cart-count").text(response.cart_count);
                        // t.find(".button-text").text("Go to Cart");
                        // t.addClass("go-cart-btn");
                        syncBackendCartToLocal();

                        // â­ If "Buy Now" button â†’ redirect to checkout with variant_id parameter
                        if (t.hasClass("buy_now")) {
                            // Add small delay to ensure cart is updated
                            setTimeout(function () {
                                let buyNowUrl = appUrl + "cart/checkout?buy_now_variant_id=" + variant_id + "&product_type=" + product_type;
                                Livewire.navigate(buyNowUrl);
                            }, 300);
                            return;
                        }

                        return;
                    }

                    iziToast.error({
                        message: response.message,
                        position: "topRight",
                    });
                },
            });

            return;
        }


        // ============================================================
        // â­ GUEST USER â€” SAVE IN LOCALSTORAGE
        // ============================================================
        let cart_item = {
            product_variant_id: variant_id,
            qty: parseInt(qty || min),
            final_price: parseInt(qty || min) * parseFloat(variant_price),

            product_type,
            variant_price,
            final_price: parseInt(qty) * parseFloat(variant_price),
            name,
            slug,
            brand_name,
            min,
            max,
            step,
            image,
            store_id,
        };

        let cart = JSON.parse(localStorage.getItem("cart")) || [];

        let exists = cart.find(i => i.product_variant_id == variant_id);
        showPdpQtyUI(this);
        if (exists) {
            // â­ If "Buy Now" and item already in cart â†’ redirect to checkout
            if (t.hasClass("buy_now")) {
                if (!is_logged) {
                    iziToast.info({
                        message: "Item already in cart. Please login to proceed to checkout",
                        position: "topRight",
                    });
                    let buyNowUrl = appUrl + "cart/checkout?buy_now_variant_id=" + variant_id + "&product_type=" + product_type;
                    setTimeout(function () {
                        window.location.href = appUrl + "login?redirect=" + encodeURIComponent(buyNowUrl);
                    }, 500);
                    return;
                } else {
                    // Shouldn't happen for guest, but just in case
                    let buyNowUrl = appUrl + "cart/checkout?buy_now_variant_id=" + variant_id + "&product_type=" + product_type;
                    setTimeout(function () {
                        window.location.href = buyNowUrl;
                    }, 300);
                    return;
                }
            }

            // â­ Already added â†’ do NOT add again (for regular add to cart)
            iziToast.error({
                message: "Item Already Added in Cart",
                position: "topRight",
            });

            // â­ Change button to "Go to Cart"
            // t.find(".button-text").text("Go to Cart");
            // t.addClass("go-cart-btn");

            return;
        } else {
            iziToast.success({
                message: "Added to Cart Successfully",
                position: "topRight",
            });

        }

        cart.push(cart_item);
        localStorage.setItem("cart", JSON.stringify(cart));

        // â­ If "Buy Now" button â†’ redirect to checkout (guest users need to login first)
        if (t.hasClass("buy_now")) {
            if (!is_logged) {
                // Guest user â†’ redirect to login, then checkout with variant_id
                iziToast.info({
                    message: "Please login to proceed to checkout",
                    position: "topRight",
                });
                let buyNowUrl = appUrl + "cart/checkout?buy_now_variant_id=" + variant_id + "&product_type=" + product_type;
                setTimeout(function () {
                    window.location.href = appUrl + "login?redirect=" + encodeURIComponent(buyNowUrl);
                }, 500);
                return;
            } else {
                // Logged-in guest (shouldn't happen, but just in case)
                let buyNowUrl = appUrl + "cart/checkout?buy_now_variant_id=" + variant_id + "&product_type=" + product_type;
                setTimeout(function () {
                    window.location.href = buyNowUrl;
                }, 300);
                return;
            }
        }



        display_cart(cart);
        return;

    });
}

function syncGuestCartUI() {
    if (typeof is_logged !== "undefined" && is_logged) return;

    let cartRaw = localStorage.getItem("cart");
    if (!cartRaw) return;

    let cart;
    try {
        cart = JSON.parse(cartRaw);
    } catch (e) {
        return;
    }

    if (!Array.isArray(cart) || cart.length === 0) return;

    cart.forEach(item => {
        let variantId = String(item.product_variant_id);

        // Find add-to-cart button by data attribute
        let addBtn = document.querySelector(
            '.add_cart[data-product-variant-id="' + variantId + '"]'
        );

        if (!addBtn) return;

        let wrapper = addBtn.closest(".button-action");
        if (!wrapper) return;

        let qtyBox = wrapper.querySelector(".cart-qtyDetail");
        let qtyInput = wrapper.querySelector(".qty");

        addBtn.classList.add("d-none");

        if (qtyBox) qtyBox.classList.remove("d-none");
        if (qtyInput) qtyInput.value = item.qty;
    });
}
const cartObserver = new MutationObserver(() => {
    syncGuestCartUI();
});

cartObserver.observe(document.body, {
    childList: true,
    subtree: true
});
window.addEventListener("load", function () {
    syncGuestCartUI();
});




// â­ RUN THESE ON PAGE LOAD
$(document).ready(function () {
    // For loggedâ€‘in users, try to pull cart from backend into localStorage/UI.
    if (typeof is_logged !== "undefined" && is_logged) {
        syncBackendCartToLocal();
    }

    // Always run this so that, if the item is already in cart (from localStorage
    // or from a previous sync), we hide the Add to Cart button and show the qty block.
    updateAddToCartButtons();

    // Enable add_cart functionality for both guest and loggedâ€‘in.
    add_cart();
});

// ---------------------------------------------------------------------
// Shop By Category (home tabs) - load products via AJAX and rebind cart
// ---------------------------------------------------------------------
(function initRoomTabs() {
    let roomTabsClickHandler = null;

    async function loadProductsBySlug(slug, container) {
        if (!slug || !container) return;
        try {
            container.innerHTML = '<div class="text-center py-4">Loading products...</div>';
            const baseUrl = appUrl.endsWith("/") ? appUrl : `${appUrl}/`;
            const response = await fetch(`${baseUrl}filter-products/${encodeURIComponent(slug)}`, {
                headers: {
                    "X-Requested-With": "XMLHttpRequest",
                    Accept: "text/html",
                },
                credentials: "same-origin",
                method: "GET",
            });
            if (!response.ok) throw new Error(`HTTP error ${response.status}`);
            const html = await response.text();
            container.innerHTML = html;
            rehydrateRoomCartHandlers();
        } catch (e) {
            console.error("Error loading products:", e);
            container.innerHTML =
                '<div class="text-center py-4">Failed to load products. Please try again.</div>';
        }
    }

    function setActiveTab(clicked, viewAllLink) {
        const tabs = Array.from(document.querySelectorAll(".room-tab"));
        tabs.forEach((btn) => btn.classList.remove("active"));
        clicked.classList.add("active");
        const slug = clicked.getAttribute("data-slug");
        if (viewAllLink && slug) {
            viewAllLink.href = `/categories/${slug}/products`;
        }
    }

    function bindRoomTabs() {
        const container = document.getElementById("room-products-container");
        const viewAllLink = document.getElementById("view-all-products-link");
        const tabsContainer = document.getElementById("room-tabs");
        if (!container || !tabsContainer) return;

        if (roomTabsClickHandler) {
            tabsContainer.removeEventListener("click", roomTabsClickHandler);
        }

        roomTabsClickHandler = function (e) {
            const clickedTab = e.target.closest(".room-tab");
            if (clickedTab) {
                const slug = clickedTab.getAttribute("data-slug");
                if (slug) {
                    setActiveTab(clickedTab, viewAllLink);
                    loadProductsBySlug(slug, container);
                }
            }
        };

        tabsContainer.addEventListener("click", roomTabsClickHandler);

        // Load first tab on init if container is empty
        const tabs = Array.from(document.querySelectorAll(".room-tab"));
        if (tabs.length > 0 && (!container.innerHTML || container.innerHTML.trim() === "")) {
            const firstTab = tabs[0];
            const firstSlug = firstTab.getAttribute("data-slug");
            if (firstSlug) {
                setActiveTab(firstTab, viewAllLink);
                loadProductsBySlug(firstSlug, container);
            }
        }
    }

    // Re-run global cart bindings after injecting HTML. Retry a few times
    // in case custom.js functions aren't ready yet.
    function rehydrateRoomCartHandlers(attempt = 0) {
        const MAX_ATTEMPTS = 5;
        let pendingRetry = false;

        if (typeof add_cart === "function") {
            add_cart();
        } else if (attempt < MAX_ATTEMPTS) {
            pendingRetry = true;
        }

        if (typeof updateAddToCartButtons === "function") {
            updateAddToCartButtons();
        } else if (attempt < MAX_ATTEMPTS) {
            pendingRetry = true;
        }

        if (pendingRetry) {
            setTimeout(() => rehydrateRoomCartHandlers(attempt + 1), 100);
        }
    }

    function initRoomTabsOnReady() {
        if (document.readyState === "loading") {
            document.addEventListener("DOMContentLoaded", bindRoomTabs, { once: true });
        } else {
            bindRoomTabs();
        }
    }

    initRoomTabsOnReady();
    document.addEventListener("livewire:navigated", () => {
        setTimeout(bindRoomTabs, 100);
    });
    document.addEventListener("livewire:init", () => {
        setTimeout(bindRoomTabs, 100);
    });
})();

function updateAddToCartButtons() {
    let cart = JSON.parse(localStorage.getItem("cart")) || [];
    $(".add_cart").each(function () {
        let btn = $(this);
        let variant_id = btn.attr("data-product-variant-id");

        let exists = cart.find(item => item.product_variant_id == variant_id);

        if (exists) {
            // btn.find(".button-text").text("Go to Cart");
            // btn.addClass("go-cart-btn");

            // âœ… If this card has an attached quantity section, show it and hide the Add to Cart button
            //    This keeps the qty block visible even after page refresh for items already in cart.
            let wrapper = btn.closest(".button-action");
            if (wrapper.length) {
                // Hide the Add to Cart button block
                wrapper.find(".addtocart-btn").addClass("d-none");

                // Show the qty block
                let qtyBlock = wrapper.find(".cart-qtyDetail");
                qtyBlock.removeClass("d-none");

                // Sync quantity input with cart quantity if present
                let qtyInput = qtyBlock.find('input.qty[data-variant-id="' + variant_id + '"]');
                if (qtyInput.length && exists.qty) {
                    qtyInput.val(exists.qty);
                }
            }
        }
    });
}

// Sync backend cart into localStorage/UI (logged-in)
function syncBackendCartToLocal() {
    console.log('syncBackendCartToLocal');
    if (!is_logged) return;
    let store_id = $("#current_store_id").val() || $("#default_store_id").val() || "";
    if (!store_id) return;
    console.log('store_id', store_id);
    $.ajax({
        type: "POST",
        url: appUrl + "api/v1/get_user_cart",
        data: {
            only_delivery_charge: 0,
            store_id,
            is_saved_for_later: 0,
        },
        success: function (res) {
            const items = (res && (res.cart_items || (res.data && res.data.cart_items))) || [];
            const normalized = items.map((i) => {
                const qty = parseInt(i.qty) || 1;
                const variant_price = parseFloat(i.variant_price || i.price || i.final_price || 0);
                return {
                    product_variant_id: i.product_variant_id || i.id,
                    qty,
                    variant_price,
                    final_price: qty * variant_price,
                    product_type: i.product_type || i.cart_product_type || "regular",
                };
            });

            localStorage.setItem("cart", JSON.stringify(normalized));
            display_cart(normalized);
            syncLocalCartToUI();
            normalized.forEach((item) => mirrorQtyInputs(item.product_variant_id, item.qty));
            updateAddToCartButtons();
        },
    });
}


$(document).on("click", ".go-cart-btn", function (e) {
    e.preventDefault();
});

function initialize() {
    product_zoom();
    bootTab_init();
    bootstrap_table_initialize();
    add_cart();
}
function bootstrap_table_initialize() {
    $("#user_wallet_transactions").bootstrapTable({
        formatLoadingMessage: function () {
            return '<i class="fa fa-spinner fa-spin fa-fw"></i>';
        },
    });
    $("#wallet_withdrawal_request").bootstrapTable({
        formatLoadingMessage: function () {
            return '<i class="fa fa-spinner fa-spin fa-fw"></i>';
        },
    });
    $("#user_transactions").bootstrapTable({
        formatLoadingMessage: function () {
            return '<i class="fa fa-spinner fa-spin fa-fw"></i>';
        },
    });
    $("#natifications_table").bootstrapTable({
        formatLoadingMessage: function () {
            return '<i class="fa fa-spinner fa-spin fa-fw"></i>';
        },
    });
}

function syncLocalCartToUI() {
    let cart = JSON.parse(localStorage.getItem("cart")) || [];

    $("input.qty").each(function () {
        let variant_id = $(this).data("variant-id");
        let cartItem = cart.find(i => i.product_variant_id == variant_id);

        if (cartItem) {
            $(this).val(cartItem.qty);
        }
    });
}

// Keep all qty inputs for the same variant in sync (e.g., listing + sidebar)
function mirrorQtyInputs(variantId, newQty) {
    $(`input.qty[data-variant-id="${variantId}"]`).val(newQty);
}

// Broadcast cart changes so sidebar/listing/cart page can react
function dispatchCartChanged(payload = {}) {
    const event = new CustomEvent("cartChanged", { detail: payload });
    window.dispatchEvent(event);
}

// Fetch cart from backend (logged-in) and hydrate UI + localStorage
function hydrateLoggedInCartUI() {
    if (!is_logged) return;

    let store_id = $("#current_store_id").val() || $("#default_store_id").val() || "";

    const normalizeCartItems = (items) =>
        items.map((i) => {
            let qty = parseInt(i.qty) || 1;
            let variant_price = parseFloat(i.variant_price || i.price || i.final_price || 0);
            return {
                product_variant_id: i.product_variant_id || i.id,
                qty,
                product_type: i.product_type || i.cart_product_type || "regular",
                variant_price,
                final_price: qty * variant_price,
                name: (i.product && i.product.name) || i.name || "",
                slug: (i.product && i.product.slug) || i.slug || "",
                brand_name: (i.product && i.product.brand_name) || i.brand_name || "",
                min: i.min ?? i.minimum_order_quantity ?? 1,
                max: i.max ?? i.total_allowed_quantity ?? 0,
                step: i.step ?? i.quantity_step_size ?? 1,
                image: i.image || (i.product && i.product.image) || "",
                store_id: i.store_id || store_id,
            };
        });

    $.ajax({
        type: "POST",
        url: appUrl + "api/v1/get_user_cart",
        data: {
            only_delivery_charge: 0,
            store_id,
            is_saved_for_later: 0,
        },
        success: function (res) {
            const items = (res && (res.cart_items || (res.data && res.data.cart_items))) || [];
            if (!items.length) return;

            const normalized = normalizeCartItems(items);
            localStorage.setItem("cart", JSON.stringify(normalized));
            display_cart(normalized);
            syncLocalCartToUI();
            normalized.forEach((item) => {
                mirrorQtyInputs(item.product_variant_id, item.qty);
            });
        },
    });
}



// **********************************************************************
// â­ MAIN FUNCTION â€” INC / DEC LOGIC WITH CART SYNC
// **********************************************************************
// function qnt_incre() {

//     // =========================================================================
//     // CLICK PLUS / MINUS
//     // =========================================================================
//     $(document).on("click", ".qtyBtn", function () {
//         console.log('click here increment')

//         let qtyField = $(this).closest(".qtyField");
//         let inputField = qtyField.find(".qty");

//         // Guard against NaN so calculations stay consistent
//         let maxVal   = parseInt(inputField.attr("max"));
//         if (isNaN(maxVal)) maxVal = Number.MAX_SAFE_INTEGER;
//         let minVal   = parseInt(inputField.attr("min"));
//         if (isNaN(minVal)) minVal = 0;
//         let stepSize = parseInt(inputField.attr("step"));
//         if (isNaN(stepSize)) stepSize = 1;
//         let oldValue = parseInt(inputField.val());
//         if (isNaN(oldValue)) oldValue = minVal;

//         let variant_id    = inputField.data("variant-id");
//         let variant_price = inputField.data("variant-price");
//         let product_type  = inputField.data("product-type") || "regular";
//         let name          = inputField.data("name");
//         let slug          = inputField.data("slug");
//         let brand_name    = inputField.data("brand-name");
//         let image         = inputField.data("image");
//         let store_id      = inputField.data("store-id");


//         let newVal;
//         console.log('variant_id', variant_id,user_id);

//         // Safety: if variant id is missing, do nothing
//         if (!variant_id) {
//             console.warn("Missing variant_id on qty input");
//             return;
//         }
//         if ($(this).is(".plus")) {

//            if (!is_logged) {
//                 let cart = JSON.parse(localStorage.getItem("cart")) || [];
//                 let exists = cart.find(item => item.product_variant_id == variant_id);

//                 if (!exists) {
//                     let cart_item = {
//                         product_variant_id: variant_id,
//                         qty: 1,
//                         product_type,
//                         variant_price,
//                         final_price: parseFloat(variant_price),
//                         name,
//                         slug,
//                         brand_name,
//                         min: minVal,
//                         max: maxVal,
//                         step: stepSize,
//                         image,
//                         store_id
//                     };

//                     cart.push(cart_item);
//                     localStorage.setItem("cart", JSON.stringify(cart));
//                     display_cart(cart);
//                      showPdpQtyUI(this);

//                     syncLocalCartToUI(); // keep listing/inputs aligned
//                     // mirrorQtyInputs(variant_id, 1);
// mirrorQtyInputs(variant_id, minVal);
// $(this).val(minVal);
//                     dispatchCartChanged({ variant_id, qty: 1, source: "add_guest" });
//                     oldValue = 1;
//                 }
//              }

//             else {
//                 // LOGGED-IN USER â†’ INITIAL ADD
//                 $.ajax({
//                     type: "POST",
//                     url: appUrl + "cart/add-to-cart",
//                     data: {
//                         product_variant_id: variant_id,
//                         qty: 1,
//                         is_saved_for_later: false,
//                         product_type
//                     },
//                     async: false,
//                     success: function () {
//                         mirrorQtyInputs(variant_id, oldValue + stepSize);
//                         dispatchCartChanged({ variant_id, qty: oldValue + stepSize, source: "add_logged_in" });
//                         Livewire.dispatch("refreshComponent");
//                     }
//                 });
//             }
//         }


//         // =========================================================================
//         // INCREMENT / DECREMENT LOGIC
//         // =========================================================================
//         if ($(this).is(".plus")) {
//         console.log('this calll e=which is double')
//             newVal = oldValue + stepSize;

//             if (newVal > maxVal) {
//                 newVal = maxVal;
//                 iziToast.error({
//                     message: "Maximum allowable quantity is " + maxVal,
//                     position: "topRight",
//                 });
//             }
//         }
//       else {
//     // MINUS button logic

//     // âœ… If qty is already at minimum â†’ REMOVE item
//     if (oldValue <= minVal) {

//         if (!is_logged) {
//             let cart = JSON.parse(localStorage.getItem("cart")) || [];
//             cart = cart.filter(item => item.product_variant_id != variant_id);
//             localStorage.setItem("cart", JSON.stringify(cart));
//             resetToAddToCartUI(this);
//             resetToAddToCartUIByVariant(variant_id);

//             // âœ… UPDATE CART COUNT
//             $(".cart-count").text(cart.length);
//             $(".cart_count").text(cart.length);
//             display_cart(cart);
//             //  let card = $(`[data-variant-wrapper="${variant_id}"]`);

//             // card.find(".product-form-submit.addtocart-btn").removeClass("d-none");
//             // card.find(".addtocart-btn").removeClass("d-none").addClass("add_cart");
//             // card.find(".cart-qtyDetail").addClass("d-none");

//             syncLocalCartToUI();


//             // Hide Qty block
//             $(`input.qty[data-variant-id="${variant_id}"]`)
//                 .closest(".qtyDetail")
//                 .addClass("d-none");

//             // Reset qty input to min
//             $(`input.qty[data-variant-id="${variant_id}"]`).each(function () {
//                 let minQty = parseInt($(this).attr("min")) || 1;
//                 $(this).val(minQty);
//             });
//             // mirrorQtyInputs(variant_id, 1);
//             mirrorQtyInputs(variant_id, minVal);
//             $(this).val(minVal);

//             dispatchCartChanged({
//                 variant_id,
//                 qty: 0,
//                 source: "remove_guest"
//             });

//             iziToast.success({
//                 message: "Removed from Cart",
//                 position: "topRight"
//             });

//         } else {
//          // ---------- LOGGED IN ----------
//             let user_id  = $("#user_id").val();
//             let store_id = $("#current_store_id").val();

//             // âœ… DISPATCH EVENT (THIS IS THE KEY)
//             window.dispatchEvent(
//                 new CustomEvent("remove_from_cart", {
//                     detail: {
//                          el: this,
//                         data: {
//                             variant_id: variant_id,
//                             product_type: product_type,
//                             store_id: store_id,
//                             user_id: user_id,
//                         }
//                     }
//                 })
//             );
//         }
//         // â— IMPORTANT: stop execution
//         return;
//     }

//     // âœ… Normal decrement
//     newVal = oldValue - stepSize;
//     if (newVal < minVal) newVal = minVal;
// }



//         // =========================================================================
//         // UPDATE INPUT FIELD + FORCE CHANGE EVENT (VERY IMPORTANT)
//         // =========================================================================
//         inputField.val(newVal).trigger("change");
//     });




//     // =========================================================================
//     // INPUT DIRECT CHANGE â€” UPDATE CART (LOCAL OR BACKEND)
//     // =========================================================================
//     $(document).on("change", "input.qty", function () {

//         let input = $(this);
//         let variant_id = input.data("variant-id");
//         let variant_price = input.data("variant-price");
//         let product_type = input.data("product-type") || "regular";

//         // Safety: if we don't have a variant id, do nothing to avoid 422s
//         if (!variant_id) {
//             console.warn("Missing variant_id on qty input");
//             return;
//         }

//         let maxVal = parseInt(input.attr("max"));
//         if (isNaN(maxVal)) maxVal = Number.MAX_SAFE_INTEGER;
//         let minVal = parseInt(input.attr("min"));
//         if (isNaN(minVal)) minVal = 0;

//         let newVal = parseInt(input.val());
//         if (isNaN(newVal)) newVal = minVal;

//         if (newVal > maxVal) newVal = maxVal;
//         if (newVal < minVal) newVal = minVal;

//         input.val(newVal);

//         let final_price = newVal * parseFloat(variant_price);


//         // --------------------------- GUEST USER ---------------------------
//       if (!is_logged) {
//     debounceCartUpdate(variant_id, function () {
//         let cart = JSON.parse(localStorage.getItem("cart")) || [];
//         let item = cart.find(i => i.product_variant_id == variant_id);

//         if (item) {
//             item.qty = newVal;
//             item.final_price = final_price;
//         }

//         localStorage.setItem("cart", JSON.stringify(cart));
//         display_cart(cart);
//         syncLocalCartToUI();
//         mirrorQtyInputs(variant_id, newVal);
//         dispatchCartChanged({
//             variant_id,
//             qty: newVal,
//             source: "change_guest"
//         });
//     }, 8);

//     return;
// }



//         // --------------------------- LOGGED-IN USER ---------------------------
//       // --------------------------- LOGGED-IN USER ---------------------------
// debounceCartUpdate(variant_id, function () {
//     $.ajax({
//         type: "POST",
//         url: appUrl + "cart/manage-cart",
//         data: {
//             product_variant_id: variant_id,
//             qty: newVal,
//             is_saved_for_later: 0,
//             address_id: 0,
//             product_type
//         },
//         success: function () {
//             mirrorQtyInputs(variant_id, newVal);
//             dispatchCartChanged({
//                 variant_id,
//                 qty: newVal,
//                 source: "change_logged_in"
//             });
//             Livewire.dispatch("refreshComponent");
//             syncBackendCartToLocal();
//         }
//     });
// }, 8); // âœ… 5â€“8 ms debounce


//     });
// }

function disableQtyControls(qtyField) {
    if (!qtyField || !qtyField.length) return;
    qtyField.addClass("qty-loading");
    qtyField.find(".qtyBtn").prop("disabled", true);
    qtyField.find("input.qty").prop("disabled", true);
}

function enableQtyControls(qtyField) {
    if (!qtyField || !qtyField.length) return;
    qtyField.removeClass("qty-loading");
    qtyField.find(".qtyBtn").prop("disabled", false);
    qtyField.find("input.qty").prop("disabled", false);
}
function qnt_incre() {

    // =========================================================================
    // CLICK PLUS / MINUS
    // =========================================================================
    $(document).on("click", ".qtyBtn", function () {
        console.log('click here increment')

        let qtyField = $(this).closest(".qtyField");
        let inputField = qtyField.find(".qty");

        // ðŸ”’ ONLY ADDITION
        disableQtyControls(qtyField);

        // Guard against NaN so calculations stay consistent
        let maxVal = parseInt(inputField.attr("max"));
        if (isNaN(maxVal)) maxVal = Number.MAX_SAFE_INTEGER;
        let minVal = parseInt(inputField.attr("min"));
        if (isNaN(minVal)) minVal = 0;
        let stepSize = parseInt(inputField.attr("step"));
        if (isNaN(stepSize)) stepSize = 1;
        let oldValue = parseInt(inputField.val());
        if (isNaN(oldValue)) oldValue = minVal;

        let variant_id = inputField.data("variant-id");
        let variant_price = inputField.data("variant-price");
        let product_type = inputField.data("product-type") || "regular";
        let name = inputField.data("name");
        let slug = inputField.data("slug");
        let brand_name = inputField.data("brand-name");
        let image = inputField.data("image");
        let store_id = inputField.data("store-id");

        let newVal;
        console.log('variant_id', variant_id, user_id);

        if (!variant_id) {
            enableQtyControls(qtyField);
            return;
        }

        if ($(this).is(".plus")) {

            if (!is_logged) {
                let cart = JSON.parse(localStorage.getItem("cart")) || [];
                let exists = cart.find(item => item.product_variant_id == variant_id);

                if (!exists) {
                    let cart_item = {
                        product_variant_id: variant_id,
                        qty: 1,
                        product_type,
                        variant_price,
                        final_price: parseFloat(variant_price),
                        name,
                        slug,
                        brand_name,
                        min: minVal,
                        max: maxVal,
                        step: stepSize,
                        image,
                        store_id
                    };

                    cart.push(cart_item);
                    localStorage.setItem("cart", JSON.stringify(cart));
                    display_cart(cart);
                    showPdpQtyUI(this);
                    syncLocalCartToUI();
                    mirrorQtyInputs(variant_id, minVal);
                    $(this).val(minVal);
                    dispatchCartChanged({ variant_id, qty: 1, source: "add_guest" });
                    oldValue = 1;

                    enableQtyControls(qtyField);
                }
            } else {
                $.ajax({
                    type: "POST",
                    url: appUrl + "cart/add-to-cart",
                    data: {
                        product_variant_id: variant_id,
                        qty: 1,
                        is_saved_for_later: false,
                        product_type
                    },
                    async: false,
                    success: function () {
                        mirrorQtyInputs(variant_id, oldValue + stepSize);
                        dispatchCartChanged({ variant_id, qty: oldValue + stepSize, source: "add_logged_in" });
                        Livewire.dispatch("refreshComponent");
                        enableQtyControls(qtyField);
                    }
                });
            }
        }

        // =========================================================================
        // INCREMENT / DECREMENT LOGIC
        // =========================================================================
        if ($(this).is(".plus")) {
            console.log('this calll e=which is double')
            newVal = oldValue + stepSize;

            if (newVal > maxVal) {
                newVal = maxVal;
                iziToast.error({
                    message: "Maximum allowable quantity is " + maxVal,
                    position: "topRight",
                });
            }
        } else {

            if (oldValue <= minVal) {

                if (!is_logged) {
                    let cart = JSON.parse(localStorage.getItem("cart")) || [];
                    cart = cart.filter(item => item.product_variant_id != variant_id);
                    localStorage.setItem("cart", JSON.stringify(cart));
                    resetToAddToCartUI(this);
                    resetToAddToCartUIByVariant(variant_id);
                    $(".cart-count").text(cart.length);
                    $(".cart_count").text(cart.length);
                    display_cart(cart);
                    syncLocalCartToUI();

                    $(`input.qty[data-variant-id="${variant_id}"]`)
                        .closest(".qtyDetail")
                        .addClass("d-none");

                    $(`input.qty[data-variant-id="${variant_id}"]`).each(function () {
                        let minQty = parseInt($(this).attr("min")) || 1;
                        $(this).val(minQty);
                    });

                    mirrorQtyInputs(variant_id, minVal);
                    $(this).val(minVal);

                    dispatchCartChanged({
                        variant_id,
                        qty: 0,
                        source: "remove_guest"
                    });

                    iziToast.success({
                        message: "Removed from Cart",
                        position: "topRight"
                    });

                    enableQtyControls(qtyField);

                } else {
                    let user_id = $("#user_id").val();
                    let store_id = $("#current_store_id").val();

                    window.dispatchEvent(
                        new CustomEvent("remove_from_cart", {
                            detail: {
                                el: this,
                                data: {
                                    variant_id: variant_id,
                                    product_type: product_type,
                                    store_id: store_id,
                                    user_id: user_id,
                                }
                            }
                        })
                    );

                    enableQtyControls(qtyField);
                }
                return;
            }

            newVal = oldValue - stepSize;
            if (newVal < minVal) newVal = minVal;
        }

        inputField.val(newVal).trigger("change");
    });

    // =========================================================================
    // INPUT DIRECT CHANGE
    // =========================================================================
    $(document).on("change", "input.qty", function () {

        let input = $(this);
        let qtyField = input.closest(".qtyField");

        // ðŸ”’ ONLY ADDITION
        disableQtyControls(qtyField);

        let variant_id = input.data("variant-id");
        let variant_price = input.data("variant-price");
        let product_type = input.data("product-type") || "regular";

        if (!variant_id) {
            enableQtyControls(qtyField);
            return;
        }

        let maxVal = parseInt(input.attr("max"));
        if (isNaN(maxVal)) maxVal = Number.MAX_SAFE_INTEGER;
        let minVal = parseInt(input.attr("min"));
        if (isNaN(minVal)) minVal = 0;

        let newVal = parseInt(input.val());
        if (isNaN(newVal)) newVal = minVal;

        if (newVal > maxVal) newVal = maxVal;
        if (newVal < minVal) newVal = minVal;

        input.val(newVal);
        let final_price = newVal * parseFloat(variant_price);

        if (!is_logged) {
            debounceCartUpdate(variant_id, function () {
                let cart = JSON.parse(localStorage.getItem("cart")) || [];
                let item = cart.find(i => i.product_variant_id == variant_id);

                if (item) {
                    item.qty = newVal;
                    item.final_price = final_price;
                }

                localStorage.setItem("cart", JSON.stringify(cart));
                display_cart(cart);
                syncLocalCartToUI();
                mirrorQtyInputs(variant_id, newVal);
                dispatchCartChanged({
                    variant_id,
                    qty: newVal,
                    source: "change_guest"
                });

                enableQtyControls(qtyField);
            }, 8);

            return;
        }

        debounceCartUpdate(variant_id, function () {
            $.ajax({
                type: "POST",
                url: appUrl + "cart/manage-cart",
                data: {
                    product_variant_id: variant_id,
                    qty: newVal,
                    is_saved_for_later: 0,
                    address_id: 0,
                    product_type
                },
                success: function () {
                    mirrorQtyInputs(variant_id, newVal);
                    dispatchCartChanged({
                        variant_id,
                        qty: newVal,
                        source: "change_logged_in"
                    });
                    Livewire.dispatch("refreshComponent");
                    syncBackendCartToLocal();
                    enableQtyControls(qtyField);
                }
            });
        }, 8);
    });
}



qnt_incre();
document.addEventListener("livewire:navigating", () => {
    $(".kv-ltr-theme-svg-star").rating("destroy");
});
document.addEventListener("livewire:navigated", () => {
    $(".loading-state").addClass("d-none");
    let store_slug = $("#store_slug").val();
    let current_store_id = $("#current_store_id").val();
    if (store_slug == null || store_slug == "" || store_slug == undefined) {
        store_slug = $("#default_store_slug").val();
    }
    let custom_url = $("#custom_url").val();
    let current_url = $("#current_url").val();

    let primaryColor = $("#store-primary-color").val();
    let secondaryColor = $("#store-secondary-color").val();
    let linkActiveColor = $("#store-link-active-color").val();
    let linkHoverColor = $("#store-link-hover-color").val();
    const root = document.documentElement;
    // Set the CSS variables
    root.style.setProperty("--primary-color", primaryColor);
    root.style.setProperty("--secondary-color", secondaryColor);
    root.style.setProperty("--link-active-color", linkActiveColor);
    root.style.setProperty("--link-hover-color", linkHoverColor);
    console.log(primaryColor, secondaryColor, linkActiveColor, linkHoverColor);

    $(".slider-link").on("click", function (e) {
        let link = $(this).data("link");
        let url = setUrlParameter(link, "store", store_slug);
        Livewire.navigate(url);
    });

    var currency_symbol = $("#currency").val();

    $(".changeLang").on("click", function () {
        let lang = $(this).data("lang-code");
        Livewire.dispatch("changeLang", { lang });
        console.log(lang, 'lang')

    });
    $(".changeCurrency").on("click", function () {
        let currency = $(this).data("currency-code");
        Livewire.dispatch("changeCurrency", { currency });
    });
    if ($("#user_id").val() >= 1) {
        is_logged = true;
    } else {
        is_logged = false;
    }

    // Logged-in: hydrate cart from backend after a page refresh
    if (is_logged) {
        hydrateLoggedInCartUI();
    }

    $(document).on("change", "#prTearm", function () {
        if (!$(this).prop("checked")) {
            $(".cart-checkout").addClass("disabled");
        } else {
            $(".cart-checkout").removeClass("disabled");
        }
    });

    function proceedToCheckoutHandler() {
        if (is_logged == false) {
            iziToast.destroy();
            iziToast.error({
                message: "Please Login First",
                position: "topRight",
            });
            setTimeout(() => {
                let url = setUrlParameter(
                    appUrl + "/login",
                    "store",
                    store_slug
                );
                Livewire.navigate(url);
            }, 1500);
            return false;
        }
        let url = setUrlParameter(
            appUrl + "cart/checkout",
            "store",
            store_slug
        );
        Livewire.navigate(url);
        return false;
    }

    $(document)
        .off("click", ".proceed-to-checkout")
        .on("click", ".proceed-to-checkout", proceedToCheckoutHandler);

    function cartBtnHandler() {
        if (is_logged == false) {
            iziToast.destroy();
            iziToast.error({
                message: "Please Login First",
                position: "topRight",
            });
            setTimeout(() => {
                let url = setUrlParameter(
                    appUrl + "/login",
                    "store",
                    store_slug
                );
                Livewire.navigate(url);
            }, 1500);
            return false;
        }
        let url = setUrlParameter(appUrl + "cart/", "store", store_slug);
        Livewire.navigate(url);
        return false;
    }

    $(document)
        .off("click", ".cart-btn")
        .on("click", ".cart-btn", cartBtnHandler);
    Shareon.init();

    // function product_image_swap() {
    //     $(".swatchLbl").on("click", function () {
    //         alert('here1324');
    //         $(this).parent().siblings(".active").removeClass("active");
    //         $(this).parent().addClass("active");
    //     });
    // }
    // product_image_swap();

    function product_image_swap() {
        $(".swatchLbl").on("click", function () {
            // Handle the active class toggle
            $(this).parent().siblings(".active").removeClass("active");
            $(this).parent().addClass("active");

            // Get new image from the selected variant
            var newImage = $(this).attr("data-image");
            // console.log(newImage);
            var newZoomImage = $(this).attr("data-zoom-image");

            // Update the main product image
            if (newImage && newZoomImage) {
                $("#zoompro").attr("src", newImage);
                $("#zoompro").attr("data-zoom-image", newZoomImage);
            }
        });
    }

    product_image_swap();

    if (is_logged == false) {
        //display local cart
        let cart = localStorage.getItem("cart");
        cart = localStorage.getItem("cart") != null ? JSON.parse(cart) : [];
        display_cart(cart);

        // remove from local storage cart
        $(document).on("click", ".remove_from_cart", function () {
            let product_variant_id = $(this).data("variant-id");

            let cart = JSON.parse(localStorage.getItem("cart")) || [];

            cart = cart.filter(
                item => item.product_variant_id != product_variant_id
            );

            localStorage.setItem("cart", JSON.stringify(cart));

            let cart_count = cart.reduce((sum, item) => sum + Number(item.qty || 0), 0);

            $(".cart-count, .cart_count").text(cart_count);

            display_cart(cart);
        });


    }
    //remove from cart
    window.addEventListener("remove_from_cart", (e) => {

        let { variant_id, store_id, user_id, product_type } = e.detail.data;
        let el = e.detail.el;
        $.ajax({
            type: "POST",
            url: appUrl + "cart/remove-from-cart",
            data: {
                user_id,
                product_variant_id: variant_id,
                product_type,
                store_id,
            },
            success: function (response) {

                if (response.error === false) {

                    iziToast.success({
                        message: response.message,
                        position: "topRight",
                    });
                    let cart = response.data.cart_items || [];
                    console.log("Updated cart:", cart);
                    /* 🔥 REMOVE ITEM MANUALLY */
                    cart = cart.filter(item =>
                        item.product_variant_id != variant_id
                    );
                    /* =========================
                       1ï¸âƒ£ UPDATE CART COUNT
                    ========================= */
                    let count = response.data?.cart_items?.length || 0;
                    $(".cart-count, .cart_count").text(count);

                    /* =========================
                       2ï¸âƒ£ RESET QTY INPUTS
                    ========================= */
                    $(`input.qty[data-variant-id="${variant_id}"]`).each(function () {
                        let minQty = parseInt($(this).attr("min")) || 1;
                        $(this).val(minQty);
                    });
                    display_cart(cart);
                    resetToAddToCartUI(el);
                    resetToAddToCartUIByVariant(variant_id);

                    // const checkbox = $("#prTearm");
                    // const checkoutBtn = $("#checkoutBtn");
                    // const viewCartBtn = $("#viewCartBtn");

                    // checkbox.prop("checked", false);          // uncheck terms
                    // checkoutBtn.addClass("disabled");         // disable checkout
                    // viewCartBtn.addClass("disabled");

                    /* =========================
                       3ï¸âƒ£ TOGGLE BUTTONS (KEY)
                    ========================= */
                    // Show Add to Cart
                    // $(`.addtocart-btn[data-product-variant-id="${variant_id}"]`)
                    //     .removeClass("d-none")
                    //     .addClass("add_cart");

                    // // Hide Qty block
                    // $(`input.qty[data-variant-id="${variant_id}"]`)
                    //     .closest(".qtyDetail")
                    //     .addClass("d-none");

                    /* =========================
                       4ï¸âƒ£ FINAL SYNC
                    ========================= */
                    // mirrorQtyInputs(variant_id, 1);
                    // mirrorQtyInputs(variant_id, minVal);
                    // $(this).val(minVal);


                    // display_cart(response.data.cart_items);
                    syncBackendCartToLocal();
                    Livewire.dispatch("refreshComponent");

                    return;
                }

                iziToast.error({
                    message: response.message,
                    position: "topRight",
                });
            }
        });
    });


    // add to favorite

    // $(".add-favorite").on("click", function () {
    //     let product_id = $(this).data("product-id");
    //     let product_type = $(this).data("product-type");
    //     if (product_type == undefined || product_type == null) {
    //         product_type = "regular";
    //     }
    //     let user_id = $("#user_id").val();
    //     let t = $(this);
    //     if (user_id == null || user_id == "") {
    //         iziToast.error({
    //             message: "Please Login First",
    //             position: "topRight",
    //         });
    //         return;
    //     }
    //     $.ajax({
    //         url: appUrl + "product/add-to-favorite",
    //         method: "POST",
    //         data: {
    //             product_id,
    //             user_id,
    //             product_type,
    //         },
    //         dataType: "json",
    //         success: function (response) {
    //             if (response.error == false) {
    //                 if (t.hasClass("card_fav_btn")) {
    //                     t.addClass("remove-favorite")
    //                         .removeClass("add-favorite")
    //                         .children("ion-icon")
    //                         .attr("name", "heart")
    //                         .addClass("text-danger");
    //                 } else {
    //                     $(".add-favorite")
    //                         .removeClass("d-flex")
    //                         .addClass("d-none");
    //                     $(".remove-favorite")
    //                         .removeClass("d-none")
    //                         .addClass("d-flex");
    //                 }
    //                 $(".wishlist-count").text(response["wishlist_count"]);
    //                 iziToast.success({
    //                     message:
    //                         "An item has been successfully added to your wishlist.",
    //                     position: "topRight",
    //                 });
    //             }
    //         },
    //     });
    // });

    $(document).on("click", ".add-favorite", function () {
        let product_id = $(this).data("product-id");
        let product_type = $(this).data("product-type") || "regular";
        let user_id = $("#user_id").val();
        let t = $(this);

        if (!user_id) {
            iziToast.destroy();
            iziToast.error({
                message: "Please Login First",
                position: "topRight",
            });
            return;
        }

        $.ajax({
            url: appUrl + "product/add-to-favorite",
            method: "POST",
            data: { product_id, user_id, product_type },
            dataType: "json",
            success: function (response) {
                if (!response.error) {
                    if (t.hasClass("card_fav_btn")) {
                        t.removeClass("add-favorite").addClass("remove-favorite");
                        t.children("i")
                            .removeClass("anm-heart-l")
                            .addClass("anm-heart text-danger");

                        // Update Tooltip
                        t.attr("title", "Remove From Wishlist")
                            .tooltip("dispose")
                            .tooltip();
                    } else {
                        // For product details page where add/remove are separate buttons
                        t.removeClass("d-flex").addClass("d-none");
                        t.siblings(".remove-favorite").removeClass("d-none").addClass("d-flex");
                    }

                    $(".wishlist-count").text(response["wishlist_count"]);

                    iziToast.success({
                        message: "Item added to wishlist successfully.",
                        position: "topRight",
                    });
                }
            },
        });
    });

    // remove from favorite

    $(document).on("click", ".remove-favorite", function (e) {
        e.preventDefault();

        let productId = $(this).attr("data-product-id");
        let productType = $(this).attr("data-product-type") || "regular";
        let user_id = $("#user_id").val();
        let t = $(this);

        Swal.fire({
            title: "Do you Really want to Remove This from Wishlist?",
            showCancelButton: true,
            confirmButtonText: "Yes Remove",
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: appUrl + "product/remove-from-favorite",
                    method: "POST",
                    data: { productId, user_id, productType },
                    dataType: "json",
                    success: function (response) {
                        if (!response.error) {
                            if (t.hasClass("card_fav_btn")) {
                                // For product cards where a single button toggles
                                t.removeClass("remove-favorite").addClass("add-favorite");
                                t.children("i")
                                    .removeClass("anm-heart text-danger")
                                    .addClass("anm-heart-l");

                                t.attr("title", "Add to Wishlist")
                                    .tooltip("dispose")
                                    .tooltip();
                            } else {
                                // For product details page where add/remove are separate buttons
                                t.removeClass("d-flex").addClass("d-none");
                                t.siblings(".add-favorite").removeClass("d-none").addClass("d-flex");
                            }

                            $(".wishlist-count").text(response["wishlist_count"]);
                            $(".favorite_count").text(response["wishlist_count"] + " items");
                            Livewire.dispatch("refreshComponent");

                            iziToast.success({
                                message: "The item has been removed from your wishlist.",
                                position: "topRight",
                            });
                        }
                    },
                });
            }
        });
    });

    window.addEventListener("quickview", (event) => {
        setTimeout(() => {
            if ($(".kv-ltr-theme-svg-star").length > 0) {
                $(".kv-ltr-theme-svg-star").rating({
                    hoverOnClear: false,
                    theme: "krajee-svg",
                });
            }
            attributes();
            add_cart();
            Shareon.init();
        }, 1000);
    });


    // add to compare
    // $(".add-compare").on("click", function (e) {
    //     let product_id = $(this).attr("data-product-id");
    //     let product_type = $(this).attr("data-product-type");
    //     if (product_type == undefined || product_type == null) {
    //         product_type = "regular";
    //     }
    //     e.preventDefault();
    //     let compare_item = {
    //         product_id: product_id.trim(),
    //         product_type: product_type.trim(),
    //     };
    //     let compare = localStorage.getItem("compare");

    //     compare = compare !== null ? JSON.parse(compare) : null;
    //     if (compare !== null && compare !== undefined) {
    //         if (compare.find((item) => item.product_id === product_id)) {
    //             iziToast.destroy();
    //             iziToast.error({
    //                 message:
    //                     "This Product is already present in your Compare List",
    //                 position: "topRight",
    //             });
    //             return;
    //         }
    //         compare.push(compare_item);
    //     } else {
    //         compare = [compare_item];
    //     }
    //     localStorage.setItem("compare", JSON.stringify(compare));
    //     iziToast.success({
    //         message: "Product Added To Compare",
    //         position: "topRight",
    //     });
    // });


    $(".add-compare").on("click", function (e) {
        e.preventDefault();

        let product_id = $(this).attr("data-product-id").toString().trim();
        let product_type = $(this).attr("data-product-type") || "regular";

        let compare_item = {
            product_id: product_id,
            product_type: product_type.trim(),
            product_id: $(this).attr("data-product-id").toString().trim(),
            product_type: $(this).attr("data-product-type") || "regular",
            product_variant_id: $(this).attr("data-product-variant-id") || null,
            product_reference_id: $(this).attr("data-product-reference-id") || null,
            variant_price: $(this).attr("data-variant-price") || null,
            name: $(this).attr("data-name") || null,
            slug: $(this).attr("data-slug") || null,
            brand_name: $(this).attr("data-brand-name") || null,
            min: $(this).attr("data-min") || null,
            max: $(this).attr("data-max") || null,
            step: $(this).attr("data-step") || null,
            image: $(this).attr("data-image") || null,
            store_id: $(this).attr("data-store-id") || null,
        };

        let compare = JSON.parse(localStorage.getItem("compare")) || [];

        if (compare.some(item => item.product_id.toString().trim() === product_id)) {
            iziToast.error({
                message: "This Product is already present in your Compare List",
                position: "topRight",
            });
            return;
        }

        compare.push(compare_item);
        localStorage.setItem("compare", JSON.stringify(compare));

        // ðŸ”¥ IMPORTANT: notify UI
        window.dispatchEvent(new Event("compareUpdated"));

        iziToast.success({
            message: "Product Added To Compare",
            position: "topRight",
        });
    });

    $(document).off("click", ".remove_compare_item").on("click", ".remove_compare_item", function (e) {
        e.preventDefault();

        let product_id = $(this).attr("data-product-id").toString().trim();

        let compare = JSON.parse(localStorage.getItem("compare")) || [];

        compare = compare.filter(item => item.product_id.toString().trim() !== product_id);

        localStorage.setItem("compare", JSON.stringify(compare));

        window.dispatchEvent(new Event("compareUpdated")); // update UI

        iziToast.success({
            message: "Product removed from compare list",
            position: "topRight",
        });

        display_compare();
    });

    $(".star-rating").on("rating:change", function (event, value, caption) {
        Livewire.dispatch("updateRating", { update_rating: value });
    });

    function attributes() {
        $(".attributes").on("change", function (e) {
            e.preventDefault();
            let prices = [];
            let variant_ids = [];
            let variant_prices = [];
            let variant = [];
            let variants = [];
            let attributes_length = [];
            let selected_attributes = [];
            let is_variant_available = false;
            let price = "";
            $(".variants").each(function () {
                prices = {
                    price: $(this).data("price"),
                    spacial_price: $(this).data("special_price"),
                };
                variant_ids.push($(this).data("id"));
                variant_prices.push(prices);
                variant = $(this).val().split(",");
                variants.push(variant);
            });
            attributes_length = variant.length;
            $(this).parent().siblings().children().prop("checked", false);
            $(".attributes").each(function (i, e) {
                if ($(this).prop("checked")) {
                    selected_attributes.push($(this).val());
                    var selected_variant_id = "";
                    if (selected_attributes.length == attributes_length) {
                        prices = [];
                        var selected_variant_id = "";
                        $.each(variants, function (i, e) {
                            if (arrays_equal(selected_attributes, e)) {
                                is_variant_available = true;
                                prices.push(variant_prices[i]);
                                selected_variant_id = variant_ids[i];
                            }
                        });
                        if (is_variant_available) {
                            $("#add_cart").attr(
                                "data-product-variant-id",
                                selected_variant_id
                            );
                            $(".modal_add_cart").attr(
                                "data-product-variant-id",
                                selected_variant_id
                            );
                            $(".dlt-add-cart").attr(
                                "data-product-variant-id",
                                selected_variant_id
                            );
                            if (
                                prices[0].spacial_price < prices[0].price &&
                                prices[0].spacial_price != 0
                            ) {
                                price = parseFloat(prices[0].spacial_price);
                                $(".add_cart").attr(
                                    "data-variant-price",
                                    prices[0].spacial_price
                                );
                                $(".product_price").html(
                                    currency_symbol + price.toFixed(2)
                                );
                            } else {
                                price = parseFloat(prices[0].price);
                                $(".add_cart").attr(
                                    "data-variant-price",
                                    prices[0].price
                                );
                                $(".product_price").html(
                                    currency_symbol + price.toFixed(2)
                                );
                            }
                            $(".add_cart").removeAttr("disabled");
                        } else {
                            price = "No variant Available!";
                            $(".product_price").html(price);
                            $(".add_cart").attr("disabled", "true");
                        }
                    }
                }
            });
        });
    }
    attributes();

    initialize();
    if ($(".kv-ltr-theme-svg-star").length > 0) {
        $(".kv-ltr-theme-svg-star").rating({
            hoverOnClear: false,
            theme: "krajee-svg",
        });
    }

    function goBack() {
        parent.history.back();
    }
    // $(document).on("click", ".remove_compare_item", function (e) {
    //     e.preventDefault();
    //     let product_id = $(this).attr("data-product-id");

    //     var compare_count = $("#compare_count").text();
    //     compare_count--;

    //     $("#compare_count").html(compare_count);
    //     $(".compare" + product_id).remove();
    //     if (compare_count == 0) {
    //         $(".compare_item").remove();
    //         let comp = "";
    //         comp +=
    //             '<div id="page-content"><div class="container"><div class="row">' +
    //             '<div class="col-12 col-sm-12 col-md-12 col-lg-12 text-center">' +
    //             '<p><img src="' +
    //             appUrl +
    //             "frontend/elegant/images/empty-img.gif" +
    //             '" alt="image"  width="500" /></p>' +
    //             '<h2 class="fs-4 mt-4"><strong>SORRY,</strong> This Compare is currently empty</h2>' +
    //             '<p class="same-width-btn"><a wire:navigate href="#" onClick="goBack()" class="btn btn-secondary btn-lg mb-2 mx-3">GO Back</a></p>' +
    //             "</div></div></div> </div>`";
    //         $("#compare_item").html(comp);
    //     }

    //     let compare = localStorage.getItem("compare");
    //     compare = compare !== null ? JSON.parse(compare) : null;
    //     if (compare) {
    //         let new_compare = compare.filter(function (item) {
    //             return item.product_id != product_id;
    //         });
    //         localStorage.setItem("compare", JSON.stringify(new_compare));
    //         display_compare();
    //     }
    // });

    $(document).ready(function () {

        // Show data on first load
        display_compare();

        // ✅ Listen for compareUpdated event (from add/remove)
        window.addEventListener('compareUpdated', function () {
            display_compare();
        });

        // Desktop tab click
        $('.tablink').on('click', function () {
            var rel = $(this).attr('rel');

            $('.product-tabs li').removeClass('active');
            $('.tab-content').removeClass('active');

            $(this).parent('li').addClass('active');
            $('#' + rel).addClass('active');

            if (rel === 'compare_list_box') {
                display_compare(); // show compare
            }
        });

        // Mobile accordion click
        $('.tabs-ac-style').on('click', function () {
            var rel = $(this).attr('rel');

            $('.tabs-ac-style').removeClass('active');
            $('.tab-content').removeClass('active');

            $(this).addClass('active');
            $('#' + rel).addClass('active');

            if (rel === 'compare_list_box') {
                display_compare();
            }
        });

    });
    let compareUrl = custom_url.split("?");
    if (compareUrl[0] === appUrl + "compare") {
        if (localStorage.getItem("compare")) {
            var compare = localStorage.getItem("compare").length;
            compare = compare !== null ? JSON.parse(compare) : null;
            if (compare) {
                display_compare();
            }
        }
    }

    function cart_sync() {
        let cart = localStorage.getItem("cart");
        cart = localStorage.getItem("cart") != null ? JSON.parse(cart) : "";
        if (cart != "" && cart != undefined) {
            let product_variant_id = [];
            let qty = [];
            let product_type = [];
            let store_id = [];
            cart.forEach((e) => {
                product_variant_id.push(e.product_variant_id);
                qty.push(e.qty);
                product_type.push(e.product_type);
                store_id.push(e.store_id);
            });
            $.ajax({
                type: "POST",
                url: appUrl + "cart/cart-sync",
                data: {
                    product_variant_id: product_variant_id,
                    qty: qty,
                    product_type: product_type,
                    store_id: store_id,
                    is_saved_for_later: false,
                },
                dataType: "json",
                success: function (response) {
                    if (response.error == false) {
                        Livewire.dispatch("refreshComponent");
                        $(".cart-count").text(response.cart_count);
                        localStorage.removeItem("cart");
                        iziToast.success({
                            message: response.message,
                            position: "topRight",
                        });
                        return;
                    }
                    localStorage.removeItem("cart");
                    iziToast.error({
                        message: response.message,
                        position: "topRight",
                    });
                    return;
                },
            });
            return;
        }
        return;
    }
    if (is_logged == true) {
        cart_sync();
    }

    initListner("click", ".select-store", function () {
        let store_id = $(this).data("store-id");
        let store_name = $(this).data("store-name");
        let store_image = $(this).data("store-image");
        let store_slug = $(this).data("store-slug");

        $.ajax({
            type: "POST",
            url: "/set_store",
            data: {
                store_id,
                store_name,
                store_image,
                store_slug,
            },
            success: function (data) {
                if (data) {
                } else {
                    iziToast.error({
                        message: "Error In Setting Store",
                        position: "topRight",
                    });
                }
                let url = setUrlParameter(current_url, "store", store_slug);
                Livewire.navigate(url);
            },
        });
    });

    $(document).on("click", ".store-show", function () {
        $(".stores-main").addClass("sticky-stores-active");
        $(".store-show")
            .children("ion-icon")
            .attr("name", "chevron-forward-outline");
        $(this).removeClass("store-show");
        $(this).addClass("store-hide");
    });

    $(document).on("click", ".store-hide", function () {
        $(".stores-main").removeClass("sticky-stores-active");
        $(".store-hide")
            .children("ion-icon")
            .attr("name", "chevron-back-outline");
        $(this).removeClass("store-hide");
        $(this).addClass("store-show");
    });

    function setUrlParameter(url, paramName, paramValue) {
        paramName = paramName.replace(/\s+/g, "-");
        if (paramValue == null || paramValue == "") {
            return url
                .replace(
                    new RegExp("[?&]" + paramName + "=[^&#]*(#.*)?$"),
                    "$1"
                )
                .replace(new RegExp("([?&])" + paramName + "=[^&]*&"), "$1");
        }
        var pattern = new RegExp("\\b(" + paramName + "=).*?(&|#|$)");
        if (url.search(pattern) >= 0) {
            return url.replace(pattern, "$1" + paramValue + "$2");
        }
        url = url.replace(/[?#]$/, "");
        return (
            url +
            (url.indexOf("?") > 0 ? "&" : "?") +
            paramName +
            "=" +
            paramValue
        );
    }

    $(document).on("change", "#SortBy", function (e) {
        e.preventDefault();
        var sort = $(this).val();
        let link = setUrlParameter(location.href, "sort", sort);
        Livewire.navigate(link);
    });
    $(document).on("click", ".list_view", function (e) {
        e.preventDefault();
        var list_view = $(this).data("value");
        let link = setUrlParameter(location.href, "mode", list_view);
        Livewire.navigate(link);
    });

    $(document).on("change", "#perPage", function (e) {
        e.preventDefault();
        var perPage = $(this).val();
        let link = setUrlParameter(location.href, "perPage", perPage);
        Livewire.navigate(link);
    });

    $(document).on("click", ".bySearch", function (e) {
        e.preventDefault();
        let search = $(".search_text").val();
        let search_text = search.split(" ").join("_");
        let link = setUrlParameter(appUrl + "products/", "search", search_text);
        if (search != "") {
            Livewire.navigate(link);
        }
    });
    $(document).on("click", ".quick-view-modal", function (e) {
        e.preventDefault();
        let product_id = $(this).data("product-id");
        let product_type = $(this).data("product-type");
        if (product_type == undefined || product_type == null) {
            product_type = "regular";
        }
        if (product_id != null && product_id != undefined) {
            Livewire.dispatch("quick_view", {
                id: product_id,
                product_type: product_type,
            });
        }
    });

    $("#search-drawer").on("shown.bs.offcanvas", function () {
        $(".searchInput").trigger("focus");
    });

    $("#quickview_modal").on("hidden.bs.modal", function () {
        Livewire.dispatch("clear_quickview_modal");
    });

    function getUrlParameter(sParam, custom_url = "") {
        sParam = sParam.replace(/\s+/g, "-");
        if (custom_url != "") {
            if (custom_url.indexOf("?") > -1) {
                var sPageURL = custom_url.substring(
                    custom_url.indexOf("?") + 1
                );
            } else {
                return undefined;
            }
        } else {
            var sPageURL = window.location.search.substring(1);
        }

        var sURLVariables = sPageURL.split("&"),
            sParameterName,
            i;

        for (i = 0; i < sURLVariables.length; i++) {
            sParameterName = sURLVariables[i].split("=");

            if (sParameterName[0] === sParam) {
                return sParameterName[1] === undefined
                    ? true
                    : decodeURIComponent(sParameterName[1]);
            }
        }
    }

    function buildUrlParameterValue(
        paramName,
        paramValue,
        action,
        custom_url = ""
    ) {
        if (custom_url != "") {
            var param = getUrlParameter(paramName, custom_url);
        } else {
            var param = getUrlParameter(paramName);
        }
        if (action == "add") {
            if (param == undefined) {
                param = paramValue;
            } else {
                param += "|" + paramValue;
            }
            return param;
        } else if (action == "remove") {
            if (param != undefined) {
                param = param.split("|");
                param.splice($.inArray(paramValue, param), 1);
                return param.join("|");
            } else {
                return "";
            }
        }
    }

    $(document).on("change", ".product-filter", function (e) {
        e.preventDefault();
        var attribute_name = $(this).data("attribute");
        attribute_name = "filter-" + attribute_name;
        var get_param = getUrlParameter(attribute_name);
        var current_param_value = $(this).val();
        if (get_param == undefined) {
            get_param = "";
        }
        if (this.checked) {
            var param = buildUrlParameterValue(
                attribute_name,
                current_param_value,
                "add",
                custom_url
            );
        } else {
            var param = buildUrlParameterValue(
                attribute_name,
                current_param_value,
                "remove",
                custom_url
            );
        }
        custom_url = setUrlParameter(custom_url, attribute_name, param);
    });

    $(".product-filter-btn").on("click", function (e) {
        e.preventDefault();
        Livewire.navigate(custom_url);
    });

    $(document).on("click", ".logout", function (e) {
        e.preventDefault();
        $.ajax({
            type: "get",
            url: appUrl + "login/logout",
            data: "",
            dataType: "json",
            success: function (response) {
                iziToast.destroy();
                iziToast.success({
                    message: response.message,
                    position: "topRight",
                });
                location.reload();
                return;
            },
        });
    });
    $(document).on("change", ".brand", function (e) {
        e.preventDefault();
        let t = $(this).val();
        let u = $(this)
            .parent()
            .siblings()
            .children(".brand")
            .prop("checked", false)
            .val();
        var param = buildUrlParameterValue("brand", u, "remove", custom_url);
        custom_url = setUrlParameter(custom_url, "brand", param);
        if (this.checked) {
            var param = buildUrlParameterValue("brand", t, "add", custom_url);
        } else {
            var param = buildUrlParameterValue(
                "brand",
                t,
                "remove",
                custom_url
            );
        }
        custom_url = setUrlParameter(custom_url, "brand", param);
    });

    // price slider
    //     function price_slider() {
    //         const $slider = $("#slider-range");
    //         if (!$slider.length) return; // nothing to init

    //         // Always pull the latest values so the slider reflects refreshed filters
    //         // Get min/max from hidden inputs - ensure they're valid numbers
    //         let min_price = parseFloat($("#min-price").val());
    //         let max_price = parseFloat($("#max-price").val());

    //         // If min_price is 0 or invalid, try to get from input field attributes
    //         if (isNaN(min_price) || min_price <= 0) {
    //             min_price = parseFloat($("#min-price-input").attr('min')) || 0;
    //         }
    //         if (isNaN(max_price) || max_price <= 0) {
    //             max_price = parseFloat($("#max-price-input").attr('max')) || 0;
    //         }

    //         // If min_price is 0 but max_price > 0, try to get actual min from selected_min_price
    //         // or set a reasonable minimum (1% of max_price, minimum 1)




    //         let selected_min_price = parseFloat($("#selected_min_price").val());
    //         let selected_max_price = parseFloat($("#selected_max_price").val());

    //         // Use actual min/max if selected values are invalid
    //         if (isNaN(selected_min_price) || selected_min_price < min_price) {
    //             selected_min_price = min_price;
    //         }
    //         if (isNaN(selected_max_price) || selected_max_price > max_price) {
    //             selected_max_price = max_price;
    //         }

    //         // Clamp selections to the actual available range to avoid slider snapping to ends
    //         selected_min_price = Math.min(Math.max(selected_min_price, min_price), max_price);
    //         selected_max_price = Math.min(Math.max(selected_max_price, min_price), max_price);
    //         if (selected_max_price < selected_min_price) {
    //             selected_max_price = selected_min_price;
    //         }
    //         $("#selected_min_price").val(selected_min_price);
    //         $("#selected_max_price").val(selected_max_price);

    //         // When the page re-renders via Livewire, refresh the slider options instead of keeping the stale range
    //         if ($slider.hasClass("ui-slider")) {
    //             $slider.slider("option", {
    //                 range: true,
    //                 min: min_price,
    //                 max: max_price,
    //                 step: 0.01, // Allow decimal precision to prevent rounding
    //                 values: [selected_min_price, selected_max_price],
    //             });
    //             // Sync input fields after slider refresh
    //             if ($("#min-price-input").length) {
    //                 $("#min-price-input").val(parseFloat(selected_min_price).toFixed(2));
    //                 $("#max-price-input").val(parseFloat(selected_max_price).toFixed(2));
    //             }
    //         } else {
    //           $slider.slider({
    //     range: true,
    //     min: 0,
    //     max: max_price,
    //     step: 0.01,
    //     values: [selected_min_price, selected_max_price],
    //     slide: function (event, ui) {
    //         $("#amount").val(
    //             currency_symbol + ui.values[0].toFixed(2) +
    //             " - " +
    //             currency_symbol + ui.values[1].toFixed(2)
    //         );
    //         $("#min-price").val(ui.values[0]);
    //         $("#max-price").val(ui.values[1]);
    //         $("#min-price-input").val(ui.values[0].toFixed(2));
    //         $("#max-price-input").val(ui.values[1].toFixed(2));
    //     }
    // });

    //         }

    //         // Update amount display with precise values (no rounding)
    //         let sliderMin = parseFloat($slider.slider("values", 0));
    //         let sliderMax = parseFloat($slider.slider("values", 1));
    //         $("#amount").val(
    //             currency_symbol +
    //             sliderMin.toFixed(2) +
    //             " - " +
    //             currency_symbol +
    //             sliderMax.toFixed(2)
    //         );

    //         // Sync input fields with slider values (use parseFloat to maintain precision)
    //         if ($("#min-price-input").length) {
    //             $("#min-price-input").val(parseFloat($slider.slider("values", 0)).toFixed(2));
    //             $("#max-price-input").val(parseFloat($slider.slider("values", 1)).toFixed(2));
    //         }

    //         // Remove old event listeners to prevent duplicates
    //         $("#min-price-input, #max-price-input").off("input change blur");

    //         // Function to update slider and hidden fields from input values
    //         function updateSliderFromInputs() {
    //             if (!$("#min-price-input").length) return;

    //             let minInput = parseFloat($("#min-price-input").val());
    //             let maxInput = parseFloat($("#max-price-input").val());

    //             // Use current slider values if inputs are empty or invalid
    //             if (isNaN(minInput) || minInput === '') {
    //                 minInput = parseFloat($slider.slider("values", 0));
    //             }
    //             if (isNaN(maxInput) || maxInput === '') {
    //                 maxInput = parseFloat($slider.slider("values", 1));
    //             }

    //             // Clamp values to valid range
    //             minInput = Math.min(Math.max(minInput, min_price), max_price);
    //             maxInput = Math.min(Math.max(maxInput, min_price), max_price);

    //             // Ensure min doesn't exceed max
    //             if (minInput > maxInput) {
    //                 minInput = maxInput;
    //                 $("#min-price-input").val(minInput.toFixed(2));
    //             }

    //             // Ensure max is not less than min
    //             if (maxInput < minInput) {
    //                 maxInput = minInput;
    //                 $("#max-price-input").val(maxInput.toFixed(2));
    //             }

    //             // Update slider
    //             $slider.slider("values", [minInput, maxInput]);

    //             // Update hidden fields (used by filter button)
    //             $("#min-price").val(minInput);
    //             $("#max-price").val(maxInput);

    //             // Update amount display
    //             $("#amount").val(
    //                 currency_symbol + minInput.toFixed(2) + " - " + currency_symbol + maxInput.toFixed(2)
    //             );
    //         }

    //         // Sync slider when user types in input fields (real-time)
    //         $("#min-price-input, #max-price-input").on("input", function() {
    //             updateSliderFromInputs();
    //         });

    //         // Also update on blur/change for better validation
    //         $("#min-price-input, #max-price-input").on("blur change", function() {
    //             updateSliderFromInputs();
    //         });
    //     }
    //     price_slider();
    //     // Re-run after Livewire navigation so the slider picks up the new min/max from the response
    //     document.addEventListener("livewire:navigated", price_slider);


    function price_slider() {
        const $slider = $("#slider-range");
        if (!$slider.length) return;

        // ==========================
        // CONSTANTS (NO ZERO EVER)
        // ==========================
        const MIN_LIMIT = 1;
        const MAX_LIMIT = Math.max(
            parseFloat($("#max-price-input").attr("max")) || MIN_LIMIT,
            MIN_LIMIT
        );

        // ==========================
        // INITIAL VALUES
        // ==========================
        let sliderMin = parseFloat($("#selected_min_price").val());
        let sliderMax = parseFloat($("#selected_max_price").val());

        if (isNaN(sliderMin) || sliderMin < MIN_LIMIT) sliderMin = MIN_LIMIT;
        if (isNaN(sliderMax) || sliderMax < MIN_LIMIT) sliderMax = MAX_LIMIT;

        // ==========================
        // INIT SLIDER
        // ==========================
        if (!$slider.hasClass("ui-slider")) {
            $slider.slider({
                range: true,
                min: MIN_LIMIT,
                max: MAX_LIMIT,
                step: 1,
                values: [sliderMin, sliderMax],
                slide: function (event, ui) {
                    updateAll(ui.values[0], ui.values[1]);
                }
            });
        } else {
            $slider.slider("values", [sliderMin, sliderMax]);
        }

        updateAll(sliderMin, sliderMax);

        // ==========================
        // INPUT TYPING (NO FORCE)
        // ==========================
        $("#min-price-input, #max-price-input")
            .off("input")
            .on("input", function () {
                let minRaw = $("#min-price-input").val();
                let maxRaw = $("#max-price-input").val();

                let minVal = minRaw === "" ? null : parseFloat(minRaw);
                let maxVal = maxRaw === "" ? null : parseFloat(maxRaw);

                syncFromInputs(minVal, maxVal);
            });

        // ==========================
        // BLUR VALIDATION
        // ==========================
        $("#min-price-input, #max-price-input")
            .off("blur")
            .on("blur", function () {
                let minVal = $("#min-price-input").val();
                let maxVal = $("#max-price-input").val();

                minVal = minVal === "" ? MIN_LIMIT : parseFloat(minVal);
                maxVal = maxVal === "" ? MAX_LIMIT : parseFloat(maxVal);

                if (minVal < MIN_LIMIT) minVal = MIN_LIMIT;
                if (maxVal < MIN_LIMIT) maxVal = MIN_LIMIT;
                if (minVal > maxVal) minVal = maxVal;

                updateAll(minVal, maxVal);
                $slider.slider("values", [minVal, maxVal]);
            });

        // ==========================
        // CORE FUNCTIONS
        // ==========================
        function syncFromInputs(minVal, maxVal) {

            // both empty â†’ do nothing (let user type)
            if (minVal === null && maxVal === null) return;

            let current = $slider.slider("values");

            if (minVal === null) minVal = current[0];
            if (maxVal === null) maxVal = current[1];

            if (minVal < MIN_LIMIT) minVal = MIN_LIMIT;
            if (maxVal < MIN_LIMIT) maxVal = MIN_LIMIT;
            if (minVal > maxVal) return;

            // âœ… ONLY update slider + amount
            $slider.slider("values", [minVal, maxVal]);

            $("#amount").val(
                currency_symbol +
                minVal.toFixed(2) +
                " - " +
                currency_symbol +
                maxVal.toFixed(2)
            );
        }


        function resetSlider() {
            updateAll(MIN_LIMIT, MAX_LIMIT);
            $slider.slider("values", [MIN_LIMIT, MAX_LIMIT]);
        }

        function updateAll(minVal, maxVal) {
            minVal = Math.max(minVal ?? MIN_LIMIT, MIN_LIMIT);
            maxVal = Math.max(maxVal ?? MAX_LIMIT, MIN_LIMIT);

            $("#min-price-input").val(minVal);
            $("#max-price-input").val(maxVal);

            $("#min-price").val(minVal);
            $("#max-price").val(maxVal);

            $("#selected_min_price").val(minVal);
            $("#selected_max_price").val(maxVal);

            $("#amount").val(
                currency_symbol +
                minVal.toFixed(2) +
                " - " +
                currency_symbol +
                maxVal.toFixed(2)
            );
        }
    }

    // INIT
    price_slider();
    document.addEventListener("livewire:navigated", price_slider);

    initListner("click", ".price-filter-btn", function (e) {
        e.preventDefault();

        // Get values from input fields (user-friendly inputs) or fallback to hidden fields
        let min_price_val, max_price_val;

        if ($("#min-price-input").length) {
            min_price_val = parseFloat($("#min-price-input").val());
            if (isNaN(min_price_val)) {
                min_price_val = parseFloat($("#min-price").val());
            }
        } else {
            min_price_val = parseFloat($("#min-price").val());
        }

        if ($("#max-price-input").length) {
            max_price_val = parseFloat($("#max-price-input").val());
            if (isNaN(max_price_val)) {
                max_price_val = parseFloat($("#max-price").val());
            }
        } else {
            max_price_val = parseFloat($("#max-price").val());
        }

        // Ensure values are valid numbers
        if (isNaN(min_price_val) || min_price_val < 0) min_price_val = 0;
        if (isNaN(max_price_val) || max_price_val < 0) max_price_val = 0;

        // Ensure min doesn't exceed max
        if (min_price_val > max_price_val) {
            max_price_val = min_price_val;
        }

        // Update hidden fields to ensure consistency
        $("#min-price").val(min_price_val);
        $("#max-price").val(max_price_val);

        // Apply filter
        custom_url = setUrlParameter(custom_url, "min_price", min_price_val);
        custom_url = setUrlParameter(custom_url, "max_price", max_price_val);
        Livewire.navigate(custom_url);
    });

    $(".show_tabs").on("click", function () {
        $(".widget-title").trigger("click");
        $(this).addClass("d-none");
        $(".close_tabs").removeClass("d-none");
    });
    $(".close_tabs").on("click", function () {
        $(".widget-title").trigger("click");
        $(this).addClass("d-none");
        $(".show_tabs").removeClass("d-none");
    });
    window.addEventListener("toast_fire", (e) => {
        if (e.detail.data.type == "success") {
            iziToast.success({
                message: e.detail.data.message,
                position: "topRight",
            });
            return;
        }
        iziToast.error({
            message: e.detail.data.message,
            position: "topRight",
        });
    });

    $(".add_address").on("click", function () {
        let name = $("#name").val();
        $(".add_address").html("Add Address");
        let type = $("#address_type").val();
        let mobile = $("#address_mobile").val();
        let alternate_mobile = $("#alternate_mobile").val();
        let address = $("#form_address").val();
        let landmark = $("#landmark").val();
        let city_list = $("#city_list").val();
        let postcode = $("#postcode").val();
        let state = $("#state").val();
        let country = $("#country_list").val();
        let latitude = $("#latitude").val();
        let longitude = $("#longitude").val();
        let address_id = $("#edit_address_id").val();

        let pincodeRegex = /^[1-9][0-9]{5}$/;

        if (postcode && !pincodeRegex.test(postcode)) {
            iziToast.error({
                message: "Please enter a valid 6-digit pincode",
                position: "topRight",
            });
            $("#postcode").focus();
            return;
        }

        $.ajax({
            type: "POST",
            url: appUrl + "addresses/add_address",
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
            data: {
                name: name,
                type: type,
                mobile: mobile,
                alternate_mobile: alternate_mobile,
                address: address,
                landmark: landmark,
                city: city_list,
                pincode: postcode,
                state: state,
                country: country,
                latitude: latitude,
                longitude: longitude,
                address_id: address_id,
            },
            success: function (response) {
                // if (response.error == true) {
                //     $.each(response.message, function (key, value) {
                //         iziToast.error({
                //             message: value[0],
                //             position: "topRight",
                //         });
                //         return false;
                //     });
                //     return false;
                // }
                if (response.error === true) {
                    $.each(response.message, function (key, value) {
                        iziToast.error({
                            message: value[0],
                            position: "topRight",
                        });
                    });
                    return;
                }
                iziToast.success({
                    message: response.message,
                    position: "topRight",
                });
                Livewire.dispatch("refreshComponent");
                $("#addNewModal").modal("hide");
            },
        });
    });
    $("#addNewModal").on("hidden.bs.modal", function () {
        $("#name").val("");
        $("#address_type").val("");
        $("#address_mobile").val("");
        $("#alternate_mobile").val("");
        $("#form_address").val("");
        $("#landmark").val("");
        $("#city_list").val("");
        $("#postcode").val("");
        $("#state").val("");
        $("#country_list").val("");
        $("#latitude").val("");
        $("#longitude").val("");
        $("#edit_address_id").val("");
    });
    $(".edit-address-btn").on("click", function () {
        var addressId = $(this).data("address-id");
        $("#edit_address_id").val(addressId);
        $.ajax({
            url: appUrl + "my-account/addresses/edit_address",
            method: "GET",
            data: { address_id: addressId },
            success: function (response) {
                var country = new Option(response.country, false, false, false);
                $("#country_list").append(country).trigger("change");

                var city = new Option(response.city, false, false, false);
                $("#city_list").append(city).trigger("change");

                $("#name").val(response.name);
                $("#address_type").val(response.type).trigger('change');
                $("#address_mobile").val(response.mobile);
                $("#alternate_mobile").val(response.alternate_mobile);
                $("#form_address").val(response.address);
                $("#landmark").val(response.landmark);
                $("#postcode").val(response.pincode);
                $("#state").val(response.state);
                $("#latitude").val(response.latitude);
                $("#longitude").val(response.longitude);
                $(".add_address").html("Update Address");
            },
            error: function (xhr, status, error) {
                console.error(error);
            },
        });
    });

    $(document).on("click", ".delete_address", function (e) {
        e.preventDefault();
        let address_id = $(this).attr("data-address-id");
        Swal.fire({
            title: "Do you Really want to Remove This Address?",
            showCancelButton: true,
            confirmButtonText: "Delete",
        }).then((result) => {
            if (result.isConfirmed) {
                Livewire.dispatch("deleteAddress", { address_id });
                iziToast.success({
                    message: "Address Deleted Successfully",
                    position: "topRight",
                });
            }
        });
    });

    $(".city_list").select2({
        ajax: {
            url: appUrl + "my-account/get_Cities",
            type: "GET",
            dataType: "json",
            delay: 250,
            data: function (params) {
                return {
                    search: params.term,
                };
            },
            processResults: function (response) {
                return {
                    results: response,
                };
            },
            cache: true,
        },
        dropdownParent: $(".city_list_div"),
        minimumInputLength: 1,
        placeholder: "Search for City",
    });
    // Call the function for each select element
    initializeSelect2(
        "#country_list",
        "my-account/get_Countries",
        "Search for countries",
        $(".country_list_div")
    );
    initializeSelect2(
        "#edit-country_list",
        "my-account/get_Countries",
        "Search for countries",
        $(".edit-country_list_div")
    );
    initializeSelect2(
        "#city_list",
        "my-account/get_Cities",
        "Search for City",
        $(".city_list_div")
    );
    initializeSelect2(
        "#edit-city_list",
        "my-account/get_Cities",
        "Search for City",
        $(".edit-city_list_div")
    );

    // user wallet transaction table
    let $table = $("#user_wallet_transactions");
    let $refreshButton = $("#tableRefresh");

    $refreshButton.on("click", function () {
        $table.bootstrapTable("refresh");
    });

    let $searchInput = $("#searchInput");

    $searchInput.on("input", function () {
        let searchText = $(this).val();
        $table.bootstrapTable("searchText", searchText);
    });

    $(function () {
        $("#toolbar")
            .find("select")
            .change(function () {
                $table.bootstrapTable("destroy").bootstrapTable({
                    exportDataType: $(this).val(),
                    exportTypes: [
                        "json",
                        "xml",
                        "csv",
                        "txt",
                        "sql",
                        "excel",
                        "pdf",
                    ],
                    columns: [
                        {
                            field: "state",
                            checkbox: true,
                            visible: $(this).val() === "selected",
                        },
                        {
                            field: "id",
                            title: "ID",
                        },
                        {
                            field: "name",
                            title: "Item Name",
                        },
                        {
                            field: "price",
                            title: "Item Price",
                        },
                    ],
                });
            })
            .trigger("change");
    });

    // edit profile
    initListner("submit", "#edit-profile-form", (e) => {
        e.preventDefault();

        let formData = new FormData();
        if ($("#city_list").val() == null) {
            iziToast.error({
                message: "Please Select City.",
                position: "topRight",
            });
            return;
        }
        if ($("#edit-username").val().trim() === "") {
            iziToast.error({
                message: "Please Enter Name.",
                position: "topRight",
            });
            return;
        }

        if ($("#edit-streetaddress").val().trim() === "") {
            iziToast.error({
                message: "Please Enter Address.",
                position: "topRight",
            });
            return;
        }
        if ($("#country_list").val() == null) {
            iziToast.error({
                message: "Please Select Country.",
                position: "topRight",
            });
            return;
        }
        if ($("#profile_upload")[0].files.length > 0) {
            formData.append("profile_upload", $("#profile_upload")[0].files[0]);
        }

        formData.append("username", $("#edit-username").val());
        formData.append("city", $("#city_list").val());
        formData.append("country", $("#country_list").val());
        formData.append("address", $("#edit-streetaddress").val());
        formData.append("zipcode", $("#edit-zipcode").val());
        // formData.append("profile_upload", image);
        // console.log(image,'image')
        $.ajax({
            type: "POST",
            url: appUrl + "my-account/profile_update",
            data: formData,
            contentType: false,
            processData: false,
            success: function (response) {
                if (response.error == false) {

                    Livewire.dispatch("refreshComponent");
                    if (response.image) {
                        $(".profileImg img").attr("src", response.image + "?t=" + new Date().getTime());
                    }

                    $("#editProfileModal").modal("hide");
                    iziToast.success({
                        message: response.message,
                        position: "topRight",
                    });
                    return;
                }
                $.each(response.message, function (key, value) {
                    iziToast.error({
                        message: value[0],
                        position: "topRight",
                    });
                    return false;
                });
                return false;
            },
        });
    });

    $(document).on("change", "#profile_upload", function () {
        const file = this.files[0];

        if (!file) return;

        const reader = new FileReader();

        reader.onload = function (e) {
            $(".profileImg img").attr("src", e.target.result);
        };

        reader.readAsDataURL(file);
    });


    // $(".check-product-deliverability").on("click", function () {
    //     let product_deliverability_type = $(
    //         "#product_deliverability_type"
    //     ).val();
    //     let product_id = $("#product_id").val();
    //     let city = $("#city_list").val();
    //     let pincode = $("#pincode").val();
    //     let product_type = $("#product_type").val();
    //     if (product_deliverability_type == "city_wise_deliverability") {
    //         if (city == undefined || city == null || city == "") {
    //             iziToast.error({
    //                 message:
    //                     "Please Choose City to Verify the Product Deliverability",
    //                 position: "topRight",
    //             });
    //             return;
    //         }
    //     } else {
    //         if (pincode == undefined || pincode == null || pincode == "") {
    //             iziToast.error({
    //                 message:
    //                     "Please Enter Pincode to Verify the Product Deliverability",
    //                 position: "topRight",
    //             });
    //             return;
    //         }
    //     }
    //     $.ajax({
    //         type: "POST",
    //         url: appUrl + "check-product-deliverability",
    //         data: {
    //             product_id,
    //             city,
    //             pincode,
    //             product_type,
    //         },
    //         dataType: "json",
    //         success: function (response) {
    //             if (response.error == true) {
    //                 $.each(response.message, function (key, value) {
    //                     iziToast.error({
    //                         message: value[0],
    //                         position: "topRight",
    //                     });
    //                     return false;
    //                 });
    //             }
    //             if (response[0].is_deliverable == false) {
    //                 $(".deliverability-res")
    //                     .removeClass("text-success")
    //                     .addClass("text-danger")
    //                     .html("Sorry, but the product cannot be delivered.");
    //                 return false;
    //             }
    //             $(".deliverability-res")
    //                 .removeClass("text-danger")
    //                 .addClass("text-success")
    //                 .html(
    //                     "The product is deliverable, and the delivery charges will be added during checkout."
    //                 );
    //             return false;
    //         },
    //     });
    // });

    $(".check-product-deliverability").on("click", function () {
        // Hide city warning by default
        $("#city-warning").addClass("d-none");

        let product_deliverability_type = $(
            "#product_deliverability_type"
        ).val();
        let product_id = $("#product_id").val();
        let city = $("#city_list").val();
        let pincode = $("#pincode").val();
        let product_type = $("#product_type").val();
        if (product_deliverability_type == "city_wise_deliverability") {
            if (city == undefined || city == null || city == "") {
                iziToast.error({
                    message:
                        "Please Choose City to Verify the Product Deliverability",
                    position: "topRight",
                });
                return;
            }
        } else {
            if (pincode == undefined || pincode == null || pincode == "") {
                iziToast.error({
                    message:
                        "Please Enter Pincode to Verify the Product Deliverability",
                    position: "topRight",
                });
                return;
            }
        }
        $.ajax({
            type: "POST",
            url: appUrl + "check-product-deliverability",
            data: {
                product_id,
                city,
                pincode,
                product_type,
            },
            dataType: "json",
            success: function (response) {

                if (response.error === true) {
                    iziToast.error({
                        message: response.message,
                        position: "topRight",
                    });
                    return;
                }

                if (response.is_deliverable === false) {
                    $(".deliverability-res")
                        .removeClass("text-success")
                        .addClass("text-danger")
                        .html("Sorry, but the product cannot be delivered.");
                    $("#city-warning").removeClass("d-none");
                    return;
                }

                $(".deliverability-res")
                    .removeClass("text-danger")
                    .addClass("text-success")
                    .html(
                        "The product is deliverable, and delivery charges will be added during checkout."
                    );
                $("#city-warning").addClass("d-none");

            }

        });
    });

    $(".AddNewTicket").on("click", function () {
        let ticket_id = $(this).data("ticket-id");
        let user_id = $("#user_id").val();
        $("#ticket_id").val(ticket_id);

        $.ajax({
            type: "post",
            url: appUrl + "my-account/support/get-ticket",
            data: {
                ticket_id,
                user_id,
            },
            success: function (response) {
                if (response.error == false) {
                    $("#ticket_type").val(response.data.ticket_type_id);
                    $("#ticket_email").val(response.data.email);
                    $("#ticket_description").val(response.data.description);
                    $("#ticket_subject").val(response.data.subject);
                    $(".add_ticket_btn").html("Update Ticket");
                    $(".add_new_ticket").html("Update Ticket");
                }
            },
        });
    });
    $("#AddNewTicket").on("hidden.bs.modal", function () {
        $("#ticket_id").val("");
        $("#ticket_type").val("");
        $("#ticket_email").val("");
        $("#ticket_description").val("");
        $("#ticket_subject").val("");
        $(".add_ticket_btn").html("Add");
        $(".add_new_ticket").html("Add Ticket");
    });

    $(".add_ticket_btn").on("click", function () {
        let ticket_type = $("#ticket_type").val();
        let ticket_email = $("#ticket_email").val();
        let ticket_description = $("#ticket_description").val();
        let ticket_subject = $("#ticket_subject").val();
        let ticket_id = $("#ticket_id").val();

        $.ajax({
            type: "post",
            url: appUrl + "my-account/support/add-ticket",
            data: {
                ticket_type,
                ticket_email,
                ticket_description,
                ticket_subject,
                ticket_id,
            },
            success: function (response) {
                if (response.error == false) {
                    Livewire.dispatch("refreshComponent");
                    $("#AddNewTicket").modal("hide");
                    iziToast.success({
                        message: response.message,
                        position: "topRight",
                    });
                    return;
                }
                $.each(response.message, function (key, value) {
                    iziToast.error({
                        message: value[0],
                        position: "topRight",
                    });
                    return false;
                });
                return false;
            },
        });
    });

    // change password
    // $(document).on("click", ".change_password", () => {
    //     let current_password = $("#current_password").val();
    //     let new_password = $("#new_password").val();
    //     let verify_password = $("#verify_password").val();

    //     $.ajax({
    //         type: "POST",
    //         url: appUrl + "my-account/change-password",
    //         data: {
    //             current_password: current_password,
    //             new_password: new_password,
    //             verify_password: verify_password,
    //         },
    //         success: function (response) {

    //             if (response.error == false) {
    //                     $("#changePasswordForm")[0].reset();
    //             $("#editLoginModal").modal("hide");

    //                 $("#editLoginModal").modal("hide");
    //                 iziToast.success({
    //                     message: response.message,
    //                     position: "topRight",
    //                 });
    //                 return;
    //             }
    //             if (typeof response.message === "string") {
    //                 iziToast.error({
    //                     message: response.message,
    //                     position: "topRight",
    //                 });
    //             } else {
    //                 $.each(response.message, function (key, value) {
    //                     iziToast.error({
    //                         message: value[0],
    //                         position: "topRight",
    //                     });
    //                     return false;
    //                 });
    //             }
    //             $("#editLoginModal").modal("hide");

    //             return false;
    //         },
    //     });
    // });

    // Change password - SAFE SINGLE BIND
    $(document)
        .off("click", ".change_password")
        .on("click", ".change_password", function (e) {
            e.preventDefault();

            let btn = $(this);

            let current_password = $("#pc_current_password").val();
            let new_password = $("#pc_new_password").val();
            let verify_password = $("#pc_verify_password").val();

            // Prevent double click
            btn.prop("disabled", true);

            $.ajax({
                type: "POST",
                url: appUrl + "my-account/change-password",
                data: {
                    current_password,
                    new_password,
                    verify_password,
                },
                success: function (response) {

                    if (response.error === false) {
                        $("#changePasswordForm")[0].reset();
                        $("#editLoginModal").modal("hide");

                        iziToast.success({
                            message: response.message,
                            position: "topRight",
                        });
                        return;
                    }

                    if (typeof response.message === "string") {
                        iziToast.error({
                            message: response.message,
                            position: "topRight",
                        });
                    } else {
                        $.each(response.message, function (key, value) {
                            iziToast.error({
                                message: value[0],
                                position: "topRight",
                            });
                            return false;
                        });
                    }
                },
                complete: function () {
                    btn.prop("disabled", false);
                }
            });
        });

    $(document).ready(function () {

        $("#editLoginModal").on("hidden.bs.modal", function () {

            $("#changePasswordForm")[0].reset();

            $("#changePasswordForm input")
                .attr("type", "password");

            $("#changePasswordForm .toggle-password")
                .attr("name", "eye-off-outline")
                .removeClass("active");
        });

    });



    $(".update_order_item_status").on("click", function () {
        let order_status = $(this).data("status");
        let order_item_id = $(this).data("item-id");
        let confirm_title = "";
        let confirm_btn = "";
        if (order_status == "cancelled") {
            confirm_title =
                "Are you sure you want to cancel this ordered item?";
            confirm_btn = "Yes Remove";
        } else if (order_status == "returned") {
            confirm_title = "Are you sure you want to return the ordered item?";
            confirm_btn = "Yes Return";
        }
        Swal.fire({
            title: confirm_title,
            showCancelButton: true,
            confirmButtonText: confirm_btn,
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    type: "POST",
                    url: appUrl + "orders/update-order-item-status",
                    data: {
                        order_status,
                        order_item_id,
                    },
                    dataType: "json",
                    success: function (response) {
                        if (response.error == false) {
                            iziToast.success({
                                message: response.message,
                                position: "topRight",
                            });
                            setTimeout(() => {
                                location.reload();
                            }, 1500);

                            Livewire.dispatch("refreshComponent");
                            return false;
                        } else {
                            iziToast.error({
                                message: response.message,
                                position: "topRight",
                            });
                        }
                    },
                });
            }
        });
    });

    $(".chat-btn-popup").on("click", function () {
        $("#chat-iframe").toggleClass("chat-iframe-show");
    });

    $(function () {
        $("#recovery_number, #number").intlTelInput({
            allowExtensions: !0,
            formatOnDisplay: !0,
            autoFormat: !0,
            autoHideDialCode: !0,
            autoPlaceholder: !0,
            defaultCountry: "in",
            ipinfoToken: "yolo",
            nationalMode: !1,
            numberType: "MOBILE",
            preferredCountries: ["in", "ae", "qa", "om", "bh", "kw", "ma"],
            preventInvalidNumbers: !0,
            separateDialCode: !0,
            initialCountry: "in",
            geoIpLookup: function (e) {
                $.get("https://ipinfo.io", function () { }, "jsonp").always(
                    function (t) {
                        var a = t && t.country ? t.country : "";
                        e(a);
                    }
                );
            },
            utilsScript:
                "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js",
        });
    });
    let authentication_method = $("#recovery_authentication_method, #authentication_method").val();
    if (authentication_method == "firebase") {
        FirebaseAuth();
    } else if (authentication_method == "sms") {
        CustomSmsAuth();
    }

    let store = setUrlParameter(custom_url, "store", store_slug);
    let split_url = custom_url.split("?");
    const urlParams = new URLSearchParams("?".concat(split_url[1]));
    const store_exsist = urlParams.get("store");
    if (store_exsist == null) {
        Livewire.navigate(store);
    }
});

$(function () {
    var $pswp = $(".pswp")[0],
        image = [],
        getItems = function () {
            var items = [];
            $(".lightboximages a").each(function () {
                var $href = $(this).attr("href"),
                    $size = $(this).data("size").split("x"),
                    item = {
                        src: $href,
                        w: $size[0],
                        h: $size[1],
                    };
                items.push(item);
            });
            return items;
        };
    var items = getItems();

    $.each(items, function (index, value) {
        image[index] = new Image();
        image[index].src = value["src"];
    });
    $(".prlightbox").on("click", function (event) {
        event.preventDefault();

        var $index = $(".active-thumb").parent().attr("data-slick-index");
        $index++;
        $index = $index - 1;

        var options = {
            index: $index,
            bgOpacity: 0.7,
            showHideOpacity: true,
        };
        var lightBox = new PhotoSwipe(
            $pswp,
            PhotoSwipeUI_Default,
            items,
            options
        );
        lightBox.init();
    });
});
$(".messages").animate({ scrollTop: $(document).height() }, "fast");

$("#profile-img").on("click", function () {
    $("#status-options").toggleClass("active");
});

$(".expand-button").on("click", function () {
    $("#profile").toggleClass("expanded");
    $("#contacts").toggleClass("expanded");
});

$("#status-options ul li").on("click", function () {
    $("#profile-img").removeClass();
    $("#status-online").removeClass("active");
    $("#status-away").removeClass("active");
    $("#status-busy").removeClass("active");
    $("#status-offline").removeClass("active");
    $(this).addClass("active");

    if ($("#status-online").hasClass("active")) {
        $("#profile-img").addClass("online");
    } else if ($("#status-away").hasClass("active")) {
        $("#profile-img").addClass("away");
    } else if ($("#status-busy").hasClass("active")) {
        $("#profile-img").addClass("busy");
    } else if ($("#status-offline").hasClass("active")) {
        $("#profile-img").addClass("offline");
    } else {
        $("#profile-img").removeClass();
    }

    $("#status-options").removeClass("active");
});

function newMessage() {
    let message = $(".message-input input").val();
    if ($.trim(message) == "") {
        return false;
    }
    $(
        '<li class="sent"><img src="http://emilcarlsson.se/assets/mikeross.png" alt="" /><p>' +
        message +
        "</p></li>"
    ).appendTo($(".messages ul"));
    $(".message-input input").val(null);
    $(".contact.active .preview").html("<span>You: </span>" + message);
    $(".messages").animate({ scrollTop: $(document).height() }, "fast");
}

$(".submit").on("click", function () {
    newMessage();
});

$(window).on("keydown", function (e) {
    if (e.which == 13) {
        newMessage();
        return false;
    }
});

function initializeSelect2(selector, url, placeholder, dropdownParent) {
    $(selector).select2({
        ajax: {
            url: appUrl + url,
            type: "GET",
            dataType: "json",
            delay: 250,
            data: function (params) {
                return {
                    search: params.term,
                };
            },
            processResults: function (response) {
                return {
                    results: response,
                };
            },
            cache: true,
        },
        dropdownParent: dropdownParent,
        minimumInputLength: 1,
        placeholder: placeholder,
    });
}

$(".delete_rating").on("click", function () {
    $(".review_rating").rating("clear");
    $("#review_image").val("");
    $("#message").val("");
});



// function display_compare() {
//     // let compare = localStorage.getItem("compare");
//     // let currency_symbol = $("#currency").val();

//     let compare = localStorage.getItem("compare");
//     let currency_symbol = $("#currency").val();
//     compare = compare ? JSON.parse(compare) : [];
//     console.log(compare);
//     // If compare list is empty, show empty UI and return early
//     if (compare.length === 0) {
//         let comp = "";
//         comp +=
//             '<div id="page-content"><div class="container"><div class="row">' +
//             '<div class="col-12 text-center">' +
//             '<p><img src="' +
//             appUrl +
//             'frontend/elegant/images/empty-img.gif" alt="No Products" width="500" /></p>' +
//             '<h2 class="fs-4 mt-4"><strong>SORRY,</strong> No products found for comparison.</h2>' +
//             '<p class="same-width-btn"><a href="#" onClick="goBack()" class="btn btn-secondary btn-lg mb-2 mx-3">GO BACK</a></p>' +
//             "</div></div></div></div>";
//         $("#compare_item").html(comp);
//         $("#compare_count").html(0); // Reset the compare count
//         $("#compare_count_alert").html(""); // Clear alert if needed
//         return;
//     }

//     $.ajax({
//         type: "POST",
//         url: appUrl + "product/add-to-compare",
//         data: {
//             product_id: compare,
//         },
//         success: function (response) {
//             let compare_count = compare.length;
//             if (compare_count >= 0) {
//                 $("#compare_count").html(compare_count);
//             }
//             let comp = "";
//             // if (response.error == false && compare_count > 0) {
//             if (response.error == false) {
//                 if (compare !== null && compare_count > 0) {
//                     let comp_alert =
//                         '<div class="alert alert-success py-2 alert-dismissible fade show cart-alert" role="alert">There are <span class="text-primary fw-600" id="compare_count">' +
//                         compare_count +
//                         '</span> products in this Compare list <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>';
//                     $("#compare_count_alert").html(comp_alert);
//                     comp +=
//                         '<table class="table table-borderless align-middle compare_table">' +
//                         "<tbody>" +
//                         '<tr><th class="name">Products</th>';
//                     let current_product_id = $("#current_view_product_id").val();
//                     response.data.regular_product.forEach((e) => {
//                         if (current_product_id && e.id == current_product_id) {
//                             return;
//                         }
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             '<div class="product-image position-relative">' +
//                             '<button type="button" class="btn remove-icon close-btn remove_compare_item" data-bs-toggle="tooltip" data-bs-placement="top" title="Remove" data-product-id="' +
//                             e.id +
//                             '"><ion-icon name="close-outline"></ion-icon></button>' +
//                             '<img class="image rounded-0 blur-up lazyload" data-src="' +
//                             e.image +
//                             '" src="' +
//                             e.image +
//                             '" alt="' +
//                             e.name +
//                             '" title="' +
//                             e.name +
//                             '" />' +
//                             '<button type="button" class="btn btn-light quick-view-modal" data-bs-toggle="modal" data-bs-target="#quickview_modal" data-product-id="' +
//                             e.id +
//                             '"' +
//                             '><ion-icon name="search-outline" class="fs-5"></ion-icon></button></div>' +
//                             '<div class="product-name mt-3"><a href="' +
//                             appUrl +
//                             "products/" +
//                             e.slug +
//                             '">' +
//                             e.name +
//                             "</a></div>" +
//                             '<div class="product-price fw-500"><span class="price">' +
//                             currency_symbol +
//                             (e.type == "simple_product"
//                                 ? e.variants[0]["special_price"] > 0
//                                     ? e.variants[0]["special_price"]
//                                     : e.variants[0]["price"]
//                                 : (e.min_max_price.max_price > 0
//                                     ? e.min_max_price.max_price
//                                     : e.min_max_price.price) +
//                                 "-" +
//                                 (e.min_max_price.special_min_price > 0
//                                     ? e.min_max_price.special_min_price
//                                     : e.min_max_price.min_price)) +
//                             "</span></div>";
//                     });

//                     response.data.combo_products.forEach((e) => {
//                         var finalPrice =
//                             e.special_price && e.special_price > 0
//                                 ? e.special_price
//                                 : e.price;
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             '<div class="product-image position-relative">' +
//                             '<button type="button" class="btn remove-icon close-btn remove_compare_item" data-bs-toggle="tooltip" data-bs-placement="top" title="Remove" data-product-id="' +
//                             e.id +
//                             '">' +
//                             '<ion-icon name="close-outline"></ion-icon></button>' +
//                             '<img class="image rounded-0 blur-up lazyload" data-src="' +
//                             e.image +
//                             '" src="' +
//                             e.image +
//                             '" alt="' +
//                             e.name +
//                             '" title="' +
//                             e.name +
//                             '" />' +
//                             '<button type="button" class="btn btn-light quick-view-modal" data-bs-toggle="modal" data-bs-target="#quickview_modal" data-product-type="combo-product" data-product-id="' +
//                             e.id +
//                             '">' +
//                             '<ion-icon name="search-outline" class="fs-5"></ion-icon></button></div>' +
//                             '<div class="product-name mt-3"><a href="' +
//                             appUrl +
//                             "products/" +
//                             e.slug +
//                             '">' +
//                             e.name +
//                             "</a></div>" +
//                             '<div class="product-price fw-500">' +
//                             '<span class="price">' +
//                             currency_symbol +
//                             finalPrice +
//                             "</span>" +
//                             "</div>" +
//                             "</td>";
//                     });

//                     comp += '<tr><th class="name">Description</th>';
//                     response.data.regular_product.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             e.description +
//                             "</td>";
//                     });

//                     response.data.combo_products.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             e.description +
//                             "</td>";
//                     });

//                     comp += '</tr><tr><th class="name">Ratings</th>';
//                     response.data.regular_product.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '"><div class="product-review d-flex-center mt-0">' +
//                             '<i class="icon anm anm-star"></i>' +
//                             e.rating +
//                             ' | <span class="caption ms-1">' +
//                             e.no_of_ratings +
//                             " Reviews</span>" +
//                             "</div></td>";
//                     });

//                     response.data.combo_products.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '"><div class="product-review d-flex-center mt-0">' +
//                             '<i class="icon anm anm-star"></i>' +
//                             e.rating +
//                             ' | <span class="caption ms-1">' +
//                             e.no_of_ratings +
//                             " Reviews</span>" +
//                             "</div></td>";
//                     });

//                     comp += '</tr><tr><th class="name">Brand</th>';
//                     response.data.regular_product.forEach((e) => {
//                         comp +=
//                             ' <td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             (e.brand_name != "" ? e.brand_name : "-") +
//                             "</td>";
//                     });
//                     response.data.combo_products.forEach((e) => {
//                         comp +=
//                             ' <td class="item-row compare' + e.id + '">-</td>';
//                     });
//                     comp += '</tr><tr><th class="name">Category</th>';
//                     response.data.regular_product.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">' +
//                             e.category_name;
//                         ("</td>");
//                     });
//                     response.data.combo_products.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' + e.id + '">-</td>';
//                     });

//                     comp += '</tr><tr><th class="name">Product Type</th>';
//                     response.data.regular_product.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">Single Product</td>';
//                     });
//                     response.data.combo_products.forEach((e) => {
//                         comp +=
//                             '<td class="item-row compare' +
//                             e.id +
//                             '">Combo Product</td>';
//                     });
//                     comp += "</tr>";
//                     comp += "</tr></tbody></table>";
//                     $("#compare_item").html(comp);
//                 }
//             }
//         },
//     });
// }

$(document).on("click", ".clear-rating", () => {
    $(".star-rating").rating("reset");
});
$(document).on("click", ".clear-rating", () => {
    $(".star-rating").rating("reset");
});



function arrays_equal(e, t) {
    if (!Array.isArray(e) || !Array.isArray(t) || e.length !== t.length)
        return !1;
    const a = e.concat().sort(),
        r = t.concat().sort();
    for (let e = 0; e < a.length; e++) if (a[e] !== r[e]) return !1;
    return !0;
}
$("#editLoginModal").on("hidden.bs.modal", function () {
    $(this).find('input[type="password"]').val("");
});

Livewire.on("cart-updated", ({ message }) => {
    // alert(message);
    iziToast.error({
        message: message,
        position: "topRight",
    });
});

$('#send_bank_receipt_form').on('submit', function (e) {
    e.preventDefault();
    console.log('here in form submit');

    var formdata = new FormData(this);

    var csrfToken = document.head.querySelector(
        'meta[name="csrf-token"]'
    ).content;
    formdata.append("_token", csrfToken);

    $.ajax({
        type: 'POST',
        url: $(this).attr('action'),
        data: formdata,

        cache: false,
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (result) {
            if (result.error == false) {
                iziToast.success({
                    message:
                        '<span style="text-transform:capitalize">' +
                        result.message +
                        "</span>",
                    position: "topRight",
                });
            }
            location.reload();
        },
        error: function () {
            iziToast.error({
                message:
                    '<span style="text-transform:capitalize">An error occurred while sending the message.</span>',
                position: "topRight",
            });
        }

    });

});

if (window.location.href.includes("my-account/support")) {
    var ticket_id = '';
    // Support Ticket chat
    $(document).on("click", ".view_ticket", function (e, row) {
        e.preventDefault();
        var scrolled = 0;
        $(".ticket_msg").data("max-loaded", false);
        ticket_id = $(this).data("ticket-id");

        var date_created = $(this).data("date_created");
        var subject = $(this).data("subject");
        var status = $(this).data("status");

        var ticket_type = $(this).data("ticket_type");
        $('input[name="ticket_id"]').val(ticket_id);

        $("#date_created").html(date_created);
        $("#subject").html(subject);
        $(".change_ticket_status").data("ticket_id", ticket_id);

        if (status == 1) {
            $('#status').html('<label class="badge bg-warning ml-2">PENDING</label>');
        } else if (status == 2) {
            $('#status').html('<label class="badge  bg-danger ml-2">OPENED</label>');
        } else if (status == 3) {
            $('#status').html('<label class="badge bg-success ml-2">RESOLVED</label>');
        } else if (status == 4) {
            $('#status').html('<label class="badge bg-dark ml-2">CLOSED</label>');
        } else if (status == 5) {
            $('#status').html('<label class="badge bg-primary ml-2">REOPENED</label>');
        }

        $('#ticket_type_chat').text(ticket_type);
        $('#subject_chat').text(subject);
        $('#date_created').html(date_created);
        $(".ticket_msg").html("");
        $(".ticket_msg").data("limit", 5);
        $(".ticket_msg").data("offset", 0);
        load_messages($(".ticket_msg"), ticket_id);
    });

    function load_messages(element, ticket_id) {
        var limit = element.data("limit");
        var offset = element.data("offset");
        element.data("offset", limit + offset);
        var max_loaded = element.data("max-loaded");
        if (max_loaded == false) {
            var loader =
                '<div class="loader text-center"><img src="' +
                appUrl +
                'assets/img/pre-loader.gif" alt="Loading. please wait.. ." title="Loading. please wait.. ."></div>';
            $.ajax({
                type: "get",
                data:
                    "ticket_id=" +
                    ticket_id +
                    "&limit=" +
                    limit +
                    "&offset=" +
                    offset,
                url: appUrl + "my-account/support/get-ticket-message",
                beforeSend: function () {
                    $(".ticket_msg").prepend(loader);
                },
                dataType: "json",
                cache: false,
                contentType: false,
                processData: false,
                success: function (result) {

                    if (result.error == false) {
                        if (result.error == false && result.data.length > 0) {
                            var messages_html = "";
                            var is_left = "";
                            var i = 1;
                            result.data.reverse().forEach((messages) => {
                                var atch_html = "";
                                is_left =
                                    messages.user_type == "admin" ? "left justify-content-start align-items-start" : "right justify-content-end align-items-end";
                                if (messages.attachments.length > 0) {
                                    messages.attachments.forEach((atch) => {
                                        atch_html +=
                                            "<div class='image-upload-section d-flex " +
                                            (is_left === "left" ? "justify-content-start" : "justify-content-end") +
                                            "'>" + // Align based on `is_left`
                                            "<div class='col-md-12 col-sm-12 shadow mb-4 rounded text-center grow image'>" +
                                            "<a href='" + atch.media + "' target='_blank'>" +
                                            "<img src='" +
                                            atch.media +
                                            "' alt='Attachment Image' class='img-fluid rounded' style='max-width: 100%; height: 100px; object-fit: contain;' />" +
                                            "</a>" +
                                            "</div>" +
                                            "</div>";
                                        i++;
                                    });
                                }
                                messages_html +=
                                    "<div class='d-flex " + (messages.attachments.length > 0 ? '' : 'direct-chat-msg') + " flex-column " + is_left + "'>" +
                                    "<div class='direct-chat-infos clearfix text-black-50'>" +
                                    "<span class='direct-chat-name float-" + is_left + "' id='name'>" + " " + messages.name + " " + "</span>" +
                                    "<span class='direct-chat-timestamp float-" + is_left + "' id='last_updated'>" + messages.updated_at + " " + "</span>" +
                                    "</div>" +
                                    "<div class='direct-chat-text float-" + is_left + "' id='message'>" + messages.message +
                                    "</br>" +
                                    atch_html +
                                    "</div>" +
                                    "</div>";
                            });
                            $(".ticket_msg").prepend(messages_html);
                            $(".ticket_msg").find(".loader").remove();
                            $(element).animate({
                                scrollTop: $(element).offset().top,
                            });
                        }
                    } else {
                        element.data("offset", offset);
                        element.data("max-loaded", true);
                        $(".ticket_msg").find(".loader").remove();
                        $(".ticket_msg").prepend(
                            '<div class="text-center"> <p>You have reached the top most message!</p></div>'
                        );
                    }
                    $("#element").scrollTop(20); // Scroll alittle way down, to allow user to scroll more
                    $(element).animate({
                        scrollTop: $(element).offset().top,
                    });
                    return false;
                },
            });
        }
    }

    // Dropzone configuration
    let myDropzone = new Dropzone("#myAlbumTicket", {
        url: appUrl + "my-account/support/send-message",
        autoProcessQueue: false,
        paramName: "attachments",
        addRemoveLinks: true,
        parallelUploads: 10,
        uploadMultiple: true,
        maxFiles: 3,
        dictMaxFilesExceeded: 'Only 3 files are allowed at once',
        dictRemoveFile: 'x',
    });


    $('#ticket_send_msg_form').on('submit', function (e) {
        e.preventDefault();

        var formdata = new FormData(this);

        var csrfToken = document.head.querySelector(
            'meta[name="csrf-token"]'
        ).content;
        formdata.append("_token", csrfToken);

        var ticket_id = $('#ticket_id').val();
        var message = $("#message_input").val();
        let drop_file_count = myDropzone.files.length;

        if (message.length > 0 || drop_file_count > 0) {
            // Append ticket_id and other necessary data to Dropzone's formData
            myDropzone.on('sending', function (file, xhr, formData) {
                formData.append('ticket_id', ticket_id);
                formData.append('user_id', $('#user_id').val());
                formData.append('user_type', $('#user_type').val());
                formData.append('message', message); // Include message if present
                formData.append("_token", csrfToken);
            });

            if (drop_file_count > 0) {
                // Process Dropzone queue for file uploads
                myDropzone.processQueue();
            } else {
                // No files, proceed with regular AJAX for text message
                $.ajax({
                    type: 'POST',
                    url: $(this).attr('action'),
                    data: formdata,

                    cache: false,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (result) {
                        var token = $('meta[name="csrf-token"]').attr("content");
                        $("#submit_btn").html("Send").attr("disabled", false);
                        if (result.error == false) {
                            $(".product-image-container").remove();
                            if (result.data.id > 0) {
                                var messages = result.data;
                                var message_html = "";
                                var i = 1;
                                var atch_html = "";
                                var is_left =
                                    messages.user_type == "admin" ? "left justify-content-start align-items-start" : "right justify-content-end align-items-end";

                                if (messages.attachments.length > 0) {
                                    messages.attachments.forEach((atch) => {
                                        atch_html +=
                                            "<div class='image-upload-section d-flex " +
                                            (is_left === "left" ? "justify-content-start" : "justify-content-end") +
                                            "'>" + // Align based on `is_left`
                                            "<div class='col-md-12 col-sm-12 shadow mb-4 rounded text-center grow image'>" +
                                            "<a href='" + atch.media + "' target='_blank'>" +
                                            "<img src='" +
                                            atch.media +
                                            "' alt='Attachment Image' class='img-fluid rounded' style='max-width: 100%; height: 100px; object-fit: contain;' />" +
                                            "</a>" +
                                            "</div>" +
                                            "</div>";
                                        i++;
                                    });
                                }
                                message_html +=
                                    "<div class='d-flex " + (messages.attachments.length > 0 ? '' : 'direct-chat-msg') + " flex-column " +
                                    is_left +
                                    "'>" +
                                    "<div class='direct-chat-infos clearfix text-black-50'>" +
                                    "<span class='direct-chat-name float-" +
                                    is_left +
                                    "' id='name'>" +
                                    " " +
                                    messages.name +
                                    " " +
                                    "</span>" +
                                    "<span class='direct-chat-timestamp float-" +
                                    is_left +
                                    "' id='last_updated'>" +
                                    messages.updated_at +
                                    " " +
                                    "</span>" +
                                    "</div>" +
                                    "<div class='direct-chat-text float-" +
                                    is_left +
                                    "' id='message'>" +
                                    messages.message +
                                    "</br>" +
                                    atch_html +
                                    "</div>" +
                                    "</div>";
                                $(".ticket_msg").append(message_html);
                                $("#message_input").val("");
                                $("#element").scrollTop($("#element")[0].scrollHeight);
                                $('input[name="attachments[]"]').val("");
                            } else {
                                // Handle the case when result.data.id is not greater than 0 (e.g., invalid data)
                                iziToast.error({
                                    message:
                                        '<span style="text-transform:capitalize">' +
                                        result.data.message +
                                        "</span>",
                                });
                            }
                        } else {
                            // Handle the error case
                            $("#element").data("max-loaded", true);
                            iziToast.error({
                                message:
                                    '<span style="text-transform:capitalize">' +
                                    result.error_message +
                                    "</span> ",
                            });
                            return false;
                        }
                        iziToast.success({
                            message:
                                '<span style="text-transform:capitalize">' +
                                result.message +
                                "</span> ",
                        });
                    },
                    error: function () {
                        $('#submit_btn').html('Send').attr('disabled', false);

                        iziToast.error({
                            message:
                                '<span style="text-transform:capitalize">An error occurred while sending the message.</span>',
                        });
                    }
                });
            }
        } else {


            iziToast.error({
                message:
                    '<span style="text-transform:capitalize">Please enter a message or attach a file.</span>',
            });
        }

        return false;
    });

    $(function () {
        var scrolled = 0;
        if ($("#element").length) {
            $("#element").scrollTop($("#element")[0].scrollHeight);
            $("#element").scroll(function () {
                if ($("#element").scrollTop() == 0) {

                    load_messages($(".ticket_msg"), ticket_id);
                }
            });
            $("#element").bind("mousewheel", function (e) {
                if (e.originalEvent.wheelDelta / 120 > 0) {
                    if ($(".ticket_msg")[0].scrollHeight < 370 && scrolled == 0) {

                        load_messages($(".ticket_msg"), ticket_id);
                        scrolled = 1;
                    }
                }
            });
        }
    });


    $(document).ready(function () {

        // Handle duplicate file prevention
        myDropzone.on("addedfile", function (file) {
            let i = 0;
            if (this.files.length) {
                for (let _i = 0, _len = this.files.length; _i < _len - 1; _i++) {
                    if (
                        this.files[_i].name === file.name &&
                        this.files[_i].size === file.size &&
                        this.files[_i].lastModifiedDate.toString() === file.lastModifiedDate.toString()
                    ) {
                        this.removeFile(file);
                    } else if (this.files[4] != null) {
                        this.removeFile(file);
                    }
                    i++;
                }
            }
        });

        // Handle successful file upload
        myDropzone.on('successmultiple', function (file, response) {
            let data = typeof response === 'string' ? JSON.parse(response) : response;

            if (data.error == false && data.data.id > 0) {
                var messages = data.data;
                var message_html = "";

                var i = 1;
                var atch_html = "";
                var is_left = messages.user_type == "admin" ? "left justify-content-start align-items-start" : "right justify-content-end align-items-end";

                if (messages.attachments.length > 0) {
                    messages.attachments.forEach((atch) => {
                        atch_html +=
                            "<div class='image-upload-section d-flex " +
                            (is_left === "left" ? "justify-content-start" : "justify-content-end") +
                            "'>" + // Align based on `is_left`
                            "<div class='col-md-12 col-sm-12 shadow mb-4 rounded text-center grow image'>" +
                            "<a href='" + atch.media + "' target='_blank'>" +
                            "<img src='" +
                            atch.media +
                            "' alt='Attachment Image' class='img-fluid rounded' style='max-width: 100%; height: 100px; object-fit: contain;' />" +
                            "</a>" +
                            "</div>" +
                            "</div>";
                        i++;
                    });
                }
                message_html +=
                    "<div class='d-flex " + (messages.attachments.length > 0 ? '' : 'direct-chat-msg') + " flex-column " + is_left + "'>" +
                    "<div class='direct-chat-infos clearfix text-black-50'>" +
                    "<span class='direct-chat-name float-" + is_left + "' id='name'>" + " " + messages.name + " " + "</span>" +
                    "<span class='direct-chat-timestamp float-" + is_left + "' id='last_updated'>" + messages.updated_at + " " + "</span>" +
                    "</div>" +
                    "<div class='direct-chat-text float-" + is_left + "' id='message'>" + messages.message +
                    "</br>" +
                    atch_html +
                    "</div>" +
                    "</div>";

                $('.ticket_msg').append(message_html);
                $("#message_input").val('');
                $("#element").scrollTop($("#element")[0].scrollHeight);

                iziToast.success({
                    message:
                        '<span style="text-transform:capitalize">' +
                        data.message +
                        "</span> ",
                });
            } else {

                iziToast.error({
                    message:
                        '<span style="text-transform:capitalize">' + data.message + '</span>',
                });
            }

            closeDropZone();
            myDropzone.removeAllFiles(true);
        });

        // Handle Dropzone errors
        myDropzone.on('error', function (file, errorMessage) {

            iziToast.error({
                message:
                    '<span style="text-transform:capitalize">File upload failed: ' + errorMessage + '</span>',
            });
            myDropzone.removeFile(file);
        });

        // Show/hide Dropzone
        $(document).on("dragenter", "#chat-box-content", function (e) {
            showDropZone();
        });

        $(document).on("click", ".btn-attech", function () {

            showDropZone();
        });

        window.closeDropZone = function () {
            $('#chat-box-content').show();
            $('#chat-dropbox').addClass("d-none");
            myDropzone.removeAllFiles(true);
        };

        window.showDropZone = function () {
            $('#chat-dropbox').removeClass("d-none");
            $('#chat-box-content').hide();
        };
    });

    $(document).ready(function () {
        $('#message_input').on('keydown', function (event) {
            if (event.key === 'Enter') {
                event.preventDefault();
                $('#ticket_send_msg_form').submit();
            }
        });
    });
}

document.addEventListener("livewire:navigated", () => {
    syncLocalCartToUI();
});

document.addEventListener("livewire:initialized", () => {
    syncLocalCartToUI();
});

$(document).ready(function () {
    syncLocalCartToUI();
});


/* ================= PASSWORD TOGGLE ================= */
// $(document).ready(function () {
//     $(document).on("click", ".password-toggle-btn, .eye-icon", function () {
//         const toggleBtn = $(this);
//         const formGroup = toggleBtn.closest(".form-group");
//         const input = formGroup.find("input");
//         const icon = toggleBtn.hasClass("eye-icon") ? toggleBtn : toggleBtn.find("ion-icon");

//         if (input.length && icon.length) {
//             const isPassword = input.attr("type") === "password";
//             input.attr("type", isPassword ? "text" : "password");
//             const newIcon = isPassword ? "eye-outline" : "eye-off-outline";
//             icon.attr("name", newIcon);
//             // Some versions of ionicons need the property set directly
//             if (icon[0].tagName === "ION-ICON") {
//                 icon[0].name = newIcon;
//             }
//         }
//     });
// });




// ===============================================
// FIXED: REMOVE FROM CART CLICK HANDLER
// ===============================================



// ===============================================
// FIXED: REMOVE FROM CART CLICK HANDLER
// ===============================================
// $(document).on('click', '.remove_from_cart', function (e) {
//     e.preventDefault();
//     let variant_id = $(this).data('variant-id');
//     let product_type = $(this).data('product-type');

//     // Dispatch the existing event that handles AJAX and UI updates
//     let event = new CustomEvent('remove_from_cart', {
//         detail: {
//             data: {
//                 variant_id: variant_id,
//                 store_id: $('#current_store_id').val(),
//                 user_id: $('#user_id').val(),
//                 product_type: product_type
//             },
//             el: this // Pass the element for UI reset functions
//         }
//     });
//     window.dispatchEvent(event);
// });

/**
 * Display compare items from local storage
 */
function display_compare() {
    let compare = JSON.parse(localStorage.getItem("compare")) || [];
    let box = $("#compare_item");

    if (box.length === 0) {
        box = $("#compare_list_box");
    }

    if (box.length === 0) return;

    if (compare.length === 0) {
        box.html(`
            <div class="text-center py-5">
                <ion-icon name="git-compare-outline" style="font-size: 48px; color: #ccc;"></ion-icon>
                <p class="mt-3 text-muted">No products added to compare yet.</p>
            </div>
        `);
        return;
    }

    let html = `<div class="row">`;

    compare.forEach((item, index) => {
        let detailUrl = item.product_type === 'combo' ? `/combo-products/${item.slug}` : `/products/${item.slug}`;
        html += `
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card p-2 text-center position-relative h-100">
                    <button class="btn btn-danger btn-sm remove_compare_item"
                        data-product-id="${item.product_id}"
                        style="position:absolute; top:5px; right:5px; z-index:999;">
                        <ion-icon name="close-outline"></ion-icon>
                    </button>
                    <img src="${item.image}"
                        class="img-fluid mb-2"
                        alt="${item.name}"
                        style="height:150px; object-fit:contain;">
                    <h6 class="text-truncate">${item.name}</h6>
                    <p class="text-primary fw-bold mt-1">
                        ${item.variant_price ? item.variant_price : ""}
                    </p>
                    <p class="text-muted small">${item.brand_name || ""}</p>
                    <a href="${detailUrl}"
                        class="btn btn-primary btn-sm mt-2">
                        View Details
                    </a>
                </div>
            </div>
        `;
    });

    html += `</div>`;
    box.html(html);
}

// Global event listener for tab switching
$(document).on('click', '.tablink, .tabs-ac-style', function () {
    let rel = $(this).attr('rel');
    if (rel === 'compare_item' || rel === 'compare_list_box') {
        display_compare();
    }
});

// Update display when compare list changes
window.addEventListener('compareUpdated', function () {
    display_compare();
});

$(document).ready(function () {
    display_compare();

    // Initialize Custom SMS Auth listeners
    if (typeof CustomSmsAuth === 'function') {
        CustomSmsAuth();
    }

    // Toggle register button on agreement checkbox
    $(document).on('change', '#agree', function () {
        if ($(this).is(':checked')) {
            $('#register-form-submit').prop('disabled', false);
            $('#agree_error').text(""); // Clear error if checked
        } else {
            $('#register-form-submit').prop('disabled', true);
        }
    });

    // Initial check
    if ($('#agree').is(':checked')) {
        $('#register-form-submit').prop('disabled', false);
    } else {
        $('#register-form-submit').prop('disabled', true);
    }
});



