@extends('admin/layout')
@section('title')
    {{ labels('admin_labels.affiliate_users', 'Affiliate Users') }}
@endsection
@section('content')
    <x-admin.breadcrumb :title="labels('admin_labels.affiliate_users', 'Affiliate Users')" :subtitle="labels(
        'admin_labels.efficiently_organize_and_control_affiliate_users',
        'Efficiently Organize and Control Affiliate Users',
    )" :breadcrumbs="[
        ['label' => labels('admin_labels.affiliate_user', 'Affiliate Users'), 'url' => route('admin.affiliate.manage_user')],
        ['label' => labels('admin_labels.add_user', 'Add User')]]" />

    <section class="content">
        <div class="row">
            <div class="col-12">
                <div class="card card-info">

                    {{-- Stepper --}}
                    <div class="px-3 py-3">
                        <div class="stepper-container d-flex flex-nowrap overflow-auto">
                            <div class="step-wrapper text-center flex-shrink-0 px-2">
                                <div class="affiliate_step" id="step1" onclick="goToStep(1)">
                                    <div class="circle"></div>
                                    <h6 class="mt-2">{{ labels('admin_labels.account_information', 'Account Information') }}</h6>
                                </div>
                                <div class="bar d-none d-md-block"></div>
                            </div>
                            <div class="step-wrapper text-center flex-shrink-0 px-2">
                                <div class="affiliate_step" id="step2" onclick="goToStep(2)">
                                    <div class="circle"></div>
                                    <h6 class="mt-2">{{ labels('admin_labels.website_and_mobile_app_list', 'Website and Mobile App List') }}</h6>
                                </div>
                                <div class="bar d-none d-md-block"></div>
                            </div>
                            <div class="step-wrapper text-center flex-shrink-0 px-2">
                                <div class="affiliate_step" id="step4" onclick="goToStep(3)">
                                    <div class="circle"></div>
                                    <h6 class="mt-2">{{ labels('admin_labels.start_using_associates_central', 'Start Using Associates Central') }}</h6>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Form --}}
                    <form id="add_affiliate_user_form" method="POST" action="{{ route('admin.affiliate_users.store') }}" novalidate>
                        @csrf
                        <input type="hidden" name="form_mode" value="add">
                        <div class="card shadow-sm">
                            <div class="card-body">

                                {{-- Step 1 --}}
                                <div class="step-page" id="page1">
                                    <h5 class="mb-4">{{ labels('admin_labels.account_information', 'Account Information') }}</h5>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="full_name" class="form-label">{{ labels('admin_labels.full_name', 'Full Name') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="full_name" name="full_name" placeholder="Enter Full Name">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="email" class="form-label">{{ labels('admin_labels.email_address', 'Email Address') }} <span class="text-danger">*</span></label>
                                            <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="mobile" class="form-label">{{ labels('admin_labels.mobile', 'Mobile') }} <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="mobile" name="mobile" maxlength="16" placeholder="Enter Mobile" oninput="validateNumberInput(this)">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="password" class="form-label">{{ labels('admin_labels.password', 'Password') }} <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="password" name="password" placeholder="Enter Password">
                                                <button type="button" class="btn btn-outline-secondary toggleAffiliatePassword"><i class="fa fa-eye"></i></button>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="confirm_password" class="form-label">{{ labels('admin_labels.confirm_password', 'Confirm Password') }} <span class="text-danger">*</span></label>
                                            <div class="input-group">
                                                <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" placeholder="Enter Confirm Password">
                                                <button type="button" class="btn btn-outline-secondary toggleAffiliatePassword"><i class="fa fa-eye"></i></button>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <label for="address" class="form-label">{{ labels('admin_labels.address', 'Address') }} <span class="text-danger">*</span></label>
                                            <textarea class="form-control" id="address" name="address" rows="3" placeholder="Enter Address"></textarea>
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-end mt-3">
                                        <button type="button" class="btn btn-primary" onclick="nextStep(2)">Next</button>
                                    </div>
                                </div>

                                {{-- Step 2 --}}
                                <div class="step-page d-none" id="page2">
                                    <h5 class="mb-4">{{ labels('admin_labels.your_websites_and_mobile_apps', 'Your Websites and Mobile Apps') }}</h5>
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label for="website_url" class="form-label">{{ labels('admin_labels.website', 'Website') }} <span class="text-danger">*</span></label>
                                            <input type="url" class="form-control" id="website_url" name="website_url" placeholder="https://www.example.com/myblog">
                                        </div>
                                        <div class="col-md-6">
                                            <label for="application_url" class="form-label">{{ labels('admin_labels.mobile_app', 'Mobile App') }} <span class="text-danger">*</span></label>
                                            <input type="url" class="form-control" id="application_url" name="application_url" placeholder="https://xxxx/dp/xxxx">
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between mt-3">
                                        <button type="button" class="btn btn-secondary" onclick="prevStep(1)">{{ labels('admin_labels.previous', 'Previous') }}</button>
                                        <button type="button" class="btn btn-primary" onclick="nextStep(3)">{{ labels('admin_labels.next', 'Next') }}</button>
                                    </div>
                                </div>

                                {{-- Step 3 --}}
                                <div class="step-page d-none" id="page3">
                                    <h5 class="mb-4">{{ labels('admin_labels.start_using_associates_central', 'Start Using Associates Central') }}</h5>
                                    <div class="mb-3">
                                        <label class="form-label">{{ labels('admin_labels.status', 'Status') }} <span class="text-danger">*</span></label>
                                        <div class="d-flex flex-wrap gap-3">
                                            @foreach (['0' => 'Deactive', '1' => 'Approved', '2' => 'Not-Approved'] as $value => $label)
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="status" id="status_{{ $value }}" value="{{ $value }}">
                                                    <label class="form-check-label" for="status_{{ $value }}">{{ $label }}</label>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="d-flex justify-content-between">
                                        <button type="button" class="btn btn-secondary" onclick="prevStep(2)">{{ labels('admin_labels.previous', 'Previous') }}</button>
                                        <button type="submit" class="btn btn-primary submit_button">{{ labels('admin_labels.add_user', 'Add User') }}</button>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>

    {{-- Responsive CSS --}}
    <style>
        .stepper-container {
            gap: 1rem;
        }
        .step-wrapper .circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #17a2b8;
            margin: auto;
        }
        @media (max-width: 576px) {
            .step-wrapper h6 {
                font-size: 0.8rem;
                white-space: nowrap;
            }
            .step-wrapper .circle {
                width: 30px;
                height: 30px;
            }
        }
    </style>
@endsection
