@php
    use App\Services\CartService;
    use App\Models\Category;
    $user_id = auth()->id() ?? 0;
    $store_id = session('store_id') ?? '';
    $favorites = getFavorites(user_id: $user_id, store_id: $store_id);
    $cart_count = app(CartService::class)->getCartCount($user_id, $store_id);

    $main_categories = Category::where('parent_id', 0)
        ->where('status', 1)
        ->where('store_id', $store_id)
        ->orderBy('row_order', 'asc')
        ->take(6)
        ->get();
@endphp
<div class="footer">
    <div class="footer-top clearfix">
        <div class="container-fluid">
            <div class="row justify-content-around">
                <div class="col-12 col-sm-12 col-md-3 col-lg-3 footer-links">
                    <h4 class="h4">{{ labels('front_messages.quick_links', 'Quick links') }}</h4>
                    <ul>
                        {{-- @auth
                        <li><a href="{{ customUrl('my-account') }}" wire:navigate>{{ labels('front_messages.my_account',
                                'My Account') }}</a></li>
                        @else
                        <li><a href="{{ customUrl('login') }}" wire:navigate>{{ labels('front_messages.sign_in',
                                'Login') }}</a></li>
                        <li><a href="{{ customUrl('register') }}" wire:navigate>{{ labels('front_messages.sign_up_now',
                                'Sign Up') }}</a></li>
                        @endauth --}}
                        <li><a href="{{ customUrl('about_us') }}"
                                wire:navigate>{{ labels('front_messages.about_us', 'About us') }}</a></li>
                        <li><a href="{{ customUrl('privacy_policy') }}"
                                wire:navigate>{{ labels('front_messages.privacy_policy', 'Privacy policy') }}</a></li>
                        <li><a href="{{ customUrl('contact_us') }}"
                                wire:navigate>{{ labels('front_messages.contact_us', 'Contact Us') }}</a></li>
                        <li><a href="{{ customUrl('term_and_conditions') }}"
                                wire:navigate>{{ labels('front_messages.terms_and_conditions', 'Terms & condition') }}</a>
                        </li>
                    </ul>
                </div>
                <div class="col-12 col-sm-12 col-md-3 col-lg-3 footer-links">
                    <h4 class="h4">{{ labels('front_messages.customer_services', 'Customer Services') }}</h4>
                    <ul>
                        <li><a href="{{ customUrl('faqs') }}"
                                wire:navigate>{{ labels('front_messages.faqs', 'FAQ\'s') }}</a></li>
                        {{--
                        <li><a href="{{ customUrl('contact_us') }}" wire:navigate>{{ labels('front_messages.contact_us',
                                'Contact Us') }}</a></li>
                        --}}
                        {{-- @auth
                        <li>
                            <a href="{{ customUrl('my-account.support') }}" wire:navigate>{{
                                labels('front_messages.support_center', 'Support Center') }}</a>
                        </li>
                        @endauth --}}
                        <li><a href="{{ customUrl('return_policy') }}"
                                wire:navigate>{{ labels('front_messages.return_refund_policy', 'Return & Refund Policy') }}</a>
                        </li>
                        <li><a href="{{ customUrl('shipping_policy') }}"
                                wire:navigate>{{ labels('front_messages.shipping_policy', 'Shipping Policy') }}</a>
                        </li>
                    </ul>
                </div>

                <div class="col-12 col-sm-12 col-md-3 col-lg-3 footer-links">
                    <h4 class="h4">{{ labels('front_messages.categories', 'Shop By Categories') }}</h4>
                    <ul>
                        @foreach ($main_categories as $category)
                            <li>
                                <a href="{{ customUrl('categories/' . $category->slug . '/products') }}"
                                    wire:navigate>{{ $category->name }}</a>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <div class="col-12 col-sm-12 col-md-3 col-lg-3 footer-contact">
                    <h4 class="h4">{{ labels('front_messages.contact_us', 'Contact Us') }}</h4>
                    <p class="address d-flex"><ion-icon class="fs-5 me-2 "
                            name="location-outline"></ion-icon>{{ $settings->address }}</p>
                    <p class="phone d-flex align-items-center"><ion-icon class="fs-5 me-2"
                            name="call-outline"></ion-icon></i> <b
                            class="me-1 d-none">{{ labels('front_messages.phone', 'Phone') }}:</b> <a
                            href="tel:{{ $settings->support_number }}">{{ $settings->support_number }}</a></p>
                    <p class="email d-flex align-items-center"><ion-icon class="fs-5 me-2"
                            name="mail-outline"></ion-icon></i> <b
                            class="me-1 d-none">{{ labels('front_messages.email', 'Email') }}:</b> <a
                            href="mailto:{{ $settings->support_email }}">{{ $settings->support_email }}</a></p>
                    @if (
                            $settings->twitter_link !== null ||
                            $settings->facebook_link !== null ||
                            $settings->instagram_link !== null ||
                            $settings->youtube_link !== null
                        )
                        <ul class="list-inline  mt-3">
                            {{--
                            @if ($settings->twitter_link !== null)
                            <li class="list-inline-item"><a href="{{ $settings->twitter_link }}" data-bs-toggle="tooltip"
                                    data-bs-placement="top" title="Twitter"><i class="anm anm-twitter hdr-icon icon "
                                        style="font-size: 24px; height: 24px; width: 24px;"></i></a></li>
                            @endif
                            --}}
                            @if ($settings->facebook_link !== null)
                                <li class="list-inline-item">
                                    <a href="{{ $settings->facebook_link }}" target="_blank" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="Facebook">

                                        <img src="{{ asset('assets/img/facebook.png') }}" alt="Facebook" width="24" height="24"
                                            style="object-fit: contain;">
                                    </a>
                                </li>
                            @endif


                            @if ($settings->instagram_link !== null)
                                <li class="list-inline-item">
                                    <a href="{{ $settings->instagram_link }}" target="_blank" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="Instagram">

                                        <img src="{{ asset('assets/img/instagram.png') }}" alt="Instagram" width="24"
                                            height="24" style="object-fit: contain;">
                                    </a>
                                </li>
                            @endif
                            @if ($settings->youtube_link !== null)
                                <li class="list-inline-item">
                                    <a href="{{ $settings->youtube_link }}" target="_blank" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="YouTube">

                                        <img src="{{ asset('assets/img/youtube.png') }}" alt="YouTube" width="24" height="24"
                                            style="object-fit: contain;">
                                    </a>
                                </li>
                            @endif
                            @if ($settings->linkedin_link !== null)
                                <li class="list-inline-item">
                                    <a href="{{ $settings->linkedin_link }}" target="_blank" data-bs-toggle="tooltip"
                                        data-bs-placement="top" title="LinkedIn">

                                        <img src="{{ asset('assets/img/linkedin.png') }}" alt="LinkedIn" width="24" height="24"
                                            style="object-fit: contain;">
                                    </a>
                                </li>
                            @endif
                        </ul>
                    @endif
                    @if ($settings->app_download_section == 1)
                        <ul class="list-inline  mt-3">
                            @if ($settings->app_download_section_playstore_url != '')
                                <li class="list-inline-item"><a href="{{ $settings->app_download_section_playstore_url }}"
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="Play Store">
                                        <img src="{{ asset('assets/img/playstore.png') }}" alt="Play store" width="24"
                                            height="24" style="object-fit: contain;">
                                    </a></li>
                            @endif
                            @if ($settings->app_download_section_appstore_url != '')
                                <li class="list-inline-item"><a href="{{ $settings->app_download_section_appstore_url }}"
                                        data-bs-toggle="tooltip" data-bs-placement="top" title="App Store">
                                        <img src="{{ asset('assets/img/appstore1.png') }}" alt="app store" width="24"
                                            height="24" style="object-fit: contain;">
                                    </a></li>
                            @endif
                        </ul>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @if (config('constants.ALLOW_MODIFICATION') == 0)
        <a target="blank"
            href="https://codecanyon.net/item/eshop-plus-multi-vendor-ecommerce-multi-module-website-in-laravel/56605998"
            class="buy_now_button position-fixed bottom-0 m-3 z-3 text-decoration-none">
            <div class="btn btn-primary d-flex align-items-center gap-1 mb-4 rounded-pill px-3 py-2">
                <i class="anm anm-cart-plus"></i>
                Buy Now
            </div>
        </a>
    @endif
    <hr class="horizontal light m-0">
    <div class="footer-bottom clearfix">
        <div class="container-fluid">
            <div class="d-flex-center flex-column justify-content-md-between flex-md-row-reverse">
                {{--
                <ul class="payment-icons d-flex-center mb-2 mb-md-0">
                    <li><i class="icon anm anm-cc-visa"></i></li>
                    <li><i class="icon anm anm-cc-mastercard"></i></li>
                    <li><i class="icon anm anm-cc-amex"></i></li>
                    <li><i class="icon anm anm-cc-paypal"></i></li>
                    <li><i class="icon anm anm-cc-stripe"></i></li>
                </ul>
                --}}
                <div class="copytext text"> {!! $settings->copyright_details !!}</div>
            </div>
        </div>
    </div>
    <!--Scoll Top-->
    @auth
        <iframe src="{{ url('chatify') }}" id="chat-iframe"></iframe>
    @endauth

    <style>
        .wa-float-box {
            margin-bottom: 10px;
        }

        .wa-float-btn {
            background-color: #25d366;
            color: white !important;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            text-decoration: none;
            transition: all 0.3s ease;
            position: relative;
        }

        .wa-float-btn:hover {
            transform: scale(1.1);
            background-color: #128c7e;
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.3);
        }

        .wa-float-btn .wa-pulse {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #25d366;
            border-radius: 50%;
            z-index: -1;
            opacity: 0.7;
            animation: wa-pulse-ani 2s infinite;
        }

        @keyframes wa-pulse-ani {
            0% {
                transform: scale(1);
                opacity: 0.7;
            }

            100% {
                transform: scale(1.6);
                opacity: 0;
            }
        }

        #chat-iframe {
            position: fixed;
            bottom: 20px;
            right: 20px;
            z-index: 1000;
            border: none;
            display: none;
            width: 350px;
            height: 500px;
        }

        .footer {
            padding-bottom: 0 !important;
            margin-bottom: 0 !important;
        }

        .sticky-btn-box {
            position: fixed;
            bottom: 80px;
            right: 20px;
            z-index: 999;
            display: flex;
            flex-direction: column;
            gap: 10px;
        }

        .menubar-mobile {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 60px;
            background: #fff;
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.1);
            z-index: 1001;
            padding: 5px 15px;
        }

        .menubar-item {
            text-align: center;
            flex: 1;
        }

        .menubar-icon {
            font-size: 20px;
            display: block;
            color: #333;
        }

        .menubar-label {
            font-size: 10px;
            color: #666;
            display: block;
            margin-top: 2px;
        }

        /* Adjust sticky box if menu is visible */
        @media (max-width: 991px) {
            .sticky-btn-box {
                bottom: 80px;
            }
        }
    </style>

    <div class="sticky-btn-box">
        @php
            $wa_link_number = 7758007923;
        @endphp

        @if($wa_link_number)
            <div class="wa-float-box">
                <a href="https://wa.me/{{ $wa_link_number }}?text=Hi 👋I’m interested in solar products from your website. Please contact me with details. Thanks"
                    class="wa-float-btn" target="_blank" title="Chat with us on WhatsApp">
                    <div class="wa-pulse"></div>
                    <ion-icon name="logo-whatsapp"></ion-icon>
                </a>
            </div>
        @endif

        @auth
            {{-- <a wire:navigate href="{{ customUrl('my-account/live-customer-support') }}"
                class="chat-btn chat-btn-redirect d-flex justify-content-center align-items-center"><i
                    class="anm anm-chat hdr-icon icon"></i></a>
            <div class="chat-btn chat-btn-popup d-flex justify-content-center align-items-center"><i
                    class="anm anm-chat hdr-icon icon"></i></div> --}}
        @endauth
        <div id="site-scroll" class="d-flex justify-content-center align-items-center d-none mb-2"><i
                class="icon anm anm-arw-up"></i></div>

    </div>
    <div class="menubar-mobile d-flex align-items-center justify-content-between d-lg-none">
        <div class="menubar-shop menubar-item">
            <a wire:navigate href="{{ customUrl('products') }}"><i class="menubar-icon anm anm-th-large-l"></i><span
                    class="menubar-label">{{ labels('front_messages.products', 'Products') }}</span></a>
        </div>
        @auth
            <div class="menubar-account menubar-item">
                <a href="{{ customUrl('my-account') }}" wire:navigate><i class="menubar-icon icon anm anm-user-al"></i><span
                        class="menubar-label">{{ labels('front_messages.my_account', 'My Account') }}</span></a>
            </div>
        @else
            <div class="menubar-account menubar-item">
                <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#loginModal"><i
                        class="menubar-icon icon anm anm-user-al"></i><span
                        class="menubar-label">{{ labels('front_messages.sign_in', 'Login') }}</span></a>
            </div>
        @endauth
        <div class="menubar-search menubar-item">
            <a wire:navigate href="{{ customUrl('home') }}"><span class="menubar-icon anm anm-home-l"></span><span
                    class="menubar-label">{{ labels('front_messages.home', 'Home') }}</span></a>
        </div>
        <div class="menubar-wish menubar-item">
            <a wire:navigate href="{{ customUrl('my-account.favorites') }}">
                <span class="span-count position-relative text-center"><i
                        class="menubar-icon icon anm anm-heart-l"></i><span
                        class="wishlist-count counter menubar-count">{{ $favorites['favorites_count'] }}</span></span>
                <span class="menubar-label">{{ labels('front_messages.wishlist', 'Wishlist') }}</span>
            </a>
        </div>
        <div class="menubar-cart menubar-item">
            <a href="#;" class="btn-minicart" data-bs-toggle="offcanvas" data-bs-target="#minicart-drawer">
                <span class="span-count position-relative text-center"><i
                        class="menubar-icon icon anm anm-cart-l"></i><span
                        class="cart-count counter menubar-count">{{ $cart_count }}</span></span>
                <span class="menubar-label">{{ labels('front_messages.cart', 'Cart') }}</span>
            </a>
        </div>
    </div>
    <livewire:pages.quickview-model />


    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1" aria-labelledby="loginModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content rounded-4 border-0 shadow-lg">
                <div class="modal-header border-0 pb-0">
                    <button type="button" class="btn-close shadow-none" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body p-4 pt-0">
                    @livewire('RegisterAndLogin.Login', ['isModal' => true])
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modals = ['loginModal', 'registerModal'];

        modals.forEach(modalId => {
            const modalEl = document.getElementById(modalId);
            if (modalEl) {
                modalEl.addEventListener('show.bs.modal', function () {
                    document.body.classList.add('modal-open-fix');
                });

                modalEl.addEventListener('hidden.bs.modal', function () {
                    document.body.classList.remove('modal-open-fix');
                });
            }
        });
    });
</script>