
@props(['categories'])

@once
<style>
.category-link {
    position: relative;
    z-index: 2;
}
.category-image {
    background-color: none !important;
}

.category-card {
    display: inline-block;
    text-align: center;
    transition: all 0.3s ease;
}

.category-card .category-image {
    width: 240px;
    height: 240px;
    margin: 0 auto;
    overflow: hidden;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
}

.category-card .category-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    border-radius: inherit;
    transition: transform 0.4s ease;
}

.category-card:hover .category-image img {
    transform: scale(1.05);
}

.category-card:hover {
    transform: translateY(-4px);
}

.category-title {
    color: #000;
    font-size: 16px;
    font-weight: 600;
}
</style>
@endonce

<div class="collection-slider-4items gp15 arwOut5 hov-arrow dots-hide">
    @foreach ($categories as $category)
        <x-utility.categories.cards.cardThree :$category />
    @endforeach
</div>