<div id="minicart-drawer" wire:ignore.self x-data="{ agreed: false }" x-init="$el.addEventListener('hidden.bs.offcanvas', () => { agreed = false })" class="minicart-right-drawer offcanvas offcanvas-end" tabindex="-1">
    @php
        use App\Models\Product;
        use App\Models\ComboProduct;
        use App\Services\TranslationService;
        use App\Services\MediaService;
        use App\Services\CurrencyService;
    @endphp
    @if (count($cart_data) < 1)
        <!--MiniCart Empty-->
        <div id="cartEmpty" class="cartEmpty d-flex-justify-center flex-column text-center p-3 text-muted">
            <div class="minicart-header d-flex-center justify-content-between w-100">
                <h4 class="fs-6">{{ labels('front_messages.your_cart', 'Your cart') }} (<span
                        class="cart_count">0</span> {{ labels('front_messages.items', 'Items') }})</h4>
                <button class="close-cart border-0" data-bs-dismiss="offcanvas" aria-label="Close"><ion-icon
                        name="close-outline" class="icon" data-bs-toggle="tooltip" data-bs-placement="left"
                        title="Close"></ion-icon></button>
            </div>
            <div id="display_cart">
                <div class="cartEmpty-content mt-4">
                    <ion-icon name="cart-outline" class="icon text-muted fs-1"></ion-icon>
                    <p class="my-3">{{ labels('front_messages.no_products_in_cart', 'No Products in the Cart') }}</p>
                    <!-- <a href="{{ customUrl('products') }}"
                        class="btn btn-primary cart-btn">{{ labels('front_messages.continue_shopping', 'Continue shopping dsjfkldj') }}</a> -->
                    <a href="{{ customUrl('products') }}"
                    onclick="window.location.href='{{ customUrl('products') }}'; return false;"
                    class="btn btn-primary cart-btn">
                    Continue shopping
                    </a>

                </div>
            </div>
        </div>
        <!--End MiniCart Empty-->
    @else
        <!--MiniCart Content-->
        <div id="cart-drawer" class="block block-cart">
            <div class="minicart-header">
                <button wire:ignore class="close-cart border-0" data-bs-dismiss="offcanvas" aria-label="Close">
                    <ion-icon class="icon" data-bs-toggle="tooltip" data-bs-placement="left"
                        name="close-outline"></ion-icon></button>
                <h4 class="fs-6">{{ labels('front_messages.your_cart', 'Your cart') }}
                    ({{ count($cart_data['cart_items']) }} {{ labels('front_messages.items', 'Items') }})</h4>
            </div>
            {{-- @dd($cart_data['cart_items'][0]); --}}
            <div class="minicart-content">
                <ul class="m-0 clearfix">
                    @foreach ($cart_data['cart_items'] as $items)
                        @php
                            $language_code = app(TranslationService::class)->getLanguageCode();
                            $product_name = '';
                            $product_type = $items->cart_product_type;
                            if ($items->cart_product_type == 'combo') {
                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                    ComboProduct::class,
                                    'title',
                                    $items->product_variant_id,
                                    $product_type,
                                    $language_code,
                                );
                                $pro_image = app(MediaService::class)->dynamic_image($items->comboProduct->image, 70);
                            } else {
                                $product_name = app(TranslationService::class)->getDynamicTranslation(
                                    Product::class,
                                    'name',
                                    $items->product->id,
                                    $product_type,
                                    $language_code,
                                );
                                $pro_image = app(MediaService::class)->dynamic_image($items->product->image, 70);
                            }

                        @endphp
                        <li class="item d-flex justify-content-center align-items-center">
                        @php
                                $slug = $items->cart_product_type == 'combo' ? $items->comboProduct->slug : $items->product->slug;
                                $prefix = $items->cart_product_type == 'combo' ? 'combo-products/' : 'products/';
                        @endphp

                            <a class="product-image rounded-3" wire:navigate
                                href="{{ customUrl($prefix . $slug) }}">
                                <img class="blur-up lazyload" data-src="{{ $pro_image }}" src="{{ $pro_image }}"
                                    alt="{{ $product_name }}" title="{{ $product_name }}"  />
                            </a>

                            <div class="product-details">
                                <div class="product-title-container" x-data="{ expanded: false, isOverflown: false }" x-init="$nextTick(() => { isOverflown = $refs.title.scrollHeight > $refs.title.clientHeight })">
                                    <a x-ref="title" class="" wire:navigate
                                        href="{{ customUrl($prefix . $slug) }}"
                                        :style="expanded ? 'display: block; white-space: normal;' : 'display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; text-overflow: ellipsis;'"
                                    >{{ $product_name }}</a>
                                    <span x-show="isOverflown" @click="expanded = !expanded" class="read-more-toggle text-primary pointer" style="cursor: pointer; font-size: 13px; font-weight: 500; display: inline-block; margin-top: 2px;">
                                        <span x-show="!expanded">... read more</span>
                                        <span x-show="expanded"> show less</span>
                                    </span>
                                </div>
                                @if ($items->cart_product_type != 'combo')
                                    <div class="variant-cart my-2">
                                        {{ $items['product_variants'][0]['variant_values'] }}
                                    </div>
                                @endif
                                <div class="priceRow">
                                    <div class="product-price">
                                        @php
                                            if ($items->cart_product_type == 'combo') {
                                                $price = app(CurrencyService::class)->currentCurrencyPrice(
                                                    $items->comboProduct->price ?? 0,
                                                    true,
                                                );
                                                $special_price =
                                                    $items->comboProduct->special_price &&
                                                    $items->comboProduct->special_price > 0
                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                            $items->comboProduct->special_price,
                                                            true,
                                                        )
                                                        : $price;
                                            } else {
                                                $price = app(CurrencyService::class)->currentCurrencyPrice(
                                                    $items->productVariant->price,
                                                    true,
                                                );
                                                $special_price =
                                                    $items->productVariant->special_price &&
                                                    $items->productVariant->special_price > 0
                                                        ? app(CurrencyService::class)->currentCurrencyPrice(
                                                            $items->productVariant->special_price,
                                                            true,
                                                        )
                                                        : $price;
                                            }
                                        @endphp

                                        @if ($special_price !== $price)
                                            <span class="price old-price">{{ $price }}</span>
                                        @endif
                                        <span class="price">{{ $special_price }}</span>
                                    </div>
                                </div>

                            </div>
                            @php
                                $productData = $items->cart_product_type == 'combo' ? $items->comboProduct : $items->product;
                            @endphp
                             @php
                              
                                $cartQty  = $productData->cart_qty ?? $productData->qty ?? $productData->minimum_order_quantity;
                            @endphp

                            <div class="qtyDetail text-end cart-qtyDetail">
                                <div class="qtyField">
                                    <button wire:ignore class="qtyBtn minus" href="#;">
                                        <ion-icon name="remove-outline"></ion-icon>
                                    </button>

                                    <input type="number" name="quantity" value="{{ $cartQty  }}" class="qty"
                                        max='{{ $productData->total_allowed_quantity == 0 ? 'Infinity' : $productData->total_allowed_quantity }}'
                                        step='{{ $productData->quantity_step_size }}'
                                        min='{{ $productData->minimum_order_quantity }}'
                                        data-variant-id='{{ $items->product_variant_id }}'
                                        data-product-type="{{ $items->cart_product_type }}">

                                    <button wire:ignore class="qtyBtn plus" href="#;">
                                        <ion-icon name="add-outline"></ion-icon>
                                    </button>
                                </div>

                                <a wire:click="remove_from_cart({{ $items->product_variant_id }}, '{{ $items->cart_product_type }}')"
                                    class="remove_from_cart remove pointer"
                                    data-variant-id="{{ $items->product_variant_id }}"
                                    data-product-type="{{ $items->cart_product_type }}">
                                    <ion-icon wire:ignore class="icon" data-bs-toggle="tooltip"
                                        data-bs-placement="top" name="close-outline"></ion-icon>
                                </a>
                            </div>

                        </li>
                    @endforeach
                </ul>
            </div>
            <div class="minicart-bottom">
                <div class="subtotal clearfix my-3">
                    <div class="totalInfo clearfix"><span>{{ labels('front_messages.total', 'Total') }}:</span><span
                            class="item product-price">
                          {{--  {{ app(CurrencyService::class)->currentCurrencyPrice($cart_data['sub_total'], true) }} --}}
                        {{ app(CurrencyService::class)->formateCurrency(number_format($cart_data['sub_total'], 2)) }}</span>
                    </div>

                </div>
                <div class="agree-check customCheckbox">
                    <input id="prTearm" name="tearm" type="checkbox" value="tearm" required x-model="agreed" />
                    <label for="prTearm">{{ labels('front_messages.i_agree_with_the', 'I agree with the') }}
                    </label><a wire:navigate href="{{ url('term-and-conditions') }}"
                        class="ms-1 text-link">{{ labels('front_messages.terms_and_conditions', 'Terms & conditions') }}</a>
                </div>
                <div class="minicart-action d-flex mt-3">
                    @auth
                        <a id="checkoutBtn" href="{{ url('cart/checkout') }}" wire:navigate
                            :class="{ 'disabled': !agreed }"
                            class="cart-checkout proceed-to-checkout btn btn-primary w-50 me-1 disabled">{{ labels('front_messages.check_out', 'Check Out') }}</a>
                    @else
                        @php
                            $store_slug = session('store_slug') ?? '';
                            // Get absolute URL for login (use url() to ensure absolute URL like calculator page)
                            $loginUrl = url('/login');
                            $redirectUrl = urlencode(url('cart/checkout'));

                            // Add query parameters properly
                            $queryParams = [];
                            if ($store_slug) {
                                $queryParams['store'] = $store_slug;
                            }
                            $queryParams['redirect'] = $redirectUrl;

                            $loginUrl .= '?' . http_build_query($queryParams);
                        @endphp
                        <a href="{{ $loginUrl }}" id="checkoutBtn"
                            onclick="window.location.href='{{ $loginUrl }}'; return false;"
                            data-navigate="false"
                            :class="{ 'disabled': !agreed }"
                            class="cart-checkout proceed-to-checkout btn btn-primary w-50 me-1 checkout-login-redirect disabled">{{ labels('front_messages.check_out', 'Check Out') }}</a>
                    @endauth

                    <a id="viewCartBtn" href="{{ url('cart') }}" wire:navigate
                        :class="{ 'disabled': !agreed }"
                        class="cart-checkout cart-btn btn btn-secondary w-50 ms-1 disabled">{{ labels('front_messages.view_cart', 'View Cart') }}</a>
                </div>
            </div>
        </div>
    @endif

    <!-- <script>
        // Keep modal qty inputs in sync with localStorage after DOM updates (guest users)
        document.addEventListener('DOMContentLoaded', function () {
            if (typeof syncLocalCartToUI === 'function') {
                syncLocalCartToUI();
            }
        });
        if (typeof Livewire !== 'undefined') {
            Livewire.hook('morph.updated', () => {
                if (typeof syncLocalCartToUI === 'function') {
                    syncLocalCartToUI();
                }
            });
        }

        // Additional handler as backup - runs immediately on click
        document.addEventListener('DOMContentLoaded', function() {
            const checkoutLinks = document.querySelectorAll('.checkout-login-redirect');
            checkoutLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                    e.stopPropagation();
                    const href = this.getAttribute('href');
                    if (href) {
                        window.location.href = href;
                    }
                    return false;
                }, true); // Use capture phasea
            });
        });

        // Also handle dynamically added elements
        if (typeof Livewire !== 'undefined') {
            Livewire.hook('morph.updated', ({ el, component }) => {
                const checkoutLinks = el.querySelectorAll ? el.querySelectorAll('.checkout-login-redirect') : [];
                checkoutLinks.forEach(function(link) {
                    link.addEventListener('click', function(e) {
                        e.preventDefault();
                        e.stopImmediatePropagation();
                        e.stopPropagation();
                        const href = this.getAttribute('href');
                        if (href) {
                            window.location.href = href;
                        }
                        return false;
                    }, true);
                });
            });
        }
    </script>
    <script>
document.addEventListener('DOMContentLoaded', function () {
    document.querySelectorAll('.minicart-right-drawer .product-image img').forEach(img => {
        img.style.width = '50px';
        img.style.height = '50px';
        img.style.objectFit = 'cover';
        img.style.display = 'block';
    });
});

if (typeof Livewire !== 'undefined') {
    Livewire.hook('morph.updated', () => {
        document.querySelectorAll('.minicart-right-drawer .product-image img').forEach(img => {
            img.style.width = '50px';
            img.style.height = '50px';
            img.style.objectFit = 'cover';
            img.style.display = 'block';
        });
    });
}
</script> -->


    <!--MiniCart Content-->
</div>
