@php
    $title = labels('front_messages.contact_us', 'Contact Us');
@endphp
<div id="page-content">
    <x-utility.breadcrumbs.breadcrumbOne :breadcrumb="$title" />
    <div class="container contact-style1">
        <div class="contact-form-details section pt-0">
            <div class="row">
                <div class="col-12 col-sm-12 col-md-8 col-lg-7">
                    <div class="formFeilds contact-form form-vertical mb-4 mb-md-0">
                        <div class="section-header" style="text-align: center ; margin-bottom: 20px">
                            <h2>{{ labels('front_messages.lets_get_in_touch', "Get in touch!") }}</h2>
                        </div>
                        <!-- <p class="text-center">{!! nl2br($contact_us['contact_us']) !!}</p> -->

                        <style>
                            .contact-form .form-control.is-invalid {
                                border-color: #ff0000 !important;
                            }
                            .contact-form .text-danger {
                                font-size: 14px;
                                color: #ff0000 !important;
                            }
                        </style>

                        @if ($errors->has('mailError'))
                            <p class="fw-400 text-danger mt-1">{{ $errors->first('mailError') }}</p>
                        @endif
                        <form wire:submit="send_contact_us_email" id="contact-form" class="contact-form">
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-group">
                                        <input wire:model="first_name" type="text" class="form-control @error('first_name') is-invalid @enderror"
                                            placeholder="{{ labels('front_messages.first_name', 'First Name*') }}" />
                                        @error('first_name')
                                            <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                                    <div class="form-group">
                                        <input wire:model="last_name" type="text" class="form-control @error('last_name') is-invalid @enderror"
                                            placeholder="{{ labels('front_messages.last_name', 'Last Name*') }}" />
                                        @error('last_name')
                                            <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input wire:model="mobile_number" type="text" class="form-control @error('mobile_number') is-invalid @enderror"
                                            placeholder="{{ labels('front_messages.mobile_number', 'Mobile Number*') }}" />
                                        @error('mobile_number')
                                            <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input wire:model="email" type="email" class="form-control @error('email') is-invalid @enderror"
                                            placeholder="{{ labels('front_messages.email_id', 'Email ID*') }}" />
                                        @error('email')
                                            <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-group">
                                        <textarea wire:model="message" class="form-control @error('message') is-invalid @enderror" rows="5"
                                            placeholder="{{ labels('front_messages.message', 'Message*') }}"></textarea>
                                        @error('message')
                                            <p class="fw-400 text-danger mt-1">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 mb-3">
                                    <label for="captcha" class="mb-1">{{ labels('front_messages.enter_captcha', 'Enter Captcha') }} <span class="required">*</span></label>
                                    <div class="captcha-wrapper d-flex flex-column gap-2 p-3 border rounded" style="background: #fdfdfd; border-color: #eee !important;">
                                        <div class="d-flex align-items-center gap-2">
                                            <div id="contact-captcha-img-container">
                                                {!! captcha_img('flat') !!}
                                            </div>
                                            <button type="button" class="btn btn-outline-secondary btn-sm d-flex align-items-center justify-content-center"
                                                wire:click="refreshCaptcha"
                                                style="height: 35px; width: 35px; min-width: 35px; padding: 0;"
                                                title="Refresh Captcha">
                                                <span wire:ignore>
                                                    <ion-icon name="refresh-outline" style="font-size: 20px;"></ion-icon>
                                                </span>
                                            </button>
                                        </div>
                                        <input wire:model="captcha" type="text" id="contact_captcha_input"
                                            class="form-control mt-1 @error('captcha') is-invalid @enderror"
                                            placeholder="Type the code shown above"
                                            autocomplete="off"
                                            style="height: 40px !important;">
                                        @error('captcha')
                                            <p class="fw-400 text-danger mt-1 mb-0" style="font-size: 13px;">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="form-row">
                                <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                                    <div class="form-group mailsendbtn mb-0 ">
                                        <button
                                            class="btn btn-md">{{ labels('front_messages.send_message', 'Send Message') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-12 col-sm-12 col-md-4 col-lg-5 " style="margin-top: 60px">
                    <div class="contact-details bg-block">
                        <h3 class="mb-3 fs-5">{{ labels('front_messages.store_information', 'Store information') }}
                        </h3>
                        <ul class="list-unstyled">
                            <li class="mb-2 address">
                                <strong class="d-block mb-2">{{ labels('front_messages.address', 'Address') }}
                                    :</strong>
                                <p><i class="icon anm anm-map-marker-al me-2 d-none"></i>{{ $web_settings['address'] }}
                                </p>
                            </li>
                            <li class="mb-2 phone"><strong>{{ labels('front_messages.mobile', 'Phone') }} :</strong><i
                                    class="icon anm anm-phone me-2 d-none"></i> <a
                                    href="tel:{{ $web_settings['support_number'] }}">{{ $web_settings['support_number'] }}</a>
                            </li>
                            <li class="mb-0 email"><strong>{{ labels('front_messages.email', 'Email') }} :</strong><i
                                    class="icon anm anm-envelope-l me-2 d-none"></i> <a
                                    href="mailto:{{ $web_settings['support_email'] }}">{{ $web_settings['support_email'] }}</a>
                            </li>
                        </ul>
                        <hr>
                        <div class="follow-us">
                            <label for=""
                                class="d-block mb-3"><strong>{{ labels('front_messages.stay_connected', 'Stay Connected') }}</strong></label>
                            <ul class="list-inline  mt-3">
                                <!-- <li class="list-inline-item"><a href="{{ $web_settings['facebook_link'] }}"
                                        target="_blank" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="Facebook"><i class="anm anm-facebook hdr-icon icon"></i></a>
                                </li> -->

                                 @if ($web_settings['facebook_link'] !== null)
                                        <li class="list-inline-item">
                                            <a href="{{ $web_settings['facebook_link'] }}"
                                            target="_blank"
                                            data-bs-toggle="tooltip"
                                            data-bs-placement="top"
                                            title="Facebook">

                                                <img src="{{ asset('assets/img/facebook.png') }}"
                                                    alt="Facebook"
                                                    width="24"
                                                    height="24"
                                                    style="object-fit: contain;">
                                            </a>
                                        </li>
                                @endif

                                 @if ($web_settings['instagram_link'] !== null)
                            <li class="list-inline-item">
                                <a href="{{ $web_settings['instagram_link'] }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="Instagram">

                                    <img src="{{ asset('assets/img/instagram.png') }}"
                                        alt="Instagram"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                        @if ($web_settings['youtube_link'] !== null)
                            <li class="list-inline-item">
                                <a href="{{ $web_settings['youtube_link'] }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="YouTube">

                                    <img src="{{ asset('assets/img/youtube.png') }}"
                                        alt="YouTube"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                         @if ($web_settings['linkedin_link'] !== null)
                            <li class="list-inline-item">
                                <a href="{{ $web_settings['linkedin_link'] }}"
                                target="_blank"
                                data-bs-toggle="tooltip"
                                data-bs-placement="top"
                                title="LinkedIn">

                                    <img src="{{ asset('assets/img/linkedin.png') }}"
                                        alt="LinkedIn"
                                        width="24"
                                        height="24"
                                        style="object-fit: contain;">
                                </a>
                            </li>
                        @endif
                                {{--
                                <li class="list-inline-item"><a href="{{ $web_settings['twitter_link'] }}"
                                        target="_blank" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="Twitter"><i class="anm anm-twitter hdr-icon icon"></i></a>
                                </li>
                                --}}
                                <!-- <li class="list-inline-item"><a href="{{ $web_settings['instagram_link'] }}"
                                        target="_blank" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="Instagram"><i class="anm anm-instagram hdr-icon icon"></i></a>
                                </li>
                                <li class="list-inline-item"><a href="{{ $web_settings['youtube_link'] }}"
                                        target="_blank" data-bs-toggle="tooltip" data-bs-placement="top"
                                        title="Youtube"><i class="anm anm-youtube hdr-icon icon"></i></a>
                                </li> -->
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        window.addEventListener('refreshCaptcha', event => {
            fetch('/captcha/flat?' + Math.random())
                .then(response => response.url)
                .then(url => {
                    const container = document.getElementById('contact-captcha-img-container');
                    if (container) {
                        const img = container.querySelector('img');
                        if (img) img.src = url;
                    }
                });
        });
    </script>
</div>
