@php
    // dd(count($products_listing) < 1);
    // dd(count($Attributes) >= 1 && count($products_listing) < 1);
    $showFilter = true;
    use App\Models\Brand;
    use App\Services\TranslationService;
    use App\Services\StoreService;
    use App\Services\MediaService;
    use App\Services\CurrencyService;

    // Custom Sort options
    $sortByOptions = [
        '' => labels('front_messages.featured', 'Featured'),
        'top-rated' => labels('front_messages.top_rated', 'Top Rated'),
        'price-asc' => labels('front_messages.price_low_to_high', 'Price, low to high'),
        'price-desc' => labels('front_messages.price_high_to_low', 'Price, high to low'),
        'oldest-first' => labels('front_messages.old_to_new', 'Old to New'),
        'latest-products' => labels('front_messages.new_to_old', 'New to Old'),
    ];
    $currentSortLabel = $sortByOptions[$sorted_by] ?? $sortByOptions[''];
@endphp

<style>
    /* Custom List-based Dropdown Styles for Sort By */
    .custom-toolbar-dropdown {
        position: relative;
        display: inline-block;
    }
    .custom-toolbar-dropdown .dropdown-toggle {
        padding: 5px 12px;
        border: 1px solid #ddd;
        background: #fff;
        cursor: pointer;
        display: flex;
        align-items: center;
        min-width: 150px;
        justify-content: space-between;
        font-size: 14px;
        border-radius: 4px;
        color: #333;
    }
    .custom-toolbar-dropdown .dropdown-list {
        position: absolute;
        top: 100%;
        right: 0;
        background: #fff;
        border: 1px solid #ddd;
        border-radius: 4px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
        z-index: 1060;
        display: none;
        min-width: 180px;
        overflow: visible; /* Changed from hidden to allow pseudo-element bridge */
    }
    /* Bridge the gap between toggle and list to maintain hover state */
    .custom-toolbar-dropdown .dropdown-list::before {
        content: '';
        position: absolute;
        top: -10px;
        left: 0;
        width: 100%;
        height: 10px;
        background: transparent;
    }
    .custom-toolbar-dropdown:hover .dropdown-list {
        display: block;
    }
    .custom-toolbar-dropdown .dropdown-list ul {
        list-style: none !important;
        margin: 0 !important;
        padding: 5px 0 !important;
    }
    .custom-toolbar-dropdown .dropdown-list ul li {
        margin: 0 !important;
        padding: 0 !important;
        list-style: none !important;
    }
    .custom-toolbar-dropdown .dropdown-list ul li a {
        display: block;
        padding: 8px 15px;
        color: #333 !important;
        text-decoration: none !important;
        transition: all 0.2s;
        font-size: 14px;
        text-align: left;
    }
    .custom-toolbar-dropdown .dropdown-list ul li a:hover {
        background: #f8f9fa;
        color: var(--primary-color, #5dc943) !important;
    }
    
    .filters-toolbar-item, .shop-toolbar {
        overflow: visible !important;
    }

    /* Fix Product Card Image Layout */
    .product-box .product-image .product-img {
        display: block;
        width: 100%;
        height: 100%;
        aspect-ratio: 4 / 5; /* standard product ratio */
        overflow: hidden;
        background-color: #f8f8f8; /* placeholder color */
    }

    .product-box .product-image .product-img img {
        width: 100%;
        height: 100%;
        object-fit: cover !important;
    }

    /* Specific height for combo products or specific grid styles if needed */
    .img-box-h300px {
        height: 300px !important;
    }
</style>
<div id="page-content">
    <div class="template-product">
        <div class="page-header text-center">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12 col-sm-12 col-md-12 col-lg-12">
                        <!--Breadcrumbs-->
                        <div class="breadcrumbs"><a wire:navigate href="{{ customUrl('/') }}"
                                title="Back to the home page">{{ labels('front_messages.home', 'Home') }}</a>
                            @if (isset($bread_crumb['right_breadcrumb']) && !empty($bread_crumb['right_breadcrumb']))
                                @foreach ($bread_crumb['right_breadcrumb'] as $right_breadcrumb)
                                    <span class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                            name="chevron-forward-outline"></ion-icon>{!! $right_breadcrumb !!}</span>
                                @endforeach
                            @endif
                            <span class="main-title fw-bold"><ion-icon class="align-text-top icon"
                                    name="chevron-forward-outline"></ion-icon>{!! $bread_crumb['page_main_bread_crumb'] ?? 'Products' !!}</span>
                        </div>
                        <!--End Breadcrumbs-->
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="container-fluid">
        {{--
        @if ($bySearch != null)
            <div class="search-results-form mb-4 pb-4 mb-lg-5 pb-lg-5 border-bottom">
                <div class="row">
                    <div class="col-12 col-sm-12 col-md-8 offset-md-2 col-lg-6 offset-lg-3">
                        <div class="page-title text-center mb-3">
                            <h2 class="mb-2">{{ labels('front_messages.results_for', 'Results for') }}
                                "{{ $bySearch }}"</h2>
                            <p>{{ count($products_listing) }}
                                {{ labels('front_messages.results_found_for', 'results found for') }}
                                "{{ $bySearch }}"</p>
                        </div>
                    </div>
                </div>
            </div>
        @endif
        --}}
        <div class="row">
            <!--Sidebar-->
            @if ($showFilter == true)
                <div class="col-12 col-sm-12 col-md-12 col-lg-3 sidebar sidebar-bg filterbar">
                    <div class="closeFilter d-block d-lg-none"><ion-icon class="icon" name="close-outline"></ion-icon>
                    </div>
                    <div class="sidebar-tags sidebar-sticky clearfix">
                        <!--Filter By-->
                            <div class="sidebar-widget filterBox filter-widget border-0 p-0">
                                <div class="d-flex justify-content-between align-items-center gap-2">
                                    <h2>{{ labels('front_messages.filter_by', 'Filters') }}</h2>
                                    <!-- <p class="cursor-pointer toggle-filter-tab show_tabs m-0">
                                        {{ labels('front_messages.close_all_tabs', 'Close All Tabs') }}</p>
                                    <p class="cursor-pointer toggle-filter-tab close_tabs d-none m-0">
                                        {{ labels('front_messages.show_all_tabs', 'Show All Tabs') }}</p> -->
                                          <a wire:navigate
                                href="{{ customUrl(url()->current()) }}"
                                class="btn btn-sm btn-secondary">
                                {{ labels('front_messages.clear', 'Reset') }}
                                </a>

                                </div>
                            </div>
                        <!--End Filter By-->
                        <!--Price Filter-->
                         @if ($min_max_price['max_price'] >= 1)
                        <div class="divider filterBox filter-widget">
                            <div class="widget-title">
                                <h2>{{ labels('front_messages.price', 'Price') }}</h2>
                            </div>

                            <div class="widget-content price-filter filterDD">
                                <ul class="sidebar-categories scrollspy morelist clearfix">
                                    @php
                                        $currency_symbol = app(\App\Services\CurrencyService::class)->getDefaultCurrency()->symbol;
                                        $max_val = (int)$min_max_price['max_price'];
                                        $ranges = [
                                            [
                                                'min' => 0,
                                                'max' => 50000,
                                                'label' => 'Less than ' . $currency_symbol . '50,000',
                                            ],
                                            [
                                                'min' => 50000,
                                                'max' => 200000,
                                                'label' => $currency_symbol . '50,000 to ' . $currency_symbol . '2 Lakh',
                                            ],
                                            [
                                                'min' => 200000,
                                                'max' => 350000,
                                                'label' => $currency_symbol . '2 Lakh to ' . $currency_symbol . '3.5 Lakh',
                                            ],
                                            [
                                                'min' => 350000,
                                                'max' => 500000,
                                                'label' => $currency_symbol . '3.5 Lakh to ' . $currency_symbol . '5 Lakh',
                                            ],
                                            [
                                                'min' => 500000,
                                                'max' => 700000,
                                                'label' => $currency_symbol . '5 Lakh to ' . $currency_symbol . '7 Lakh',
                                            ],
                                            [
                                            'min' => 700000,
                                            'max' => $max_val,
                                            'label' => $currency_symbol . '7 Lakh & above',
                                        ]

                                        ];

                                    @endphp
                                    @php
                                        $selected_ranges = explode(',', request()->price_ranges ?? '');
                                        if (request()->min_price !== null && request()->max_price !== null) {
                                            $selected_ranges[] = request()->min_price . '-' . request()->max_price;
                                        }
                                        $visibleCount = 0;
                                    @endphp
                                    @foreach($ranges as $range)
                                        @if($range['min'] < $max_val)
                                            <li class="lvl1 {{ $visibleCount >= 3 ? 'more-item' : '' }}"
                                                style="{{ $visibleCount >= 3 ? 'display: none;' : '' }}">
                                                <input type="checkbox"
                                                    class="price-range-filter"
                                                    id="price-{{ $range['min'] }}-{{ $range['max'] }}"
                                                    data-min="{{ $range['min'] }}"
                                                    data-max="{{ $range['max'] }}"
                                                    {{ in_array($range['min'] . '-' . $range['max'], $selected_ranges) ? 'checked' : '' }}>
                                                <label for="price-{{ $range['min'] }}-{{ $range['max'] }}">
                                                    <span></span>{{ $range['label'] }}
                                                </label>
                                            </li>
                                            @php $visibleCount++; @endphp
                                        @endif
                                    @endforeach
                                </ul>

                                @if($visibleCount > 3)
                                    <div class="showMore price-show-more">
                                        <a href="javascript:void(0);">
                                            <span class="text">{{ labels('front_messages.show_more', 'Show More') }}</span>
                                        </a>
                                    </div>
                                @endif

                                <script>
                                    function initPriceShowMore() {
                                        $('.price-show-more a').off('click').on('click', function() {
                                            let $this = $(this);
                                            let $widget = $this.closest('.widget-content');
                                            let $moreItems = $widget.find('.more-item');
                                            let isExpanded = $moreItems.first().is(':visible');

                                            if (isExpanded) {
                                                $moreItems.slideUp();
                                                $this.find('.text').text("{{ labels('front_messages.show_more', 'Show More') }}");
                                            } else {
                                                $moreItems.slideDown();
                                                $this.find('.text').text("{{ labels('front_messages.show_less', 'Show Less') }}");
                                            }
                                        });
                                    }

                                    function applyPriceFilter() {
                                        initPriceShowMore();

                                        $(document).off('change', '.price-range-filter').on('change', '.price-range-filter', function() {
                                            let checkedRanges = [];
                                            $('.price-range-filter:checked').each(function() {
                                                checkedRanges.push($(this).data('min') + '-' + $(this).data('max'));
                                            });

                                            let url = new URL(window.location.href);
                                            if (checkedRanges.length > 0) {
                                                url.searchParams.set('price_ranges', checkedRanges.join(','));
                                                url.searchParams.delete('min_price');
                                                url.searchParams.delete('max_price');
                                            } else {
                                                url.searchParams.delete('price_ranges');
                                                url.searchParams.delete('min_price');
                                                url.searchParams.delete('max_price');
                                            }

                                            // Reset pagination
                                            url.searchParams.delete('page');

                                            if (typeof Livewire !== 'undefined') {
                                                Livewire.navigate(url.toString());
                                            } else {
                                                window.location.href = url.toString();
                                            }
                                        });
                                    }

                                    document.addEventListener('DOMContentLoaded', applyPriceFilter);
                                    document.addEventListener("livewire:navigated", applyPriceFilter);
                                </script>
                            </div>
                        </div>
                        @endif


                        <div class="divider filterBox filter-widget">
                            <div class="widget-title">
                                <h2>{{ labels('front_messages.stock', 'In Stock') }}</h2>
                            </div>

                            <div class="widget-content filterDD">
                                <ul class="sidebar-categories scrollspy clearfix">
                                    <li class="lvl1">
                                        <input
                                            type="checkbox"
                                            id="in_stock"
                                            {{ request()->in_stock == 1 ? 'checked' : '' }}
                                        />
                                        <label for="in_stock">
                                            <span></span>{{ labels('front_messages.in_stock', 'Show only In-Stock products') }}
                                        </label>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <script>
                            function applyStockFilter() {
                                document.getElementById("in_stock").addEventListener("change", function () {
                                    let url = new URL(window.location.href);

                                    if (this.checked) {
                                        url.searchParams.set("in_stock", 1);
                                    } else {
                                        url.searchParams.delete("in_stock");
                                    }

                                    // Reset pagination
                                    url.searchParams.delete('page');

                                    if (typeof Livewire !== 'undefined') {
                                        Livewire.navigate(url.toString());
                                    } else {
                                        window.location.href = url.toString();
                                    }
                                });
                            }
                            document.addEventListener('DOMContentLoaded', applyStockFilter);
                            document.addEventListener("livewire:navigated", applyStockFilter);
                        </script>



                        {{-- @dd($Attributes) --}}
                        <!--End Price Filter-->
                        @if (count($filter_categories ?? []) >= 1)
                            <style>
                                .category-filter-list {
                                    list-style: none;
                                    padding: 0;
                                    margin: 0;
                                }
                                .category-filter-list .cat-item {
                                    display: flex;
                                    align-items: center;
                                    width: 100%;
                                    padding: 4px 0;
                                }
                                .category-filter-list .form-check-input {
                                    width: 18px !important;
                                    height: 18px !important;
                                    margin-top: 0 !important;
                                    cursor: pointer !important;
                                    border: 1px solid #ced4da !important;
                                    display: inline-block !important;
                                    -webkit-appearance: checkbox !important;
                                    appearance: checkbox !important;
                                    opacity: 1 !important;
                                    visibility: visible !important;
                                    position: relative !important;
                                    z-index: 10 !important;
                                    flex-shrink: 0 !important;
                                }
                                .category-filter-list .cat-label {
                                    margin-left: 12px;
                                    cursor: pointer;
                                    flex-grow: 1;
                                    font-size: 15px;
                                    font-weight: 400;
                                    color: #333;
                                    margin-bottom: 0;
                                }
                                .category-filter-list li.lvl1 > .cat-item > .cat-label {
                                    font-weight: 600;
                                    font-size: 16px;
                                }
                                .category-filter-list .sub-menu {
                                    list-style: none;
                                    padding-left: 20px;
                                    margin-bottom: 5px;
                                }
                            </style>
                            <div class="divider filterBox filter-widget category-filter">
                                <div class="widget-title">
                                    <h2>{{ labels('front_messages.categories', 'Categories') }}</h2>
                                </div>
                                <div class="widget-content filterDD">
                                    <ul class="category-filter-list scrollspy clearfix">
                                        @foreach ($filter_categories as $categoryFilter)
                                            <li class="lvl1 {{ $loop->index >= 3 ? 'more-item' : '' }}"
                                                style="{{ $loop->index >= 3 ? 'display: none;' : '' }}">
                                                <input type="checkbox"
                                                       class="category-range-filter"
                                                       id="cat-{{ $categoryFilter->slug }}"
                                                       value="{{ $categoryFilter->slug }}"
                                                       {{ $categoryFilter->is_checked ? 'checked' : '' }}>
                                                <label for="cat-{{ $categoryFilter->slug }}" style="font-weight: bold;">
                                                    <span></span>{{ $categoryFilter->name }}
                                                </label>

                                                @if(count($categoryFilter->children) > 0)
                                                    <ul class="sub-menu">
                                                        @foreach($categoryFilter->children as $subCat)
                                                            <li class="lvl2">
                                                                <input type="checkbox"
                                                                       class="category-range-filter"
                                                                       id="cat-{{ $subCat->slug }}"
                                                                       value="{{ $subCat->slug }}"
                                                                       {{ $subCat->is_checked ? 'checked' : '' }}>
                                                                <label for="cat-{{ $subCat->slug }}"  >
                                                                    <span></span>{{ $subCat->name }}
                                                                </label>

                                                                @if(count($subCat->children) > 0)
                                                                    <ul class="sub-menu">
                                                                        @foreach($subCat->children as $subSubCat)
                                                                            <li class="lvl3">
                                                                                <input type="checkbox"
                                                                                       class="category-range-filter"
                                                                                       id="cat-{{ $subSubCat->slug }}"
                                                                                       value="{{ $subSubCat->slug }}"
                                                                                       {{ $subSubCat->is_checked ? 'checked' : '' }}>
                                                                                <label for="cat-{{ $subSubCat->slug }}">
                                                                                    <span></span>{{ $subSubCat->name }}
                                                                                </label>
                                                                            </li>
                                                                        @endforeach
                                                                    </ul>
                                                                @endif
                                                            </li>
                                                        @endforeach
                                                    </ul>
                                                @endif
                                            </li>
                                        @endforeach
                                    </ul>
                                    @if(count($filter_categories) > 3)
                                        <div class="showMore category-show-more">
                                            <a href="javascript:void(0);">
                                                <span class="text">{{ labels('front_messages.show_more', 'Show More') }}</span>
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <script>
                                function initCategoryShowMore() {
                                    $('.category-show-more a').off('click').on('click', function() {
                                        let $this = $(this);
                                        let $widget = $this.closest('.widget-content');
                                        let $moreItems = $widget.find('.more-item');
                                        let isExpanded = $moreItems.first().is(':visible');

                                        if (isExpanded) {
                                            $moreItems.slideUp();
                                            $this.find('.text').text("{{ labels('front_messages.show_more', 'Show More') }}");
                                            $this.find('i').removeClass('anm-minus-r').addClass('anm-plus-r');
                                        } else {
                                            $moreItems.slideDown();
                                            $this.find('.text').text("{{ labels('front_messages.show_less', 'Show Less') }}");
                                            $this.find('i').removeClass('anm-plus-r').addClass('anm-minus-r');
                                        }
                                    });
                                }

                                function applyCategoryFilter() {
                                    console.log('Attaching category filter listeners');
                                    initCategoryShowMore();

                                    $(document).off('change', '.category-range-filter').on('change', '.category-range-filter', function() {
                                        let selectedSlugs = [];
                                        $('.category-range-filter:checked').each(function() {
                                            selectedSlugs.push($(this).val());
                                        });

                                        let url = new URL(window.location.href);
                                        if (selectedSlugs.length > 0) {
                                            url.searchParams.set('category', selectedSlugs.join(','));
                                        } else {
                                            url.searchParams.delete('category');
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });
                                }

                                document.addEventListener('DOMContentLoaded', applyCategoryFilter);
                                document.addEventListener("livewire:navigated", applyCategoryFilter);
                            </script>
                        @endif

                            @if (count($Attributes) >= 1)
                                @foreach ($Attributes as $Attribute)
                                    <div class="divider filterBox filter-widget brand-filter">
                                        <div class="widget-title">
                                            <h2>{{ $Attribute['attribute_name'] }}</h2>
                                        </div>
                                        <div class="widget-content filterDD">
                                            <ul class="sidebar-categories scrollspy clearfix">
                                                @foreach ($Attribute['attribute_values'] as $key => $type)
                                                    <li class="lvl1 {{ $key >= 3 ? 'more-item' : '' }}"
                                                        style="{{ $key >= 3 ? 'display: none;' : '' }}">
                                                        <input type="checkbox"
                                                                value="{{ $Attribute['attribute_values'][$key] }}"
                                                                id="attr-{{ $Attribute['attribute_values'][$key] }}-{{ $key }}"
                                                                class="product-filter"
                                                                data-attribute="{{ $Attribute['attribute_name'] }}"
                                                                {{ $Attribute['is_checked'][$key] == true ? 'checked' : '' }}>
                                                        <label for="attr-{{ $Attribute['attribute_values'][$key] }}-{{ $key }}">
                                                            <span></span>{{ $Attribute['attribute_values'][$key] }}
                                                        </label>
                                                    </li>
                                                @endforeach
                                            </ul>
                                            @if(count($Attribute['attribute_values']) > 3)
                                                <div class="showMore attribute-show-more">
                                                    <a href="javascript:void(0);">
                                                        <span class="text">{{ labels('front_messages.show_more', 'Show More') }}</span>
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endforeach
                            @endif

                            @if ($products_type == 'regular')
                                @if (count($brands) >= 1)
                                    <div class="  filterBox filter-widget brand-filter">
                                        <div class="widget-title">
                                            <h2>Brands</h2>
                                        </div>
                                        <div class="widget-content filterDD">
                                            <ul class="sidebar-categories scrollspy clearfix">
                                                @foreach ($brands as $index => $brand)
                                                    <li class="lvl1 {{ $index >= 3 ? 'more-item' : '' }}"
                                                        style="{{ $index >= 3 ? 'display: none;' : '' }}">
                                                        <input type="checkbox" value="{{ $brand->slug }}"
                                                            id="brand-{{ $brand->slug }}" class="brand"
                                                            {{ $brand->is_checked == true ? 'checked' : '' }}>
                                                        <label for="brand-{{ $brand->slug }}"
                                                            class="d-flex align-items-center"><span></span>
                                                            <div class="filter-brand-img"><img
                                                                    src="{{ app(MediaService::class)->dynamic_image(app(MediaService::class)->getMediaImageUrl($brand->image), 40) }}"
                                                                    alt="{{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $brand->id, $language_code) }}"
                                                                    srcset=""></div>
                                                            {{ app(TranslationService::class)->getDynamicTranslation(Brand::class, 'name', $brand->id, $language_code) }}
                                                        </label>
                                                    </li>
                                                @endforeach
                                            </ul>
                                            @if(count($brands) > 3)
                                                <div class="showMore brand-show-more">
                                                    <a href="javascript:void(0);">
                                                        <span class="text">{{ labels('front_messages.show_more', 'Show More') }}</span>
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                @endif
                            @endif

                            <!-- <div class="text-right">
                                <a wire:navigate
                                href="{{ customUrl(url()->current()) }}"
                                class="btn btn-sm btn-secondary">
                                {{ labels('front_messages.clear', 'Clear') }}
                                </a>

                                <button
                                    class="btn btn-sm product-filter-btn">{{ labels('front_messages.filter', 'filter') }}</button>
                            </div> -->

                            <script>
                                function initFilterShowMore() {
                                    $('.attribute-show-more a, .brand-show-more a').off('click').on('click', function() {
                                        let $this = $(this);
                                        let $widget = $this.closest('.widget-content');
                                        let $moreItems = $widget.find('.more-item');
                                        let isExpanded = $moreItems.first().is(':visible');

                                        if (isExpanded) {
                                            $moreItems.slideUp();
                                            $this.find('.text').text("{{ labels('front_messages.show_more', 'Show More') }}");
                                        } else {
                                            $moreItems.slideDown();
                                            $this.find('.text').text("{{ labels('front_messages.show_less', 'Show Less') }}");
                                        }
                                    });
                                }

                                function applyBrandAndAttributeFilters() {
                                    initFilterShowMore();

                                    // Brand Filter
                                    $(document).off('change', '.brand').on('change', '.brand', function() {
                                        let url = new URL(window.location.href);
                                        if ($(this).is(':checked')) {
                                            url.searchParams.set('brand', $(this).val());
                                        } else {
                                            url.searchParams.delete('brand');
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });

                                    // Attribute Filter
                                    $(document).off('change', '.product-filter').on('change', '.product-filter', function() {
                                        let url = new URL(window.location.href);
                                        let attrName = $(this).data('attribute');
                                        let attrValue = $(this).val();

                                        if ($(this).is(':checked')) {
                                            url.searchParams.set('filter-' + attrName, attrValue);
                                        } else {
                                            url.searchParams.delete('filter-' + attrName);
                                        }

                                        // Reset pagination
                                        url.searchParams.delete('page');

                                        if (typeof Livewire !== 'undefined') {
                                            Livewire.navigate(url.toString());
                                        } else {
                                            window.location.href = url.toString();
                                        }
                                    });
                                }

                                document.addEventListener('DOMContentLoaded', applyBrandAndAttributeFilters);
                                document.addEventListener("livewire:navigated", applyBrandAndAttributeFilters);
                            </script>
                       {{-- @endif --}}
                        <div class="sidebar-offers mt-4">
                            @livewire('offers.offers-section', ['is_sidebar' => true])
                        </div>
                    </div>

                </div>
            @endif

            <!--End Sidebar-->

            <!--Products-->
            <div class="col-12 col-sm-12 col-md-12 {{ $showFilter == true ? 'col-lg-9' : '' }}  main-col">

                @php
                    $activeFilters = [];
                    // Collect attribute filters from query params starting with filter-
                    foreach (request()->query() as $key => $value) {
                        if (strpos($key, 'filter-') === 0 && !empty($value)) {
                            $attrName = str_replace('filter-', '', $key);
                            $activeFilters[] = [
                                'label' => ucfirst($attrName) . ': ' . $value,
                                'remove_keys' => [$key],
                            ];
                        }
                    }
                    // Brand filter chip (brand slug exists in query, name already checked above)
                    if (!empty(request()->query('brand'))) {
                        $brandSlug = request()->query('brand');
                        // Try to find readable name from provided $brands (they have is_checked state)
                        $brandName = null;
                        if (isset($brands)) {
                            foreach ($brands as $b) {
                                if ($b->slug === $brandSlug) {
                                    $brandName = app(\App\Services\TranslationService::class)->getDynamicTranslation(\App\Models\Brand::class, 'name', $b->id, $language_code);
                                    break;
                                }
                            }
                        }
                        $activeFilters[] = [
                            'label' => 'Brand: ' . ($brandName ?? $brandSlug),
                            'remove_keys' => ['brand'],
                        ];
                    }
                    // Price filter chip (only if selected differs from overall min/max)
                    if (isset($min_max_price) && ($min_max_price['selected_min_price'] != $min_max_price['min_price'] || $min_max_price['selected_max_price'] != $min_max_price['max_price'])) {
                        $activeFilters[] = [
                            'label' => 'Price: ' . $min_max_price['selected_min_price'] . ' - ' . $min_max_price['selected_max_price'],
                            'remove_keys' => ['min_price', 'max_price'],
                        ];
                    }
                    // Multiple Price ranges chips
                    if (!empty(request()->query('price_ranges'))) {
                        $p_ranges = explode(',', request()->query('price_ranges'));
                        foreach ($p_ranges as $p_range) {
                            $activeFilters[] = [
                                'label' => 'Price: ' . $p_range,
                                'remove_keys' => ['price_ranges'], // This is tricky, removing one range from a list
                                'range_to_remove' => $p_range,
                            ];
                        }
                    }
                    // Search chip
                    if (!empty($bySearch)) {
                        $activeFilters[] = [
                            'label' => 'Search: ' . $bySearch,
                            'remove_keys' => ['search'],
                        ];
                    }
                @endphp


                @if (count($sub_categories) >= 1)
                    <x-utility.categories.subCategories.subCategoriesSection :$sub_categories :language_code="$language_code" />
                @endif
                <!--Toolbar-->
                    <div class="toolbar toolbar-wrapper shop-toolbar">
                        <div class="row align-items-center">
                            <div
                                class="col-4 col-sm-2 col-md-4 col-lg-4 text-left filters-toolbar-item d-flex order-1 order-sm-0">
                                <button type="button"
                                    class="p-0 px-2 btn icon anm anm-sliders-hr d-inline-flex d-lg-none me-2"><ion-icon
                                        class="btn-filter icon fs-5" name="options-outline"></ion-icon><span
                                        class="d-none">{{ labels('front_messages.filter', 'filter') }}</span></button>
                                <div class="filters-item d-flex align-items-center">
                                    <label
                                        class="mb-0 me-2 d-none d-lg-inline-block">{{ labels('front_messages.view_as', 'View as') }}:</label>
                                    <div class="grid-options view-mode d-flex">
                                        <a class="icon-mode mode-list d-none  d-md-block {{ $view_mode == 'list' ? 'active' : '' }}"
                                            data-col="1" data-value="list"></a>
                                        <a class="icon-mode mode-grid grid-2 d-none  d-md-block" data-col="2"></a>
                                        <a class="icon-mode mode-grid grid-3 d-md-block" data-col="3"></a>
                                        <a class="icon-mode mode-grid grid-4 d-lg-block {{ $view_mode == 'list' ? '' : 'active' }}"
                                            data-col="4"></a>

                                    </div>
                                </div>
                            </div>
                            <div
                                class="col-12 col-sm-4 col-md-4 col-lg-4 text-center product-count order-0 order-md-1 mb-3 mb-sm-0">
                                @if (count($products_listing) >= 1)
                                    @php
                                        $currentPage = request()->input('page', 1);
                                        $from = ($currentPage - 1) * $perPage + 1;
                                        $to = min($from + count($products_listing) - 1, $total_products);
                                    @endphp
                                    <span class="toolbar-product-count">
                                        {{ labels('front_messages.showing', 'Showing') }}
                                        {{ $from }}
                                        {{ labels('front_messages.to', 'to') }}
                                        {{ $to }}
                                        {{ labels('front_messages.of', 'of') }}
                                        {{ $total_products }}
                                        {{ labels('front_messages.results', 'results') }}
                                    </span>
                                @endif
                            </div>
                            <div
                                class="col-8 col-sm-6 col-md-4 col-lg-4 text-right filters-toolbar-item d-flex justify-content-end order-2 order-sm-2">
                                <div class="filters-item d-flex align-items-center ms-2 ms-lg-3">
                                    <label for="perPage"
                                        class="mb-0 me-2 text-nowrap d-none">{{ labels('front_messages.per_page', 'Per Page') }}:</label>
                                    <select name="perPage" id="perPage" class="filters-toolbar-perPage me-2">
                                        <option value="12" {{ $perPage == '12' ? 'selected' : '' }}>12
                                        </option>
                                        <option value="16" {{ $perPage == '16' ? 'selected' : '' }}>16
                                        </option>
                                        <option value="20" {{ $perPage == '20' ? 'selected' : '' }}>20
                                        </option>
                                        <option value="24" {{ $perPage == '24' ? 'selected' : '' }}>24
                                        </option>
                                    </select>
                                    
                                    <!-- Custom Sort By Dropdown -->
                                    <div class="custom-toolbar-dropdown sort-by-dropdown">
                                        <div class="dropdown-toggle">
                                            <span>{{ $currentSortLabel }}</span>
                                        </div>
                                        <div class="dropdown-list">
                                            <ul class="m-0 p-0">
                                                @foreach($sortByOptions as $val => $label)
                                                    <li>
                                                        <a wire:navigate href="{{ request()->fullUrlWithQuery(['sort' => $val, 'page' => 1]) }}">
                                                            {{ $label }}
                                                        </a>
                                                    </li>
                                                @endforeach
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!--End Toolbar-->
                @if (count($products_listing) < 1)
                    @php
                        if (!empty($bySearch)) {
                            $title = labels('front_messages.no_results_for', 'No products found for') . ' "' . $bySearch . '"';
                        } else {
                            $title = labels('front_messages.no_product_found', 'No Product Found!');
                        }
                    @endphp
                    <x-utility.others.not-found :$title />

                    @if (count($relative_products ?? []) >= 1)
                        <section class="section product-slider pb-0 mt-5">
                            
                            <div class="container-fluid">
                                @php
                                    $heading['title'] = labels('front_messages.related_products', 'Related Products');
                                    $heading['short_description'] = labels('front_messages.discover_more', 'Discover more amazing products');
                                @endphp
                                <x-utility.section_header.sectionHeaderTwo :$heading />
                                
                                <div class="relative-products-wrapper position-relative">
                                    <div class="swiper style1-mySwiper gp15 arwOut5 hov-arrow grid-products
                                        {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }}"
                                        data-mobile-slides="1">
                                        <div class="swiper-wrapper">
                                            @foreach ($relative_products as $details)
                                                <div class="swiper-slide">
                                                    @php
                                                        $component = getProductDisplayComponent($store_settings);
                                                        $details = (object) $details;
                                                    @endphp
                                                    <x-dynamic-component :component="$component" :details="$details" />
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                    <div class="swiper-button-prev related-prev"></div>
                                    <div class="swiper-button-next related-next"></div>
                                </div>
                            </div>
                        </section>

                        <script>
                            document.addEventListener("DOMContentLoaded", function () {
                                initRelatedSwiper();
                            });
                            document.addEventListener("livewire:navigated", function () {
                                initRelatedSwiper();
                            });

                            function initRelatedSwiper() {
                                if (typeof Swiper !== 'undefined') {
                                    new Swiper(".style1-mySwiper", {
                                        slidesPerView: 4,
                                        spaceBetween: 15,
                                        navigation: {
                                            nextEl: ".related-next",
                                            prevEl: ".related-prev",
                                        },
                                        breakpoints: {
                                            320: { slidesPerView: 1, spaceBetween: 10 },
                                            640: { slidesPerView: 2, spaceBetween: 15 },
                                            768: { slidesPerView: 3, spaceBetween: 15 },
                                            1024: { slidesPerView: 4, spaceBetween: 15 },
                                        },
                                    });
                                }
                            }
                        </script>
                    @endif
                @else

                    <!--Product Grid-->
                     @if (!empty($activeFilters))
                     <div class="mb-3 d-flex flex-wrap gap-2 align-items-center">
                         {{-- <span class="me-2 fw-600">Active Filters:</span> --}}
                         @foreach ($activeFilters as $chip)
                             @php
                                 $params = request()->query();
                                 foreach ($chip['remove_keys'] as $rk) {
                                     if ($rk === 'price_ranges' && isset($chip['range_to_remove'])) {
                                         $ranges = explode(',', $params[$rk] ?? '');
                                         $ranges = array_filter($ranges, fn($r) => $r !== $chip['range_to_remove']);
                                         if (empty($ranges)) {
                                             unset($params[$rk]);
                                         } else {
                                             $params[$rk] = implode(',', $ranges);
                                         }
                                     } else {
                                         unset($params[$rk]);
                                     }
                                 }
                                 $paramsString = count($params) ? ('?' . http_build_query($params)) : '';
                                 $removeUrl = customUrl(url()->current() . $paramsString);
                             @endphp
                             <a wire:navigate href="{{ $removeUrl }}" class="btn btn-sm btn-outline-secondary ">
                                 <span class="me-1">{{ $chip['label'] }}</span>
                                 <ion-icon name="close-circle-outline"></ion-icon>
                             </a>
                         @endforeach
                         @php
                             $clearUrl = customUrl(url()->current());
                         @endphp
                         {{-- <a href="{{ $clearUrl }}" class="btn btn-sm btn-link text-decoration-none ms-2">Clear all</a> --}}
                     </div>
                @endif
                    @php
                        $store_settings = app(StoreService::class)->getStoreSettings();
                    @endphp
                    <div class="grid-products grid-view-items mb-4">

                        <div
                            class="row col-row product-options {{ ($store_settings['products_display_style_for_web'] ?? '') == 'products_display_style_for_web_3' ? 'pro-hover3' : '' }} {{ $view_mode == 'list' ? 'list-style' : 'row-cols-lg-4 row-cols-md-3 row-cols-sm-3 row-cols-1' }} ">
                            @foreach ($products_listing as $details)
                                @php
                                    $store_settings = app(StoreService::class)->getStoreSettings();
                                    $component = getProductDisplayComponent($store_settings);
                                    $details = (object) $details;
                                @endphp

                                <x-dynamic-component :component="$component" :details="$details" />
                            @endforeach
                        </div>
                    </div>
                @endif

                <!--End Product Grid-->
                <div class="d-flex justify-content-between align-content-center">
                    {{-- @dd($links) --}}
                    {!! $links !!}
                </div>
            </div>
            <!--End Products-->
          
        </div>
        
    </div>
    {{-- Store CONVERTED prices (for both display and filtering) --}}
{{-- Keep base prices for filtering; UI formatting happens in JS --}}
<input type="hidden" id="min-price" value="{{ $min_max_price['selected_min_price'] }}">
<input type="hidden" id="max-price" value="{{ $min_max_price['selected_max_price'] }}">

<input type="hidden" id="selected_min_price" value="{{ $min_max_price['selected_min_price'] }}">
<input type="hidden" id="selected_max_price" value="{{ $min_max_price['selected_max_price'] }}">

</div>

